/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.adempiere.base.BaseActivator;
import org.adempiere.base.event.EventProperty;
import org.adempiere.base.event.IEventManager;
import org.compiere.util.CLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventManager
implements IEventManager {
    private EventAdmin eventAdmin;
    private static IEventManager instance = null;
    private static final CLogger log = CLogger.getCLogger(EventManager.class);
    private static final Object mutex = new Object();
    private Map<EventHandler, List<ServiceRegistration<?>>> registrations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindEventAdmin(EventAdmin eventAdmin) {
        Object object = mutex;
        synchronized (object) {
            if (instance == null) {
                instance = this;
                mutex.notifyAll();
            }
        }
        this.eventAdmin = eventAdmin;
    }

    public void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEventManager getInstance() {
        Object object = mutex;
        synchronized (object) {
            while (true) {
                if (instance != null) {
                    return instance;
                }
                try {
                    mutex.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean postEvent(Event event) {
        if (this.eventAdmin != null) {
            this.eventAdmin.postEvent(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean sendEvent(Event event) {
        if (this.eventAdmin != null) {
            this.eventAdmin.sendEvent(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean register(String topic, EventHandler eventHandler) {
        return this.register(topic, null, eventHandler);
    }

    @Override
    public boolean register(String[] topics, EventHandler eventHandler) {
        return this.register(topics, null, eventHandler);
    }

    @Override
    public boolean register(String topic, String filter, EventHandler eventHandler) {
        String[] topics = new String[]{topic};
        return this.register(topics, filter, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(String[] topics, String filter, EventHandler eventHandler) {
        BundleContext bundleContext = BaseActivator.getBundleContext();
        if (bundleContext == null) {
            log.severe("No bundle context. Topic=" + Arrays.toString(topics));
            return false;
        }
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", topics);
        if (filter != null) {
            ((Dictionary)d).put("event.filter", filter);
        }
        ServiceRegistration registration = bundleContext.registerService(EventHandler.class.getName(), (Object)eventHandler, d);
        Map<EventHandler, List<ServiceRegistration<?>>> map = this.registrations;
        synchronized (map) {
            List<ServiceRegistration<?>> list = this.registrations.get(eventHandler);
            if (list == null) {
                list = new ArrayList();
                this.registrations.put(eventHandler, list);
            }
            list.add(registration);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(EventHandler eventHandler) {
        List<ServiceRegistration<?>> serviceRegistrations = null;
        Map<EventHandler, List<ServiceRegistration<?>>> map = this.registrations;
        synchronized (map) {
            serviceRegistrations = this.registrations.remove(eventHandler);
        }
        if (serviceRegistrations == null) {
            return false;
        }
        for (ServiceRegistration<?> registration : serviceRegistrations) {
            registration.unregister();
        }
        return true;
    }

    public static Event newEvent(String topic, Object data) {
        Event event = null;
        if (data instanceof Dictionary) {
            Dictionary dict = (Dictionary)data;
            if (dict.get("event.errorMessages") == null) {
                dict.put("event.errorMessages", new ArrayList());
            }
            event = new Event(topic, dict);
        } else if (data instanceof Map) {
            Map map = (Map)data;
            if (!map.containsKey("event.errorMessages")) {
                map.put("event.errorMessages", new ArrayList());
            }
            event = new Event(topic, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("event.topics", topic);
            if (data != null) {
                map.put("event.data", data);
            }
            map.put("event.errorMessages", new ArrayList());
            event = new Event(topic, map);
        }
        return event;
    }

    public static Event newEvent(String topic, EventProperty ... properties) {
        Event event = null;
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (properties != null) {
            int i2 = 0;
            while (i2 < properties.length) {
                map.put(properties[i2].name, properties[i2].value);
                ++i2;
            }
            if (!map.containsKey("event.topics")) {
                map.put("event.topics", topic);
            }
            if (!map.containsKey("event.errorMessages")) {
                map.put("event.errorMessages", new ArrayList());
            }
        }
        event = new Event(topic, map);
        return event;
    }
}

