/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.util.StringTokenizer;
import org.adempiere.base.event.AbstractEventHandler;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.X_C_AddressValidation;
import org.osgi.service.event.Event;

public class AddressValidationEventHandler
extends AbstractEventHandler {
    @Override
    protected void doHandleEvent(Event event) {
        PO po;
        String topic = event.getTopic();
        if ((topic.equals("adempiere/po/beforeNew") || topic.equals("adempiere/po/beforeChange")) && (po = this.getPO(event)).get_TableName().equals("C_Location")) {
            MLocation location = (MLocation)po;
            String addressValidation = MSysConfig.getValue("ADDRESS_VALIDATION", null, location.getAD_Client_ID());
            boolean isEnabled = false;
            if (addressValidation != null && addressValidation.trim().length() > 0 && location.getCountry() != null) {
                StringTokenizer st = new StringTokenizer(addressValidation, ";");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (!token.equals(location.getCountry().getCountryCode().trim())) continue;
                    isEnabled = true;
                    break;
                }
            }
            if (!isEnabled) {
                return;
            }
            X_C_AddressValidation validation = null;
            if (location.getC_AddressValidation_ID() > 0) {
                validation = new MAddressValidation(location.getCtx(), location.getC_AddressValidation_ID(), location.get_TrxName());
            }
            if (validation == null) {
                validation = MAddressValidation.getDefaultAddressValidation(location.getCtx(), location.getAD_Client_ID(), location.get_TrxName());
            }
            if (validation != null) {
                location.processOnline(validation.getC_AddressValidation_ID());
            }
        }
    }

    @Override
    protected void initialize() {
        this.registerTableEvent("adempiere/po/beforeNew", "C_Location");
        this.registerTableEvent("adempiere/po/beforeChange", "C_Location");
    }
}

