/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.util.List;
import org.adempiere.base.event.IEventManager;
import org.compiere.model.PO;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractEventHandler
implements EventHandler {
    protected IEventManager eventManager = null;

    public void handleEvent(Event event) {
        try {
            this.doHandleEvent(event);
        }
        catch (RuntimeException e) {
            this.addError(event, e);
            throw e;
        }
        catch (Exception e) {
            this.addError(event, e);
            throw new RuntimeException(e);
        }
        catch (Error e) {
            this.addError(event, e);
            throw e;
        }
        catch (Throwable e) {
            this.addError(event, e);
            throw new Error(e);
        }
    }

    public void bindEventManager(IEventManager eventManager) {
        this.eventManager = eventManager;
        this.initialize();
    }

    public void unbindEventManager(IEventManager eventManager) {
        this.eventManager = null;
        eventManager.unregister(this);
    }

    protected abstract void doHandleEvent(Event var1);

    protected abstract void initialize();

    protected void registerEvent(String eventTopic) {
        this.registerEvent(eventTopic, null);
    }

    protected void registerEvent(String topic, String filter) {
        if (filter != null) {
            this.eventManager.register(topic, filter, (EventHandler)this);
        } else {
            this.eventManager.register(topic, (EventHandler)this);
        }
    }

    protected void registerTableEvent(String topic, String tableName) {
        String filter = "(tableName=" + tableName + ")";
        this.registerEvent(topic, filter);
    }

    protected PO getPO(Event event) {
        return (PO)this.getEventProperty(event, "event.data");
    }

    protected <T> T getEventData(Event event) {
        return this.getEventProperty(event, "event.data");
    }

    protected <T> T getEventProperty(Event event, String property) {
        return (T)event.getProperty(property);
    }

    protected void addError(Event event, Throwable e) {
        String msg = e.getLocalizedMessage();
        if (msg == null) {
            msg = e.toString();
        }
        this.addErrorMessage(event, msg);
    }

    protected void addErrorMessage(Event event, String errorMessage) {
        List errors = (List)this.getEventProperty(event, "event.errorMessages");
        if (errors != null) {
            errors.add(errorMessage);
        }
    }
}

