/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.adempiere.base.IServiceHolder;
import org.adempiere.base.IServicesHolder;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DynamicServiceHolder<T>
implements IServiceHolder<T>,
IServicesHolder<T> {
    private ServiceTracker<T, T> serviceTracker;

    public DynamicServiceHolder(ServiceTracker<T, T> tracker) {
        this.serviceTracker = tracker;
        if (this.serviceTracker.getTrackingCount() == -1) {
            this.serviceTracker.open();
        }
    }

    @Override
    public T getService() {
        Object service = this.serviceTracker.getService();
        return (T)service;
    }

    @Override
    public List<T> getServices() {
        ArrayList<Object> services = new ArrayList<Object>();
        ServiceReference[] objects = this.serviceTracker.getServiceReferences();
        List<Object> references = new ArrayList();
        if (objects != null && objects.length > 0) {
            references = Arrays.asList(objects);
        }
        Collections.sort(references, Collections.reverseOrder());
        for (ServiceReference reference : references) {
            services.add(this.serviceTracker.getService(reference));
        }
        return services;
    }
}

