/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import org.adempiere.base.ILookupFactory;
import org.compiere.model.GridFieldVO;
import org.compiere.model.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MPaymentLookup;
import org.compiere.util.DisplayType;

public class DefaultLookupFactory
implements ILookupFactory {
    @Override
    public Lookup getLookup(GridFieldVO gridFieldVO) {
        Lookup lookup = null;
        if (gridFieldVO.lookupInfo == null && DisplayType.isLookup(gridFieldVO.displayType)) {
            gridFieldVO.loadLookupInfo();
        }
        if (gridFieldVO.displayType == 21) {
            lookup = new MLocationLookup(gridFieldVO.ctx, gridFieldVO.WindowNo);
        } else if (gridFieldVO.displayType == 31) {
            lookup = new MLocatorLookup(gridFieldVO.ctx, gridFieldVO.WindowNo);
        } else if (gridFieldVO.displayType == 25) {
            lookup = new MAccountLookup(gridFieldVO.ctx, gridFieldVO.WindowNo);
        } else if (gridFieldVO.displayType == 35) {
            lookup = new MPAttributeLookup(gridFieldVO.ctx, gridFieldVO.WindowNo);
        } else if (gridFieldVO.displayType == 200012) {
            lookup = new MPaymentLookup(gridFieldVO.ctx, gridFieldVO.WindowNo, gridFieldVO.ValidationCode);
        } else if (DisplayType.isLookup(gridFieldVO.displayType) && gridFieldVO.lookupInfo != null) {
            lookup = new MLookup(gridFieldVO.lookupInfo, gridFieldVO.TabNo);
        }
        return lookup;
    }

    @Override
    public boolean isLookup(GridFieldVO gridFieldVO) {
        return gridFieldVO.displayType == 21 || gridFieldVO.displayType == 31 || gridFieldVO.displayType == 25 || gridFieldVO.displayType == 35 || gridFieldVO.displayType == 200012 || DisplayType.isLookup(gridFieldVO.displayType);
    }
}

