/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.base.IDocFactory;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MTable;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DefaultDocumentFactory
implements IDocFactory {
    private static final CLogger s_log = CLogger.getCLogger(DefaultDocumentFactory.class);

    @Override
    public Doc getDocument(MAcctSchema as, int AD_Table_ID, int Record_ID, String trxName) {
        Doc doc;
        block7: {
            String tableName = MTable.getTableName(Env.getCtx(), AD_Table_ID);
            doc = null;
            StringBuffer sql = new StringBuffer("SELECT * FROM ").append(tableName).append(" WHERE ").append(tableName).append("_ID=? AND Processed='Y'");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        doc = this.getDocument(as, AD_Table_ID, rs, trxName);
                    } else {
                        s_log.severe("Not Found: " + tableName + "_ID=" + Record_ID);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return doc;
    }

    @Override
    public Doc getDocument(MAcctSchema as, int AD_Table_ID, ResultSet rs, String trxName) {
        Doc doc = null;
        String tableName = MTable.getTableName(Env.getCtx(), AD_Table_ID);
        String packageName = "org.compiere.acct";
        String className = null;
        int firstUnderscore = tableName.indexOf("_");
        className = firstUnderscore == 1 ? String.valueOf(packageName) + ".Doc_" + tableName.substring(2).replaceAll("_", "") : String.valueOf(packageName) + ".Doc_" + tableName.replaceAll("_", "");
        try {
            Class<?> cClass = Class.forName(className);
            Constructor<?> cnstr = cClass.getConstructor(MAcctSchema.class, ResultSet.class, String.class);
            doc = (Doc)cnstr.newInstance(as, rs, trxName);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "Doc Class invalid: " + className + " (" + e.toString() + ")");
            throw new AdempiereUserError("Doc Class invalid: " + className + " (" + e.toString() + ")");
        }
        if (doc == null) {
            s_log.log(Level.SEVERE, "Unknown AD_Table_ID=" + AD_Table_ID);
        }
        return doc;
    }
}

