/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.lang.reflect.Method;
import java.util.logging.Level;
import org.adempiere.base.ICalloutFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.compiere.model.Callout;
import org.compiere.util.CLogger;

public class DefaultCalloutFactory
implements ICalloutFactory {
    private static final CLogger log = CLogger.getCLogger(DefaultCalloutFactory.class);

    @Override
    public Callout getCallout(String className, String methodName) {
        Callout callout = null;
        callout = EquinoxExtensionLocator.instance().locate(Callout.class, Callout.class.getName(), className, null).getExtension();
        if (callout == null) {
            ClassLoader classLoader;
            Class<?> calloutClass;
            block12: {
                calloutClass = null;
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    try {
                        calloutClass = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        if (!log.isLoggable(Level.FINE)) break block12;
                        log.log(Level.FINE, className, ex);
                    }
                }
            }
            if (calloutClass == null) {
                classLoader = this.getClass().getClassLoader();
                try {
                    calloutClass = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    log.log(Level.WARNING, className, ex);
                    return null;
                }
            }
            if (calloutClass == null) {
                return null;
            }
            try {
                callout = (Callout)calloutClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Instance for " + className, ex);
                return null;
            }
            Method[] methods = calloutClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals(methodName)) {
                    return callout;
                }
                ++i2;
            }
        }
        log.log(Level.FINE, "Required method " + methodName + " not found in class " + className);
        return null;
    }
}

