/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.base.AbstractProductPricing;
import org.adempiere.base.DefaultProcessFactory;
import org.adempiere.base.IAddressValidationFactory;
import org.adempiere.base.IBankStatementLoaderFactory;
import org.adempiere.base.IBankStatementMatcherFactory;
import org.adempiere.base.ICalloutFactory;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.IColumnCalloutFactory;
import org.adempiere.base.IKeyStore;
import org.adempiere.base.IModelValidatorFactory;
import org.adempiere.base.IPaymentExporterFactory;
import org.adempiere.base.IPaymentProcessorFactory;
import org.adempiere.base.IProcessFactory;
import org.adempiere.base.IProductPricing;
import org.adempiere.base.IProductPricingFactory;
import org.adempiere.base.IReplenishFactory;
import org.adempiere.base.IResourceFinder;
import org.adempiere.base.IShipmentProcessorFactory;
import org.adempiere.base.ITaxProviderFactory;
import org.adempiere.base.Service;
import org.adempiere.base.osgi.OSGiScriptEngineManager;
import org.adempiere.model.IAddressValidation;
import org.adempiere.model.IShipmentProcessor;
import org.adempiere.model.ITaxProvider;
import org.adempiere.model.MShipperFacade;
import org.compiere.impexp.BankStatementLoaderInterface;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.Callout;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MTaxProvider;
import org.compiere.model.ModelValidator;
import org.compiere.model.PaymentInterface;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.StandardTaxProvider;
import org.compiere.process.ProcessCall;
import org.compiere.util.CLogger;
import org.compiere.util.PaymentExport;
import org.compiere.util.ReplenishInterface;
import org.osgi.framework.FrameworkUtil;

public class Core {
    private static final CLogger s_log = CLogger.getCLogger(Core.class);

    public static IResourceFinder getResourceFinder() {
        return new IResourceFinder(){

            @Override
            public URL getResource(String name) {
                List<IResourceFinder> f = Service.locator().list(IResourceFinder.class).getServices();
                for (IResourceFinder finder : f) {
                    URL url = finder.getResource(name);
                    if (url == null) continue;
                    return url;
                }
                return null;
            }
        };
    }

    public static List<IColumnCallout> findCallout(String tableName, String columnName) {
        ArrayList<IColumnCallout> list = new ArrayList<IColumnCallout>();
        List<IColumnCalloutFactory> factories = Service.locator().list(IColumnCalloutFactory.class).getServices();
        if (factories != null) {
            for (IColumnCalloutFactory factory : factories) {
                IColumnCallout[] callouts = factory.getColumnCallouts(tableName, columnName);
                if (callouts == null || callouts.length <= 0) continue;
                IColumnCallout[] iColumnCalloutArray = callouts;
                int n = callouts.length;
                int n2 = 0;
                while (n2 < n) {
                    IColumnCallout callout = iColumnCalloutArray[n2];
                    list.add(callout);
                    ++n2;
                }
            }
        }
        return list;
    }

    public static Callout getCallout(String className, String methodName) {
        List<ICalloutFactory> factories = Service.locator().list(ICalloutFactory.class).getServices();
        if (factories != null) {
            for (ICalloutFactory factory : factories) {
                Callout callout = factory.getCallout(className, methodName);
                if (callout == null) continue;
                return callout;
            }
        }
        return null;
    }

    public static ProcessCall getProcess(String processId) {
        List<IProcessFactory> factories = Core.getProcessFactories();
        if (factories != null && !factories.isEmpty()) {
            for (IProcessFactory factory : factories) {
                ProcessCall process = factory.newProcessInstance(processId);
                if (process == null) continue;
                return process;
            }
        }
        return null;
    }

    private static List<IProcessFactory> getProcessFactories() {
        List<IProcessFactory> factories = null;
        int maxIterations = 5;
        int waitMillis = 1000;
        int iterations = 0;
        boolean foundDefault = false;
        while (true) {
            if ((factories = Service.locator().list(IProcessFactory.class).getServices()) != null && !factories.isEmpty()) {
                for (IProcessFactory factory : factories) {
                    if (!(factory instanceof DefaultProcessFactory)) continue;
                    foundDefault = true;
                    break;
                }
            }
            if (foundDefault || ++iterations >= maxIterations) break;
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        return factories;
    }

    public static ModelValidator getModelValidator(String validatorId) {
        List<IModelValidatorFactory> factoryList = Service.locator().list(IModelValidatorFactory.class).getServices();
        if (factoryList != null) {
            for (IModelValidatorFactory factory : factoryList) {
                ModelValidator validator = factory.newModelValidatorInstance(validatorId);
                if (validator == null) continue;
                return validator;
            }
        }
        return null;
    }

    public static IKeyStore getKeyStore() {
        return Service.locator().locate(IKeyStore.class).getService();
    }

    public static PaymentProcessor getPaymentProcessor(MBankAccountProcessor mbap, PaymentInterface mp) {
        MPaymentProcessor mpp;
        String className;
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("create for " + mbap);
        }
        if ((className = (mpp = new MPaymentProcessor(mbap.getCtx(), mbap.getC_PaymentProcessor_ID(), mbap.get_TrxName())).getPayProcessorClass()) == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "No PaymentProcessor class name in " + mbap);
            return null;
        }
        PaymentProcessor myProcessor = null;
        List<IPaymentProcessorFactory> factoryList = Service.locator().list(IPaymentProcessorFactory.class).getServices();
        if (factoryList != null) {
            for (IPaymentProcessorFactory factory : factoryList) {
                PaymentProcessor processor = factory.newPaymentProcessorInstance(className);
                if (processor == null) continue;
                myProcessor = processor;
                break;
            }
        }
        if (myProcessor == null) {
            s_log.log(Level.SEVERE, "Not found in service/extension registry and classpath");
            return null;
        }
        myProcessor.initialize(mbap, mp);
        return myProcessor;
    }

    public static BankStatementLoaderInterface getBankStatementLoader(String className) {
        if (className == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "No BankStatementLoaderInterface class name");
            return null;
        }
        BankStatementLoaderInterface myBankStatementLoader = null;
        List<IBankStatementLoaderFactory> factoryList = Service.locator().list(IBankStatementLoaderFactory.class).getServices();
        if (factoryList != null) {
            for (IBankStatementLoaderFactory factory : factoryList) {
                BankStatementLoaderInterface loader = factory.newBankStatementLoaderInstance(className);
                if (loader == null) continue;
                myBankStatementLoader = loader;
                break;
            }
        }
        if (myBankStatementLoader == null) {
            s_log.log(Level.CONFIG, String.valueOf(className) + " not found in service/extension registry and classpath");
            return null;
        }
        return myBankStatementLoader;
    }

    public static BankStatementMatcherInterface getBankStatementMatcher(String className) {
        if (className == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "No BankStatementMatcherInterface class name");
            return null;
        }
        BankStatementMatcherInterface myBankStatementMatcher = null;
        List<IBankStatementMatcherFactory> factoryList = Service.locator().list(IBankStatementMatcherFactory.class).getServices();
        if (factoryList != null) {
            for (IBankStatementMatcherFactory factory : factoryList) {
                BankStatementMatcherInterface matcher = factory.newBankStatementMatcherInstance(className);
                if (matcher == null) continue;
                myBankStatementMatcher = matcher;
                break;
            }
        }
        if (myBankStatementMatcher == null) {
            s_log.log(Level.CONFIG, String.valueOf(className) + " not found in service/extension registry and classpath");
            return null;
        }
        return myBankStatementMatcher;
    }

    public static IShipmentProcessor getShipmentProcessor(MShipperFacade sf) {
        String className;
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("create for " + sf);
        }
        if ((className = sf.getShippingProcessorClass()) == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "Shipment processor class not define for shipper " + sf);
            return null;
        }
        List<IShipmentProcessorFactory> factoryList = Service.locator().list(IShipmentProcessorFactory.class).getServices();
        if (factoryList == null) {
            return null;
        }
        for (IShipmentProcessorFactory factory : factoryList) {
            IShipmentProcessor processor = factory.newShipmentProcessorInstance(className);
            if (processor == null) continue;
            return processor;
        }
        return null;
    }

    public static IAddressValidation getAddressValidation(MAddressValidation validation) {
        String className = validation.getAddressValidationClass();
        if (className == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "Address validation class not defined: " + validation);
            return null;
        }
        List<IAddressValidationFactory> factoryList = Service.locator().list(IAddressValidationFactory.class).getServices();
        if (factoryList == null) {
            return null;
        }
        for (IAddressValidationFactory factory : factoryList) {
            IAddressValidation processor = factory.newAddressValidationInstance(className);
            if (processor == null) continue;
            return processor;
        }
        return null;
    }

    public static ITaxProvider getTaxProvider(MTaxProvider provider) {
        ITaxProvider calculator = null;
        if (provider != null) {
            if (provider.getC_TaxProvider_ID() == 0) {
                return new StandardTaxProvider();
            }
            if (!provider.isActive()) {
                s_log.log(Level.SEVERE, "Tax provider is inactive: " + provider);
                return null;
            }
            String className = provider.getTaxProviderClass();
            if (className == null || className.length() == 0) {
                s_log.log(Level.SEVERE, "Tax provider class not defined: " + provider);
                return null;
            }
            List<ITaxProviderFactory> factoryList = Service.locator().list(ITaxProviderFactory.class).getServices();
            if (factoryList == null) {
                return null;
            }
            for (ITaxProviderFactory factory : factoryList) {
                calculator = factory.newTaxProviderInstance(className);
                if (calculator == null) continue;
                return calculator;
            }
        }
        return null;
    }

    public static ReplenishInterface getReplenish(String className) {
        if (className == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "No ReplenishInterface class name");
            return null;
        }
        ReplenishInterface myReplenishInstance = null;
        List<IReplenishFactory> factoryList = Service.locator().list(IReplenishFactory.class).getServices();
        if (factoryList != null) {
            for (IReplenishFactory factory : factoryList) {
                ReplenishInterface loader = factory.newReplenishInstance(className);
                if (loader == null) continue;
                myReplenishInstance = loader;
                break;
            }
        }
        if (myReplenishInstance == null) {
            s_log.log(Level.CONFIG, String.valueOf(className) + " not found in service/extension registry and classpath");
            return null;
        }
        return myReplenishInstance;
    }

    public static ScriptEngine getScriptEngine(String engineName) {
        OSGiScriptEngineManager osgiFactory = new OSGiScriptEngineManager(FrameworkUtil.getBundle(Core.class).getBundleContext());
        ScriptEngine engine = osgiFactory.getEngineByName(engineName);
        return engine;
    }

    public static PaymentExport getPaymentExporter(String className) {
        if (className == null || className.length() == 0) {
            s_log.log(Level.SEVERE, "No PaymentExporter class name");
            return null;
        }
        PaymentExport myPaymentExporter = null;
        List<IPaymentExporterFactory> factoryList = Service.locator().list(IPaymentExporterFactory.class).getServices();
        if (factoryList != null) {
            for (IPaymentExporterFactory factory : factoryList) {
                PaymentExport exporter = factory.newPaymentExporterInstance(className);
                if (exporter == null) continue;
                myPaymentExporter = exporter;
                break;
            }
        }
        if (myPaymentExporter == null) {
            s_log.log(Level.CONFIG, String.valueOf(className) + " not found in service/extension registry and classpath");
            return null;
        }
        return myPaymentExporter;
    }

    public static IProductPricing getProductPricing() {
        List<IProductPricingFactory> factoryList = Service.locator().list(IProductPricingFactory.class).getServices();
        if (factoryList != null) {
            for (IProductPricingFactory factory : factoryList) {
                AbstractProductPricing myProductPricing = factory.newProductPricingInstance();
                if (myProductPricing == null) continue;
                return myProductPricing;
            }
        }
        return null;
    }
}

