/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.Color;
import java.awt.Paint;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MChart;
import org.compiere.model.MChartDatasource;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class ChartBuilder {
    private static final CLogger log = CLogger.getCLogger(ChartBuilder.class);
    private MChart chartModel;
    private HashMap<String, MQuery> queries;
    private Dataset dataset;

    public ChartBuilder(MChart chart) {
        this.chartModel = chart;
    }

    public JFreeChart createChart() {
        String type = this.chartModel.getChartType();
        if ("BC".equals(type)) {
            if (this.chartModel.isTimeSeries()) {
                return this.createXYBarChart();
            }
            return this.createBarChart();
        }
        if ("B3".equals(type)) {
            return this.create3DBarChart();
        }
        if ("BS".equals(type)) {
            if (this.chartModel.isTimeSeries()) {
                return this.createXYBarChart();
            }
            return this.createStackedBarChart();
        }
        if ("B4".equals(type)) {
            return this.create3DStackedBarChart();
        }
        if ("P3".equals(type)) {
            return this.create3DPieChart();
        }
        if ("PC".equals(type)) {
            return this.createPieChart();
        }
        if ("L3".equals(type)) {
            return this.create3DLineChart();
        }
        if ("AC".equals(type)) {
            return this.createAreaChart();
        }
        if ("AS".equals(type)) {
            return this.createStackedAreaChart();
        }
        if ("LC".equals(type)) {
            if (this.chartModel.isTimeSeries()) {
                return this.createTimeSeriesChart();
            }
            return this.createLineChart();
        }
        if ("RC".equals(type)) {
            return this.createRingChart();
        }
        if ("WC".equals(type)) {
            return this.createWaterfallChart();
        }
        throw new IllegalArgumentException("unknown chart type=" + type);
    }

    public void loadData() {
        this.queries = new HashMap();
        for (MChartDatasource ds : this.chartModel.getDatasources()) {
            this.addData(ds);
        }
    }

    private void addData(MChartDatasource ds) {
        String where;
        String category;
        String value = ds.getValueColumn();
        String unit = "D";
        if (!this.chartModel.isTimeSeries()) {
            category = ds.getCategoryColumn();
        } else {
            if (this.chartModel.getTimeUnit().equals("W")) {
                unit = "W";
            } else if (this.chartModel.getTimeUnit().equals("M")) {
                unit = "MM";
            } else if (this.chartModel.getTimeUnit().equals("Q")) {
                unit = "Q";
            } else if (this.chartModel.getTimeUnit().equals("Y")) {
                unit = "Y";
            }
            category = " TRUNC(" + ds.getDateColumn() + ", '" + unit + "') ";
        }
        String series = DB.TO_STRING(ds.getName());
        boolean hasSeries = false;
        if (ds.getSeriesColumn() != null) {
            series = ds.getSeriesColumn();
            hasSeries = true;
        }
        if (!Util.isEmpty(where = ds.getWhereClause())) {
            where = Env.parseContext(Env.getCtx(), this.chartModel.getWindowNo(), where, true);
        }
        boolean hasWhere = false;
        String sql = "SELECT " + value + ", " + category + ", " + series + " FROM " + ds.getFromClause();
        if (!Util.isEmpty(where)) {
            sql = String.valueOf(sql) + " WHERE " + where;
            hasWhere = true;
        }
        Timestamp currentDate = Env.getContextAsDate(Env.getCtx(), "#Date");
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        int scope = this.chartModel.getTimeScope();
        int offset = ds.getTimeOffset();
        if (this.chartModel.isTimeSeries() && scope != 0) {
            startDate = this.increment(currentDate, this.chartModel.getTimeUnit(), offset += -scope);
            endDate = this.increment(startDate, this.chartModel.getTimeUnit(), scope);
        }
        if (startDate != null && endDate != null) {
            sql = String.valueOf(sql) + (hasWhere ? " AND " : " WHERE ");
            sql = String.valueOf(sql) + category + ">=TRUNC(" + DB.TO_DATE(new Timestamp(startDate.getTime())) + ", '" + unit + "') AND ";
            sql = String.valueOf(sql) + category + "<=TRUNC(" + DB.TO_DATE(new Timestamp(endDate.getTime())) + ", '" + unit + "') ";
        }
        if (sql.indexOf(64) >= 0) {
            sql = Env.parseContext(Env.getCtx(), 0, sql, false, true);
        }
        MRole role = MRole.getDefault(Env.getCtx(), false);
        sql = role.addAccessSQL(sql, null, true, false);
        sql = hasSeries ? String.valueOf(sql) + " GROUP BY " + series + ", " + category + " ORDER BY " + series + ", " + category : String.valueOf(sql) + " GROUP BY " + category + " ORDER BY " + category;
        log.log(Level.FINE, sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        TimeSeries tseries = null;
        Dataset dataset = this.getDataset();
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String key = rs.getString(2);
                    String seriesName = rs.getString(3);
                    if (seriesName == null) {
                        seriesName = ds.getName();
                    }
                    String queryWhere = "";
                    if (hasWhere) {
                        queryWhere = String.valueOf(queryWhere) + where + " AND ";
                    }
                    queryWhere = String.valueOf(queryWhere) + series + " = " + DB.TO_STRING(seriesName) + " AND " + category + " = ";
                    if (this.chartModel.isTimeSeries() && dataset instanceof TimeSeriesCollection) {
                        if (tseries == null || !tseries.getKey().equals(seriesName)) {
                            if (tseries != null) {
                                ((TimeSeriesCollection)dataset).addSeries(tseries);
                            }
                            tseries = new TimeSeries((Comparable)((Object)seriesName));
                        }
                        Date date = rs.getDate(2);
                        Day period = null;
                        if (this.chartModel.getTimeUnit().equals("D")) {
                            period = new Day((java.util.Date)date);
                        } else if (this.chartModel.getTimeUnit().equals("W")) {
                            period = new Week((java.util.Date)date);
                        } else if (this.chartModel.getTimeUnit().equals("M")) {
                            period = new Month((java.util.Date)date);
                        } else if (this.chartModel.getTimeUnit().equals("Q")) {
                            period = new Quarter((java.util.Date)date);
                        } else if (this.chartModel.getTimeUnit().equals("Y")) {
                            period = new Year((java.util.Date)date);
                        }
                        tseries.add((RegularTimePeriod)period, (Number)rs.getBigDecimal(1));
                        key = period.toString();
                        queryWhere = String.valueOf(queryWhere) + DB.TO_DATE(new Timestamp(date.getTime()));
                    } else {
                        queryWhere = String.valueOf(queryWhere) + DB.TO_STRING(key);
                    }
                    MQuery query = new MQuery(ds.getAD_Table_ID());
                    String keyCol = MTable.get(Env.getCtx(), ds.getAD_Table_ID()).getKeyColumns()[0];
                    String whereClause = String.valueOf(keyCol) + " IN (SELECT " + ds.getKeyColumn() + " FROM " + ds.getFromClause() + " WHERE " + queryWhere + " )";
                    query.addRestriction(whereClause.toString());
                    query.setRecordCount(1);
                    HashMap<String, MQuery> map = this.getQueries();
                    if (dataset instanceof DefaultPieDataset) {
                        ((DefaultPieDataset)dataset).setValue((Comparable)((Object)key), (Number)rs.getBigDecimal(1));
                        map.put(key, query);
                        continue;
                    }
                    if (dataset instanceof DefaultCategoryDataset) {
                        ((DefaultCategoryDataset)dataset).addValue((Number)rs.getBigDecimal(1), (Comparable)((Object)seriesName), (Comparable)((Object)key));
                        map.put(String.valueOf(seriesName) + "__" + key, query);
                        continue;
                    }
                    if (!(dataset instanceof TimeSeriesCollection)) continue;
                    map.put(String.valueOf(seriesName) + "__" + key, query);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (tseries != null) {
            ((TimeSeriesCollection)dataset).addSeries(tseries);
        }
    }

    private java.util.Date increment(java.util.Date lastDate, String timeUnit, int qty) {
        if (lastDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastDate);
        if (timeUnit.equals("D")) {
            cal.add(6, qty);
        } else if (timeUnit.equals("W")) {
            cal.add(3, qty);
        } else if (timeUnit.equals("M")) {
            cal.add(2, qty);
        } else if (timeUnit.equals("Q")) {
            cal.add(2, 3 * qty);
        } else if (timeUnit.equals("Y")) {
            cal.add(1, qty);
        }
        return cal.getTime();
    }

    public CategoryDataset getCategoryDataset() {
        this.dataset = new DefaultCategoryDataset();
        this.loadData();
        return (CategoryDataset)this.dataset;
    }

    public IntervalXYDataset getXYDataset() {
        this.dataset = new TimeSeriesCollection();
        this.loadData();
        return (IntervalXYDataset)this.dataset;
    }

    public PieDataset getPieDataset() {
        this.dataset = new DefaultPieDataset();
        this.loadData();
        return (PieDataset)this.dataset;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public HashMap<String, MQuery> getQueries() {
        return this.queries;
    }

    public MQuery getQuery(String key) {
        if (this.queries.containsKey(key)) {
            return this.queries.get(key);
        }
        return null;
    }

    private JFreeChart createXYBarChart() {
        JFreeChart chart = ChartFactory.createXYBarChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (boolean)true, (String)this.chartModel.get_Translation("RangeLabel"), (IntervalXYDataset)this.getXYDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createTimeSeriesChart() {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (XYDataset)this.getXYDataset(), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createWaterfallChart() {
        JFreeChart chart = ChartFactory.createWaterfallChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createRingChart() {
        JFreeChart chart = ChartFactory.createRingChart((String)this.chartModel.get_Translation("Name"), (PieDataset)this.getPieDataset(), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createPieChart() {
        JFreeChart chart = ChartFactory.createPieChart((String)this.chartModel.get_Translation("Name"), (PieDataset)this.getPieDataset(), (boolean)false, (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart create3DPieChart() {
        JFreeChart chart = ChartFactory.createPieChart3D((String)this.chartModel.get_Translation("Name"), (PieDataset)this.getPieDataset(), (boolean)false, (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createBarChart() {
        JFreeChart chart = ChartFactory.createBarChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        BarRenderer renderer = new BarRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart create3DBarChart() {
        JFreeChart chart = ChartFactory.createBarChart3D((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createStackedBarChart() {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        GroupedStackedBarRenderer renderer = new GroupedStackedBarRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart create3DStackedBarChart() {
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createAreaChart() {
        JFreeChart chart = ChartFactory.createAreaChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createStackedAreaChart() {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createLineChart() {
        JFreeChart chart = ChartFactory.createLineChart((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart create3DLineChart() {
        JFreeChart chart = ChartFactory.createLineChart3D((String)this.chartModel.get_Translation("Name"), (String)this.chartModel.get_Translation("DomainLabel"), (String)this.chartModel.get_Translation("RangeLabel"), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.chartModel.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.chartModel.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private void setupCategoryChart(JFreeChart chart) {
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis xAxis = plot.getDomainAxis();
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer.setSeriesPaint(2, (Paint)Color.YELLOW);
        renderer.setSeriesPaint(3, (Paint)Color.GREEN);
        renderer.setSeriesPaint(4, (Paint)Color.ORANGE);
        renderer.setSeriesPaint(5, (Paint)Color.CYAN);
        renderer.setSeriesPaint(6, (Paint)Color.MAGENTA);
        renderer.setSeriesPaint(7, (Paint)Color.GRAY);
        renderer.setSeriesPaint(8, (Paint)Color.PINK);
        plot.setRenderer(renderer);
    }
}

