/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.event.ColSizeEvent;
import org.zkoss.zul.impl.HeaderElement;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.XulElement;

public abstract class HeadersElement
extends XulElement {
    private boolean _sizable;

    public boolean isSizable() {
        return this._sizable;
    }

    public void setSizable(boolean sizable) {
        if (this._sizable != sizable) {
            this._sizable = sizable;
            this.smartUpdate("sizable", sizable);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "sizable", this._sizable);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onColSize")) {
            ((MeshElement)this.getParent()).setSpan(false);
            ((MeshElement)this.getParent()).setSizedByContent(false);
            boolean isMultiple = request.getData().containsKey("widths");
            ColSizeEvent evt = ColSizeEvent.getColSizeEvent(request);
            List<Component> headers = isMultiple ? this.getChildren() : Collections.singletonList(evt.getColumn());
            for (int i = 0; i < headers.size(); ++i) {
                String width;
                HeaderElement header = (HeaderElement)headers.get(i);
                String string = width = isMultiple ? evt.getWidth(i) : evt.getWidth();
                if (header.isVisible()) {
                    header.setWidthByClient(width);
                }
                if (header.getHflex() == null) continue;
                header.setHflexByClient(null);
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        HeadersElement.addClientEvent(HeadersElement.class, (String)"onColSize", (int)1);
    }
}

