/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Imagemap;

public class Area
extends AbstractComponent {
    private String _shape;
    private String _coords;
    private String _tooltiptext;
    private Integer _tabindex;

    public Area() {
    }

    public Area(String coords) {
        this.setCoords(coords);
    }

    public String getShape() {
        return this._shape;
    }

    public void setShape(String shape) throws WrongValueException {
        if (shape != null) {
            if (shape.length() == 0) {
                shape = null;
            } else if (!("rect".equals(shape) || "rectangle".equals(shape) || "circle".equals(shape) || "circ".equals(shape) || "polygon".equals(shape) || "poly".equals(shape))) {
                throw new WrongValueException("Unknown shape: " + shape);
            }
        }
        if (!Objects.equals((Object)shape, (Object)this._shape)) {
            this._shape = shape;
            this.smartUpdate("shape", this._shape);
        }
    }

    public Integer getTabindexInteger() {
        return this._tabindex;
    }

    public void setTabindex(Integer tabindex) {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", tabindex);
        }
    }

    public String getCoords() {
        return this._coords;
    }

    public void setCoords(String coords) {
        if (coords != null && coords.length() == 0) {
            coords = null;
        }
        if (!Objects.equals((Object)coords, (Object)this._coords)) {
            this._coords = coords;
            this.smartUpdate("coords", this._coords);
        }
    }

    public String getTooltiptext() {
        return this._tooltiptext;
    }

    public void setTooltiptext(String tooltiptext) {
        if (tooltiptext != null && tooltiptext.length() == 0) {
            tooltiptext = null;
        }
        if (!Objects.equals((Object)this._tooltiptext, (Object)tooltiptext)) {
            this._tooltiptext = tooltiptext;
            this.smartUpdate("tooltiptext", this.getTooltiptext());
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Imagemap)) {
            throw new UiException("Area's parent must be imagemap, not " + parent);
        }
        super.beforeParentChanged(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "coords", this._coords);
        this.render(renderer, "shape", this._shape);
        this.render(renderer, "tooltiptext", this._tooltiptext);
        if (this._tabindex != null) {
            renderer.render("tabindex", (Object)this._tabindex);
        }
    }
}

