/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.webservices;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import org.adempiere.base.ServiceQuery;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.compiere.model.Lookup;
import org.compiere.model.MUser;
import org.compiere.model.MWebService;
import org.compiere.model.MWebServiceType;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_WS_WebServiceMethod;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.idempiere.adInterface.x10.ADLoginRequest;
import org.idempiere.adInterface.x10.DataField;
import org.idempiere.adInterface.x10.OutputField;
import org.idempiere.adInterface.x10.OutputFields;
import org.idempiere.adInterface.x10.StandardResponse;
import org.idempiere.adInterface.x10.StandardResponseDocument;
import org.idempiere.adinterface.CompiereService;
import org.idempiere.webservices.IWSValidator;
import org.idempiere.webservices.fault.IdempiereServiceFault;

public class AbstractService {
    private static final String ROLE_ACCESS_SQL = "SELECT IsActive FROM WS_WebServiceTypeAccess WHERE AD_Role_ID IN (SELECT AD_Role_ID FROM AD_Role WHERE AD_Role_ID=? UNION SELECT Included_Role_ID as AD_Role_ID FROM AD_Role_Included WHERE AD_Role_ID=?) AND WS_WebServiceType_ID=?";
    private static final String COMPIERE_SERVICE = "CompiereService";
    @Resource
    protected WebServiceContext jaxwsContext;
    @Context
    protected MessageContext jaxrsContext;
    private static CCache<String, MWebServiceType> s_WebServiceTypeCache = new CCache("WS_WebServiceType", 10, 60);
    private static CCache<String, Boolean> s_RoleAccessCache = new CCache("WS_WebServiceTypeAccess", 60, 60);

    protected String login(ADLoginRequest loginRequest, String webService, String method, String serviceType) {
        KeyNamePair[] roles;
        HttpServletRequest req;
        CompiereService cachedCs;
        CompiereService m_cs = this.getCompiereService();
        if (m_cs.getUserName() == null && (cachedCs = CompiereService.get(req = this.getHttpServletRequest(), loginRequest)) != null) {
            m_cs = cachedCs;
            req.setAttribute(COMPIERE_SERVICE, (Object)cachedCs);
            m_cs.connectCacheInstance();
            return this.authenticate(webService, method, serviceType, cachedCs);
        }
        if (m_cs.isLoggedIn() && m_cs.getAD_Client_ID() == loginRequest.getClientID() && loginRequest.getClientID() == Env.getAD_Client_ID((Properties)Env.getCtx()) && m_cs.getAD_Org_ID() == loginRequest.getOrgID() && m_cs.getAD_Role_ID() == loginRequest.getRoleID() && m_cs.getM_Warehouse_ID() == loginRequest.getWarehouseID() && loginRequest.getUser().equals(m_cs.getUserName())) {
            return this.authenticate(webService, method, serviceType, m_cs);
        }
        String ret = AbstractService.invokeLoginValidator(loginRequest, m_cs.getCtx(), null, 5);
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        Login login = new Login(m_cs.getCtx());
        KeyNamePair[] clients = login.getClients(loginRequest.getUser(), loginRequest.getPass());
        if (clients == null) {
            return "Error login - User invalid";
        }
        m_cs.setPassword(loginRequest.getPass());
        m_cs.setExpiryMinutes(loginRequest.getStage());
        m_cs.setIPAddress(this.getHttpServletRequest().getRemoteAddr());
        boolean okclient = false;
        KeyNamePair selectedClient = null;
        KeyNamePair[] keyNamePairArray = clients;
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair client = keyNamePairArray[n2];
            if (client.getKey() == loginRequest.getClientID()) {
                okclient = true;
                selectedClient = client;
                break;
            }
            ++n2;
        }
        if (!okclient) {
            return "Error logging in - client not allowed for this user";
        }
        m_cs.getCtx().setProperty("#AD_Client_ID", "" + loginRequest.getClientID());
        Env.setContext((Properties)m_cs.getCtx(), (String)"#AD_Client_ID", (String)selectedClient.getID());
        MUser user = MUser.get((Properties)m_cs.getCtx(), (String)loginRequest.getUser());
        if (user != null) {
            Env.setContext((Properties)m_cs.getCtx(), (String)"#AD_User_ID", (int)user.getAD_User_ID());
            Env.setContext((Properties)m_cs.getCtx(), (String)"#AD_User_Name", (String)user.getName());
            Env.setContext((Properties)m_cs.getCtx(), (String)"#SalesRep_ID", (int)user.getAD_User_ID());
            String userAgent = this.getHttpServletRequest().getHeader("User-Agent");
            Env.setContext((Properties)m_cs.getCtx(), (String)"#UserAgent", (String)(userAgent == null ? "Unknown" : userAgent));
        }
        if ((roles = login.getRoles(loginRequest.getUser(), selectedClient)) != null) {
            String error;
            boolean okrole = false;
            KeyNamePair[] keyNamePairArray2 = roles;
            int n3 = roles.length;
            int n4 = 0;
            while (n4 < n3) {
                KeyNamePair role = keyNamePairArray2[n4];
                if (role.getKey() == loginRequest.getRoleID()) {
                    okrole = true;
                    break;
                }
                ++n4;
            }
            if (!okrole) {
                return "Error logging in - role not allowed for this user";
            }
            KeyNamePair[] orgs = login.getOrgs(new KeyNamePair(loginRequest.getRoleID(), ""));
            if (orgs == null) {
                return "Error logging in - no organizations for this role";
            }
            KeyNamePair orglogin = null;
            boolean okorg = false;
            KeyNamePair[] keyNamePairArray3 = orgs;
            int n5 = orgs.length;
            int n6 = 0;
            while (n6 < n5) {
                KeyNamePair org = keyNamePairArray3[n6];
                if (org.getKey() == loginRequest.getOrgID()) {
                    okorg = true;
                    orglogin = org;
                    break;
                }
                ++n6;
            }
            if (!okorg) {
                return "Error logging in - org not allowed for this role";
            }
            KeyNamePair[] warehouses = login.getWarehouses(new KeyNamePair(loginRequest.getOrgID(), ""));
            if (warehouses != null) {
                boolean okwh = false;
                KeyNamePair[] keyNamePairArray4 = warehouses;
                int n7 = warehouses.length;
                int n8 = 0;
                while (n8 < n7) {
                    KeyNamePair warehouse = keyNamePairArray4[n8];
                    if (warehouse.getKey() == loginRequest.getWarehouseID()) {
                        okwh = true;
                        break;
                    }
                    ++n8;
                }
                if (!okwh) {
                    return "Error logging in - warehouse not allowed for this org";
                }
            } else if (warehouses == null && loginRequest.getWarehouseID() > 0) {
                return "Error logging in - warehouse not allowed for this org";
            }
            if ((error = login.validateLogin(orglogin)) != null && error.length() > 0) {
                return error;
            }
            int AD_User_ID = Env.getAD_User_ID((Properties)m_cs.getCtx());
            if (!m_cs.login(AD_User_ID, loginRequest.getRoleID(), loginRequest.getClientID(), loginRequest.getOrgID(), loginRequest.getWarehouseID(), loginRequest.getLang())) {
                return "Error logging in";
            }
        } else {
            return "Error logging in - no roles or user/pwd invalid for user " + loginRequest.getUser();
        }
        ret = AbstractService.invokeLoginValidator(loginRequest, m_cs.getCtx(), null, 6);
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return this.authenticate(webService, method, serviceType, m_cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String authenticate(String webServiceValue, String methodValue, String serviceTypeValue, CompiereService m_cs) {
        MWebService m_webservice = MWebService.get(m_cs.getCtx(), webServiceValue);
        if (m_webservice == null || !m_webservice.isActive()) {
            return "Web Service " + webServiceValue + " not registered";
        }
        X_WS_WebServiceMethod m_webservicemethod = m_webservice.getMethod(methodValue);
        if (m_webservicemethod == null || !m_webservicemethod.isActive()) {
            return "Method " + methodValue + " not registered";
        }
        MWebServiceType m_webservicetype = null;
        String key = String.valueOf(m_cs.getAD_Client_ID()) + "|" + m_webservice.getWS_WebService_ID() + "|" + m_webservicemethod.getWS_WebServiceMethod_ID() + "|" + serviceTypeValue;
        CCache<String, MWebServiceType> cCache = s_WebServiceTypeCache;
        synchronized (cCache) {
            m_webservicetype = (MWebServiceType)((Object)s_WebServiceTypeCache.get((Object)key));
            if (m_webservicetype == null && (m_webservicetype = (MWebServiceType)new Query(m_cs.getCtx(), "WS_WebServiceType", "AD_Client_ID IN (0,?) AND WS_WebService_ID=? AND WS_WebServiceMethod_ID=? AND Value=?", null).setOnlyActiveRecords(true).setParameters(new Object[]{m_cs.getAD_Client_ID(), m_webservice.getWS_WebService_ID(), m_webservicemethod.getWS_WebServiceMethod_ID(), serviceTypeValue}).setOrderBy("AD_Client_ID DESC").first()) != null) {
                s_WebServiceTypeCache.put((Object)key, (Object)m_webservicetype);
            }
        }
        if (m_webservicetype == null) {
            return "Service type " + serviceTypeValue + " not configured";
        }
        this.getHttpServletRequest().setAttribute("MWebServiceType", (Object)m_webservicetype);
        int AD_Role_ID = Env.getAD_Role_ID((Properties)m_cs.getCtx());
        key = String.valueOf(AD_Role_ID) + "|" + m_webservicetype.get_ID();
        CCache<String, Boolean> cCache2 = s_RoleAccessCache;
        synchronized (cCache2) {
            Boolean bAccess = (Boolean)s_RoleAccessCache.get((Object)key);
            if (bAccess == null) {
                String hasAccess = DB.getSQLValueStringEx(null, (String)ROLE_ACCESS_SQL, (Object[])new Object[]{AD_Role_ID, AD_Role_ID, m_webservicetype.get_ID()});
                bAccess = "Y".equals(hasAccess);
                s_RoleAccessCache.put((Object)key, (Object)bAccess);
            }
            if (!bAccess.booleanValue()) {
                return "Web Service Error: Login role does not have access to the service type";
            }
        }
        String ret = AbstractService.invokeLoginValidator(null, m_cs.getCtx(), m_webservicetype, 7);
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        m_cs.refreshLastAuthorizationTime();
        return null;
    }

    protected static StandardResponseDocument rollbackAndSetError(Trx trx, StandardResponse resp, StandardResponseDocument ret, boolean isError, String string) {
        resp.setError(string);
        resp.setIsError(isError);
        trx.rollback();
        trx.close();
        return ret;
    }

    protected CompiereService getCompiereService() {
        HttpServletRequest req = this.getHttpServletRequest();
        CompiereService m_cs = (CompiereService)req.getAttribute(COMPIERE_SERVICE);
        if (m_cs == null) {
            m_cs = new CompiereService();
            req.setAttribute(COMPIERE_SERVICE, (Object)m_cs);
        }
        return m_cs;
    }

    protected MWebServiceType getWebServiceType() {
        return (MWebServiceType)((Object)this.getHttpServletRequest().getAttribute("MWebServiceType"));
    }

    protected Map<String, Object> getRequestCtx() {
        HttpServletRequest req = this.getHttpServletRequest();
        HashMap reqCtx = (HashMap)req.getAttribute("RequestCtx");
        if (reqCtx == null) {
            reqCtx = new HashMap();
            req.setAttribute("RequestCtx", reqCtx);
        }
        return reqCtx;
    }

    protected void setOuputFields(StandardResponse resp, MWebServiceType m_webservicetype, PO po, POInfo poInfo) {
        String[] outCols = m_webservicetype.getOutputColumnNames(false);
        if (outCols.length > 0) {
            OutputFields outputFields = resp.addNewOutputFields();
            if (outputFields == null) {
                outputFields = resp.addNewOutputFields();
            }
            String[] stringArray = outCols;
            int n = outCols.length;
            int n2 = 0;
            while (n2 < n) {
                String colName = stringArray[n2];
                int indCol = poInfo.getColumnIndex(colName);
                if (indCol >= 0) {
                    OutputField outField = outputFields.addNewOutputField();
                    outField.setColumn(colName);
                    if (po.get_Value(indCol) != null) {
                        if (po.get_Value(indCol) instanceof byte[]) {
                            outField.setValue(new String(Base64.encodeBase64((byte[])((byte[])po.get_Value(indCol)))));
                        } else {
                            outField.setValue(po.get_Value(indCol).toString());
                        }
                        Lookup lookup = poInfo.getColumnLookup(indCol);
                        if (lookup != null) {
                            NamePair pair;
                            if (lookup.getSize() == 0) {
                                lookup.refresh();
                            }
                            if ((pair = lookup.getDirect(po.get_Value(indCol), false, false)) != null) {
                                outField.setText(pair.getName());
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected String parseSQL(String sql, ArrayList<Object> sqlParas, PO po, POInfo poInfo, Map<String, Object> requestCtx) throws AdempiereException {
        if (sql.startsWith("@SQL=")) {
            sql = sql.substring(5);
        }
        if (sql.toLowerCase().indexOf(" where ") == -1) {
            throw new AdempiereException("Invalid SQL: Query do not have any filetering criteria");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        if (sql.indexOf(64) == -1) {
            sqlBuilder.append(sql);
        } else {
            int firstInd = sql.indexOf(64);
            while (firstInd >= 0) {
                sqlBuilder.append(sql.substring(0, firstInd));
                sql = sql.substring(firstInd + 1);
                firstInd = sql.indexOf(64);
                if (firstInd == -1) {
                    throw new AdempiereException("Missing closing '@' in SQL");
                }
                String token = sql.substring(0, firstInd);
                boolean isNullable = false;
                if (token.charAt(0) == '!') {
                    isNullable = true;
                    token = token.substring(1);
                }
                sql = sql.substring(firstInd + 1);
                Object val = this.parseVariable(token, po, poInfo, requestCtx);
                if (val == null && isNullable) {
                    int ind = sqlBuilder.lastIndexOf("=");
                    sqlBuilder.replace(ind, sqlBuilder.length(), " Is Null ");
                } else {
                    if (val == null) {
                        throw new AdempiereException("Can not resolve varialbe '" + token + "' in sql");
                    }
                    sqlBuilder.append(" ? ");
                    sqlParas.add(val);
                }
                firstInd = sql.indexOf(64);
            }
            sqlBuilder.append(sql);
        }
        return sqlBuilder.toString();
    }

    protected Object parseVariable(String varName, PO po, POInfo poInfo, Map<String, Object> requestCtx) {
        int indDot;
        Object val = null;
        if (varName.charAt(0) == '@') {
            varName = varName.substring(1);
        }
        if ((indDot = varName.indexOf(".")) == -1) {
            if (varName.charAt(0) == '#') {
                val = this.getCompiereService().getCtx().getProperty(varName);
                if (varName.endsWith("_ID") && val != null) {
                    Integer intVal = Integer.parseInt((String)val);
                    val = intVal;
                }
            } else {
                if (po != null && poInfo.getColumnIndex(varName) != -1) {
                    val = po.get_Value(varName);
                }
                if (val == null) {
                    val = requestCtx.get(varName);
                }
            }
        } else {
            String tblName = varName.substring(0, indDot);
            String colName = varName.substring(indDot + 1);
            if (colName.indexOf(".") >= 0) {
                throw new IdempiereServiceFault(" can not resolve " + varName + ". contains un supported multi level object resolution", new QName("resolveCtxVariable"));
            }
            Object obj = requestCtx.get(tblName);
            if (obj == null || !(obj instanceof PO)) {
                throw new IdempiereServiceFault(" can not found object of " + tblName + ". Request variable " + varName + " can not resolved", new QName("resolveCtxVariable"));
            }
            PO refPO = (PO)obj;
            val = refPO.get_Value(colName);
        }
        return val;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertToObj(String strValue, Class<?> columnClass, String colName) {
        Boolean value = null;
        if (columnClass == Boolean.class) {
            if ("Y".equalsIgnoreCase(strValue)) return Boolean.TRUE;
            if ("true".equalsIgnoreCase(strValue)) {
                return Boolean.TRUE;
            }
            if ("N".equalsIgnoreCase(strValue)) return Boolean.FALSE;
            if (!"false".equalsIgnoreCase(strValue)) throw new IdempiereServiceFault(" input column " + colName + " wrong value " + strValue, new QName("setValueAccordingToClass"));
            return Boolean.FALSE;
        }
        if (columnClass == Integer.class) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " for " + colName, e.getCause(), new QName("setValueAccordingToClass"));
            }
        }
        if (columnClass == BigDecimal.class) {
            try {
                return new BigDecimal(strValue);
            }
            catch (Exception e) {
                throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " for " + colName, e.getCause(), new QName("setValueAccordingToClass"));
            }
        }
        if (columnClass == Timestamp.class) {
            try {
                return Timestamp.valueOf(strValue);
            }
            catch (Exception e) {
                throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " for " + colName, e.getCause(), new QName("setValueAccordingToClass"));
            }
        }
        if (columnClass != byte[].class) return strValue;
        try {
            return (Boolean)Base64.decodeBase64((byte[])strValue.getBytes());
        }
        catch (Exception e) {
            throw new IdempiereServiceFault(String.valueOf(e.getClass().toString()) + " " + e.getMessage() + " for " + colName, e.getCause(), new QName("setValueAccordingToClass"));
        }
    }

    protected Class<?> getVariableType(String columnName, int displayType) {
        Class ColumnClass = null;
        ColumnClass = columnName.equals("AD_Language") || columnName.equals("EntityType") ? String.class : (columnName.equals("Posted") || columnName.equals("Processed") || columnName.equals("Processing") ? Boolean.class : (columnName.equals("Record_ID") ? Integer.class : DisplayType.getClass((int)displayType, (boolean)true)));
        return ColumnClass;
    }

    public static List<IWSValidator> getValidators(String serviceType) {
        ServiceQuery query = new ServiceQuery();
        query.put((Object)"WSType", (Object)serviceType);
        return EquinoxExtensionLocator.instance().list(IWSValidator.class, query).getExtensions();
    }

    public static StandardResponseDocument invokeWSValidator(MWebServiceType m_WebServiceType, int time, PO po, DataField[] fields, Trx trx, Map<String, Object> requestCtx, StandardResponse resp, StandardResponseDocument ret) {
        List<IWSValidator> validators = AbstractService.getValidators(m_WebServiceType.getValue());
        List<IWSValidator> globalValidators = AbstractService.getValidators("GLOBAL");
        for (IWSValidator validator : globalValidators) {
            try {
                validator.validate(po, m_WebServiceType, fields, time, trx.getTrxName(), requestCtx);
            }
            catch (IdempiereServiceFault e) {
                return AbstractService.rollbackAndSetError(trx, resp, ret, true, e.getMessage());
            }
        }
        for (IWSValidator validator : validators) {
            try {
                validator.validate(po, m_WebServiceType, fields, time, trx.getTrxName(), requestCtx);
            }
            catch (IdempiereServiceFault e) {
                return AbstractService.rollbackAndSetError(trx, resp, ret, true, e.getMessage());
            }
        }
        return null;
    }

    public static String invokeLoginValidator(ADLoginRequest loginRequest, Properties ctx, MWebServiceType m_webserviceType, int time) {
        List<IWSValidator> validators = null;
        if (m_webserviceType != null) {
            validators = AbstractService.getValidators(m_webserviceType.getValue());
        }
        List<IWSValidator> globalValidators = AbstractService.getValidators("GLOBAL");
        for (IWSValidator validator : globalValidators) {
            try {
                validator.login(loginRequest, ctx, m_webserviceType, time);
            }
            catch (IdempiereServiceFault e) {
                return e.getMessage();
            }
        }
        if (validators != null) {
            for (IWSValidator validator : validators) {
                try {
                    validator.login(loginRequest, ctx, m_webserviceType, time);
                }
                catch (IdempiereServiceFault e) {
                    return e.getMessage();
                }
            }
        }
        return null;
    }

    private HttpServletRequest getHttpServletRequest() {
        HttpServletRequest req = this.jaxrsContext != null ? this.jaxrsContext.getHttpServletRequest() : (HttpServletRequest)this.jaxwsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        return req;
    }
}

