/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.adinterface;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.adempiere.util.ServerContext;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.idempiere.adInterface.x10.ADLoginRequest;
import org.idempiere.adinterface.CompiereUtil;

public class CompiereService {
    private static CLogger log = CLogger.getCLogger(CompiereService.class);
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private int m_AD_User_ID;
    private int m_AD_Role_ID;
    private int m_M_Warehouse_ID;
    private String m_locale;
    private String m_userName;
    private String m_password;
    private int m_expiryMinutes;
    private long m_lastAuthorizationTime;
    private String m_IPAddress;
    private static Map<String, CompiereService> csMap = new HashMap<String, CompiereService>();
    private static Map<String, Properties> ctxMap = new HashMap<String, Properties>();
    private boolean m_loggedin = false;
    public SimpleDateFormat dateFormat = null;
    public SimpleDateFormat dateFormatJDBC = null;
    public SimpleDateFormat dateTimeFormat = null;
    public SimpleDateFormat dateTimeFormatJDBC = null;
    public SimpleDateFormat timeFormat = null;
    public SimpleDateFormat timeFormatJDBC = null;
    private Language m_language;
    public final String dateFormatOnlyForCtx = "yyyy-MM-dd";
    private int m_connectCount = 0;

    public synchronized int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public synchronized int getAD_Org_ID() {
        return this.m_AD_Org_ID;
    }

    public synchronized Properties getCtx() {
        return Env.getCtx();
    }

    public void connect() {
        CompiereUtil.initWeb();
        ServerContext.setCurrentInstance((Properties)new Properties());
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)"en_US");
        this.m_language = Language.getLanguage((String)"en_US");
        this.dateFormat = DisplayType.getDateFormat((int)15, (Language)this.m_language);
        this.dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)this.m_language);
        this.timeFormat = DisplayType.getDateFormat((int)24, (Language)this.m_language);
        this.dateFormatJDBC = DisplayType.getDateFormat_JDBC();
        this.dateTimeFormatJDBC = DisplayType.getTimestampFormat_Default();
        this.timeFormatJDBC = DisplayType.getTimeFormat_Default();
        ++this.m_connectCount;
    }

    public synchronized void connectCacheInstance() {
        ++this.m_connectCount;
    }

    public synchronized void disconnect() {
        --this.m_connectCount;
        this.expungeIfExpire();
    }

    public synchronized Language getLanguage() {
        return this.m_language;
    }

    public synchronized boolean isLoggedIn() {
        return this.m_loggedin;
    }

    private synchronized String checkLogin(Properties ctx, int AD_User_ID, int AD_Role_ID, int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID) {
        String loginInfo;
        block8: {
            loginInfo = null;
            String sql = "SELECT u.Name || '@' || c.Name || '.' || o.Name AS Text FROM AD_User u, AD_Client c, AD_Org o, AD_User_Roles ur, AD_Role r WHERE u.AD_User_ID=? AND c.AD_Client_ID=? AND o.AD_Org_ID=? AND ur.AD_Role_ID=? AND ur.AD_User_ID=u.AD_User_ID AND ur.AD_Role_ID=r.AD_Role_ID AND (o.AD_Client_ID = 0 OR o.AD_Client_ID=c.AD_Client_ID) AND (r.IsAccessAllOrgs='Y' OR (c.AD_Client_ID IN (SELECT AD_Client_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID) AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID)))";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, AD_Client_ID);
                    pstmt.setInt(3, AD_Org_ID);
                    pstmt.setInt(4, AD_Role_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        loginInfo = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (loginInfo == null) {
            return null;
        }
        KeyNamePair org = new KeyNamePair(AD_Org_ID, String.valueOf(AD_Org_ID));
        KeyNamePair wh = null;
        if (M_Warehouse_ID > 0) {
            wh = new KeyNamePair(M_Warehouse_ID, String.valueOf(M_Warehouse_ID));
        }
        Timestamp date = null;
        String printer = null;
        Login login = new Login(ctx);
        login.loadPreferences(org, wh, date, printer);
        return loginInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean login(int AD_User_ID, int AD_Role_ID, int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID, String Lang) {
        this.m_loggedin = false;
        String loginInfo = this.checkLogin(this.getCtx(), AD_User_ID, AD_Role_ID, AD_Client_ID, AD_Org_ID, M_Warehouse_ID);
        if (loginInfo == null) {
            return false;
        }
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_locale = Lang;
        boolean email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
        MUser user = MUser.get((Properties)this.getCtx(), (int)this.m_AD_User_ID);
        this.m_userName = email_login ? user.getEMail() : user.getName();
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)Lang);
        this.m_language = Language.getLanguage((String)Lang);
        Env.verifyLanguage((Properties)this.getCtx(), (Language)this.m_language);
        this.dateFormat = DisplayType.getDateFormat((int)15, (Language)this.m_language);
        this.dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)this.m_language);
        this.timeFormat = DisplayType.getDateFormat((int)24, (Language)this.m_language);
        this.dateFormatJDBC = DisplayType.getDateFormat_JDBC();
        this.dateTimeFormatJDBC = DisplayType.getTimestampFormat_Default();
        this.timeFormatJDBC = DisplayType.getTimeFormat_Default();
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext((Properties)this.getCtx(), (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
        if (log.isLoggable(Level.INFO)) {
            log.info(" #Date = " + Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        }
        Env.setContext((Properties)this.getCtx(), (String)"#M_Warehouse_ID", (int)M_Warehouse_ID);
        Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)this.m_language.getAD_Language());
        MSession session = MSession.get((Properties)this.getCtx(), (boolean)false);
        if (session == null) {
            log.fine("No Session found");
            session = MSession.get((Properties)this.getCtx(), (boolean)true);
        }
        session.setWebSession("WebService");
        session.setDescription(String.valueOf(session.getDescription()) + "\nUser Agent: " + this.getCtx().getProperty("#UserAgent"));
        session.saveEx();
        this.m_loggedin = true;
        Map<String, CompiereService> map = csMap;
        synchronized (map) {
            String key = CompiereService.getKey(this.m_AD_Client_ID, this.m_AD_Org_ID, this.m_userName, this.m_AD_Role_ID, this.m_M_Warehouse_ID, this.m_locale, this.m_password, this.m_IPAddress);
            if (!csMap.containsKey(key)) {
                csMap.put(key.toString(), this);
                Properties savedCache = new Properties();
                savedCache.putAll((Map<?, ?>)Env.getCtx());
                ctxMap.put(key.toString(), savedCache);
                if (log.isLoggable(Level.INFO)) {
                    log.info("Saving " + this + " in cache");
                }
            }
        }
        return true;
    }

    public synchronized int getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public synchronized int getAD_Role_ID() {
        return this.m_AD_Role_ID;
    }

    public synchronized String getLocale() {
        return this.m_locale;
    }

    public synchronized int getM_Warehouse_ID() {
        return this.m_M_Warehouse_ID;
    }

    public synchronized String getUserName() {
        return this.m_userName;
    }

    public synchronized void setPassword(String pass) {
        this.m_password = pass;
    }

    public synchronized String getPassword() {
        return this.m_password;
    }

    public synchronized void setExpiryMinutes(int expiryMinutes) {
        this.m_expiryMinutes = expiryMinutes;
    }

    public synchronized int getExpiryMinutes() {
        return this.m_expiryMinutes;
    }

    public synchronized void refreshLastAuthorizationTime() {
        this.m_lastAuthorizationTime = System.currentTimeMillis();
    }

    public synchronized void setIPAddress(String remoteAddr) {
        this.m_IPAddress = remoteAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiereService get(HttpServletRequest req, ADLoginRequest loginRequest) {
        String key = CompiereService.getKey(loginRequest.getClientID(), loginRequest.getOrgID(), loginRequest.getUser(), loginRequest.getRoleID(), loginRequest.getWarehouseID(), loginRequest.getLang(), loginRequest.getPass(), req.getRemoteAddr());
        CompiereService l_cs = null;
        Map<String, CompiereService> map = csMap;
        synchronized (map) {
            if (csMap.containsKey(key) && (l_cs = csMap.get(key)) != null) {
                if (l_cs.expungeIfExpire()) {
                    l_cs = null;
                } else {
                    Properties cachedCtx = ctxMap.get(key);
                    Env.getCtx().putAll((Map<?, ?>)cachedCtx);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Reusing " + l_cs);
                    }
                }
            }
        }
        return l_cs;
    }

    private static String getKey(int aD_Client_ID, int aD_Org_ID, String userName, int aD_Role_ID, int m_Warehouse_ID, String locale, String password, String iPAddress) {
        StringBuilder key = new StringBuilder().append(aD_Client_ID).append("|").append(aD_Org_ID).append("|").append(userName).append("|").append(aD_Role_ID).append("|").append(m_Warehouse_ID).append("|").append(locale).append("|").append(password).append("|").append(iPAddress);
        return key.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean expungeIfExpire() {
        boolean expired;
        boolean bl = expired = this.getExpiryMinutes() <= 0 || this.m_lastAuthorizationTime + (long)(this.getExpiryMinutes() * 60000) <= System.currentTimeMillis();
        if (this.m_connectCount == 0 && expired) {
            Map<String, CompiereService> map = csMap;
            synchronized (map) {
                String key = CompiereService.getKey(this.m_AD_Client_ID, this.m_AD_Org_ID, this.m_userName, this.m_AD_Role_ID, this.m_M_Warehouse_ID, this.m_locale, this.m_password, this.m_IPAddress);
                if (csMap.containsKey(key)) {
                    csMap.remove(key);
                }
                if (ctxMap.containsKey(key)) {
                    Properties cachedCtx = ctxMap.remove(key);
                    Properties currentCtx = ServerContext.getCurrentInstance();
                    try {
                        ServerContext.setCurrentInstance((Properties)cachedCtx);
                        if (log.isLoggable(Level.INFO)) {
                            log.info("Closing expired/invalid " + this);
                        }
                        Env.logout();
                    }
                    finally {
                        if (currentCtx == cachedCtx) {
                            ServerContext.dispose();
                        } else {
                            ServerContext.setCurrentInstance((Properties)currentCtx);
                        }
                    }
                }
                this.m_loggedin = false;
            }
        }
        return expired;
    }
}

