/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_WS_WebService;
import org.compiere.model.X_WS_WebServiceMethod;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MWebService
extends X_WS_WebService {
    private static final long serialVersionUID = 3561409141850981248L;
    private X_WS_WebServiceMethod[] m_methods = null;
    private static CCache<Integer, MWebService> s_cache = new CCache("WS_WebService", 20);
    private static CLogger s_log = CLogger.getCLogger(MWebService.class);

    public static MWebService get(Properties ctx, int WS_WebService_ID) {
        Integer key = WS_WebService_ID;
        MWebService retValue = (MWebService)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWebService(ctx, WS_WebService_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static synchronized MWebService get(Properties ctx, String webServiceValue) {
        MWebService retValue2;
        block9: {
            if (webServiceValue == null) {
                return null;
            }
            for (MWebService retValue2 : s_cache.values()) {
                if (!webServiceValue.equals(retValue2.getValue())) continue;
                return retValue2;
            }
            retValue2 = null;
            String sql = "SELECT * FROM WS_WebService WHERE Value=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setString(1, webServiceValue);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue2 = new MWebService(ctx, rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue2 != null) {
            Integer key = retValue2.getWS_WebService_ID();
            s_cache.put((Object)key, (Object)retValue2);
        }
        return retValue2;
    }

    public X_WS_WebServiceMethod[] getMethods(boolean requery) {
        ArrayList<X_WS_WebServiceMethod> list;
        block7: {
            if (this.m_methods != null && !requery) {
                return this.m_methods;
            }
            String sql = "SELECT * FROM WS_WebServiceMethod WHERE WS_WebService_ID=? AND IsActive='Y' ORDER BY Value";
            list = new ArrayList<X_WS_WebServiceMethod>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getWS_WebService_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new X_WS_WebServiceMethod(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_methods = new X_WS_WebServiceMethod[list.size()];
        list.toArray(this.m_methods);
        return this.m_methods;
    }

    public X_WS_WebServiceMethod getMethod(String methodValue) {
        if (methodValue == null || methodValue.length() == 0) {
            return null;
        }
        this.getMethods(false);
        int i = 0;
        while (i < this.m_methods.length) {
            if (methodValue.equals(this.m_methods[i].getValue())) {
                return this.m_methods[i];
            }
            ++i;
        }
        return null;
    }

    public MWebService(Properties ctx, int WS_WebService_ID, String trxName) {
        super(ctx, WS_WebService_ID, trxName);
    }

    public MWebService(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

