/*
 * Decompiled with CFR 0.152.
 */
package net.sf.compilo.report;

import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import net.sf.compilo.data.CompiereDataSourceFactory;
import net.sf.compilo.data.compiereDataSource;
import net.sf.compilo.report.ReportInfo;
import net.sf.compilo.report.ReportPool;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;

public class ReportProcessor {
    public static File REPORT_HOME = null;
    private static CLogger log = CLogger.getCLogger(ReportProcessor.class);
    private int m_AD_PInstance_ID = 0;
    private int m_AD_Process_ID = 0;
    private int m_Record_ID = 0;
    private HashMap<String, Object> m_Param = null;
    private Properties m_ctx = null;
    private JasperPrint m_jasperPrint = null;
    private ProcessInfo m_pi = null;

    static {
        String reportPath = Ini.getAdempiereHome();
        String classpath = Thread.currentThread().getContextClassLoader().getResource("net/sf/jasperreports/engine").toString();
        System.setProperty("jasper.reports.compile.temp", reportPath);
        System.setProperty("jasper.reports.compile.class.path", classpath.split("file:/")[1].split("!")[0]);
        REPORT_HOME = new File(reportPath);
        if (!REPORT_HOME.exists()) {
            log.saveError("The Report_Home not exists", REPORT_HOME.getAbsolutePath());
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Set REPORT_HOME to " + REPORT_HOME.getAbsolutePath());
        }
    }

    public ReportProcessor(Properties ctx, ProcessInfo pi) {
        System.setProperty("jasper.reports.compile.keep.java.file", "true");
        this.m_AD_PInstance_ID = pi.getAD_PInstance_ID();
        this.m_AD_Process_ID = pi.getAD_Process_ID();
        this.m_Record_ID = pi.getRecord_ID();
        this.m_Param = new HashMap();
        this.m_ctx = ctx;
        this.m_pi = pi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JasperPrint runReport() {
        System.setProperty("jasper.reports.compile.keep.java.file", "true");
        ReportPool rp = new ReportPool();
        ReportInfo reportInfo = rp.getReport(this.m_AD_Process_ID);
        rp = null;
        if (!reportInfo.hasError() && reportInfo.getJasperReport() != null) {
            this.m_Param.putAll(reportInfo.getSubReport());
            this.addProcessParameters(this.m_AD_PInstance_ID, this.m_Param);
            this.m_Param.put("RECORD_ID", this.m_Record_ID);
            this.m_Param.put("REPORT_HOME", REPORT_HOME);
            Language currLang = Env.getLanguage((Properties)Env.getCtx());
            this.m_Param.put("CURRENT_LANG", currLang.getAD_Language());
            Connection conn = DB.getConnectionRO();
            this.m_Param.put("REPORT_CONNECTION", conn);
            this.m_Param.put("DB_CONN", conn);
            try (compiereDataSource ds = null;){
                try {
                    ds = CompiereDataSourceFactory.createDataSource(this.m_ctx, reportInfo, this.m_pi, this.m_Param);
                    this.m_jasperPrint = JasperFillManager.fillReport((JasperReport)reportInfo.getJasperReport(), this.m_Param, (JRDataSource)ds);
                    log.finest("ReportProcessor.fillReport");
                    return this.m_jasperPrint;
                }
                catch (JRException e) {
                    this.m_jasperPrint = null;
                    e.printStackTrace();
                    if (ds == null) return this.m_jasperPrint;
                    ds.close();
                    return this.m_jasperPrint;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (ds == null) return this.m_jasperPrint;
                    ds.close();
                    return this.m_jasperPrint;
                }
            }
        } else {
            System.out.println("Error:" + reportInfo.getErrorMsg());
        }
        return this.m_jasperPrint;
    }

    private void addProcessParameters(int AD_PInstance_ID, Map<String, Object> params) {
        log.finest("ReportStarter.addProcessParameters");
        MPInstance pinstance = new MPInstance(this.m_ctx, AD_PInstance_ID, null);
        MPInstancePara[] pinstancePara = pinstance.getParameters();
        this.m_Record_ID = pinstance.getRecord_ID();
        params.put("AD_Client_ID", pinstance.getAD_Client_ID());
        params.put("AD_Org_ID", pinstance.getAD_Org_ID());
        int i2 = 0;
        while (i2 < pinstancePara.length) {
            MPInstancePara para = pinstancePara[i2];
            if (para.getInfo() != null) {
                if (para.getInfo_To() != null) {
                    params.put(String.valueOf(para.getParameterName()) + "_Info1", para.getInfo());
                    params.put(String.valueOf(para.getParameterName()) + "_info2", para.getInfo_To());
                } else {
                    params.put(String.valueOf(para.getParameterName()) + "_Info", para.getInfo());
                }
            } else {
                params.put(String.valueOf(para.getParameterName()) + "_Info", "");
                params.put(String.valueOf(para.getParameterName()) + "_Info1", "");
                params.put(String.valueOf(para.getParameterName()) + "_info2", "");
            }
            if (para.getP_String() != null) {
                if (para.getP_String_To() != null) {
                    params.put(String.valueOf(para.getParameterName()) + "1", para.getP_String());
                    params.put(String.valueOf(para.getParameterName()) + "2", para.getP_String_To());
                } else {
                    params.put(para.getParameterName(), para.getP_String());
                }
            } else if (para.getP_Date() != null) {
                if (para.getP_Date() != null) {
                    params.put(String.valueOf(para.getParameterName()) + "1", para.getP_Date());
                    params.put(String.valueOf(para.getParameterName()) + "2", para.getP_Date_To());
                } else {
                    params.put(para.getParameterName(), para.getP_Date());
                }
            } else if (para.getP_Number() != null) {
                Double pDoubleNum;
                Integer pIntNum;
                if (para.getP_Number_To() != null) {
                    try {
                        pIntNum = Integer.valueOf(para.getP_Number().toString());
                        Integer pIntNumTo = Integer.valueOf(para.getP_Number_To().toString());
                        params.put(String.valueOf(para.getParameterName()) + "1", pIntNum);
                        params.put(String.valueOf(para.getParameterName()) + "2", pIntNumTo);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            pDoubleNum = Double.valueOf(para.getP_Number().toString());
                            Double pDoubleNumTo = Double.valueOf(para.getP_Number_To().toString());
                            params.put(String.valueOf(para.getParameterName()) + "1", pDoubleNum);
                            params.put(String.valueOf(para.getParameterName()) + "2", pDoubleNumTo);
                        }
                        catch (NumberFormatException nfe2) {
                            params.put(String.valueOf(para.getParameterName()) + "1", para.getP_Number());
                            params.put(String.valueOf(para.getParameterName()) + "2", para.getP_Number_To());
                        }
                    }
                } else {
                    try {
                        pIntNum = Integer.valueOf(para.getP_Number().toString());
                        params.put(para.getParameterName(), pIntNum);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            pDoubleNum = Double.valueOf(para.getP_Number().toString());
                            params.put(para.getParameterName(), pDoubleNum);
                        }
                        catch (NumberFormatException nfe2) {
                            params.put(para.getParameterName(), para.getP_Number());
                        }
                    }
                }
            }
            ++i2;
        }
    }
}

