/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.passay.dictionary.AbstractWordList;
import org.passay.dictionary.WordLists;

public abstract class AbstractFileWordList
extends AbstractWordList {
    public static final int DEFAULT_CACHE_PERCENT = 5;
    protected final RandomAccessFile file;
    protected int size;
    private Cache cache;
    private final CharsetDecoder charDecoder;
    private final ByteBuffer wordBuf = ByteBuffer.allocate(256);
    private final CharBuffer charBuf = CharBuffer.allocate(this.wordBuf.capacity() * 4);
    private long position;

    public AbstractFileWordList(RandomAccessFile raf, boolean caseSensitive, CharsetDecoder decoder) throws IOException {
        this.file = raf;
        this.comparator = caseSensitive ? WordLists.CASE_SENSITIVE_COMPARATOR : WordLists.CASE_INSENSITIVE_COMPARATOR;
        this.charDecoder = decoder;
    }

    @Override
    public String get(int index) {
        this.checkRange(index);
        try {
            return this.readWord(index);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from file backing word list", e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Cache cache = this.cache;
        synchronized (cache) {
            this.file.close();
        }
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(int cachePercent, boolean allocateDirect) throws IOException {
        this.cache = new Cache(this.file.length(), cachePercent, allocateDirect);
        FileWord b = null;
        Cache cache = this.cache;
        synchronized (cache) {
            FileWord a;
            this.position = 0L;
            this.seek(this.position);
            while ((a = this.nextWord()) != null) {
                if (b != null && this.comparator.compare(a.word, b.word) < 0) {
                    throw new IllegalArgumentException("File is not sorted correctly for this comparator");
                }
                b = a;
                this.cache.put(this.size++, a.offset);
            }
            this.cache.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readWord(int index) throws IOException {
        Cache cache = this.cache;
        synchronized (cache) {
            FileWord w;
            Cache.Entry entry = this.cache.get(index);
            int i = entry.index;
            this.seek(entry.position);
            do {
                w = this.nextWord();
            } while (i++ < index && w != null);
            return w != null ? w.word : null;
        }
    }

    protected abstract void seek(long var1) throws IOException;

    protected abstract ByteBuffer buffer();

    protected abstract void fill() throws IOException;

    private FileWord nextWord() throws IOException {
        long start = this.position;
        this.wordBuf.clear();
        while (this.hasRemaining()) {
            byte b = this.buffer().get();
            ++this.position;
            if ((char)b == '\n' || (char)b == '\r') {
                if (this.wordBuf.position() != 0) break;
                ++start;
                continue;
            }
            this.wordBuf.put(b);
        }
        if (this.wordBuf.position() == 0) {
            return null;
        }
        this.charBuf.clear();
        this.wordBuf.flip();
        CoderResult result = this.charDecoder.decode(this.wordBuf, this.charBuf, true);
        if (result.isError()) {
            result.throwException();
        }
        return new FileWord(this.charBuf.flip().toString(), start);
    }

    private boolean hasRemaining() throws IOException {
        if (this.buffer().hasRemaining()) {
            return true;
        }
        this.fill();
        return this.buffer().hasRemaining();
    }

    public String toString() {
        return String.format("%s@%h::size=%s,cache=%s,charDecoder=%s", this.getClass().getName(), this.hashCode(), this.size, this.cache, this.charDecoder);
    }

    private static class Cache {
        private LongBuffer map;
        private int modulus;
        private boolean allocateDirect;
        private boolean initialized;

        Cache(long fileSize, int cachePercent, boolean direct) {
            if (cachePercent < 0 || cachePercent > 100) {
                throw new IllegalArgumentException("cachePercent must be between 0 and 100 inclusive");
            }
            this.allocateDirect = direct;
            long cacheSize = fileSize / 100L * (long)cachePercent;
            if (cacheSize > 0L) {
                this.modulus = (int)(fileSize / cacheSize);
                this.resize(cacheSize);
            }
        }

        void put(int index, long position) {
            if (this.initialized) {
                throw new IllegalStateException("Cache initialized, put is not allowed");
            }
            if (this.modulus == 0 || index % this.modulus > 0) {
                return;
            }
            if (this.map.position() == this.map.capacity()) {
                long newSize = (long)this.map.capacity() * 12L;
                this.resize(newSize);
            }
            this.map.put(position);
        }

        Entry get(int index) {
            if (this.modulus == 0 || index < this.modulus) {
                return new Entry(0, 0L);
            }
            int i = index / this.modulus;
            this.map.position(i);
            return new Entry(i * this.modulus, this.map.get());
        }

        private void resize(long size) {
            LongBuffer temp;
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Cache limit exceeded. Try reducing cacheSize.");
            }
            LongBuffer longBuffer = temp = this.allocateDirect ? ByteBuffer.allocateDirect((int)size).asLongBuffer() : ByteBuffer.allocate((int)size).asLongBuffer();
            if (this.map == null) {
                this.map = temp;
            } else {
                this.map.rewind();
                temp.put(this.map);
                this.map = temp;
            }
        }

        public String toString() {
            return String.format("%s@%h::size=%s,modulus=%s,allocateDirect=%s,initialized=%s", this.getClass().getSimpleName(), this.hashCode(), this.map != null ? this.map.capacity() : 0, this.modulus, this.allocateDirect, this.initialized);
        }

        static class Entry {
            int index;
            long position;

            Entry(int i, long pos) {
                this.index = i;
                this.position = pos;
            }
        }
    }

    protected static class FileWord {
        String word;
        long offset;

        FileWord(String s, long position) {
            this.word = s;
            this.offset = position;
        }
    }
}

