/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;
import org.passay.RuleResultMetadata;

public class LengthRule
implements Rule {
    public static final String ERROR_CODE_MIN = "TOO_SHORT";
    public static final String ERROR_CODE_MAX = "TOO_LONG";
    private int minimumLength;
    private int maximumLength;

    public LengthRule() {
        this(0, Integer.MAX_VALUE);
    }

    public LengthRule(int length) {
        this(length, length);
    }

    public LengthRule(int minLength, int maxLength) {
        this.minimumLength = minLength;
        this.maximumLength = maxLength;
    }

    public void setMinimumLength(int minLength) {
        this.minimumLength = minLength;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMaximumLength(int maxLength) {
        this.maximumLength = maxLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        int length = passwordData.getPassword().length();
        if (length >= this.minimumLength && length <= this.maximumLength) {
            result.setValid(true);
        } else {
            result.setValid(false);
            if (length < this.minimumLength) {
                result.getDetails().add(new RuleResultDetail(ERROR_CODE_MIN, this.createRuleResultDetailParameters()));
            } else {
                result.getDetails().add(new RuleResultDetail(ERROR_CODE_MAX, this.createRuleResultDetailParameters()));
            }
        }
        result.setMetadata(this.createRuleResultMetadata(passwordData));
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("minimumLength", this.minimumLength);
        m.put("maximumLength", this.maximumLength);
        return m;
    }

    protected RuleResultMetadata createRuleResultMetadata(PasswordData password) {
        return new RuleResultMetadata(RuleResultMetadata.CountCategory.Length, password.getPassword().length());
    }

    public String toString() {
        return String.format("%s@%h::minimumLength=%s,maximumLength=%s", this.getClass().getName(), this.hashCode(), this.minimumLength, this.maximumLength);
    }
}

