/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class LengthComplexityRule
implements Rule {
    public static final String ERROR_CODE = "INSUFFICIENT_COMPLEXITY";
    public static final String ERROR_CODE_RULES = "INSUFFICIENT_COMPLEXITY_RULES";
    private final Map<Interval, List<Rule>> rules = new HashMap<Interval, List<Rule>>();
    private boolean reportFailure = true;
    private boolean reportRuleFailures = true;

    public void addRules(String interval, List<Rule> l) {
        if (l == null || l.isEmpty()) {
            throw new IllegalArgumentException("Rules cannot be empty or null");
        }
        Interval i = new Interval(interval);
        for (Interval existingInterval : this.rules.keySet()) {
            if (!existingInterval.intersects(i)) continue;
            throw new IllegalArgumentException("Interval " + i + " intersects existing interval " + existingInterval);
        }
        this.rules.put(i, l);
    }

    public void addRules(String interval, Rule ... r) {
        this.addRules(interval, r != null ? Arrays.asList(r) : null);
    }

    public boolean getReportFailure() {
        return this.reportFailure;
    }

    public void setReportFailure(boolean b) {
        this.reportFailure = b;
    }

    public boolean getReportRuleFailures() {
        return this.reportRuleFailures;
    }

    public void setReportRuleFailures(boolean b) {
        this.reportRuleFailures = b;
    }

    public Map<Interval, List<? extends Rule>> getRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        int passwordLength = passwordData.getPassword().length();
        List<Rule> rulesByLength = this.getRulesByLength(passwordLength);
        if (rulesByLength == null) {
            return new RuleResult(false, new RuleResultDetail(ERROR_CODE_RULES, this.createRuleResultDetailParameters(passwordLength, 0, 0)));
        }
        int successCount = 0;
        RuleResult result = new RuleResult(true);
        for (Rule rule : rulesByLength) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                if (this.reportRuleFailures) {
                    result.getDetails().addAll(rr.getDetails());
                }
            } else {
                ++successCount;
            }
            result.getMetadata().merge(rr.getMetadata());
        }
        if (successCount < rulesByLength.size()) {
            result.setValid(false);
            if (this.reportFailure) {
                result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(passwordLength, successCount, rulesByLength.size())));
            }
        }
        return result;
    }

    private List<Rule> getRulesByLength(int length) {
        Optional<List> match = this.rules.entrySet().stream().filter(e -> ((Interval)e.getKey()).includes(length)).map(Map.Entry::getValue).findFirst();
        return match.isPresent() ? match.get() : null;
    }

    protected Map<String, Object> createRuleResultDetailParameters(int length, int success, int ruleCount) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("passwordLength", length);
        m.put("successCount", success);
        m.put("ruleCount", ruleCount);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::rules=%s,reportRuleFailures=%s", this.getClass().getName(), this.hashCode(), this.rules, this.reportRuleFailures);
    }

    public static class Interval {
        private static final Pattern INTERVAL_PATTERN = Pattern.compile("^([\\(|\\[])(\\d+),(\\d+|\\*)([\\)|\\]])$");
        private final Bound lowerBound;
        private final Bound upperBound;

        public Interval(String pattern) {
            Matcher m = INTERVAL_PATTERN.matcher(pattern);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid interval notation: " + pattern);
            }
            String lowerType = m.group(1);
            String lower = m.group(2);
            String upper = m.group(3);
            String upperType = m.group(4);
            this.lowerBound = new Bound(Integer.parseInt(lower), BoundType.parse(lowerType));
            this.upperBound = new Bound("*".equals(upper) ? Integer.MAX_VALUE : Integer.parseInt(upper), BoundType.parse(upperType));
            if (this.getUpperBoundClosed() - this.getLowerBoundClosed() < 0) {
                throw new IllegalArgumentException("Invalid interval notation: " + pattern + " produced an empty set");
            }
        }

        public boolean includes(int i) {
            boolean includes = false;
            if (i >= this.lowerBound.value && i <= this.upperBound.value) {
                if (i > this.lowerBound.value && i < this.upperBound.value) {
                    includes = true;
                } else if (i == this.lowerBound.value && this.lowerBound.isClosed()) {
                    includes = true;
                } else if (i == this.upperBound.value && this.upperBound.isClosed()) {
                    includes = true;
                }
            }
            return includes;
        }

        public boolean includes(Interval i) {
            return this.includes(i.getLowerBoundClosed()) && this.includes(i.getUpperBoundClosed());
        }

        public boolean intersects(Interval i) {
            return this.includes(i.getLowerBoundClosed()) || this.includes(i.getUpperBoundClosed());
        }

        private int getLowerBoundClosed() {
            return this.lowerBound.isClosed() ? this.lowerBound.value : this.lowerBound.value + 1;
        }

        private int getUpperBoundClosed() {
            return this.upperBound.isClosed() ? this.upperBound.value : this.upperBound.value - 1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                Interval other = (Interval)o;
                return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.lowerBound, this.upperBound);
        }

        public String toString() {
            return String.format("%s%s,%s%s", Character.valueOf(this.lowerBound.isClosed() ? (char)'[' : '('), this.lowerBound.value, this.upperBound.value, Character.valueOf(this.upperBound.isClosed() ? (char)']' : ')'));
        }

        private class Bound {
            private final int value;
            private final BoundType type;

            Bound(int i, BoundType bt) {
                this.value = i;
                this.type = bt;
            }

            public boolean isClosed() {
                return BoundType.CLOSED == this.type;
            }

            public boolean isOpen() {
                return BoundType.OPEN == this.type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (o != null && this.getClass() == o.getClass()) {
                    Bound other = (Bound)o;
                    return this.value == other.value && this.type == other.type;
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.value, this.type});
            }
        }

        public static enum BoundType {
            CLOSED,
            OPEN;


            public static BoundType parse(String text) {
                if ("[".equals(text) || "]".equals(text)) {
                    return CLOSED;
                }
                if ("(".equals(text) || ")".equals(text)) {
                    return OPEN;
                }
                throw new IllegalArgumentException("Invalid interval notation: " + text);
            }
        }
    }
}

