/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.wysiwygeditor.form;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.wysiwygeditor.form.JPiereCKEditorForm;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButton;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkforge.ckez.CKeditor;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.impl.XulElement;

public class JPiereCKEditor
implements EventListener<Event>,
ValueChangeListener,
IFormController {
    private static CLogger log = CLogger.getCLogger(JPiereCKEditor.class);
    private String baselang = Language.getBaseAD_Language();
    private JPiereCKEditorForm wysiwygEditorForm = null;
    private String baseTableName;
    private String trlTableName;
    private String columnName;
    private String keyColumnName;
    private int record_ID = 0;
    private PO po;
    private boolean isMultiLingual = true;
    private boolean isSameClientData = false;
    private final String JPIERE_CKEDITOR_IMAGE_PATH = MSysConfig.getValue((String)"JPIERE_CKEDITOR_IMAGE_PATH", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private final String JPIERE_CKEDITOR_CUSTOM_CONFIGURATIONS_PATH = MSysConfig.getValue((String)"JPIERE_CKEDITOR_CUSTOM_CONFIGURATIONS_PATH", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private Borderlayout mainLayout = new Borderlayout();
    private North north = new North();
    private Center center = new Center();
    private South south = new South();
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private WTableDirEditor tableDirEditor;
    private Combobox imagePathCombobox;
    private String[] imageDirs;
    private String imagePath;
    private Button SaveButton;
    private CKeditor ckeditor = new CKeditor();
    private String m_trxName;

    public JPiereCKEditor() throws IOException {
        this.wysiwygEditorForm = new JPiereCKEditorForm(this);
        LayoutUtils.addSclass((String)"jpiere-ckeditor-form", (HtmlBasedComponent)this.wysiwygEditorForm);
    }

    public ADForm getForm() {
        return this.wysiwygEditorForm;
    }

    public void initForm() {
        String errorMessage = this.prepare();
        if (errorMessage != null) {
            this.north.appendChild((Component)new Text(errorMessage));
            this.mainLayout.appendChild((Component)this.north);
            return;
        }
        this.zkInit();
        LayoutUtils.sendDeferLayoutEvent((Borderlayout)this.mainLayout, (int)100);
    }

    private String prepare() {
        this.wysiwygEditorForm.setSizable(true);
        this.wysiwygEditorForm.setClosable(true);
        this.wysiwygEditorForm.setMaximizable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.wysiwygEditorForm, (String)"95%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.wysiwygEditorForm, (String)"80%");
        this.wysiwygEditorForm.appendChild((Component)this.mainLayout);
        LayoutUtils.addSclass((String)"jpiere-ckeditor-form-content", (HtmlBasedComponent)this.mainLayout);
        this.wysiwygEditorForm.setBorder("normal");
        ProcessInfo pInfo = this.wysiwygEditorForm.getProcessInfo();
        if (pInfo == null) {
            return "ProcessInfo is Null";
        }
        this.record_ID = pInfo.getRecord_ID();
        GridTab gTab = this.wysiwygEditorForm.getGridTab();
        this.baseTableName = gTab.getTableName();
        MTable table_Trl = MTable.get((Properties)Env.getCtx(), (String)(String.valueOf(this.baseTableName) + "_Trl"));
        MClient client = MClient.get((Properties)Env.getCtx());
        if (table_Trl == null) {
            this.isMultiLingual = false;
        } else if (!client.isMultiLingualDocument()) {
            this.isMultiLingual = false;
        } else {
            this.isMultiLingual = true;
            this.trlTableName = String.valueOf(this.baseTableName) + "_Trl";
        }
        MToolBarButton[] toolBarButtons = MToolBarButton.getProcessButtonOfTab((int)gTab.getAD_Tab_ID(), null);
        int counter = 0;
        int i = 0;
        while (toolBarButtons.length > i) {
            if (toolBarButtons[i].getAD_Process_ID() == pInfo.getAD_Process_ID()) {
                if (++counter > 1) {
                    return String.valueOf(pInfo.getTitle()) + " process can set only one per one tab";
                }
                this.columnName = toolBarButtons[i].getComponentName();
            }
            ++i;
        }
        List factoryList = Service.locator().list(IModelFactory.class).getServices();
        if (factoryList != null) {
            for (IModelFactory factory : factoryList) {
                this.po = factory.getPO(this.baseTableName, this.record_ID, null);
                if (this.po != null) break;
            }
        }
        if (this.po == null) {
            return "PO is Null";
        }
        int columnIndex = this.po.get_ColumnIndex(this.columnName);
        if (columnIndex < 0) {
            return "Error of column setting";
        }
        String[] keyColumns = this.po.get_KeyColumns();
        if (keyColumns.length > 1) {
            return "key column must be only one.";
        }
        this.keyColumnName = keyColumns[0];
        if (this.po.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
            this.isSameClientData = true;
        }
        return null;
    }

    private void zkInit() {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, (String)"100%");
        this.mainLayout.appendChild((Component)this.north);
        this.north.appendChild((Component)this.parameterPanel);
        this.north.setStyle("border: none");
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.parameterLayout, (String)"100%");
        Rows parameterLayoutRows = this.parameterLayout.newRows();
        Row row = null;
        row = parameterLayoutRows.newRow();
        if (this.isMultiLingual) {
            String languageElementName = Msg.getElement((Properties)Env.getCtx(), (String)"AD_Language");
            Label languageLabel = new Label(languageElementName);
            row.appendCellChild(languageLabel.rightAlign(), 1);
            int AD_Column_ID = MColumn.getColumn_ID((String)"AD_Client", (String)"AD_Language");
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.wysiwygEditorForm.getWindowNo(), (int)0, (int)AD_Column_ID, (int)18);
            this.tableDirEditor = new WTableDirEditor("AD_Language", false, false, true, (Lookup)lookup);
            this.tableDirEditor.addValueChangeListener((ValueChangeListener)this);
            row.appendCellChild((Component)this.tableDirEditor.getComponent(), 2);
            WEditorPopupMenu popupMenu = this.tableDirEditor.getPopupMenu();
            List listcomp = popupMenu.getChildren();
            Menuitem menuItem = null;
            String image = null;
            for (Component comp : listcomp) {
                if (!(comp instanceof Menuitem)) continue;
                menuItem = (Menuitem)comp;
                image = menuItem.getImage();
                if (image != null && (image.endsWith("Zoom16.png") || image.endsWith("Refresh16.png") || image.endsWith("New16.png") || image.endsWith("InfoBPartner16.png"))) {
                    menuItem.setVisible(true);
                    continue;
                }
                menuItem.setVisible(false);
            }
            if (popupMenu != null) {
                popupMenu.addMenuListener((ContextMenuListener)this.tableDirEditor);
                row.appendChild((Component)popupMenu);
                popupMenu.addContextElement((XulElement)this.tableDirEditor.getComponent());
            }
        }
        if (this.JPIERE_CKEDITOR_IMAGE_PATH != null) {
            this.imageDirs = this.JPIERE_CKEDITOR_IMAGE_PATH.split(";");
            int i = 0;
            while (this.imageDirs.length > i) {
                if (i == 0) {
                    this.imagePathCombobox = new Combobox();
                    this.imagePathCombobox.setAutocomplete(true);
                    this.imagePathCombobox.setAutodrop(true);
                    this.imagePathCombobox.setId("lstImagePath");
                    this.imagePathCombobox.addEventListener("onSelect", (EventListener)this);
                    this.imagePath = this.imageDirs[i];
                    String pathElementName = Msg.getElement((Properties)Env.getCtx(), (String)"File_Directory");
                    Label imagePathLabel = new Label(pathElementName);
                    row.appendCellChild(imagePathLabel.rightAlign(), 1);
                    this.imagePathCombobox.setValue(this.imageDirs[i]);
                    this.setImagePath(this.imageDirs[i]);
                    row.appendCellChild((Component)this.imagePathCombobox, 2);
                }
                this.imagePathCombobox.appendItem(this.imageDirs[i]);
                ++i;
            }
        }
        if (this.isSameClientData) {
            this.SaveButton = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"save"));
            this.SaveButton.setId("SaveButton");
            this.SaveButton.addActionListener((EventListener)this);
            this.SaveButton.setEnabled(true);
            this.SaveButton.setImage(ThemeManager.getThemeResource((String)"images/Save16.png"));
            row.appendCellChild((Component)this.SaveButton);
        }
        row = parameterLayoutRows.newRow();
        row.appendCellChild((Component)new Space(), 1);
        this.mainLayout.appendChild((Component)this.center);
        this.ckeditor.setValue((String)this.po.get_Value(this.columnName));
        this.ckeditor.setVflex("1");
        HashMap<String, String> lang = new HashMap<String, String>();
        lang.put("language", Language.getLoginLanguage().getAD_Language());
        this.ckeditor.setConfig(lang);
        if (this.JPIERE_CKEDITOR_CUSTOM_CONFIGURATIONS_PATH != null) {
            this.ckeditor.setCustomConfigurationsPath(this.JPIERE_CKEDITOR_CUSTOM_CONFIGURATIONS_PATH);
        }
        this.center.appendChild((Component)this.ckeditor);
        this.mainLayout.appendChild((Component)this.south);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.south, (String)"0px");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onEvent(Event e) throws Exception {
        if (e == null) {
            return;
        }
        if (e.getTarget().equals(this.SaveButton)) {
            if (this.po != null && !this.isMultiLingual) {
                this.po.set_ValueNoCheck(this.columnName, (Object)this.ckeditor.getValue());
                this.po.saveEx();
                return;
            }
            if (!this.isMultiLingual) throw new Exception(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveError"));
            Trx trx = null;
            if (this.m_trxName == null) {
                StringBuilder l_trxname = new StringBuilder("CKEditor").append(this.baseTableName);
                if (l_trxname.length() > 23) {
                    l_trxname.setLength(23);
                }
                this.m_trxName = Trx.createTrxName((String)l_trxname.toString());
                trx = Trx.get((String)this.m_trxName, (boolean)true);
            }
            StringBuilder sqlupdate = null;
            if (this.tableDirEditor.getValue() == null || this.tableDirEditor.getValue().toString().equals(this.baselang)) {
                this.po.set_ValueNoCheck(this.columnName, (Object)this.ckeditor.getValue());
                sqlupdate = new StringBuilder("UPDATE ").append(this.baseTableName).append(" SET ").append(this.columnName).append("='").append(this.ckeditor.getValue()).append("'").append(" WHERE ").append(this.keyColumnName).append("=").append(this.po.get_ID());
            } else {
                sqlupdate = new StringBuilder("UPDATE ").append(this.trlTableName).append(" SET ").append(this.columnName).append("='").append(this.ckeditor.getValue()).append("'").append(" WHERE ").append(this.keyColumnName).append("=").append(this.po.get_ID()).append(" AND AD_Language =").append(DB.TO_STRING((String)this.tableDirEditor.getValue().toString()));
            }
            int no = DB.executeUpdate((String)sqlupdate.toString(), (String)this.m_trxName);
            if (no == 1) {
                trx.commit();
                this.m_trxName = null;
                return;
            }
            trx.rollback();
            this.m_trxName = null;
            throw new Exception(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveError"));
        }
        if (!e.getTarget().equals(this.imagePathCombobox)) return;
        String tempPath = ((Combobox)e.getTarget()).getValue();
        boolean isOK = false;
        int i = 0;
        while (this.imageDirs.length > i) {
            if (tempPath.equals(this.imageDirs[i])) {
                isOK = true;
                this.imagePath = tempPath;
            }
            ++i;
        }
        if (!isOK) {
            this.imagePathCombobox.setValue(this.imagePath);
            throw new Exception(String.valueOf(tempPath) + Msg.getMsg((Properties)Env.getCtx(), (String)"not.found"));
        }
        this.center.getChildren().remove(this.ckeditor);
        this.ckeditor = new CKeditor();
        this.ckeditor.setVflex("1");
        HashMap<String, String> lang = new HashMap<String, String>();
        lang.put("language", Language.getLoginLanguage().getAD_Language());
        this.ckeditor.setConfig(lang);
        if (this.JPIERE_CKEDITOR_CUSTOM_CONFIGURATIONS_PATH != null) {
            this.ckeditor.setCustomConfigurationsPath(this.JPIERE_CKEDITOR_CUSTOM_CONFIGURATIONS_PATH);
        }
        this.setImagePath(this.imagePath);
        this.refreshCKEditor();
        this.center.appendChild((Component)this.ckeditor);
    }

    public void valueChange(ValueChangeEvent e) {
        this.tableDirEditor.setValue(e.getNewValue());
        this.refreshCKEditor();
    }

    private void setImagePath(String path) {
        this.ckeditor.setFilebrowserImageBrowseUrl(path);
        this.ckeditor.setFilebrowserImageUploadUrl(path);
        this.ckeditor.setFilebrowserBrowseUrl(path);
        this.ckeditor.setFilebrowserUploadUrl(path);
        this.ckeditor.setFilebrowserFlashBrowseUrl(path);
        this.ckeditor.setFilebrowserFlashUploadUrl(path);
    }

    private void refreshCKEditor() {
        block8: {
            if (this.tableDirEditor.getValue() == null || this.tableDirEditor.getValue().toString().equals(this.baselang)) {
                this.ckeditor.setValue((String)this.po.get_Value(this.columnName));
            } else {
                StringBuilder sql = new StringBuilder("SELECT ").append(this.columnName).append(" FROM ").append(this.trlTableName).append(" WHERE ").append(this.keyColumnName).append("=").append(this.po.get_ID()).append(" AND AD_Language =").append(DB.TO_STRING((String)this.tableDirEditor.getValue().toString()));
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.ckeditor.setValue(rs.getString(1));
                        }
                    }
                    catch (Exception exception) {
                        log.log(Level.SEVERE, sql.toString(), (Throwable)exception);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
    }
}

