/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MArchive;
import org.compiere.model.MAttachment;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class CleanOrphanCascade
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("");
        }
        String whereTables = "    IsView = 'N' AND TableName != 'AD_ChangeLog' AND EXISTS (SELECT 1             FROM   AD_Column ct             WHERE  ct.IsActive='Y' AND ct.AD_Table_ID = AD_Table.AD_Table_ID                    AND ct.ColumnName = 'AD_Table_ID') AND EXISTS (SELECT 1             FROM   AD_Column cr             WHERE  cr.IsActive='Y' AND cr.AD_Table_ID = AD_Table.AD_Table_ID                    AND cr.ColumnName = 'Record_ID') AND EXISTS (SELECT 1             FROM   AD_Column ck             WHERE  ck.IsActive='Y' AND ck.AD_Table_ID = AD_Table.AD_Table_ID                    AND ck.ColumnName = AD_Table.TableName || '_ID')";
        List tables = new Query(this.getCtx(), "AD_Table", whereTables, this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("TableName").list();
        for (MTable table : tables) {
            String tableName = table.getTableName();
            StringBuilder sqlRef = new StringBuilder();
            sqlRef.append("SELECT DISTINCT t.AD_Table_ID, ");
            sqlRef.append("                t.TableName ");
            sqlRef.append("FROM   ").append(tableName).append(" r ");
            sqlRef.append("       JOIN AD_Table t ON ( r.AD_Table_ID = t.AD_Table_ID ) ");
            sqlRef.append("ORDER  BY t.Tablename");
            List rowTables = DB.getSQLArrayObjectsEx((String)this.get_TrxName(), (String)sqlRef.toString(), (Object[])new Object[0]);
            if (rowTables == null) continue;
            for (List row : rowTables) {
                int refTableID = ((BigDecimal)row.get(0)).intValue();
                String refTableName = row.get(1).toString();
                MTable refTable = MTable.get((Properties)this.getCtx(), (int)refTableID);
                if (refTable.getKeyColumns().length != 1) {
                    this.log.warning("Wrong reference for table " + tableName + " -> " + refTableName);
                    continue;
                }
                String colRef = refTable.getKeyColumns()[0];
                StringBuilder whereClause = new StringBuilder();
                whereClause.append("AD_Table_ID = ").append(refTableID);
                whereClause.append(" AND NOT EXISTS (SELECT ").append(colRef);
                whereClause.append("                FROM   ").append(refTableName).append(" ");
                whereClause.append("                WHERE  ").append(refTableName).append(".").append(colRef).append(" = ").append(tableName).append(".Record_ID)");
                int noDel = 0;
                if ("AD_Attachment".equals(tableName)) {
                    List attachments = new Query(this.getCtx(), tableName, whereClause.toString(), this.get_TrxName()).list();
                    for (MAttachment attachment : attachments) {
                        attachment.deleteEx(true, this.get_TrxName());
                        ++noDel;
                    }
                } else if ("AD_Archive".equals(tableName)) {
                    List archives = new Query(this.getCtx(), tableName, whereClause.toString(), this.get_TrxName()).list();
                    for (MArchive archive : archives) {
                        archive.deleteEx(true, this.get_TrxName());
                        ++noDel;
                    }
                } else {
                    StringBuilder sqlDelete = new StringBuilder();
                    sqlDelete.append("DELETE FROM ").append(tableName).append(" WHERE ").append((CharSequence)whereClause);
                    noDel = DB.executeUpdateEx((String)sqlDelete.toString(), (String)this.get_TrxName());
                }
                if (noDel <= 0) continue;
                this.addLog(Msg.parseTranslation((Properties)this.getCtx(), (String)(String.valueOf(noDel) + " " + tableName + " " + "@Deleted@ -> " + refTableName)));
            }
        }
        return "@OK@";
    }
}

