/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProductBOM;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class UniversalSubstitution
extends SvrProcess {
    int productId = 0;
    int replacementId = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("M_Product_ID")) {
                this.productId = para[i].getParameterAsInt();
            } else if (name.equals("Substitute_ID")) {
                this.replacementId = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws SQLException {
        if (this.productId == 0 || this.replacementId == 0) {
            throw new AdempiereException("Product and replacement product required");
        }
        List boms = new Query(this.getCtx(), "M_Product_BOM", "M_ProductBOM_ID=?", this.get_TrxName()).setParameters(new Object[]{this.productId}).list();
        int count = 0;
        for (MProductBOM bom : boms) {
            bom.setM_ProductBOM_ID(this.replacementId);
            bom.saveEx();
            ++count;
        }
        StringBuilder msgreturn = new StringBuilder().append(count).append(" BOM products updated");
        return msgreturn.toString();
    }
}

