/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQTopic;
import org.compiere.model.MRfQTopicSubscriber;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class RfQCreate
extends SvrProcess {
    private boolean p_IsSendRfQ = false;
    private int p_C_RfQ_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("IsSendRfQ")) {
                    this.p_IsSendRfQ = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String error;
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - " + rfq + ", Send=" + this.p_IsSendRfQ);
        }
        if ((error = rfq.checkQuoteTotalAmtOnly()) != null && error.length() > 0) {
            throw new Exception(error);
        }
        int counter = 0;
        int sent = 0;
        int notSent = 0;
        MRfQResponse[] responses = rfq.getResponses(false, false);
        MRfQTopic topic = new MRfQTopic(this.getCtx(), rfq.getC_RfQ_Topic_ID(), this.get_TrxName());
        MRfQTopicSubscriber[] subscribers = topic.getSubscribers();
        int i = 0;
        while (i < subscribers.length) {
            MRfQResponse response;
            MRfQTopicSubscriber subscriber = subscribers[i];
            boolean skip = false;
            int r = 0;
            while (r < responses.length) {
                if (subscriber.getC_BPartner_ID() == responses[r].getC_BPartner_ID() && subscriber.getC_BPartner_Location_ID() == responses[r].getC_BPartner_Location_ID()) {
                    skip = true;
                    break;
                }
                ++r;
            }
            if (!skip && (response = new MRfQResponse(rfq, subscriber)).get_ID() != 0) {
                ++counter;
                if (this.p_IsSendRfQ) {
                    if (response.sendRfQ()) {
                        ++sent;
                    } else {
                        ++notSent;
                    }
                }
            }
            ++i;
        }
        StringBuilder retValue = new StringBuilder("@Created@ ").append(counter);
        if (this.p_IsSendRfQ) {
            retValue.append(" - @IsSendRfQ@=").append(sent).append(" - @Error@=").append(notSent);
        }
        return retValue.toString();
    }
}

