/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class RfQCopyLines
extends SvrProcess {
    private int p_From_RfQ_ID = 0;
    private int p_To_RfQ_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_RfQ_ID")) {
                    this.p_From_RfQ_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_To_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRfQ to;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - From_RfQ_ID=" + this.p_From_RfQ_ID + ", To_RfQ_ID=" + this.p_To_RfQ_ID);
        }
        if ((to = new MRfQ(this.getCtx(), this.p_To_RfQ_ID, this.get_TrxName())).get_ID() == 0) {
            throw new IllegalArgumentException("No To RfQ found");
        }
        MRfQ from = new MRfQ(this.getCtx(), this.p_From_RfQ_ID, this.get_TrxName());
        if (from.get_ID() == 0) {
            throw new IllegalArgumentException("No From RfQ found");
        }
        int counter = 0;
        MRfQLine[] lines = from.getLines();
        int i = 0;
        while (i < lines.length) {
            MRfQLine newLine = new MRfQLine(to);
            newLine.setLine(lines[i].getLine());
            newLine.setDescription(lines[i].getDescription());
            newLine.setHelp(lines[i].getHelp());
            newLine.setM_Product_ID(lines[i].getM_Product_ID());
            newLine.setM_AttributeSetInstance_ID(lines[i].getM_AttributeSetInstance_ID());
            newLine.setDeliveryDays(lines[i].getDeliveryDays());
            newLine.saveEx();
            MRfQLineQty[] qtys = lines[i].getQtys();
            int j = 0;
            while (j < qtys.length) {
                MRfQLineQty newQty = new MRfQLineQty(newLine);
                newQty.setC_UOM_ID(qtys[j].getC_UOM_ID());
                newQty.setQty(qtys[j].getQty());
                newQty.setIsOfferQty(qtys[j].isOfferQty());
                newQty.setIsPurchaseQty(qtys[j].isPurchaseQty());
                newQty.setMargin(qtys[j].getMargin());
                newQty.saveEx();
                ++j;
            }
            ++counter;
            ++i;
        }
        StringBuilder msgreturn = new StringBuilder("# ").append(counter);
        return msgreturn.toString();
    }
}

