/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ProjectGenProduction
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_C_ProjectPhase_ID = 0;
    private int m_C_ProjectLine_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Project_ID")) {
                    this.m_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_ProjectPhase_ID")) {
                    this.m_C_ProjectPhase_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_ProjectLine_ID")) {
                    this.m_C_ProjectLine_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - C_Project_ID=" + this.m_C_Project_ID + " - C_ProjectLine_ID=" + this.m_C_ProjectLine_ID);
        }
        if (this.m_C_ProjectLine_ID != 0) {
            MProjectLine projectLine = new MProjectLine(this.getCtx(), this.m_C_ProjectLine_ID, this.get_TrxName());
            MProject project = new MProject(this.getCtx(), projectLine.getC_Project_ID(), this.get_TrxName());
            this.createProduction(project, projectLine);
        } else if (this.m_C_ProjectPhase_ID != 0) {
            MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            MProjectLine[] mProjectLineArray = project.getPhaseLines(this.m_C_ProjectPhase_ID);
            int n = mProjectLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MProjectLine line = mProjectLineArray[n2];
                if (line.isActive()) {
                    this.createProduction(project, line);
                }
                ++n2;
            }
        } else {
            MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
            MProjectLine[] mProjectLineArray = project.getLines();
            int n = mProjectLineArray.length;
            int n3 = 0;
            while (n3 < n) {
                MProjectLine line = mProjectLineArray[n3];
                if (line.isActive()) {
                    this.createProduction(project, line);
                }
                ++n3;
            }
        }
        return "";
    }

    private void createProduction(MProject project, MProjectLine projectLine) {
        if (projectLine.getM_Product_ID() == 0) {
            this.addLog(project.getC_Project_ID(), project.getCreated(), new BigDecimal(0), "ISSUE: Line has no Product - ProjectLine:" + projectLine.getLine() + " Desc:" + projectLine.getDescription(), projectLine.get_Table_ID(), projectLine.getC_ProjectLine_ID());
            return;
        }
        MProduct M_Product = new MProduct(this.getCtx(), projectLine.getM_Product_ID(), this.get_TrxName());
        if (!M_Product.isManufactured()) {
            this.addLog(project.getC_Project_ID(), project.getCreated(), new BigDecimal(0), "ISSUE: Product is not manufactured - ProjectLine:" + projectLine.getLine() + " Desc:" + projectLine.getDescription(), projectLine.get_Table_ID(), projectLine.getC_ProjectLine_ID());
            return;
        }
        if (projectLine.getM_Production_ID() != 0) {
            this.addLog(projectLine.getLine(), null, null, "Line was produced previously");
            return;
        }
        MProduction production = null;
        production = new MProduction(projectLine);
        int AD_Org_ID = projectLine.getAD_Org_ID();
        if (AD_Org_ID == 0) {
            this.log.warning("createProductionfromProjectLine - AD_Org_ID=0");
            AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx());
            if (AD_Org_ID != 0) {
                projectLine.setAD_Org_ID(AD_Org_ID);
            }
        }
        production.setC_BPartner_ID(project.getC_BPartner_ID());
        production.saveEx();
        projectLine.setM_Production_ID(production.getM_Production_ID());
        projectLine.saveEx();
        this.addBufferLog(production.getM_Production_ID(), production.getMovementDate(), new BigDecimal(0), String.valueOf(Msg.getElement((String)Env.getAD_Language((Properties)Env.getCtx()), (String)"M_Production_ID", (boolean)false)) + ":" + production.getDocumentNo(), production.get_Table_ID(), production.getM_Production_ID());
    }
}

