/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MSequence;
import org.compiere.model.MUOMConversion;
import org.compiere.model.ProductCost;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class M_PriceList_Create
extends SvrProcess {
    private int p_PriceList_Version_ID = 0;
    private String p_DeleteOld;
    private int m_AD_PInstance_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_PriceList_Version_ID = this.getRecord_ID();
        this.m_AD_PInstance_ID = this.getAD_PInstance_ID();
    }

    protected String doIt() throws Exception {
        String sqldel;
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlupd = new StringBuilder();
        StringBuilder sqlins = new StringBuilder();
        int cntu = 0;
        int cntd = 0;
        int cnti = 0;
        int totu = 0;
        int toti = 0;
        int totd = 0;
        int v_NextNo = 0;
        StringBuilder message = new StringBuilder();
        sqlupd.append("UPDATE M_Product_PO  SET\tPriceList = 0  ").append(" WHERE\tPriceList IS NULL ");
        cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update The PriceList to zero of M_Product_PO WHERE\tPriceList IS NULL", sqlupd.toString());
        }
        totu += cntu;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated " + cntu);
        }
        sqlupd = new StringBuilder("UPDATE M_Product_PO  SET PriceLastPO = 0  ");
        sqlupd.append(" WHERE\tPriceLastPO IS NULL ");
        cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  The PriceListPO to zero of  M_Product_PO WHERE\tPriceLastPO IS NULL", sqlupd.toString());
        }
        totu += cntu;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated " + cntu);
        }
        sqlupd = new StringBuilder("UPDATE M_Product_PO  SET     PricePO = PriceLastPO ");
        sqlupd.append(" WHERE\t(PricePO IS NULL OR PricePO = 0) AND PriceLastPO <> 0 ");
        cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  The PricePO to PriceLastPO of  M_Product_PO WHERE\t(PricePO IS NULL OR PricePO = 0) AND PriceLastPO <> 0 ", sqlupd.toString());
        }
        totu += cntu;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated " + cntu);
        }
        sqlupd = new StringBuilder("UPDATE M_Product_PO  SET     PricePO = 0  ");
        sqlupd.append(" WHERE\tPricePO IS NULL ");
        cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  The PricePO to Zero of  M_Product_PO WHERE\tPricePO IS NULL", sqlupd.toString());
        }
        totu += cntu;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated " + cntu);
        }
        sqlupd = new StringBuilder("UPDATE M_Product_PO  SET      IsCurrentVendor = 'Y'  ");
        sqlupd.append(" WHERE\t IsCurrentVendor = 'N'  AND NOT   EXISTS ");
        sqlupd.append(" (SELECT   pp.M_Product_ID   FROM     M_Product_PO pp ");
        sqlupd.append("  WHERE    pp.M_Product_ID = M_Product_PO.M_Product_ID");
        sqlupd.append("  GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1) ");
        cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
        if (cntu == -1) {
            this.raiseError("Update  IsCurrentVendor to Y of  M_Product_PO ", sqlupd.toString());
        }
        totu += cntu;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated " + cntu);
        }
        sql.append("SELECT DISTINCT M_Product_ID FROM M_Product_PO po ");
        sql.append(" WHERE\t IsCurrentVendor='Y' AND IsActive='Y' ");
        sql.append("   AND    EXISTS (SELECT   M_Product_ID ");
        sql.append(" FROM     M_Product_PO x  ");
        sql.append(" WHERE    x.M_Product_ID=po.M_Product_ID ");
        sql.append("   AND    IsCurrentVendor='Y' AND IsActive='Y' ");
        sql.append(" GROUP BY M_Product_ID ").append(" HAVING COUNT(*) > 1 ) ");
        CPreparedStatement stmtDupl = null;
        ResultSet rsDupl = null;
        CPreparedStatement stmtVendors = null;
        ResultSet rsVend = null;
        try {
            stmtDupl = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rsDupl = stmtDupl.executeQuery();
            while (rsDupl.next()) {
                sql = new StringBuilder("SELECT\tM_Product_ID         ,C_BPartner_ID ");
                sql.append(" FROM\tM_Product_PO  WHERE\tIsCurrentVendor = 'Y'  ");
                sql.append(" AND     IsActive        = 'Y' ");
                sql.append(" AND\tM_Product_ID    = ").append(rsDupl.getInt("M_Product_ID"));
                sql.append(" ORDER BY PriceList DESC");
                stmtVendors = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rsVend = stmtVendors.executeQuery();
                rsVend.next();
                while (rsVend.next()) {
                    sqlupd = new StringBuilder("UPDATE M_Product_PO ");
                    sqlupd.append(" SET\tIsCurrentVendor = 'N'  ");
                    sqlupd.append(" WHERE\tM_Product_ID= ").append(rsVend.getInt("M_Product_ID"));
                    sqlupd.append(" AND     C_BPartner_ID= ");
                    sqlupd.append(rsVend.getInt("C_BPartner_ID"));
                    cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
                    if (cntu == -1) {
                        this.raiseError("Update  IsCurrentVendor to N of  M_Product_PO for a M_Product_ID and C_BPartner_ID ingresed", sqlupd.toString());
                    }
                    totu += cntu;
                    if (!this.log.isLoggable(Level.FINE)) continue;
                    this.log.fine("Updated " + cntu);
                }
            }
        }
        catch (Throwable throwable) {
            DB.close(rsDupl, stmtDupl);
            rsDupl = null;
            stmtDupl = null;
            DB.close(rsVend, stmtVendors);
            rsVend = null;
            stmtVendors = null;
            throw throwable;
        }
        DB.close((ResultSet)rsDupl, (Statement)stmtDupl);
        rsDupl = null;
        stmtDupl = null;
        DB.close(rsVend, stmtVendors);
        rsVend = null;
        stmtVendors = null;
        if (this.p_DeleteOld.equals("Y")) {
            sqldel = "DELETE M_ProductPrice WHERE\tM_PriceList_Version_ID=?";
            cntd = DB.executeUpdate((String)sqldel, (int)this.p_PriceList_Version_ID, (String)this.get_TrxName());
            if (cntd == -1) {
                this.raiseError(" DELETE\tM_ProductPrice ", sqldel);
            }
            totd += cntd;
            message = new StringBuilder("@Deleted@=").append(cntd).append(" - ");
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Deleted " + cntd);
            }
        }
        sql = new StringBuilder("SELECT p.C_Currency_ID  , c.StdPrecision ");
        sql.append(" , v.AD_Client_ID  , v.AD_Org_ID  , v.UpdatedBy ");
        sql.append(" , v.M_DiscountSchema_ID ");
        sql.append(" , M_PriceList_Version_Base_ID  FROM\tM_PriceList p ");
        sql.append("     ,M_PriceList_Version v      ,C_Currency c ");
        sql.append(" WHERE\tp.M_PriceList_ID = v.M_PriceList_ID ");
        sql.append(" AND\t    p.C_Currency_ID  = c.C_Currency_ID");
        sql.append(" AND\tv.M_PriceList_Version_ID = ").append(this.p_PriceList_Version_ID);
        CPreparedStatement stmtCurgen = null;
        ResultSet rsCurgen = null;
        CPreparedStatement stmtDiscountLine = null;
        ResultSet rsDiscountLine = null;
        CPreparedStatement stmt = null;
        CPreparedStatement pstmt = null;
        try {
            stmtCurgen = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            rsCurgen = stmtCurgen.executeQuery();
            while (rsCurgen.next()) {
                int precision = rsCurgen.getInt("StdPrecision");
                sql = new StringBuilder("SELECT M_DiscountSchemaLine_ID");
                sql.append(",AD_Client_ID,AD_Org_ID,IsActive,Created,Createdby,Updated,Updatedby");
                sql.append(",M_DiscountSchema_ID,SeqNo,M_Product_Category_ID,C_Bpartner_ID,M_Product_ID");
                sql.append(",ConversionDate,List_Base,List_Addamt,List_Discount,List_Rounding,List_MinAmt");
                sql.append(",List_MaxAmt,List_Fixed,Std_Base,Std_Addamt,Std_Discount,Std_Rounding");
                sql.append(",Std_MinAmt,Std_MaxAmt,Std_Fixed,Limit_Base,Limit_AddAmt,Limit_Discount");
                sql.append(",Limit_Rounding,Limit_Minamt,Limit_MaxAmt,Limit_Fixed,Group1,Group2,C_ConversionType_ID");
                sql.append(" FROM  M_DiscountSchemaLine");
                sql.append(" WHERE M_DiscountSchema_ID=");
                sql.append(rsCurgen.getInt("M_DiscountSchema_ID"));
                sql.append(" AND IsActive='Y' ORDER BY SeqNo");
                stmtDiscountLine = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rsDiscountLine = stmtDiscountLine.executeQuery();
                while (rsDiscountLine.next()) {
                    int i;
                    sqldel = "DELETE FROM T_Selection WHERE AD_PInstance_ID=?";
                    cntd = DB.executeUpdate((String)sqldel, (int)this.m_AD_PInstance_ID, (String)this.get_TrxName());
                    if (cntd == -1) {
                        this.raiseError(" DELETE\tT_Selection ", sqldel);
                    }
                    totd += cntd;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Deleted " + cntd);
                    }
                    int v_temp = rsCurgen.getInt("M_PriceList_Version_Base_ID");
                    String dl_Group1 = rsDiscountLine.getString("Group1");
                    String dl_Group2 = rsDiscountLine.getString("Group2");
                    if (rsCurgen.wasNull()) {
                        sqlins = new StringBuilder("INSERT INTO T_Selection (AD_PInstance_ID, T_Selection_ID) ");
                        sqlins.append(" SELECT DISTINCT ").append(this.m_AD_PInstance_ID).append(", po.M_Product_ID ");
                        sqlins.append(" FROM M_Product p, M_Product_PO po");
                        sqlins.append(" WHERE p.M_Product_ID=po.M_Product_ID ");
                        sqlins.append(" AND\t(p.AD_Client_ID=").append(rsCurgen.getInt("AD_Client_ID")).append(" OR p.AD_Client_ID=0)");
                        sqlins.append(" AND\tp.IsActive='Y' AND po.IsActive='Y' AND po.IsCurrentVendor='Y' ");
                        sqlins.append(" AND (NULLIF(").append(rsDiscountLine.getInt("M_Product_Category_ID")).append(",0) IS NULL");
                        sqlins.append("   OR p.M_Product_Category_ID IN (").append(this.getSubCategoryWhereClause(rsDiscountLine.getInt("M_Product_Category_ID"))).append("))");
                        if (dl_Group1 != null) {
                            sqlins.append(" AND (p.Group1=?)");
                        }
                        if (dl_Group2 != null) {
                            sqlins.append(" AND (p.Group2=?)");
                        }
                        sqlins.append(" AND (NULLIF(").append(rsDiscountLine.getInt("C_BPartner_ID")).append(",0) IS NULL ");
                        sqlins.append("   OR po.C_BPartner_ID=").append(rsDiscountLine.getInt("C_BPartner_ID")).append(")");
                        sqlins.append(" AND (NULLIF(").append(rsDiscountLine.getInt("M_Product_ID")).append(",0) IS NULL ");
                        sqlins.append("   OR p.M_Product_ID=").append(rsDiscountLine.getInt("M_Product_ID")).append(")");
                        stmt = DB.prepareStatement((String)sqlins.toString(), (String)this.get_TrxName());
                        i = 1;
                        if (dl_Group1 != null) {
                            stmt.setString(i++, dl_Group1);
                        }
                        if (dl_Group2 != null) {
                            stmt.setString(i++, dl_Group2);
                        }
                        if ((cnti = stmt.executeUpdate()) == -1) {
                            this.raiseError(" INSERT INTO T_Selection ", sqlins.toString());
                        }
                        toti += cnti;
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Inserted " + cnti);
                        }
                    } else {
                        sqlins = new StringBuilder("INSERT INTO T_Selection (AD_PInstance_ID, T_Selection_ID)");
                        sqlins.append(" SELECT DISTINCT ").append(this.m_AD_PInstance_ID).append(", p.M_Product_ID");
                        sqlins.append(" FROM M_Product p, M_ProductPrice pp");
                        sqlins.append(" WHERE p.M_Product_ID=pp.M_Product_ID");
                        sqlins.append(" AND pp.M_PriceList_Version_ID = ").append(rsCurgen.getInt("M_PriceList_Version_Base_ID"));
                        sqlins.append(" AND p.IsActive='Y' AND pp.IsActive='Y'");
                        sqlins.append(" AND (NULLIF(").append(rsDiscountLine.getInt("M_Product_Category_ID")).append(",0) IS NULL");
                        sqlins.append(" OR p.M_Product_Category_ID IN (").append(this.getSubCategoryWhereClause(rsDiscountLine.getInt("M_Product_Category_ID"))).append("))");
                        if (dl_Group1 != null) {
                            sqlins.append(" AND (p.Group1=?)");
                        }
                        if (dl_Group2 != null) {
                            sqlins.append(" AND (p.Group2=?)");
                        }
                        sqlins.append(" AND (NULLIF(").append(rsDiscountLine.getInt("C_BPartner_ID")).append(",0) IS NULL OR EXISTS ");
                        sqlins.append("(SELECT M_Product_ID,C_Bpartner_ID,AD_Client_ID,AD_Org_ID,IsActive");
                        sqlins.append(",Created,CreatedBy,Updated,Updatedby,IsCurrentVendor,C_Uom_ID");
                        sqlins.append(",C_Currency_ID,PriceList,PricePo,PriceEffective,PriceLastPo");
                        sqlins.append(",PriceLastInv,VendorProductno,Upc,VendorCategory,Discontinued");
                        sqlins.append(",Discontinuedby,Order_Min,Order_Pack,CostPerOrder");
                        sqlins.append(",DeliveryTime_Promised,DeliveryTime_Actual,QualityRating");
                        sqlins.append(",RoyaltyAmt,Group1,Group2");
                        sqlins.append(",Manufacturer FROM M_Product_PO po WHERE po.M_Product_ID=p.M_Product_ID");
                        sqlins.append(" AND po.C_BPartner_ID=").append(rsDiscountLine.getInt("C_BPartner_ID")).append("))");
                        sqlins.append(" AND\t(NULLIF(").append(rsDiscountLine.getInt("M_Product_ID")).append(",0) IS NULL ");
                        sqlins.append("   OR p.M_Product_ID=").append(rsDiscountLine.getInt("M_Product_ID")).append(")");
                        stmt = DB.prepareStatement((String)sqlins.toString(), (String)this.get_TrxName());
                        i = 1;
                        if (dl_Group1 != null) {
                            stmt.setString(i++, dl_Group1);
                        }
                        if (dl_Group2 != null) {
                            stmt.setString(i++, dl_Group2);
                        }
                        if ((cnti = stmt.executeUpdate()) == -1) {
                            this.raiseError(" INSERT INTO T_Selection from existing PriceList", sqlins.toString());
                        }
                        toti += cnti;
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Inserted " + cnti);
                        }
                    }
                    message.append("@Selected@=").append(cnti);
                    v_temp = rsCurgen.getInt("M_PriceList_Version_Base_ID");
                    if (rsCurgen.wasNull() || v_temp != this.p_PriceList_Version_ID) {
                        sqldel = "DELETE M_ProductPrice pp WHERE pp.M_PriceList_Version_ID=? AND EXISTS (SELECT t_selection_id FROM T_Selection s WHERE pp.M_Product_ID=s.T_Selection_ID AND s.AD_PInstance_ID=?)";
                        cntd = DB.executeUpdate((String)sqldel, (Object[])new Object[]{this.p_PriceList_Version_ID, this.m_AD_PInstance_ID}, (boolean)false, (String)this.get_TrxName());
                        if (cntd == -1) {
                            this.raiseError(" DELETE\tM_ProductPrice ", sqldel);
                        }
                        totd += cntd;
                        message.append(", @Deleted@=").append(cntd);
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Deleted " + cntd);
                        }
                    }
                    v_temp = rsCurgen.getInt("M_PriceList_Version_Base_ID");
                    int seqproductpriceid = MSequence.get((Properties)this.getCtx(), (String)"M_ProductPrice").get_ID();
                    int currentUserID = Env.getAD_User_ID((Properties)this.getCtx());
                    if (v_temp != this.p_PriceList_Version_ID) {
                        if (rsCurgen.wasNull()) {
                            sqlins = new StringBuilder("INSERT INTO M_ProductPrice ");
                            sqlins.append("(M_ProductPrice_ID");
                            sqlins.append(" ,M_ProductPrice_UU");
                            sqlins.append(" ,M_PriceList_Version_ID");
                            sqlins.append(" ,M_Product_ID ");
                            sqlins.append(" ,AD_Client_ID");
                            sqlins.append(" , AD_Org_ID");
                            sqlins.append(" , IsActive");
                            sqlins.append(" , Created");
                            sqlins.append(" , CreatedBy");
                            sqlins.append(" , Updated");
                            sqlins.append(" , UpdatedBy");
                            sqlins.append(" , PriceList");
                            sqlins.append(" , PriceStd");
                            sqlins.append(" , PriceLimit) ");
                            sqlins.append("SELECT ");
                            sqlins.append("      nextIdFunc(").append(seqproductpriceid).append(",'N')");
                            sqlins.append("      , generate_uuid(),");
                            sqlins.append(this.p_PriceList_Version_ID);
                            sqlins.append("      ,po.M_Product_ID ");
                            sqlins.append("      ,");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append("      ,");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("      ,'Y'");
                            sqlins.append("      ,SysDate,");
                            sqlins.append(currentUserID);
                            sqlins.append("      ,SysDate,");
                            sqlins.append(currentUserID);
                            sqlins.append(" ,COALESCE(currencyConvert(po.PriceList, po.C_Currency_ID, ");
                            sqlins.append(rsCurgen.getInt("C_Currency_ID"));
                            sqlins.append(",  ? , ");
                            sqlins.append(rsDiscountLine.getInt("C_ConversionType_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("),0)");
                            sqlins.append(" ,COALESCE(currencyConvert(po.PriceList, po.C_Currency_ID, ");
                            sqlins.append(rsCurgen.getInt("C_Currency_ID"));
                            sqlins.append(", ? , ");
                            sqlins.append(rsDiscountLine.getInt("C_ConversionType_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("),0)");
                            sqlins.append(" ,COALESCE(currencyConvert(po.PricePO ,po.C_Currency_ID, ");
                            sqlins.append(rsCurgen.getInt("C_Currency_ID"));
                            sqlins.append(",? , ");
                            sqlins.append(rsDiscountLine.getInt("C_ConversionType_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("),0)");
                            sqlins.append(" FROM\tM_Product_PO po ");
                            sqlins.append(" WHERE EXISTS (SELECT * FROM T_Selection s WHERE po.M_Product_ID=s.T_Selection_ID");
                            sqlins.append(" AND s.AD_PInstance_ID=").append(this.m_AD_PInstance_ID).append(") ");
                            sqlins.append(" AND\tpo.IsCurrentVendor='Y' AND po.IsActive='Y'");
                            pstmt = DB.prepareStatement((String)sqlins.toString(), (int)1004, (int)1008, (String)this.get_TrxName());
                            pstmt.setTimestamp(1, rsDiscountLine.getTimestamp("ConversionDate"));
                            pstmt.setTimestamp(2, rsDiscountLine.getTimestamp("ConversionDate"));
                            pstmt.setTimestamp(3, rsDiscountLine.getTimestamp("ConversionDate"));
                            cnti = pstmt.executeUpdate();
                            if (cnti == -1) {
                                this.raiseError(" INSERT INTO T_Selection from existing PriceList", sqlins.toString());
                            }
                            toti += cnti;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Inserted " + cnti);
                            }
                            String sqlconversion = "SELECT p.M_Product_ID,po.C_Uom_ID,pp.PriceList FROM M_Product p INNER JOIN M_ProductPrice pp on (p.M_Product_ID=pp.M_Product_ID) INNER JOIN M_Product_PO po on (po.M_Product_ID=p.M_Product_ID) INNER JOIN C_Uom_Conversion uc on (p.M_Product_ID=uc.M_Product_ID) INNER JOIN T_Selection s on (s.T_Selection_ID=po.M_Product_ID) WHERE pp.M_PriceList_Version_ID=? AND po.C_Uom_ID<> p.C_Uom_ID AND s.AD_PInstance_ID=?";
                            CPreparedStatement pstmtconversion = null;
                            ResultSet rsconversion = null;
                            BigDecimal price = Env.ZERO;
                            int product_id = 0;
                            MUOMConversion conversion = null;
                            try {
                                pstmtconversion = DB.prepareStatement((String)sqlconversion.toString(), (String)this.get_TrxName());
                                pstmtconversion.setInt(1, this.p_PriceList_Version_ID);
                                pstmtconversion.setInt(2, this.m_AD_PInstance_ID);
                                rsconversion = pstmtconversion.executeQuery();
                                while (rsconversion != null && rsconversion.next()) {
                                    product_id = rsconversion.getInt(1);
                                    MUOMConversion[] conversions = MUOMConversion.getProductConversions((Properties)this.getCtx(), (int)product_id);
                                    int i2 = 0;
                                    while (i2 < conversions.length) {
                                        if (conversions[i2].getC_UOM_To_ID() == rsconversion.getInt(2)) {
                                            conversion = conversions[i2];
                                            price = rsconversion.getBigDecimal(3);
                                        }
                                        ++i2;
                                    }
                                }
                                if (conversion != null) {
                                    price = price.divide(conversion.getDivideRate(), precision, RoundingMode.HALF_DOWN);
                                    StringBuilder sqlupdate = new StringBuilder();
                                    sqlupdate.append("UPDATE M_ProductPrice SET PriceList=").append(price).append(" WHERE M_PriceList_Version_ID=").append(this.p_PriceList_Version_ID).append(" AND M_Product_ID= ").append(product_id);
                                    int count = DB.executeUpdate((String)sqlupdate.toString(), (String)this.get_TrxName());
                                    if (count == -1) {
                                        this.raiseError(" UPDATE M_ProductPrice set PriceList=? ", sqlupdate.toString());
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close(rsconversion, pstmtconversion);
                                throw throwable;
                            }
                            DB.close((ResultSet)rsconversion, (Statement)pstmtconversion);
                        } else {
                            sqlins = new StringBuilder("INSERT INTO M_ProductPrice ");
                            sqlins.append(" (M_ProductPrice_ID, M_ProductPrice_UU, M_PriceList_Version_ID, M_Product_ID,");
                            sqlins.append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,");
                            sqlins.append(" PriceList, PriceStd, PriceLimit)");
                            sqlins.append(" SELECT ");
                            sqlins.append("nextIdFunc(").append(seqproductpriceid).append(",'N')");
                            sqlins.append(", generate_uuid(),");
                            sqlins.append(this.p_PriceList_Version_ID);
                            sqlins.append(", pp.M_Product_ID,");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append(", 'Y', SysDate,  ");
                            sqlins.append(currentUserID);
                            sqlins.append(", SysDate, ");
                            sqlins.append(currentUserID);
                            sqlins.append(" ,");
                            sqlins.append("COALESCE(currencyConvert(pp.PriceList, pl.C_Currency_ID, ");
                            sqlins.append(rsCurgen.getInt("C_Currency_ID"));
                            sqlins.append(", ?, ");
                            sqlins.append(rsDiscountLine.getInt("C_ConversionType_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("),0),");
                            sqlins.append("COALESCE(currencyConvert(pp.PriceStd,pl.C_Currency_ID, ");
                            sqlins.append(rsCurgen.getInt("C_Currency_ID"));
                            sqlins.append(" , ? ,  ");
                            sqlins.append(rsDiscountLine.getInt("C_ConversionType_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("),0),");
                            sqlins.append(" COALESCE(currencyConvert(pp.PriceLimit,pl.C_Currency_ID, ");
                            sqlins.append(rsCurgen.getInt("C_Currency_ID"));
                            sqlins.append(" , ? , ");
                            sqlins.append(rsDiscountLine.getInt("C_ConversionType_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Client_ID"));
                            sqlins.append(", ");
                            sqlins.append(rsCurgen.getInt("AD_Org_ID"));
                            sqlins.append("),0)");
                            sqlins.append(" FROM M_ProductPrice pp");
                            sqlins.append(" INNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID)");
                            sqlins.append(" INNER JOIN M_PriceList pl ON (plv.M_PriceList_ID=pl.M_PriceList_ID)");
                            sqlins.append(" WHERE\tpp.M_PriceList_Version_ID=");
                            sqlins.append(rsCurgen.getInt("M_PriceList_Version_Base_ID"));
                            sqlins.append(" AND EXISTS (SELECT * FROM T_Selection s WHERE pp.M_Product_ID=s.T_Selection_ID");
                            sqlins.append(" AND s.AD_PInstance_ID=").append(this.m_AD_PInstance_ID).append(")");
                            sqlins.append(" AND\tpp.IsActive='Y'");
                            pstmt = DB.prepareStatement((String)sqlins.toString(), (int)1004, (int)1008, (String)this.get_TrxName());
                            pstmt.setTimestamp(1, rsDiscountLine.getTimestamp("ConversionDate"));
                            pstmt.setTimestamp(2, rsDiscountLine.getTimestamp("ConversionDate"));
                            pstmt.setTimestamp(3, rsDiscountLine.getTimestamp("ConversionDate"));
                            cnti = pstmt.executeUpdate();
                            if (cnti == -1) {
                                this.raiseError(" INSERT INTO T_Selection from existing PriceList", sqlins.toString());
                            }
                            toti += cnti;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Inserted " + cnti);
                            }
                        }
                    }
                    message.append(", @Inserted@=").append(cnti);
                    sqlupd = new StringBuilder("UPDATE M_ProductPrice p ");
                    sqlupd.append(" SET\tPriceList = (DECODE( '");
                    sqlupd.append(rsDiscountLine.getString("List_Base"));
                    sqlupd.append("', 'S', PriceStd, 'X', PriceLimit, PriceList)");
                    sqlupd.append(" + ?) * (1 - ?/100), PriceStd = (DECODE('");
                    sqlupd.append(rsDiscountLine.getString("Std_Base"));
                    sqlupd.append("', 'L', PriceList, 'X', PriceLimit, PriceStd) ");
                    sqlupd.append(" + ?) * (1 - ?/100), ").append(" PriceLimit = (DECODE('");
                    sqlupd.append(rsDiscountLine.getString("Limit_Base"));
                    sqlupd.append("', 'L', PriceList, 'S', PriceStd, PriceLimit) ");
                    sqlupd.append(" + ?) * (1 - ? /100) ");
                    sqlupd.append(" WHERE\tM_PriceList_Version_ID = ");
                    sqlupd.append(this.p_PriceList_Version_ID);
                    sqlupd.append(" AND EXISTS\t(SELECT * FROM T_Selection s ");
                    sqlupd.append(" WHERE s.T_Selection_ID = p.M_Product_ID");
                    sqlupd.append(" AND s.AD_PInstance_ID=").append(this.m_AD_PInstance_ID).append(")");
                    CPreparedStatement pstmu = DB.prepareStatement((String)sqlupd.toString(), (int)1004, (int)1008, (String)this.get_TrxName());
                    pstmu.setDouble(1, rsDiscountLine.getDouble("List_AddAmt"));
                    pstmu.setDouble(2, rsDiscountLine.getDouble("List_Discount"));
                    pstmu.setDouble(3, rsDiscountLine.getDouble("Std_AddAmt"));
                    pstmu.setDouble(4, rsDiscountLine.getDouble("Std_Discount"));
                    pstmu.setDouble(5, rsDiscountLine.getDouble("Limit_AddAmt"));
                    pstmu.setDouble(6, rsDiscountLine.getDouble("Limit_Discount"));
                    cntu = pstmu.executeUpdate();
                    if (cntu == -1) {
                        this.raiseError("Update  M_ProductPrice ", sqlupd.toString());
                    }
                    totu += cntu;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Updated " + cntu);
                    }
                    if (rsDiscountLine.getString("List_Base").equals("P") || rsDiscountLine.getString("Std_Base").equals("P") || rsDiscountLine.getString("Limit_Base").equals("P")) {
                        MClientInfo m_clientInfo = MClientInfo.get((Properties)this.getCtx(), (int)rsCurgen.getInt("AD_Client_ID"), (String)this.get_TrxName());
                        MAcctSchema as = new MAcctSchema(this.getCtx(), m_clientInfo.getC_AcctSchema1_ID(), this.get_TrxName());
                        StringBuilder sqlpc = new StringBuilder("SELECT p.M_Product_ID ");
                        sqlpc.append(" FROM M_ProductPrice p");
                        sqlpc.append(" WHERE M_PriceList_Version_ID=").append(this.p_PriceList_Version_ID);
                        sqlpc.append(" AND EXISTS (SELECT * FROM T_Selection s");
                        sqlpc.append(" WHERE s.T_Selection_ID=p.M_Product_ID");
                        sqlpc.append(" AND s.AD_PInstance_ID=").append(String.valueOf(this.m_AD_PInstance_ID) + ")");
                        CPreparedStatement ps = null;
                        ResultSet rs = null;
                        try {
                            ps = DB.prepareStatement((String)sqlpc.toString(), (String)this.get_TrxName());
                            rs = ps.executeQuery();
                            while (rs.next()) {
                                int M_Product_ID = rs.getInt("M_Product_ID");
                                ProductCost m_productCost = new ProductCost(this.getCtx(), M_Product_ID, 0, this.get_TrxName());
                                m_productCost.setQty(BigDecimal.ONE);
                                BigDecimal costs = m_productCost.getProductCosts(as, rsCurgen.getInt("AD_Org_ID"), null, 0, false);
                                if (costs == null || costs.signum() == 0) {
                                    MProduct product = new MProduct(this.getCtx(), M_Product_ID, this.get_TrxName());
                                    if (!product.isStocked()) continue;
                                    this.log.log(Level.WARNING, "No Costs for " + product.getName());
                                    continue;
                                }
                                sqlupd = new StringBuilder("UPDATE M_ProductPrice p ");
                                sqlupd.append(" SET\tPriceList  = (DECODE('").append(rsDiscountLine.getString("List_Base")).append("', 'P', ?, PriceList) + ?) * (1 - ?/100), ");
                                sqlupd.append("     PriceStd   = (DECODE('").append(rsDiscountLine.getString("Std_Base")).append("', 'P', ?, PriceStd) + ?) * (1 - ?/100),");
                                sqlupd.append("     PriceLimit = (DECODE('").append(rsDiscountLine.getString("Limit_Base")).append("', 'P', ?, PriceLimit) + ?) * (1 - ?/100)");
                                sqlupd.append(" WHERE\tM_PriceList_Version_ID=").append(this.p_PriceList_Version_ID);
                                sqlupd.append(" AND M_Product_ID = ?");
                                sqlupd.append(" AND EXISTS\t(SELECT * FROM T_Selection s");
                                sqlupd.append(" WHERE s.T_Selection_ID=p.M_Product_ID");
                                sqlupd.append(" AND s.AD_PInstance_ID=").append(String.valueOf(this.m_AD_PInstance_ID) + ")");
                                pstmu = DB.prepareStatement((String)sqlupd.toString(), (int)1004, (int)1008, (String)this.get_TrxName());
                                pstmu.setBigDecimal(1, costs);
                                pstmu.setDouble(2, rsDiscountLine.getDouble("List_AddAmt"));
                                pstmu.setDouble(3, rsDiscountLine.getDouble("List_Discount"));
                                pstmu.setBigDecimal(4, costs);
                                pstmu.setDouble(5, rsDiscountLine.getDouble("Std_AddAmt"));
                                pstmu.setDouble(6, rsDiscountLine.getDouble("Std_Discount"));
                                pstmu.setBigDecimal(7, costs);
                                pstmu.setDouble(8, rsDiscountLine.getDouble("Limit_AddAmt"));
                                pstmu.setDouble(9, rsDiscountLine.getDouble("Limit_Discount"));
                                pstmu.setInt(10, M_Product_ID);
                                cntu = pstmu.executeUpdate();
                                if (cntu == -1) {
                                    this.raiseError("Update\tM_ProductPrice ", sqlupd.toString());
                                }
                                if (!this.log.isLoggable(Level.FINE)) continue;
                                this.log.fine("Updated " + cntu);
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, ps);
                            rs = null;
                            ps = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)ps);
                        rs = null;
                        ps = null;
                    }
                    sqlupd = new StringBuilder("UPDATE\tM_ProductPrice p ");
                    sqlupd.append(" SET PriceList = DECODE('");
                    sqlupd.append(rsDiscountLine.getString("List_Rounding")).append("',");
                    sqlupd.append(" 'N', PriceList, ");
                    sqlupd.append(" '0', ROUND(PriceList, 0),");
                    sqlupd.append(" 'D', ROUND(PriceList, 1),");
                    sqlupd.append(" 'T', ROUND(PriceList, -1), ");
                    sqlupd.append(" '5', ROUND(PriceList*20,0)/20,");
                    sqlupd.append(" 'Q', ROUND(PriceList*4,0)/4,");
                    sqlupd.append(" '9', CASE");
                    sqlupd.append(" WHEN MOD(ROUND(PriceList),10)<=5 THEN ROUND(PriceList)+(5-MOD(ROUND(PriceList),10))");
                    sqlupd.append(" WHEN MOD(ROUND(PriceList),10)>5 THEN ROUND(PriceList)+(9-MOD(ROUND(PriceList),10)) END,");
                    sqlupd.append(" ROUND(PriceList, ").append(precision);
                    sqlupd.append(")),");
                    sqlupd.append(" PriceStd = DECODE('").append(rsDiscountLine.getString("Std_Rounding"));
                    sqlupd.append("',").append(" 'N', PriceStd, ");
                    sqlupd.append(" '0', ROUND(PriceStd, 0), ");
                    sqlupd.append(" 'D', ROUND(PriceStd, 1), ");
                    sqlupd.append("'T', ROUND(PriceStd, -1),");
                    sqlupd.append("'5', ROUND(PriceStd*20,0)/20,");
                    sqlupd.append("'Q', ROUND(PriceStd*4,0)/4,");
                    sqlupd.append(" '9', CASE");
                    sqlupd.append(" WHEN MOD(ROUND(PriceStd),10)<=5 THEN ROUND(PriceStd)+(5-MOD(ROUND(PriceStd),10))");
                    sqlupd.append(" WHEN MOD(ROUND(PriceStd),10)>5 THEN ROUND(PriceStd)+(9-MOD(ROUND(PriceStd),10)) END,");
                    sqlupd.append("ROUND(PriceStd, ").append(precision).append(")),");
                    sqlupd.append("PriceLimit = DECODE('");
                    sqlupd.append(rsDiscountLine.getString("Limit_Rounding")).append("', ");
                    sqlupd.append(" \t\t'N', PriceLimit, ");
                    sqlupd.append(" \t'0', ROUND(PriceLimit, 0),\t");
                    sqlupd.append("\t'D', ROUND(PriceLimit, 1),\t");
                    sqlupd.append("\t'T', ROUND(PriceLimit, -1),\t");
                    sqlupd.append("\t'5', ROUND(PriceLimit*20,0)/20,\t");
                    sqlupd.append("\t'Q', ROUND(PriceLimit*4,0)/4,\t\t");
                    sqlupd.append("    '9', CASE");
                    sqlupd.append(" WHEN MOD(ROUND(PriceLimit),10)<=5 THEN ROUND(PriceLimit)+(5-MOD(ROUND(PriceLimit),10))");
                    sqlupd.append(" WHEN MOD(ROUND(PriceLimit),10)>5 THEN ROUND(PriceLimit)+(9-MOD(ROUND(PriceLimit),10)) END,");
                    sqlupd.append("\t\tROUND(PriceLimit, ").append(precision);
                    sqlupd.append(")) ");
                    sqlupd.append(" WHERE\tM_PriceList_Version_ID=");
                    sqlupd.append(this.p_PriceList_Version_ID);
                    sqlupd.append(" AND EXISTS\t(SELECT * FROM T_Selection s ");
                    sqlupd.append(" WHERE s.T_Selection_ID=p.M_Product_ID");
                    sqlupd.append(" AND s.AD_PInstance_ID=").append(this.m_AD_PInstance_ID).append(")");
                    cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
                    if (cntu == -1) {
                        this.raiseError("Update  M_ProductPrice ", sqlupd.toString());
                    }
                    totu += cntu;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Updated " + cntu);
                    }
                    message.append(", @Updated@=").append(cntu);
                    sqlupd = new StringBuilder("UPDATE\tM_ProductPrice p ");
                    sqlupd.append(" SET\tPriceList  = DECODE('");
                    sqlupd.append(rsDiscountLine.getString("List_Base")).append("', 'F', ");
                    sqlupd.append(rsDiscountLine.getDouble("List_Fixed")).append(", PriceList), ");
                    sqlupd.append("      PriceStd   = DECODE('");
                    sqlupd.append(rsDiscountLine.getString("Std_Base")).append("', 'F', ");
                    sqlupd.append(rsDiscountLine.getDouble("Std_Fixed")).append(", PriceStd),");
                    sqlupd.append("      PriceLimit = DECODE('");
                    sqlupd.append(rsDiscountLine.getString("Limit_Base")).append("', 'F', ");
                    sqlupd.append(rsDiscountLine.getDouble("Limit_Fixed")).append(", PriceLimit)");
                    sqlupd.append(" WHERE\t M_PriceList_Version_ID=");
                    sqlupd.append(this.p_PriceList_Version_ID);
                    sqlupd.append(" AND EXISTS (SELECT * FROM T_Selection s");
                    sqlupd.append(" WHERE s.T_Selection_ID=p.M_Product_ID");
                    sqlupd.append(" AND s.AD_PInstance_ID=").append(this.m_AD_PInstance_ID).append(")");
                    cntu = DB.executeUpdate((String)sqlupd.toString(), (String)this.get_TrxName());
                    if (cntu == -1) {
                        this.raiseError("Update  M_ProductPrice ", sqlupd.toString());
                    }
                    totu += cntu;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Updated " + cntu);
                    }
                    ++v_NextNo;
                    this.addLog(0, null, null, message.toString());
                    message = new StringBuilder();
                }
                sqldel = "DELETE FROM T_Selection WHERE AD_PInstance_ID=?";
                cntd = DB.executeUpdate((String)sqldel, (int)this.m_AD_PInstance_ID, (String)this.get_TrxName());
                if (cntd == -1) {
                    this.raiseError(" DELETE\tT_Selection ", sqldel);
                }
                totd += cntd;
                if (!this.log.isLoggable(Level.FINE)) continue;
                this.log.fine("Deleted " + cntd);
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCurgen, stmtCurgen);
            rsCurgen = null;
            stmtCurgen = null;
            DB.close(rsDiscountLine, stmtDiscountLine);
            rsDiscountLine = null;
            stmtDiscountLine = null;
            DB.close(stmt);
            stmt = null;
            DB.close(pstmt);
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCurgen, (Statement)stmtCurgen);
        rsCurgen = null;
        stmtCurgen = null;
        DB.close(rsDiscountLine, stmtDiscountLine);
        rsDiscountLine = null;
        stmtDiscountLine = null;
        DB.close(stmt);
        stmt = null;
        DB.close(pstmt);
        pstmt = null;
        return "OK";
    }

    private void raiseError(String string, String sql) throws Exception {
        StringBuilder msg = new StringBuilder(string);
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = new StringBuilder(pp.getName()).append(" - ");
        }
        msg.append(sql);
        throw new AdempiereUserError(msg.toString());
    }

    private String getSubCategoryWhereClause(int productCategoryId) throws SQLException, AdempiereSystemError {
        int subTreeRootParentId = 0;
        StringBuilder retString = new StringBuilder();
        String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
        Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (rs.getInt(1) == productCategoryId) {
                    subTreeRootParentId = rs.getInt(2);
                }
                categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
            }
            retString.append(this.getSubCategoriesString(productCategoryId, categories, subTreeRootParentId));
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)stmt);
        rs = null;
        stmt = null;
        return retString.toString();
    }

    private String getSubCategoriesString(int productCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) throws AdempiereSystemError {
        StringBuilder ret = new StringBuilder();
        for (SimpleTreeNode node : categories) {
            if (node.getParentId() != productCategoryId) continue;
            if (node.getNodeId() == loopIndicatorId) {
                throw new AdempiereSystemError("The product category tree contains a loop on categoryId: " + loopIndicatorId);
            }
            ret.append(this.getSubCategoriesString(node.getNodeId(), categories, loopIndicatorId));
            ret.append(",");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(ret.toString());
        }
        return String.valueOf(ret.toString()) + productCategoryId;
    }

    private static class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

