/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLineMA;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

public class InventoryCountUpdate
extends SvrProcess {
    private int p_M_Inventory_ID = 0;
    private boolean p_InventoryCountSetZero = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("InventoryCountSet")) {
                    this.p_InventoryCountSetZero = "Z".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_Inventory_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInventory inventory;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_Inventory_ID=" + this.p_M_Inventory_ID);
        }
        if ((inventory = new MInventory(this.getCtx(), this.p_M_Inventory_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereSystemError("Not found: M_Inventory_ID=" + this.p_M_Inventory_ID);
        }
        StringBuilder sql = new StringBuilder("UPDATE M_InventoryLine SET IsActive='N' ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID).append(" AND (M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID) IN ").append("(SELECT M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID ").append("FROM M_InventoryLine ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID).append(" GROUP BY M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID ").append("HAVING COUNT(*) > 1)");
        int multiple = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Multiple=" + multiple);
        }
        int delMA = MInventoryLineMA.deleteInventoryMA((int)this.p_M_Inventory_ID, (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("DeletedMA=" + delMA);
        }
        sql = new StringBuilder("UPDATE M_InventoryLine l ").append("SET (QtyBook,QtyCount) = ").append("(SELECT SUM(QtyOnHand),SUM(QtyOnHand) FROM M_StorageOnHand s ").append("WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID").append(" AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID),").append(" Updated=SysDate,").append(" UpdatedBy=").append(this.getAD_User_ID()).append(" WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID).append(" AND EXISTS (SELECT * FROM M_StorageOnHand s ").append("WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID").append(" AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID)");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Update with ASI=" + no);
        }
        if (this.p_InventoryCountSetZero) {
            sql = new StringBuilder("UPDATE M_InventoryLine l ").append("SET QtyCount=0 ").append("WHERE M_Inventory_ID=").append(this.p_M_Inventory_ID);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Set Count to Zero=" + no);
            }
        }
        if (multiple > 0) {
            StringBuilder msgreturn = new StringBuilder("@M_InventoryLine_ID@ - #").append(no).append(" --> @InventoryProductMultiple@");
            return msgreturn.toString();
        }
        StringBuilder msgreturn = new StringBuilder("@M_InventoryLine_ID@ - #").append(no);
        return msgreturn.toString();
    }
}

