/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.X_I_BankStatement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportBankStatement
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_BankAccount_ID = 0;
    private boolean p_deleteOldImported = false;
    private Properties m_ctx;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_BankAccount_ID")) {
                    this.p_C_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOldImported")) {
                    this.p_deleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        int noInsertLine;
        int noInsert;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        block60: {
            ResultSet rs;
            StringBuilder msglog;
            block58: {
                msglog = new StringBuilder("AD_Org_ID=").append(this.p_AD_Org_ID).append(", C_BankAccount_ID").append(this.p_C_BankAccount_ID);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(msglog.toString());
                }
                sql = null;
                no = 0;
                clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
                if (this.p_deleteOldImported) {
                    sql = new StringBuilder("DELETE I_BankStatement ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                    no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Delete Old Impored =" + no);
                    }
                }
                sql = new StringBuilder("UPDATE I_BankStatement ").append("SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
                sql.append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, SysDate),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL OR AD_Client_ID IS NULL OR AD_Org_ID IS NULL OR AD_Client_ID=0 OR AD_Org_ID=0");
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Reset=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement o ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, '").append("WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0").append(" OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N')))").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Org=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement i ").append("SET C_BankAccount_ID=").append("( ").append(" SELECT C_BankAccount_ID ").append(" FROM C_BankAccount a, C_Bank b ").append(" WHERE b.IsOwnBank='Y' ").append(" AND a.AD_Client_ID=i.AD_Client_ID ").append(" AND a.C_Bank_ID=b.C_Bank_ID ").append(" AND a.AccountNo=i.BankAccountNo ").append(" AND b.RoutingNo=i.RoutingNo ").append(" OR b.SwiftCode=i.RoutingNo ").append(") ").append("WHERE i.C_BankAccount_ID IS NULL ").append("AND i.I_IsImported<>'Y' ").append("OR i.I_IsImported IS NULL").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Bank Account (With Routing No)=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement i ").append("SET C_BankAccount_ID=").append("( ").append(" SELECT C_BankAccount_ID ").append(" FROM C_BankAccount a, C_Bank b ").append(" WHERE b.IsOwnBank='Y' ").append(" AND a.C_Bank_ID=b.C_Bank_ID ").append(" AND a.AccountNo=i.BankAccountNo ").append(" AND a.AD_Client_ID=i.AD_Client_ID ").append(") ").append("WHERE i.C_BankAccount_ID IS NULL ").append("AND i.I_isImported<>'Y' ").append("OR i.I_isImported IS NULL").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Bank Account (Without Routing No)=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement i ").append("SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount a WHERE a.C_BankAccount_ID=").append(this.p_C_BankAccount_ID).append(" and a.AD_Client_ID=i.AD_Client_ID) ").append("WHERE i.C_BankAccount_ID IS NULL ").append("AND i.BankAccountNo IS NULL ").append("AND i.I_isImported<>'Y' ").append("OR i.I_isImported IS NULL").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Bank Account=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Bank Account, ' ").append("WHERE C_BankAccount_ID IS NULL ").append("AND I_isImported<>'Y' ").append("OR I_isImported IS NULL").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Bank Account=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c").append(" WHERE i.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) ").append("WHERE C_Currency_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Set Currency=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement i ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=i.C_BankAccount_ID) ").append("WHERE i.C_Currency_ID IS NULL ").append("AND i.ISO_Code IS NULL").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Set Currency=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Currency,' ").append("WHERE C_Currency_ID IS NULL ").append("AND I_IsImported<>'E' ").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
                    this.log.warning("Invalid Currency=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET ChargeAmt=0 ").append("WHERE ChargeAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Charge Amount=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET InterestAmt=0 ").append("WHERE InterestAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Interest Amount=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET TrxAmt=StmtAmt - InterestAmt - ChargeAmt ").append("WHERE TrxAmt IS NULL ").append("AND I_IsImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Transaction Amount=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Amount, ' ").append("WHERE TrxAmt + ChargeAmt + InterestAmt <> StmtAmt ").append("AND I_isImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Invalid Amount=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET ValutaDate=StatementLineDate ").append("WHERE ValutaDate IS NULL ").append("AND I_isImported<>'Y'").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Valuta Date=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->Invoice, ' ").append("WHERE I_BankStatement_ID IN ").append("(SELECT I_BankStatement_ID ").append("FROM I_BankStatement i").append(" INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) ").append("WHERE i.C_Invoice_ID IS NOT NULL ").append(" AND p.C_Invoice_ID IS NOT NULL ").append(" AND p.C_Invoice_ID<>i.C_Invoice_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Payment<->Invoice Mismatch=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->BPartner, ' ").append("WHERE I_BankStatement_ID IN ").append("(SELECT I_BankStatement_ID ").append("FROM I_BankStatement i").append(" INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) ").append("WHERE i.C_BPartner_ID IS NOT NULL ").append(" AND p.C_BPartner_ID IS NOT NULL ").append(" AND p.C_BPartner_ID<>i.C_BPartner_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Payment<->BPartner Mismatch=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice<->BPartner, ' ").append("WHERE I_BankStatement_ID IN ").append("(SELECT I_BankStatement_ID ").append("FROM I_BankStatement i").append(" INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID) ").append("WHERE i.C_BPartner_ID IS NOT NULL ").append(" AND v.C_BPartner_ID IS NOT NULL ").append(" AND v.C_BPartner_ID<>i.C_BPartner_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Invoice<->BPartner Mismatch=" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice.BPartner<->Payment.BPartner, ' ").append("WHERE I_BankStatement_ID IN ").append("(SELECT I_BankStatement_ID ").append("FROM I_BankStatement i").append(" INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID)").append(" INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) ").append("WHERE p.C_Invoice_ID<>v.C_Invoice_ID").append(" AND v.C_BPartner_ID<>p.C_BPartner_ID) ").append((CharSequence)clientCheck)).toString(), (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Invoice.BPartner<->Payment.BPartner Mismatch=" + no);
                }
                sql = new StringBuilder("SELECT i.I_BankStatement_ID, l.C_BankStatementLine_ID, i.EftTrxID ").append("FROM I_BankStatement i, C_BankStatement s, C_BankStatementLine l ").append("WHERE i.I_isImported='N' ").append("AND s.C_BankStatement_ID=l.C_BankStatement_ID ").append("AND i.EftTrxID IS NOT NULL AND ").append("(l.EftTrxID||l.EftAmt||l.EftStatementLineDate||l.EftValutaDate||l.EftTrxType||l.EftCurrency||l.EftReference||s.EftStatementReference ").append("||l.EftCheckNo||l.EftMemo||l.EftPayee||l.EftPayeeAccount) ").append("= ").append("(i.EftTrxID||i.EftAmt||i.EftStatementLineDate||i.EftValutaDate||i.EftTrxType||i.EftCurrency||i.EftReference||i.EftStatementReference ").append("||i.EftCheckNo||i.EftMemo||i.EftPayee||i.EftPayeeAccount) ");
                StringBuilder updateSql = new StringBuilder("UPDATE I_Bankstatement ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Duplicate['||?||']' ").append("WHERE I_BankStatement_ID=?").append((CharSequence)clientCheck);
                CPreparedStatement pupdt = DB.prepareStatement((String)updateSql.toString(), (String)this.get_TrxName());
                CPreparedStatement pstmtDuplicates = null;
                rs = null;
                no = 0;
                try {
                    try {
                        pstmtDuplicates = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                        rs = pstmtDuplicates.executeQuery();
                        while (rs.next()) {
                            StringBuilder info = new StringBuilder("Line_ID=").append(rs.getInt(2)).append(",EDTTrxID=").append(rs.getString(3));
                            pupdt.setString(1, info.toString());
                            pupdt.setInt(2, rs.getInt(1));
                            pupdt.executeUpdate();
                            ++no;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "DetectDuplicates " + e.getMessage());
                        DB.close((ResultSet)rs, (Statement)pstmtDuplicates);
                        rs = null;
                        pstmtDuplicates = null;
                        DB.close((Statement)pupdt);
                        pupdt = null;
                        break block58;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmtDuplicates);
                    rs = null;
                    pstmtDuplicates = null;
                    DB.close((Statement)pupdt);
                    pupdt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmtDuplicates);
                rs = null;
                pstmtDuplicates = null;
                DB.close((Statement)pupdt);
                pupdt = null;
            }
            if (no != 0 && this.log.isLoggable(Level.INFO)) {
                this.log.info("Duplicates=" + no);
            }
            this.commitEx();
            sql = new StringBuilder("SELECT * FROM I_BankStatement").append(" WHERE I_IsImported='N'").append(" ORDER BY C_BankAccount_ID, Name, StatementDate, EftStatementReference");
            MBankStatement statement = null;
            MBankAccount account = null;
            CPreparedStatement pstmt = null;
            int lineNo = 10;
            noInsert = 0;
            noInsertLine = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_I_BankStatement imp = new X_I_BankStatement(this.m_ctx, rs, this.get_TrxName());
                        if (account == null) {
                            account = MBankAccount.get((Properties)this.m_ctx, (int)imp.getC_BankAccount_ID());
                            statement = null;
                            msglog = new StringBuilder("New Statement, Account=").append(account.getAccountNo());
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info(msglog.toString());
                            }
                        } else if (account.getC_BankAccount_ID() != imp.getC_BankAccount_ID()) {
                            account = MBankAccount.get((Properties)this.m_ctx, (int)imp.getC_BankAccount_ID());
                            statement = null;
                            msglog = new StringBuilder("New Statement, Account=").append(account.getAccountNo());
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info(msglog.toString());
                            }
                        } else if (statement.getName() != null && imp.getName() != null) {
                            if (!statement.getName().equals(imp.getName())) {
                                statement = null;
                                msglog = new StringBuilder("New Statement, Statement Name=").append(imp.getName());
                                if (this.log.isLoggable(Level.INFO)) {
                                    this.log.info(msglog.toString());
                                }
                            }
                        } else if (statement.getEftStatementReference() != null && imp.getEftStatementReference() != null) {
                            if (!statement.getEftStatementReference().equals(imp.getEftStatementReference())) {
                                statement = null;
                                msglog = new StringBuilder("New Statement, Statement Reference=").append(imp.getEftStatementReference());
                                if (this.log.isLoggable(Level.INFO)) {
                                    this.log.info(msglog.toString());
                                }
                            }
                        } else if (statement.getStatementDate() != null && imp.getStatementDate() != null && !statement.getStatementDate().equals(imp.getStatementDate())) {
                            statement = null;
                            msglog = new StringBuilder("New Statement, Statement Date=").append(imp.getStatementDate());
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info(msglog.toString());
                            }
                        }
                        if (statement == null) {
                            statement = new MBankStatement(account);
                            statement.setEndingBalance(Env.ZERO);
                            if (imp.getName() != null) {
                                statement.setName(imp.getName());
                            }
                            if (imp.getStatementDate() != null) {
                                statement.setStatementDate(imp.getStatementDate());
                            }
                            if (imp.getDateAcct() != null) {
                                statement.setDateAcct(imp.getDateAcct());
                            } else {
                                statement.setDateAcct(statement.getStatementDate());
                            }
                            statement.setDescription(imp.getDescription());
                            statement.setEftStatementReference(imp.getEftStatementReference());
                            statement.setEftStatementDate(imp.getEftStatementDate());
                            if (statement.save(this.get_TrxName())) {
                                ++noInsert;
                            }
                            lineNo = 10;
                        }
                        MBankStatementLine line = new MBankStatementLine(statement, lineNo);
                        line.setReferenceNo(imp.getReferenceNo());
                        line.setDescription(imp.getLineDescription());
                        line.setStatementLineDate(imp.getStatementLineDate());
                        line.setValutaDate(imp.getValutaDate());
                        line.setIsReversal(imp.isReversal());
                        line.setC_Currency_ID(imp.getC_Currency_ID());
                        line.setTrxAmt(imp.getTrxAmt());
                        line.setStmtAmt(imp.getStmtAmt());
                        if (imp.getC_Charge_ID() != 0) {
                            line.setC_Charge_ID(imp.getC_Charge_ID());
                        }
                        line.setInterestAmt(imp.getInterestAmt());
                        line.setChargeAmt(imp.getChargeAmt());
                        line.setMemo(imp.getMemo());
                        if (imp.getC_Payment_ID() != 0) {
                            line.setC_Payment_ID(imp.getC_Payment_ID());
                        }
                        line.setEftTrxID(imp.getEftTrxID());
                        line.setEftTrxType(imp.getEftTrxType());
                        line.setEftCheckNo(imp.getEftCheckNo());
                        line.setEftReference(imp.getEftReference());
                        line.setEftMemo(imp.getEftMemo());
                        line.setEftPayee(imp.getEftPayee());
                        line.setEftPayeeAccount(imp.getEftPayeeAccount());
                        line.setEftStatementLineDate(imp.getEftStatementLineDate());
                        line.setEftValutaDate(imp.getEftValutaDate());
                        line.setEftCurrency(imp.getEftCurrency());
                        line.setEftAmt(imp.getEftAmt());
                        if (line.save(this.get_TrxName())) {
                            imp.setC_BankStatement_ID(statement.getC_BankStatement_ID());
                            imp.setC_BankStatementLine_ID(line.getC_BankStatementLine_ID());
                            imp.setI_IsImported(true);
                            imp.setProcessed(true);
                            imp.saveEx();
                            ++noInsertLine;
                            lineNo += 10;
                        }
                        line = null;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block60;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = new StringBuilder("UPDATE I_BankStatement ").append("SET I_IsImported='N', Updated=SysDate ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BankStatement_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@C_BankStatementLine_ID@: @Inserted@");
        return "";
    }
}

