/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CopyRole
extends SvrProcess {
    private int m_AD_Role_ID_From = 0;
    private int m_AD_Role_ID_To = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Role_ID") && i == 0) {
                    this.m_AD_Role_ID_From = para[i].getParameterAsInt();
                } else if (name.equals("AD_Role_ID") && i == 1) {
                    this.m_AD_Role_ID_To = para[i].getParameterAsInt();
                } else if (name.equals("AD_Client_ID")) {
                    this.m_AD_Client_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.m_AD_Org_ID = para[i].getParameterAsInt();
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (!MRole.getDefault().isAccessAdvanced()) {
            return "@Error@ @Advanced@ @Process@";
        }
        if (this.m_AD_Role_ID_From == this.m_AD_Role_ID_To) {
            throw new AdempiereException("Roles must be different");
        }
        String[] tables = new String[]{"AD_Window_Access", "AD_Process_Access", "AD_Form_Access", "AD_Workflow_Access", "AD_Task_Access", "AD_Document_Action_Access", "AD_InfoWindow_Access", "AD_Role_Included"};
        String[] keycolumns = new String[]{"AD_Window_ID", "AD_Process_ID", "AD_Form_ID", "AD_Workflow_ID", "AD_Task_ID", "C_DocType_ID, AD_Ref_List_ID", "AD_InfoWindow_ID", "Included_Role_ID"};
        int action = 0;
        int i = 0;
        while (i < tables.length) {
            String table = tables[i];
            String keycolumn = keycolumns[i];
            StringBuilder sql = new StringBuilder("DELETE FROM ").append(table).append(" WHERE AD_Role_ID = ").append(this.m_AD_Role_ID_To);
            int no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(action++, null, BigDecimal.valueOf(no), "Old records deleted from " + table);
            boolean column_IsReadWrite = !table.equals("AD_Document_Action_Access") && !table.equals("AD_InfoWindow_Access") && !table.equals("AD_Role_Included");
            boolean column_SeqNo = table.equals("AD_Role_Included");
            sql = new StringBuilder("INSERT INTO ").append(table).append(" (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, ").append("AD_Role_ID, ").append(keycolumn).append(", isActive");
            if (column_SeqNo) {
                sql.append(", SeqNo ");
            }
            if (column_IsReadWrite) {
                sql.append(", isReadWrite) ");
            } else {
                sql.append(") ");
            }
            sql.append("SELECT ").append(this.m_AD_Client_ID).append(", ").append(this.m_AD_Org_ID).append(", SYSDATE, ").append(Env.getAD_User_ID((Properties)Env.getCtx())).append(", SYSDATE, ").append(Env.getAD_User_ID((Properties)Env.getCtx())).append(", ").append(this.m_AD_Role_ID_To).append(", ").append(keycolumn).append(", IsActive ");
            if (column_SeqNo) {
                sql.append(", SeqNo ");
            }
            if (column_IsReadWrite) {
                sql.append(", isReadWrite ");
            }
            sql.append("FROM ").append(table).append(" WHERE AD_Role_ID = ").append(this.m_AD_Role_ID_From);
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(action++, null, new BigDecimal(no), "New records inserted into " + table);
            ++i;
        }
        return "Role copied";
    }
}

