/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;

public class ChangeLogProcess
extends SvrProcess {
    private int p_AD_ChangeLog_ID = 0;
    private Boolean p_CheckNewValue = null;
    private Boolean p_CheckOldValue = null;
    private boolean p_SetCustomization = false;
    private StringBuffer m_sqlUpdate = null;
    private StringBuffer m_sqlUpdateWhere = null;
    private boolean m_isInsert = false;
    private StringBuffer m_sqlInsert = null;
    private StringBuffer m_sqlInsertValue = null;
    private MTable m_table = null;
    private MColumn m_column = null;
    private int m_oldRecord_ID = 0;
    private String m_keyColumn = null;
    private int m_numberColumns = 0;
    private ArrayList<String> m_columns = new ArrayList();
    private int m_errors = 0;
    private int m_checkFailed = 0;
    private int m_ok = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("CheckNewValue")) {
                    this.p_CheckNewValue = "Y".equals(para[i].getParameter());
                } else if (name.equals("CheckOldValue")) {
                    this.p_CheckOldValue = "Y".equals(para[i].getParameter());
                } else if (name.equals("SetCustomization")) {
                    this.p_SetCustomization = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_AD_ChangeLog_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        block10: {
            if (this.p_SetCustomization) {
                return this.setCustomization();
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("AD_ChangeLog_ID=" + this.p_AD_ChangeLog_ID + ", CheckOldValue=" + this.p_CheckOldValue + ", CheckNewValue=" + this.p_CheckNewValue);
            }
            String sql = "SELECT * FROM AD_ChangeLog WHERE AD_ChangeLog_ID=? ORDER BY AD_Table_ID, Record_ID, AD_Column_ID";
            if (this.p_AD_ChangeLog_ID == 0) {
                sql = "SELECT * FROM AD_ChangeLog WHERE IsCustomization='Y' AND IsActive='Y' ORDER BY AD_Table_ID, AD_ChangeLog_ID, Record_ID, AD_Column_ID";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    if (this.p_AD_ChangeLog_ID != 0) {
                        pstmt.setInt(1, this.p_AD_ChangeLog_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.createStatement(new MChangeLog(this.getCtx(), rs, this.get_TrxName()), this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.executeStatement();
        StringBuilder msgreturn = new StringBuilder("@OK@: ").append(this.m_ok).append(" - @Errors@: ").append(this.m_errors).append(" - @Failed@: ").append(this.m_checkFailed);
        return msgreturn.toString();
    }

    private void createStatement(MChangeLog cLog, String trxName) {
        String newValue;
        if (this.m_table != null && cLog.getAD_Table_ID() != this.m_table.getAD_Table_ID()) {
            this.executeStatement();
            this.m_table = null;
        }
        if (this.m_table == null) {
            this.m_table = new MTable(this.getCtx(), cLog.getAD_Table_ID(), trxName);
        }
        if (this.m_sqlUpdate != null && cLog.getRecord_ID() != this.m_oldRecord_ID) {
            this.executeStatement();
        }
        this.m_column = new MColumn(this.getCtx(), cLog.getAD_Column_ID(), this.get_TrxName());
        if (this.m_columns.contains(this.m_column.getColumnName())) {
            this.executeStatement();
        }
        this.m_columns.add(this.m_column.getColumnName());
        if (this.m_sqlUpdate == null) {
            String tableName = this.m_table.getTableName();
            this.m_keyColumn = String.valueOf(this.m_table.getTableName()) + "_ID";
            if (tableName.equals("AD_Ref_Table")) {
                this.m_keyColumn = "AD_Reference_ID";
            }
            this.m_sqlUpdate = new StringBuffer("UPDATE ").append(tableName).append(" SET ");
            this.m_sqlUpdateWhere = new StringBuffer(" WHERE ").append(this.m_keyColumn).append("=").append(cLog.getRecord_ID());
            this.m_oldRecord_ID = cLog.getRecord_ID();
            this.m_isInsert = "I".equals(cLog.getEventChangeLog());
            if (this.m_isInsert) {
                this.m_sqlInsert = new StringBuffer("INSERT INTO ").append(tableName).append("(").append(this.m_keyColumn);
                this.m_sqlInsertValue = new StringBuffer(") VALUES (").append(cLog.getRecord_ID());
                if (!this.m_keyColumn.equals(this.m_column.getColumnName())) {
                    this.m_sqlInsert.append(",").append(this.m_column.getColumnName());
                    this.m_sqlInsertValue.append(",").append(this.getSQLValue(cLog.getOldValue()));
                }
            }
            this.m_numberColumns = 1;
        } else {
            this.m_sqlUpdate.append(", ");
            if (this.m_isInsert) {
                this.m_isInsert = cLog.isNewNull();
            }
            if (this.m_isInsert && !this.m_keyColumn.equals(this.m_column.getColumnName())) {
                this.m_sqlInsert.append(",").append(this.m_column.getColumnName());
                this.m_sqlInsertValue.append(",").append(this.getSQLValue(cLog.getOldValue()));
            }
            ++this.m_numberColumns;
        }
        this.m_sqlUpdate.append(this.m_column.getColumnName()).append("=");
        if (this.p_CheckNewValue != null) {
            this.m_sqlUpdate.append(this.getSQLValue(cLog.getOldValue()));
            if (this.p_CheckNewValue.booleanValue()) {
                this.m_sqlUpdateWhere.append(" AND ").append(this.m_column.getColumnName());
                newValue = this.getSQLValue(cLog.getNewValue());
                if (newValue == null || "NULL".equals(newValue)) {
                    this.m_sqlUpdateWhere.append(" IS NULL");
                } else {
                    this.m_sqlUpdateWhere.append("=").append(newValue);
                }
            }
        } else if (this.p_CheckOldValue != null) {
            this.m_sqlUpdate.append(this.getSQLValue(cLog.getNewValue()));
            if (this.p_CheckOldValue.booleanValue()) {
                newValue = this.getSQLValue(cLog.getOldValue());
                this.m_sqlUpdateWhere.append(" AND ").append(this.m_column.getColumnName());
                if (newValue == null || "NULL".equals(newValue)) {
                    this.m_sqlUpdateWhere.append(" IS NULL");
                } else {
                    this.m_sqlUpdateWhere.append("=").append(newValue);
                }
            }
        }
    }

    private String getSQLValue(String value) {
        if (value == null || value.length() == 0 || value.equals("NULL")) {
            return "NULL";
        }
        if (DisplayType.isNumeric((int)this.m_column.getAD_Reference_ID()) || DisplayType.isID((int)this.m_column.getAD_Reference_ID())) {
            return value;
        }
        if (20 == this.m_column.getAD_Reference_ID()) {
            if (value.equals("true")) {
                return "'Y'";
            }
            return "'N'";
        }
        if (DisplayType.isDate((int)this.m_column.getAD_Reference_ID())) {
            return DB.TO_DATE((Timestamp)Timestamp.valueOf(value));
        }
        return DB.TO_STRING((String)value);
    }

    private boolean executeStatement() {
        if (this.m_sqlUpdate == null) {
            return false;
        }
        int no = 0;
        if (this.m_isInsert && this.m_numberColumns > 2) {
            this.m_sqlInsert.append(this.m_sqlInsertValue).append(")");
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.m_sqlInsert.toString());
            }
            if ((no = DB.executeUpdate((String)this.m_sqlInsert.toString(), (String)this.get_TrxName())) == -1) {
                ++this.m_errors;
            } else if (no == 0) {
                this.log.warning("Insert failed - " + this.m_sqlInsert);
                ++this.m_checkFailed;
            } else {
                ++this.m_ok;
            }
        } else {
            this.m_sqlUpdate.append(this.m_sqlUpdateWhere);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.m_sqlUpdate.toString());
            }
            if ((no = DB.executeUpdate((String)this.m_sqlUpdate.toString(), (String)this.get_TrxName())) == -1) {
                ++this.m_errors;
            } else if (no == 0) {
                this.log.warning("Failed - " + this.m_sqlUpdate);
                ++this.m_checkFailed;
            } else {
                ++this.m_ok;
            }
        }
        this.m_sqlUpdate = null;
        this.m_sqlUpdateWhere = null;
        this.m_sqlInsert = null;
        this.m_sqlInsertValue = null;
        this.m_columns = new ArrayList();
        return no > 0;
    }

    private String setCustomization() {
        int updateNo;
        int resetNo;
        block8: {
            this.log.info("");
            String sql = "UPDATE AD_ChangeLog SET IsCustomization='N' WHERE IsCustomization='Y'";
            resetNo = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            updateNo = 0;
            sql = "SELECT * FROM AD_Table t WHERE EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='EntityType') AND EXISTS (SELECT * FROM AD_ChangeLog l WHERE t.AD_Table_ID=l.AD_Table_ID)";
            StringBuilder update = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MTable table = new MTable(this.getCtx(), rs, this.get_TrxName());
                        String tableName = table.getTableName();
                        String columnName = String.valueOf(tableName) + "_ID";
                        if (tableName.equals("AD_Ref_Table")) {
                            columnName = "AD_Reference_ID";
                        }
                        update = new StringBuilder("UPDATE AD_ChangeLog SET IsCustomization='Y' ").append("WHERE AD_Table_ID=").append(table.getAD_Table_ID());
                        update.append(" AND Record_ID IN (SELECT ").append(columnName).append(" FROM ").append(tableName).append(" WHERE EntityType IN ('D','C'))");
                        int no = DB.executeUpdate((String)update.toString(), (String)this.get_TrxName());
                        StringBuilder msglog = new StringBuilder().append(table.getTableName()).append(" = ").append(no);
                        if (this.log.isLoggable(Level.CONFIG)) {
                            this.log.config(msglog.toString());
                        }
                        updateNo += no;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, String.valueOf(sql) + " --- " + update, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@Reset@: ").append(resetNo).append(" - @Updated@: ").append(updateNo);
        return msgreturn.toString();
    }
}

