/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.GenericPO;
import org.compiere.model.MHouseKeeping;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class HouseKeeping
extends SvrProcess {
    private int p_AD_HouseKeeping_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] parameter = this.getParameter();
        int i = 0;
        while (i < parameter.length) {
            String name = parameter[i].getParameterName();
            if (parameter[i].getParameter() != null) {
                if (name.equals("AD_HouseKeeping_ID")) {
                    this.p_AD_HouseKeeping_ID = parameter[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_AD_HouseKeeping_ID == 0) {
            this.p_AD_HouseKeeping_ID = this.getRecord_ID();
        }
    }

    protected String doIt() throws Exception {
        MHouseKeeping houseKeeping = new MHouseKeeping(this.getCtx(), this.p_AD_HouseKeeping_ID, this.get_TrxName());
        String tableName = null;
        int tableID = houseKeeping.getAD_Table_ID();
        if (tableID > 0) {
            MTable table = new MTable(this.getCtx(), tableID, this.get_TrxName());
            tableName = table.getTableName();
        } else {
            tableName = houseKeeping.getTableName();
        }
        String whereClause = houseKeeping.getWhereClause();
        int noins = 0;
        int noexp = 0;
        int nodel = 0;
        if (houseKeeping.isSaveInHistoric()) {
            StringBuilder sql = new StringBuilder("INSERT INTO hst_").append(tableName).append(" SELECT * FROM ").append(tableName);
            if (whereClause != null && whereClause.length() > 0) {
                sql.append(" WHERE ").append(whereClause);
            }
            if ((noins = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName())) == -1) {
                throw new AdempiereSystemError("Cannot insert into hst_" + tableName);
            }
            this.addLog("@Inserted@ " + noins);
        }
        Date date = new Date();
        if (houseKeeping.isExportXMLBackup() && houseKeeping.getAD_Table_ID() > 0) {
            String pathFile = houseKeeping.getBackupFolder();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateString = dateFormat.format(date);
            FileWriter file = new FileWriter(String.valueOf(pathFile) + File.separator + tableName + dateString + ".xml");
            StringBuilder sql = new StringBuilder("SELECT * FROM ").append(tableName);
            if (whereClause != null && whereClause.length() > 0) {
                sql.append(" WHERE ").append(whereClause);
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            StringBuffer linexml = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    GenericPO po = new GenericPO(tableName, this.getCtx(), rs, this.get_TrxName());
                    linexml = po.get_xmlString(linexml);
                    ++noexp;
                }
                if (linexml != null) {
                    file.write(linexml.toString());
                }
                file.close();
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            pstmt = null;
            rs = null;
            this.addLog("@Exported@ " + noexp);
        }
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(tableName);
        if (whereClause != null && whereClause.length() > 0) {
            sql.append(" WHERE ").append(whereClause);
        }
        if ((nodel = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName())) == -1) {
            throw new AdempiereSystemError("Cannot delete from " + tableName);
        }
        Timestamp time = new Timestamp(date.getTime());
        houseKeeping.setLastRun(time);
        houseKeeping.setLastDeleted(nodel);
        houseKeeping.saveEx();
        this.addLog("@Deleted@ " + nodel);
        StringBuilder msg = new StringBuilder().append(Msg.getElement((Properties)this.getCtx(), (String)(String.valueOf(tableName) + "_ID"))).append(" #").append(nodel);
        return msg.toString();
    }
}

