/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.DocManager;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ClientAcctProcessor
extends SvrProcess {
    private int p_C_AcctSchema_ID;
    private int p_AD_Table_ID;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;
    private MAcctSchema[] m_ass = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder msglog = new StringBuilder("C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(", AD_Table_ID=").append(this.p_AD_Table_ID);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(msglog.toString());
        }
        if (!MClient.isClientAccounting()) {
            throw new AdempiereUserError(Msg.getMsg((Properties)this.getCtx(), (String)"ClientAccountingNotEnabled"));
        }
        this.m_client = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        this.m_ass = this.p_C_AcctSchema_ID == 0 ? MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID()) : new MAcctSchema[]{new MAcctSchema(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName())};
        this.postSession();
        MCost.create((MClient)this.m_client);
        this.addLog(this.m_summary.toString());
        return "@OK@";
    }

    private void postSession() {
        ArrayList<BigDecimal> listProcessedOn = new ArrayList<BigDecimal>();
        listProcessedOn.add(Env.ZERO);
        Timestamp ts = DB.getSQLValueTS((String)this.get_TrxName(), (String)"SELECT CURRENT_TIMESTAMP FROM DUAL", (Object[])new Object[0]);
        long ms = ts.getTime() - 2000L;
        ts = new Timestamp(ms);
        long mili = ts.getTime();
        BigDecimal value = new BigDecimal(Long.toString(mili));
        int[] documentsTableID = DocManager.getDocumentsTableID();
        String[] documentsTableName = DocManager.getDocumentsTableName();
        int i = 0;
        while (i < documentsTableID.length) {
            block30: {
                int AD_Table_ID = documentsTableID[i];
                String TableName = documentsTableName[i];
                if (this.p_AD_Table_ID == 0 || this.p_AD_Table_ID == AD_Table_ID) {
                    StringBuilder sql = new StringBuilder("SELECT DISTINCT ProcessedOn FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND ProcessedOn<?").append(" AND Processed='Y' AND Posted='N' AND IsActive='Y'");
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                            pstmt.setInt(1, this.getAD_Client_ID());
                            pstmt.setBigDecimal(2, value);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                BigDecimal processedOn = rs.getBigDecimal(1);
                                if (listProcessedOn.contains(processedOn)) continue;
                                listProcessedOn.add(processedOn);
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                }
            }
            ++i;
        }
        int[] count = new int[documentsTableID.length];
        int[] countError = new int[documentsTableID.length];
        int i2 = 0;
        while (i2 < count.length) {
            count[i2] = 0;
            countError[i2] = 0;
            ++i2;
        }
        Collections.sort(listProcessedOn);
        for (BigDecimal processedOn : listProcessedOn) {
            int i3 = 0;
            while (i3 < documentsTableID.length) {
                block34: {
                    int AD_Table_ID = documentsTableID[i3];
                    String TableName = documentsTableName[i3];
                    if (this.p_AD_Table_ID == 0 || this.p_AD_Table_ID == AD_Table_ID) {
                        StringBuilder sql = new StringBuilder("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND (ProcessedOn");
                        if (processedOn.compareTo(Env.ZERO) != 0) {
                            sql.append("=?");
                        } else {
                            sql.append(" IS NULL OR ProcessedOn=0");
                        }
                        sql.append(") AND Processed='Y' AND Posted='N' AND IsActive='Y'").append(" ORDER BY Created");
                        CPreparedStatement pstmt = null;
                        ResultSet rs = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                                pstmt.setInt(1, this.getAD_Client_ID());
                                if (processedOn.compareTo(Env.ZERO) != 0) {
                                    pstmt.setBigDecimal(2, processedOn);
                                }
                                rs = pstmt.executeQuery();
                                while (rs.next()) {
                                    boolean ok;
                                    block32: {
                                        int n = i3;
                                        count[n] = count[n] + 1;
                                        ok = true;
                                        String innerTrxName = Trx.createTrxName((String)"CAP");
                                        Trx innerTrx = Trx.get((String)innerTrxName, (boolean)true);
                                        innerTrx.setDisplayName(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_postSession");
                                        try {
                                            try {
                                                String error = DocManager.postDocument((MAcctSchema[])this.m_ass, (int)AD_Table_ID, (ResultSet)rs, (boolean)false, (boolean)false, (String)innerTrxName);
                                                ok = error == null;
                                            }
                                            catch (Exception e) {
                                                this.log.log(Level.SEVERE, String.valueOf(this.getName()) + ": " + TableName, (Throwable)e);
                                                ok = false;
                                                innerTrx.commit();
                                                innerTrx.close();
                                                innerTrx = null;
                                                break block32;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            innerTrx.commit();
                                            innerTrx.close();
                                            innerTrx = null;
                                            throw throwable;
                                        }
                                        innerTrx.commit();
                                        innerTrx.close();
                                        innerTrx = null;
                                    }
                                    if (ok) continue;
                                    int n = i3;
                                    countError[n] = countError[n] + 1;
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                                DB.close(rs, (Statement)pstmt);
                                break block34;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                    }
                }
                ++i3;
            }
        }
        i = 0;
        while (i < documentsTableID.length) {
            StringBuilder msglog;
            String TableName = documentsTableName[i];
            if (count[i] > 0) {
                this.m_summary.append(TableName).append("=").append(count[i]);
                if (countError[i] > 0) {
                    this.m_summary.append("(Errors=").append(countError[i]).append(")");
                }
                this.m_summary.append(" - ");
                msglog = new StringBuilder().append(this.getName()).append(": ").append(this.m_summary.toString());
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(msglog.toString());
                }
            } else {
                msglog = new StringBuilder().append(this.getName()).append(": ").append(TableName).append(" - no work");
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(msglog.toString());
                }
            }
            ++i;
        }
    }
}

