/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.process;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCtxHelpMsg;
import org.compiere.model.Query;
import org.compiere.model.X_AD_CtxHelpSuggestion;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class AcceptCtxHelpSuggestion
extends SvrProcess {
    private boolean p_isSaveAsTenantCustomization;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("IsSaveAsTenantCustomization")) {
                    this.p_isSaveAsTenantCustomization = para.getParameterAsBoolean();
                } else {
                    this.log.log(Level.WARNING, "Unknown Parameter: " + name);
                }
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        X_AD_CtxHelpSuggestion suggestion = new X_AD_CtxHelpSuggestion(Env.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.p_isSaveAsTenantCustomization) {
            int AD_Client_ID = suggestion.getAD_UserClient_ID();
            int AD_User_ID = suggestion.getAD_User_ID();
            return this.updateOrInsert(suggestion, AD_Client_ID, AD_User_ID);
        }
        return this.updateOrInsert(suggestion, 0, Env.getAD_User_ID((Properties)this.getCtx()));
    }

    private String updateOrInsert(X_AD_CtxHelpSuggestion suggestion, int AD_Client_ID, int AD_User_ID) {
        String original;
        boolean changed = false;
        String AD_Language = suggestion.getAD_Language();
        int AD_CtxHelpMsg_ID = suggestion.getAD_CtxHelpMsg_ID();
        if (Env.isBaseLanguage((String)AD_Language, (String)"AD_CtxHelpMsg")) {
            Query query = new Query(Env.getCtx(), "AD_CtxHelpMsg", "AD_CtxHelp_ID=? AND IsActive='Y' AND AD_Client_ID=?", this.get_TrxName());
            MCtxHelpMsg msg = (MCtxHelpMsg)query.setParameters(new Object[]{suggestion.getAD_CtxHelp_ID(), AD_Client_ID}).first();
            if (msg != null) {
                msg.setMsgText(suggestion.getMsgText());
                if (msg.is_Changed()) {
                    msg.saveEx();
                    changed = true;
                }
                if (msg.getAD_CtxHelpMsg_ID() != AD_CtxHelpMsg_ID) {
                    AD_CtxHelpMsg_ID = msg.getAD_CtxHelpMsg_ID();
                }
            } else {
                msg = new MCtxHelpMsg(Env.getCtx(), 0, this.get_TrxName());
                msg.setAD_CtxHelp_ID(suggestion.getAD_CtxHelp_ID());
                msg.setMsgText(suggestion.getMsgText());
                msg.setClientOrg(AD_Client_ID, 0);
                msg.saveEx();
                AD_CtxHelpMsg_ID = msg.getAD_CtxHelpMsg_ID();
                changed = true;
            }
        } else {
            MCtxHelpMsg ctxHelpMsg = new MCtxHelpMsg(Env.getCtx(), AD_CtxHelpMsg_ID, this.get_TrxName());
            if (ctxHelpMsg.getAD_Client_ID() != AD_Client_ID) {
                MCtxHelpMsg newMsg = new MCtxHelpMsg(Env.getCtx(), 0, this.get_TrxName());
                newMsg.setClientOrg(AD_Client_ID, 0);
                newMsg.setAD_CtxHelp_ID(ctxHelpMsg.getAD_CtxHelp_ID());
                newMsg.setMsgText(ctxHelpMsg.getMsgText());
                newMsg.setIsActive(true);
                newMsg.saveEx();
                AD_CtxHelpMsg_ID = newMsg.getAD_CtxHelpMsg_ID();
            }
        }
        if ((original = DB.getSQLValueStringEx((String)this.get_TrxName(), (String)"SELECT MsgText FROM AD_CtxHelpMsg_Trl WHERE AD_CtxHelpMsg_ID=? AND AD_Client_ID=? AND IsActive='Y' AND AD_Language=?", (Object[])new Object[]{AD_CtxHelpMsg_ID, AD_Client_ID, suggestion.getAD_Language()})) != null) {
            if (!original.equals(suggestion.getMsgText())) {
                ArrayList<Object> params = new ArrayList<Object>();
                StringBuilder update = new StringBuilder("UPDATE AD_CtxHelpMsg_Trl SET ");
                if (!Util.isEmpty((String)suggestion.getMsgText())) {
                    update.append("MsgText=? ");
                    params.add(suggestion.getMsgText());
                }
                if (!params.isEmpty()) {
                    update.append("WHERE AD_CtxHelpMsg_ID=? AND AD_Language=? AND AD_Client_ID=?");
                    params.add(AD_CtxHelpMsg_ID);
                    params.add(suggestion.getAD_Language());
                    params.add(AD_Client_ID);
                    DB.executeUpdateEx((String)update.toString(), (Object[])params.toArray(), (String)this.get_TrxName());
                    changed = true;
                }
            }
        } else {
            StringBuilder insert = new StringBuilder("Insert Into AD_CtxHelpMsg_Trl (AD_Client_ID, AD_Org_ID, AD_CtxHelpMsg_ID, IsActive, IsTranslated, AD_Language, MsgText,");
            insert.append("Created, CreatedBy, Updated, UpdatedBy, AD_CtxHelpMsg_Trl_UU)").append(" Values (?, ?, ?, 'Y', 'N', ?, ?, sysdate, ?, sysdate, ?, generate_uuid()) ");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(AD_Client_ID);
            params.add(0);
            params.add(AD_CtxHelpMsg_ID);
            params.add(AD_Language);
            params.add(suggestion.getMsgText());
            params.add(AD_User_ID);
            params.add(AD_User_ID);
            DB.executeUpdateEx((String)insert.toString(), (Object[])params.toArray(), (String)this.get_TrxName());
            changed = true;
        }
        suggestion.setIsApproved(true);
        suggestion.setIsSaveAsTenantCustomization(AD_Client_ID > 0);
        suggestion.setProcessed(true);
        suggestion.saveEx();
        if (changed) {
            return "Suggestion accepted and applied to context help";
        }
        return "No changes found";
    }
}

