/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.hazelcast.service.Activator;
import org.idempiere.hazelcast.service.ClusterMember;

public class ClusterServiceImpl
implements IClusterService {
    public Collection<IClusterMember> getMembers() {
        HazelcastInstance instance = Activator.getHazelcastInstance();
        HashSet<IClusterMember> clusterMembers = new HashSet<IClusterMember>();
        if (instance != null) {
            Set members = instance.getCluster().getMembers();
            for (Member member : members) {
                clusterMembers.add(new ClusterMember(member));
            }
        }
        return clusterMembers;
    }

    public IClusterMember getLocalMember() {
        HazelcastInstance instance = Activator.getHazelcastInstance();
        if (instance != null) {
            Member member = instance.getCluster().getLocalMember();
            return new ClusterMember(member);
        }
        return null;
    }

    public <V> Future<V> execute(Callable<V> task, IClusterMember clusterMember) {
        HazelcastInstance instance = Activator.getHazelcastInstance();
        if (instance != null) {
            Set members = instance.getCluster().getMembers();
            for (Member member : members) {
                if (!member.getUuid().equals(clusterMember.getId())) continue;
                IExecutorService service = Activator.getHazelcastInstance().getExecutorService("default");
                return service.submitToMember(task, member);
            }
        }
        return null;
    }

    public <V> Map<IClusterMember, Future<V>> execute(Callable<V> task, Collection<IClusterMember> clusterMembers) {
        HashSet<String> selectedIds = new HashSet<String>();
        for (IClusterMember clusterMember : clusterMembers) {
            selectedIds.add(clusterMember.getId());
        }
        HazelcastInstance instance = Activator.getHazelcastInstance();
        if (instance != null) {
            Set members = instance.getCluster().getMembers();
            HashSet<Member> selectedMembers = new HashSet<Member>();
            for (Member member : members) {
                if (!selectedIds.contains(member.getUuid())) continue;
                selectedMembers.add(member);
            }
            if (selectedMembers.size() > 0) {
                IExecutorService service = Activator.getHazelcastInstance().getExecutorService("default");
                Map map = service.submitToMembers(task, selectedMembers);
                LinkedHashMap<IClusterMember, Future<Future>> futureMap = new LinkedHashMap<IClusterMember, Future<Future>>();
                for (Member member : map.keySet()) {
                    futureMap.put(new ClusterMember(member), (Future)map.get(member));
                }
                return futureMap;
            }
        }
        return null;
    }
}

