/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.hazelcast.service;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISet;
import com.hazelcast.core.Member;
import java.util.Collection;
import java.util.Set;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.idempiere.hazelcast.service.Activator;

public class CacheConsoleProvider
implements CommandProvider {
    public String getHelp() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("---- Hazelcast plugin console commands: ");
        buffer.append("\n\t hazelcastStatus \u2013 print informations of current hazelcast Server");
        buffer.append("\n\t hazelcastObjects \u2013 list all distributed objects saved into hazelcast Server");
        return buffer.toString();
    }

    public Object _hazelcastStatus(CommandInterpreter console) {
        console.nextArgument();
        StringBuilder sb = new StringBuilder();
        if (Activator.getHazelcastInstance() == null) {
            sb.append("\n hazelcast not started.");
        } else {
            HazelcastInstance instance = Activator.getHazelcastInstance();
            Cluster cluster = instance.getCluster();
            Set members = cluster.getMembers();
            if (members != null) {
                for (Member member : members) {
                    sb.append("hazelcast ");
                    sb.append(member.getUuid());
                    sb.append(" Node Server: ");
                    sb.append(member.getSocketAddress());
                    sb.append("\n");
                }
            }
        }
        console.println((Object)sb.toString());
        return null;
    }

    public Object _hazelcastObjects(CommandInterpreter console) {
        StringBuilder sb = new StringBuilder();
        if (Activator.getHazelcastInstance() == null) {
            sb.append("\n hazelcast not started.");
        } else {
            HazelcastInstance instance = Activator.getHazelcastInstance();
            Collection objects = instance.getDistributedObjects();
            sb.append("\nHave ");
            sb.append(objects.size());
            sb.append(" keys:");
            for (DistributedObject object : objects) {
                sb.append("\n\t");
                sb.append(String.valueOf(object.getServiceName()) + "->" + object.getName());
                if ("hz:impl:mapService".equals(object.getServiceName())) {
                    IMap map = instance.getMap(object.getName());
                    sb.append(" #" + map.size());
                    continue;
                }
                if (!"hz:impl:setService".equals(object.getServiceName())) continue;
                ISet set = instance.getSet(object.getName());
                sb.append(" #" + set.size());
            }
        }
        console.println((Object)sb.toString());
        return null;
    }
}

