/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.keylistener;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.MCommon;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class Keylistener
extends HtmlBasedComponent {
    private String _ctrlKeys;
    private String _jsCtrlKeys;
    private boolean _autoBlur = true;
    private static final long serialVersionUID = 4611014738053691844L;

    public boolean isAutoBlur() {
        return this._autoBlur;
    }

    public void setAutoBlur(boolean autoBlur) {
        this._autoBlur = autoBlur;
        this.smartUpdate("autoblur", this._autoBlur);
    }

    public String getCtrlKeys() {
        return this._ctrlKeys;
    }

    public void setCtrlKeys(String ctrlKeys) {
        if (ctrlKeys != null && ctrlKeys.length() == 0) {
            ctrlKeys = null;
        }
        if (!Objects.equals((Object)this._ctrlKeys, (Object)ctrlKeys)) {
            this.parseCtrlKeys(ctrlKeys);
            this.smartUpdate("ctrlKeys", this._jsCtrlKeys);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "ctrlKeys", this._jsCtrlKeys);
        this.render(renderer, "autoblur", this._autoBlur);
    }

    private void parseCtrlKeys(String keys) throws UiException {
        if (keys == null || keys.length() == 0) {
            this._jsCtrlKeys = null;
            this._ctrlKeys = null;
            return;
        }
        StringBuffer sbctl = new StringBuffer();
        StringBuffer sbsft = new StringBuffer();
        StringBuffer sbalt = new StringBuffer();
        StringBuffer sbext = new StringBuffer();
        StringBuffer sbcur = null;
        int j = 0;
        int len = keys.length();
        while (j < len) {
            int cc = keys.charAt(j);
            switch (cc) {
                case 36: 
                case 64: 
                case 94: {
                    if (sbcur != null) {
                        throw new WrongValueException("Combination of Shift, Alt and Ctrl not supported: " + keys);
                    }
                    sbcur = cc == 94 ? sbctl : (cc == 64 ? sbalt : sbsft);
                    break;
                }
                case 35: {
                    int k = j + 1;
                    while (k < len) {
                        char c2 = keys.charAt(k);
                        if (!(c2 <= 'Z' && c2 >= 'A' || c2 <= 'z' && c2 >= 'a' || c2 <= '9' && c2 >= '0')) break;
                        ++k;
                    }
                    if (k == j + 1) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{Character.valueOf((char)cc), keys});
                    }
                    String s = keys.substring(j + 1, k).toLowerCase();
                    if ("pgup".equals(s)) {
                        cc = 65;
                    } else if ("pgdn".equals(s)) {
                        cc = 66;
                    } else if ("end".equals(s)) {
                        cc = 67;
                    } else if ("home".equals(s)) {
                        cc = 68;
                    } else if ("left".equals(s)) {
                        cc = 69;
                    } else if ("up".equals(s)) {
                        cc = 70;
                    } else if ("right".equals(s)) {
                        cc = 71;
                    } else if ("down".equals(s)) {
                        cc = 72;
                    } else if ("ins".equals(s)) {
                        cc = 73;
                    } else if ("del".equals(s)) {
                        cc = 74;
                    } else if ("enter".equals(s)) {
                        cc = 75;
                    } else if (s.length() > 1 && s.charAt(0) == 'f') {
                        int v;
                        try {
                            v = Integer.parseInt(s.substring(1));
                        }
                        catch (Throwable ex) {
                            throw new WrongValueException("Unknown #" + s + " in " + keys);
                        }
                        if (v == 0 || v > 12) {
                            throw new WrongValueException("Unsupported function key: #f" + v);
                        }
                        cc = (char)(79 + v);
                    } else {
                        throw new WrongValueException("Unknown #" + s + " in " + keys);
                    }
                    if (sbcur == null) {
                        sbext.append((char)cc);
                    } else {
                        sbcur.append((char)cc);
                        sbcur = null;
                    }
                    j = k - 1;
                    break;
                }
                default: {
                    if (!(sbcur != null && (cc <= 90 && cc >= 65 || cc <= 122 && cc >= 97 || cc <= 57 && cc >= 48))) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{Character.valueOf((char)cc), keys});
                    }
                    if (sbcur == sbsft) {
                        throw new WrongValueException("$" + (char)cc + " not supported: " + keys);
                    }
                    if (cc <= 90 && cc >= 65) {
                        cc = (char)(cc + 32);
                    }
                    sbcur.append((char)cc);
                    sbcur = null;
                }
            }
            ++j;
        }
        this._jsCtrlKeys = new StringBuffer().append('^').append(sbctl).append(';').append('@').append(sbalt).append(';').append('$').append(sbsft).append(';').append('#').append(sbext).append(';').toString();
        this._ctrlKeys = keys;
    }

    public boolean isChildable() {
        return false;
    }
}

