/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.idempiere.ui.zk.websocket.ServerPushEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.impl.ExecutionCarryOver;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.util.Clients;

public class WebSocketServerPush
implements ServerPush {
    private static final String ON_ACTIVATE_DESKTOP = "onActivateDesktop";
    private final AtomicReference<Desktop> desktop = new AtomicReference();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadInfo _active;
    private ExecutionCarryOver _carryOver;
    private final Object _mutex = new Object();
    private static final Map<String, ServerPushEndPoint> endPointMap = new ConcurrentHashMap<String, ServerPushEndPoint>();
    private static final Map<String, Boolean> unregisterMap = new ConcurrentHashMap<String, Boolean>();
    private static final ServerPushEndPoint STUB = new ServerPushEndPoint();
    private List<Schedule<Event>> schedules = new ArrayList<Schedule<Event>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            return true;
        }
        final ThreadInfo info = new ThreadInfo(curr);
        EventListener<Event> task = new EventListener<Event>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(Event event) throws Exception {
                if (event.getName().equals(WebSocketServerPush.ON_ACTIVATE_DESKTOP)) {
                    Object object = WebSocketServerPush.this._mutex;
                    synchronized (object) {
                        WebSocketServerPush.this._carryOver = new ExecutionCarryOver(WebSocketServerPush.this.desktop.get());
                        ThreadInfo threadInfo = info;
                        synchronized (threadInfo) {
                            info.nActive = 1;
                            info.notifyAll();
                        }
                        try {
                            WebSocketServerPush.this._mutex.wait();
                        }
                        catch (InterruptedException ex) {
                            throw UiException.Aide.wrap((Throwable)ex);
                        }
                    }
                }
            }
        };
        ThreadInfo threadInfo = info;
        synchronized (threadInfo) {
            Executions.schedule((Desktop)this.desktop.get(), (EventListener)task, (Event)new Event(ON_ACTIVATE_DESKTOP));
            if (info.nActive == 0) {
                info.wait(timeout <= 0L ? 600000L : timeout);
            }
        }
        this._carryOver.carryOver();
        this._active = info;
        return true;
    }

    private boolean echo() {
        Desktop dt = this.desktop.get();
        if (dt != null) {
            ServerPushEndPoint endPoint = WebSocketServerPush.getEndPoint(dt.getId());
            if (endPoint == null && dt.isServerPushEnabled()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                endPoint = WebSocketServerPush.getEndPoint(dt.getId());
            }
            if (endPoint != null) {
                endPoint.echo();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            if (stop) {
                this.stop();
                stopped = true;
            }
            this._carryOver.cleanup();
            this._carryOver = null;
            this._active.nActive = 0;
            this._active = null;
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notifyAll();
            }
        }
        return stopped;
    }

    public boolean isActive() {
        return this._active != null && this._active.nActive > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPiggyback() {
        ServerPushEndPoint endPoint;
        Desktop dt;
        Schedule[] pendings = null;
        List<Schedule<Event>> list = this.schedules;
        synchronized (list) {
            if (!this.schedules.isEmpty()) {
                pendings = this.schedules.toArray(new Schedule[0]);
                this.schedules = new ArrayList<Schedule<Event>>();
            }
        }
        if (pendings != null && pendings.length > 0) {
            Schedule[] scheduleArray = pendings;
            int n = pendings.length;
            int n2 = 0;
            while (n2 < n) {
                Schedule p2 = scheduleArray[n2];
                p2.scheduler.schedule(p2.task, p2.event);
                ++n2;
            }
        }
        if ((dt = this.desktop.get()) != null && (endPoint = WebSocketServerPush.getEndPoint(dt.getId())) == null && dt.isServerPushEnabled() && unregisterMap.remove(dt.getId(), Boolean.TRUE)) {
            WebSocketServerPush.registerEndPoint(dt.getId(), STUB);
            this.startServerPushAtClient(dt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Event> void schedule(EventListener<T> task, T event, Scheduler<T> scheduler) {
        if (Executions.getCurrent() == null) {
            List<Schedule<Event>> list = this.schedules;
            synchronized (list) {
                this.schedules.add(new Schedule(this, task, event, scheduler));
            }
            this.echo();
        } else {
            scheduler.schedule(task, event);
        }
    }

    public void start(Desktop desktop) {
        Desktop oldDesktop = this.desktop.getAndSet(desktop);
        if (oldDesktop != null) {
            this.log.warn("Server push already started for desktop " + desktop.getId());
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting server push for " + desktop);
        }
        WebSocketServerPush.registerEndPoint(desktop.getId(), STUB);
        this.startServerPushAtClient(desktop);
    }

    private void startServerPushAtClient(Desktop desktop) {
        Clients.response((String)"org.idempiere.websocket.serverpush.start", (AuResponse)new AuScript(null, "org.idempiere.websocket.startServerPush('" + desktop.getId() + "');"));
    }

    public void stop() {
        Desktop desktop = this.desktop.getAndSet(null);
        if (desktop == null) {
            this.log.warn("Server push hasn't been started or has already stopped");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping server push for " + desktop);
        }
        Clients.response((String)"org.idempiere.websocket.serverpush.stop", (AuResponse)new AuScript(null, "org.idempiere.websocket.stopServerPush('" + desktop.getId() + "');"));
    }

    public void resume() {
        if (this.desktop.get() != null) {
            Desktop desktop = this.desktop.getAndSet(null);
            this.start(desktop);
        }
    }

    public static void registerEndPoint(String dtid, ServerPushEndPoint endpoint) {
        endPointMap.put(dtid, endpoint);
    }

    public static boolean unregisterEndPoint(String dtid) {
        ServerPushEndPoint endpoint = endPointMap.remove(dtid);
        if (endpoint != null) {
            unregisterMap.put(dtid, Boolean.TRUE);
        }
        return endpoint != null;
    }

    public static ServerPushEndPoint getEndPoint(String dtid) {
        ServerPushEndPoint endpoint = endPointMap.get(dtid);
        if (endpoint == STUB) {
            return null;
        }
        return endpoint;
    }

    public static boolean isValidDesktopId(String dtid) {
        return endPointMap.containsKey(dtid);
    }

    private static class Schedule<T extends Event> {
        private EventListener<T> task;
        private T event;
        private Scheduler<T> scheduler;
        final /* synthetic */ WebSocketServerPush this$0;

        private Schedule(EventListener<T> task, T event, Scheduler<T> scheduler) {
            this.this$0 = var1_1;
            this.task = task;
            this.event = event;
            this.scheduler = scheduler;
        }
    }

    private static class ThreadInfo {
        private final Thread thread;
        private int nActive;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        public String toString() {
            return "[" + this.thread + ',' + this.nActive + ']';
        }
    }
}

