/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.awt.print.Pageable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import org.adempiere.exceptions.DBException;
import org.adempiere.pdf.Document;
import org.adempiere.util.ContextRunnable;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.DesktopRunnable;
import org.adempiere.webui.apps.WReport;
import org.adempiere.webui.apps.form.WReportCustomization;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.event.ZoomEvent;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.report.HTMLExtension;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.IServerPushCallback;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.FindWindow;
import org.adempiere.webui.window.WEMailDialog;
import org.compiere.Adempiere;
import org.compiere.model.GridField;
import org.compiere.model.MArchive;
import org.compiere.model.MClient;
import org.compiere.model.MLanguage;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MUser;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.North;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.impl.Utils;

public class ZkReportViewer
extends Window
implements EventListener<Event>,
ITabOnCloseHandler {
    private static final long serialVersionUID = -5315520059451132465L;
    private int m_WindowNo = -1;
    private long prevKeyEventTime = 0L;
    private KeyEvent prevKeyEvent;
    private Properties m_ctx;
    private boolean m_setting = false;
    private ReportEngine m_reportEngine;
    private int m_AD_Table_ID = 0;
    private boolean m_isCanExport;
    private MQuery m_ddQ = null;
    private MQuery m_daQ = null;
    private Menuitem m_ddM = null;
    private Menuitem m_daM = null;
    private static CLogger log = CLogger.getCLogger(ZkReportViewer.class);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Toolbar toolBar = new Toolbar();
    private ToolBarButton bSendMail = new ToolBarButton();
    private ToolBarButton bArchive = new ToolBarButton();
    private ToolBarButton bCustomize = new ToolBarButton();
    private ToolBarButton bFind = new ToolBarButton();
    private ToolBarButton bExport = new ToolBarButton();
    private ToolBarButton bWizard = new ToolBarButton();
    private Listbox comboReport = new Listbox();
    private WTableDirEditor wLanguage;
    private Label labelDrill = new Label();
    private Listbox comboDrill = new Listbox();
    private Listbox previewType = new Listbox();
    private ToolBarButton bRefresh = new ToolBarButton();
    private Iframe iframe;
    private Window winExportFile = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Listbox cboType = new Listbox();
    private Checkbox summary = new Checkbox();
    private AMedia media;
    private int mediaVersion = 0;
    private A reportLink;
    private boolean init = false;
    private BusyDialog progressWindow;
    private Mask mask;
    private Future<?> future;
    private static final String ON_RENDER_REPORT_EVENT = "onRenderReport";
    private Popup toolbarPopup;
    private boolean ToolBarMenuRestictionLoaded = false;

    public ZkReportViewer(ReportEngine re, String title) {
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        Env.setContext((Properties)re.getCtx(), (int)this.m_WindowNo, (String)"_WinInfo_IsReportViewer", (String)"Y");
        this.m_reportEngine = re;
        this.m_AD_Table_ID = re.getPrintFormat().getAD_Table_ID();
        if (!MRole.getDefault().isCanReport(this.m_AD_Table_ID)) {
            FDialog.error(this.m_WindowNo, (Component)this, "AccessCannotReport", this.m_reportEngine.getName());
            this.onClose();
        }
        this.m_isCanExport = MRole.getDefault().isCanExport(this.m_AD_Table_ID);
        this.setTitle(Util.cleanAmp((String)(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Report")) + ": " + this.m_reportEngine.getPrintFormat().get_Translation("Name"))));
        this.addEventListener(ON_RENDER_REPORT_EVENT, this);
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && !this.init) {
            try {
                this.m_ctx = this.m_reportEngine.getCtx();
                this.init();
                this.dynInit();
                SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", (Throwable)e);
                FDialog.error(this.m_WindowNo, (Component)this, "LoadError", e.getLocalizedMessage());
                this.onClose();
            }
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        Borderlayout layout = new Borderlayout();
        layout.setStyle("position: absolute; height: 97%; width: 98%; border:none; padding:none; margin:none;");
        this.appendChild((Component)layout);
        this.setStyle("width: 100%; height: 100%; position: absolute; border:none; padding:none; margin:none;");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.toolBar, "32px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.toolBar, "100%");
        this.previewType.setMold("select");
        this.previewType.appendItem("HTML", "HTML");
        if (this.m_isCanExport) {
            this.previewType.appendItem("PDF", "PDF");
            this.previewType.appendItem("Excel", "XLS");
        }
        this.toolBar.appendChild((Component)this.previewType);
        this.previewType.addEventListener("onSelect", this);
        this.toolBar.appendChild((Component)new Separator("vertical"));
        int pTypeIndex = 0;
        if (this.m_reportEngine.getReportType() != null) {
            if (this.m_reportEngine.getReportType().equals("PDF") && this.m_isCanExport) {
                pTypeIndex = 1;
            } else if (this.m_reportEngine.getReportType().equals("XLS") && this.m_isCanExport) {
                pTypeIndex = 2;
            }
        } else {
            String type;
            String string = type = this.m_reportEngine.getPrintFormat().isForm() ? MSysConfig.getValue((String)"ZK_REPORT_FORM_OUTPUT_TYPE", (String)"PDF", (int)Env.getAD_Client_ID((Properties)this.m_ctx), (int)Env.getAD_Org_ID((Properties)this.m_ctx)) : MSysConfig.getValue((String)"ZK_REPORT_TABLE_OUTPUT_TYPE", (String)"PDF", (int)Env.getAD_Client_ID((Properties)this.m_ctx), (int)Env.getAD_Org_ID((Properties)this.m_ctx));
            if ("HTML".equals(type)) {
                pTypeIndex = 0;
            } else if ("PDF".equals(type) && this.m_isCanExport) {
                pTypeIndex = 1;
            } else if ("XLS".equals(type) && this.m_isCanExport) {
                pTypeIndex = 2;
            }
        }
        this.previewType.setSelectedIndex(pTypeIndex);
        Vlayout toolbarPopupLayout = null;
        if (ClientInfo.maxWidth(699)) {
            this.toolbarPopup = new Popup();
            this.appendChild((Component)this.toolbarPopup);
            toolbarPopupLayout = new Vlayout();
            this.toolbarPopup.appendChild((Component)toolbarPopupLayout);
        }
        this.labelDrill.setValue(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Drill")) + ": ");
        this.comboDrill.setMold("select");
        this.comboDrill.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Drill"));
        if (this.toolbarPopup != null) {
            Hlayout hl = new Hlayout();
            hl.setValign("middle");
            hl.appendChild((Component)this.labelDrill);
            hl.appendChild((Component)this.comboDrill);
            toolbarPopupLayout.appendChild((Component)hl);
        } else {
            this.toolBar.appendChild((Component)this.labelDrill);
            this.toolBar.appendChild((Component)this.comboDrill);
        }
        if (this.toolbarPopup == null) {
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.comboReport.setMold("select");
        this.comboReport.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"AD_PrintFormat_ID"));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.comboReport);
        } else {
            this.toolBar.appendChild((Component)this.comboReport);
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        MClient client = MClient.get((Properties)this.m_ctx);
        if (client.isMultiLingualDocument()) {
            try {
                this.wLanguage = AEnv.getListDocumentLanguage(client);
                this.wLanguage.getComponent().setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"AD_PrintFormat_ID"));
                if (this.toolbarPopup != null) {
                    toolbarPopupLayout.appendChild((Component)this.wLanguage.getComponent());
                } else {
                    this.toolBar.appendChild((Component)this.wLanguage.getComponent());
                }
                this.wLanguage.setValue(this.m_reportEngine.getLanguageID());
                this.wLanguage.getComponent().addEventListener("onSelect", this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
        if (this.toolbarPopup == null && client.isMultiLingualDocument()) {
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.summary.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Summary"));
        this.summary.setChecked(this.m_reportEngine.isSummary());
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.summary);
        } else {
            this.toolBar.appendChild((Component)this.summary);
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.bCustomize.setName("Customize");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bCustomize.setIconSclass("z-icon-Preference");
        } else {
            this.bCustomize.setImage(ThemeManager.getThemeResource("images/Preference24.png"));
        }
        this.bCustomize.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"PrintCustomize")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bCustomize);
            this.bCustomize.setLabel(this.bCustomize.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bCustomize);
        }
        this.bCustomize.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bCustomize);
        }
        this.bFind.setName("Find");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bFind.setIconSclass("z-icon-Find");
        } else {
            this.bFind.setImage(ThemeManager.getThemeResource("images/Find24.png"));
        }
        this.bFind.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Find")));
        this.bFind.addEventListener("onClick", this);
        if (this.getAD_Tab_ID(this.m_reportEngine.getPrintFormat().getAD_Table_ID()) <= 0) {
            this.bFind.setVisible(false);
        }
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bFind);
            this.bFind.setLabel(this.bFind.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bFind);
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bFind);
        }
        this.bSendMail.setName("SendMail");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSendMail.setIconSclass("z-icon-SendMail");
        } else {
            this.bSendMail.setImage(ThemeManager.getThemeResource("images/SendMail24.png"));
        }
        this.bSendMail.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bSendMail);
            this.bSendMail.setLabel(this.bSendMail.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bSendMail);
        }
        this.bSendMail.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bSendMail);
        }
        this.bArchive.setName("Archive");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bArchive.setIconSclass("z-icon-Archive");
        } else {
            this.bArchive.setImage(ThemeManager.getThemeResource("images/Archive24.png"));
        }
        this.bArchive.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Archive")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bArchive);
            this.bArchive.setLabel(this.bArchive.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bArchive);
        }
        this.bArchive.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bArchive);
        }
        if (this.m_isCanExport) {
            this.bExport.setName("Export");
            if (ThemeManager.isUseFontIconForImage()) {
                this.bExport.setIconSclass("z-icon-Export");
            } else {
                this.bExport.setImage(ThemeManager.getThemeResource("images/Export24.png"));
            }
            this.bExport.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Export")));
            if (this.toolbarPopup != null) {
                toolbarPopupLayout.appendChild((Component)this.bExport);
                this.bExport.setLabel(this.bExport.getTooltiptext());
            } else {
                this.toolBar.appendChild((Component)this.bExport);
            }
            this.bExport.addEventListener("onClick", this);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bExport);
            }
        }
        if (this.toolbarPopup == null) {
            this.toolBar.appendChild((Component)new Separator("vertical"));
        }
        this.bRefresh.setName("Refresh");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bRefresh.setIconSclass("z-icon-Refresh");
        } else {
            this.bRefresh.setImage(ThemeManager.getThemeResource("images/Refresh24.png"));
        }
        this.bRefresh.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bRefresh);
            this.bRefresh.setLabel(this.bRefresh.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bRefresh);
        }
        this.bRefresh.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bRefresh);
        }
        if (ThemeManager.isUseFontIconForImage()) {
            this.bWizard.setIconSclass("z-icon-Wizard");
        } else {
            this.bWizard.setImage(ThemeManager.getThemeResource("images/Wizard24.png"));
        }
        this.bWizard.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"PrintWizard")));
        if (this.toolbarPopup != null) {
            toolbarPopupLayout.appendChild((Component)this.bWizard);
            this.bWizard.setLabel(this.bWizard.getTooltiptext());
        } else {
            this.toolBar.appendChild((Component)this.bWizard);
        }
        this.bWizard.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bWizard);
        }
        if (this.toolbarPopup != null) {
            ToolBarButton more = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                more.setIconSclass("z-icon-Expand");
            } else {
                more.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
            }
            this.toolBar.appendChild((Component)more);
            LayoutUtils.addSclass("space-between-content", (HtmlBasedComponent)this.toolBar);
            more.addEventListener("onClick", evt -> this.toolbarPopup.open((Component)more, "before_end"));
        }
        North north = new North();
        layout.appendChild((Component)north);
        north.appendChild((Component)this.toolBar);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        Center center = new Center();
        layout.appendChild((Component)center);
        this.iframe = new Iframe();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.iframe, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.iframe, "100%");
        this.iframe.setId("reportFrame");
        center.appendChild((Component)this.iframe);
        South south = new South();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "50px");
        layout.appendChild((Component)south);
        this.reportLink = new A();
        this.reportLink.setTarget("_blank");
        Div linkDiv = new Div();
        linkDiv.setStyle("width:100%; height: 40px; padding-top: 4px; padding-bottom: 4px;");
        linkDiv.appendChild((Component)this.reportLink);
        south.appendChild((Component)linkDiv);
        int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_reportEngine.getWindowNo(), (String)"_WinInfo_AD_Window_ID", (boolean)true);
        if (AD_Window_ID == 0) {
            AD_Window_ID = Env.getZoomWindowID((MQuery)this.m_reportEngine.getQuery());
        }
        int AD_Process_ID = this.m_reportEngine.getPrintInfo() != null ? this.m_reportEngine.getPrintInfo().getAD_Process_ID() : 0;
        this.updateToolbarAccess(AD_Window_ID, AD_Process_ID);
        this.postRenderReportEvent();
        this.setBorder("normal");
        this.addEventListener("onZoom", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof ZoomEvent) {
                    Clients.clearBusy();
                    ZoomEvent ze = (ZoomEvent)event;
                    if (ze.getData() != null && ze.getData() instanceof MQuery) {
                        AEnv.zoom((MQuery)ze.getData());
                    }
                }
            }
        });
        this.addEventListener("onDrillAcross", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof DrillEvent) {
                    Clients.clearBusy();
                    DrillEvent de = (DrillEvent)event;
                    if (de.getData() != null && de.getData() instanceof MQuery) {
                        MQuery query = (MQuery)de.getData();
                        ListItem item = ZkReportViewer.this.comboDrill.getSelectedItem();
                        if (item != null && item.getValue() != null && item.toString().trim().length() > 0) {
                            query.setTableName(item.getValue().toString());
                            ZkReportViewer.this.executeDrill(query, event.getTarget());
                        }
                    }
                }
            }
        });
        this.addEventListener("onDrillDown", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof DrillEvent) {
                    Clients.clearBusy();
                    DrillEvent de = (DrillEvent)event;
                    if (de.getData() != null && de.getData() instanceof MQuery) {
                        MQuery query = (MQuery)de.getData();
                        ZkReportViewer.this.executeDrill(query, event.getTarget());
                    }
                }
            }
        });
        this.init = true;
    }

    private int getAD_Tab_ID(int AD_Table_ID) {
        String sql = "SELECT t.AD_Tab_ID FROM AD_Tab t INNER JOIN AD_Window w ON (t.AD_Window_ID=w.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) WHERE tt.AD_Table_ID=? ORDER BY w.IsDefault DESC, t.SeqNo, ABS (tt.AD_Window_ID-t.AD_Window_ID)";
        int AD_Tab_ID = DB.getSQLValueEx(null, (String)"SELECT t.AD_Tab_ID FROM AD_Tab t INNER JOIN AD_Window w ON (t.AD_Window_ID=w.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) WHERE tt.AD_Table_ID=? ORDER BY w.IsDefault DESC, t.SeqNo, ABS (tt.AD_Window_ID-t.AD_Window_ID)", (Object[])new Object[]{AD_Table_ID});
        return AD_Tab_ID;
    }

    private void renderReport() {
        this.media = null;
        ListItem selected = this.previewType.getSelectedItem();
        if (selected == null || "PDF".equals(selected.getValue())) {
            this.future = Adempiere.getThreadPoolExecutor().submit(new DesktopRunnable((Runnable)((Object)new PDFRendererRunnable(this)), this.getDesktop()));
        } else if ("HTML".equals(this.previewType.getSelectedItem().getValue())) {
            this.future = Adempiere.getThreadPoolExecutor().submit(new DesktopRunnable((Runnable)((Object)new HTMLRendererRunnable(this)), this.getDesktop()));
        } else if ("XLS".equals(this.previewType.getSelectedItem().getValue())) {
            this.future = Adempiere.getThreadPoolExecutor().submit(new DesktopRunnable((Runnable)((Object)new XLSRendererRunnable(this)), this.getDesktop()));
        }
    }

    private void onPreviewReport() {
        try {
            if (this.future != null) {
                try {
                    this.future.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
            ++this.mediaVersion;
            String url = Utils.getDynamicMediaURI((AbstractComponent)this, (int)this.mediaVersion, (String)this.media.getName(), (String)this.media.getFormat());
            String pdfJsUrl = "pdf.js/web/viewer.html?file=" + url;
            HttpServletRequest request = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
            if (url.startsWith(String.valueOf(request.getContextPath()) + "/")) {
                url = url.substring((String.valueOf(request.getContextPath()) + "/").length());
            }
            this.reportLink.setHref(url);
            this.reportLink.setLabel(this.media.getName());
            if (ClientInfo.isMobile()) {
                ListItem selected = this.previewType.getSelectedItem();
                if (selected == null || "PDF".equals(selected.getValue())) {
                    this.iframe.setSrc(pdfJsUrl);
                } else if ("HTML".equals(this.previewType.getSelectedItem().getValue())) {
                    this.iframe.setSrc(null);
                    this.iframe.setContent((Media)this.media);
                } else {
                    this.iframe.setSrc(null);
                    this.iframe.setContent(null);
                    String script = "zk.Widget.$('#" + this.reportLink.getUuid() + "').$n().click();";
                    Clients.evalJavaScript((String)script);
                }
            } else {
                this.iframe.setSrc(null);
                this.iframe.setContent((Media)this.media);
            }
            this.revalidate();
        }
        finally {
            this.hideBusyDialog();
            this.future = null;
        }
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    private void dynInit() {
        block11: {
            boolean trl;
            this.summary.addActionListener(this);
            this.summary.setStyle("font-size: 14px");
            this.fillComboReport(this.m_reportEngine.getPrintFormat().get_ID());
            this.comboDrill.appendItem("", null);
            String sql = "SELECT t.AD_Table_ID, t.TableName, e.PrintName, NULLIF(e.PO_PrintName,e.PrintName) FROM AD_Column c  INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID) INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) WHERE c.AD_Table_ID=? AND c.IsKey='Y' ORDER BY 3";
            boolean bl = trl = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Element");
            if (trl) {
                sql = "SELECT t.AD_Table_ID, t.TableName, et.PrintName, NULLIF(et.PO_PrintName,et.PrintName) FROM AD_Column c INNER JOIN AD_Column used ON (c.ColumnName=used.ColumnName) INNER JOIN AD_Table t ON (used.AD_Table_ID=t.AD_Table_ID AND t.IsView='N' AND t.AD_Table_ID <> c.AD_Table_ID) INNER JOIN AD_Column cKey ON (t.AD_Table_ID=cKey.AD_Table_ID AND cKey.IsKey='Y') INNER JOIN AD_Element e ON (cKey.ColumnName=e.ColumnName) INNER JOIN AD_Element_Trl et ON (e.AD_Element_ID=et.AD_Element_ID) WHERE c.AD_Table_ID=? AND c.IsKey='Y' AND et.AD_Language=? ORDER BY 3";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_reportEngine.getPrintFormat().getAD_Table_ID());
                    if (trl) {
                        pstmt.setString(2, Env.getAD_Language((Properties)Env.getCtx()));
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String tableName = rs.getString(2);
                        String name = rs.getString(3);
                        String poName = rs.getString(4);
                        if (poName != null) {
                            name = String.valueOf(name) + "/" + poName;
                        }
                        this.comboDrill.appendItem(name, tableName);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.comboDrill.getItemCount() == 1) {
            this.labelDrill.setVisible(false);
            this.comboDrill.setVisible(false);
        } else {
            this.comboDrill.addEventListener("onSelect", this);
        }
        this.revalidate();
    }

    private void fillComboReport(int AD_PrintFormat_ID) {
        KeyNamePair pp;
        block10: {
            this.comboReport.removeEventListener("onSelect", this);
            this.comboReport.getItems().clear();
            KeyNamePair selectValue = null;
            int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_reportEngine.getWindowNo(), (String)"_WinInfo_AD_Window_ID", (boolean)true);
            if (AD_Window_ID == 0) {
                AD_Window_ID = Env.getZoomWindowID((MQuery)this.m_reportEngine.getQuery());
            }
            int reportViewID = this.m_reportEngine.getPrintFormat().getAD_ReportView_ID();
            String sql = MRole.getDefault().addAccessSQL("SELECT * FROM AD_PrintFormat WHERE AD_Table_ID=? AND IsActive='Y' " + (AD_Window_ID > 0 ? "AND (AD_Window_ID=? OR AD_Window_ID IS NULL) " : "") + (reportViewID > 0 ? "AND AD_ReportView_ID=? " : "") + "ORDER BY Name", "AD_PrintFormat", false, false);
            int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    int idx = 1;
                    pstmt.setInt(idx++, AD_Table_ID);
                    if (AD_Window_ID > 0) {
                        pstmt.setInt(idx++, AD_Window_ID);
                    }
                    if (reportViewID > 0) {
                        pstmt.setInt(idx++, reportViewID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPrintFormat printFormat = new MPrintFormat(Env.getCtx(), rs, null);
                        pp = new KeyNamePair(printFormat.get_ID(), printFormat.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()), true));
                        ListItem li = this.comboReport.appendItem(pp.getName(), pp.getKey());
                        if (rs.getInt(1) != AD_PrintFormat_ID || (selectValue = pp) == null) continue;
                        this.comboReport.setSelectedItem(li);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        int pfAD_Window_ID = MPrintFormat.getZoomWindowID((int)AD_PrintFormat_ID);
        if (MRole.getDefault().isTableAccess(493, false) && Boolean.TRUE.equals(MRole.getDefault().getWindowAccess(pfAD_Window_ID))) {
            StringBuffer sb = new StringBuffer("** ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"NewReport")).append(" **");
            pp = new KeyNamePair(-1, sb.toString());
            this.comboReport.appendItem(pp.getName(), pp.getKey());
        }
        this.comboReport.addEventListener("onSelect", this);
    }

    private void revalidate() {
        this.setTitle(Util.cleanAmp((String)(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Report")) + ": " + this.m_reportEngine.getName())));
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.getMsg((Properties)Env.getCtx(), (String)"DataCols")).append("=").append(this.m_reportEngine.getColumnCount()).append(", ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"DataRows")).append("=").append(this.m_reportEngine.getRowCount());
        this.statusBar.setStatusLine(sb.toString());
        this.bWizard.setDisabled(this.m_reportEngine.getPrintFormat() == null || this.m_reportEngine.getPrintFormat().getAD_Client_ID() == 0 && Env.getAD_Client_ID((Properties)Env.getCtx()) != 0 || this.m_reportEngine.getPrintFormat().isForm());
        this.invalidate();
    }

    public void onClose() {
        this.cleanUp();
        super.onClose();
    }

    @Override
    public void onClose(Tabpanel tabPanel) {
        Tab tab = tabPanel.getLinkedTab();
        tab.close();
        this.cleanUp();
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent != null && parent instanceof Tabpanel) {
            Tabpanel tabPanel = (Tabpanel)parent;
            tabPanel.setOnCloseHandler(this);
        }
    }

    private void cleanUp() {
        if (this.m_reportEngine != null || this.m_WindowNo >= 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.m_WindowNo);
            this.m_reportEngine = null;
            this.m_ctx = null;
            this.m_WindowNo = -1;
        }
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.winExportFile.onClose();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.exportFile();
        } else if (event.getName().equals("onClick") || event.getName().equals("onSelect")) {
            this.actionPerformed(event);
        } else if (event.getTarget() == this.summary) {
            this.m_reportEngine.setSummary(this.summary.isSelected());
            this.cmd_report();
        } else if (event.getName().equals(ON_RENDER_REPORT_EVENT)) {
            this.onRenderReportEvent();
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                long time = System.currentTimeMillis();
                if (this.prevKeyEvent != null && this.prevKeyEventTime > 0L && this.prevKeyEvent.getKeyCode() == keyEvent.getKeyCode() && this.prevKeyEvent.getTarget() == keyEvent.getTarget() && this.prevKeyEvent.isAltKey() == keyEvent.isAltKey() && this.prevKeyEvent.isCtrlKey() == keyEvent.isCtrlKey() && this.prevKeyEvent.isShiftKey() == keyEvent.isShiftKey() && time - this.prevKeyEventTime <= 300L) {
                    return;
                }
                this.onCtrlKeyEvent(keyEvent);
            }
        }
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 && this.m_WindowNo > 0) {
            this.prevKeyEventTime = System.currentTimeMillis();
            this.prevKeyEvent = keyEvent;
            keyEvent.stopPropagation();
            SessionManager.getAppDesktop().closeWindow(this.m_WindowNo);
        }
    }

    private void onRenderReportEvent() {
        this.renderReport();
    }

    public void actionPerformed(Event e) {
        if (this.m_setting) {
            return;
        }
        if (e.getTarget() == this.comboReport) {
            this.cmd_report();
        } else if (MClient.get((Properties)this.m_ctx).isMultiLingualDocument() && e.getTarget() == this.wLanguage.getComponent()) {
            this.cmd_report();
        } else if (e.getTarget() == this.bFind) {
            this.cmd_find();
        } else if (e.getTarget() == this.bExport) {
            this.cmd_export();
        } else if (e.getTarget() == this.previewType) {
            this.cmd_render();
        } else if (e.getTarget() == this.bSendMail) {
            this.cmd_sendMail();
        } else if (e.getTarget() == this.bArchive) {
            this.cmd_archive();
        } else if (e.getTarget() == this.bCustomize) {
            this.cmd_customize();
        } else if (e.getTarget() == this.bWizard) {
            this.cmd_Wizard();
        } else if (e.getTarget() == this.bRefresh) {
            this.cmd_report();
        } else if (e.getTarget() == this.m_ddM) {
            this.cmd_window(this.m_ddQ);
        } else if (e.getTarget() == this.m_daM) {
            this.cmd_window(this.m_daQ);
        }
    }

    private void cmd_render() {
        this.postRenderReportEvent();
    }

    private void executeDrill(MQuery query, Component component) {
        int AD_Table_ID = MTable.getTable_ID((String)query.getTableName());
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            FDialog.error(this.m_WindowNo, (Component)this, "AccessCannotReport", query.getTableName());
            return;
        }
        if (AD_Table_ID != 0) {
            new WReport(AD_Table_ID, query, component, this.m_WindowNo);
        } else {
            log.warning("No Table found for " + query.getWhereClause(true));
        }
    }

    private void cmd_window(MQuery query) {
        if (query == null) {
            return;
        }
        AEnv.zoom(query);
    }

    private void cmd_sendMail() {
        String to = "";
        MUser from = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        String subject = this.m_reportEngine.getName();
        String message = "";
        File attachment = null;
        try {
            attachment = new File(FileUtil.getTempMailName((String)subject, (String)".pdf"));
            this.m_reportEngine.getPDF(attachment);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail"), from, to, subject, message, (DataSource)new FileDataSource(attachment));
        AEnv.showWindow(dialog);
    }

    private void cmd_archive() {
        boolean success = false;
        byte[] data = Document.getPDFAsArray((Pageable)this.m_reportEngine.getLayout().getPageable(false));
        if (data != null) {
            MArchive archive = new MArchive(Env.getCtx(), this.m_reportEngine.getPrintInfo(), null);
            archive.setBinaryData(data);
            success = archive.save();
        }
        if (success) {
            FDialog.info(this.m_WindowNo, (Component)this, "Archived");
        } else {
            FDialog.error(this.m_WindowNo, (Component)this, "ArchiveError");
        }
    }

    private void cmd_export() {
        log.config("");
        if (!this.m_isCanExport) {
            FDialog.error(this.m_WindowNo, (Component)this, "AccessCannotExport", this.getTitle());
            return;
        }
        if (this.winExportFile == null) {
            this.winExportFile = new Window();
            this.winExportFile.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Export")) + ": " + this.getTitle());
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.winExportFile, 450);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this.winExportFile, 150);
            this.winExportFile.setClosable(true);
            this.winExportFile.setBorder("normal");
            this.winExportFile.setSclass("popup-dialog");
            this.winExportFile.setStyle("position:absolute");
            this.cboType.setMold("select");
            this.cboType.getItems().clear();
            this.cboType.appendItem("ps - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePS"), "ps");
            this.cboType.appendItem("xml - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXML"), "xml");
            ListItem li = this.cboType.appendItem("pdf - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf");
            this.cboType.appendItem("html - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html");
            this.cboType.appendItem("txt - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileTXT"), "txt");
            this.cboType.appendItem("ssv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv");
            this.cboType.appendItem("csv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv");
            this.cboType.appendItem("xls - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls");
            this.cboType.setSelectedItem(li);
            Hbox hb = new Hbox();
            hb.setSclass("dialog-content");
            hb.setAlign("center");
            hb.setPack("start");
            Div div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType")));
            hb.appendChild((Component)div);
            hb.appendChild((Component)this.cboType);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.cboType, "100%");
            Vbox vb = new Vbox();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
            this.winExportFile.appendChild((Component)vb);
            vb.appendChild((Component)hb);
            vb.appendChild((Component)this.confirmPanel);
            LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
            this.confirmPanel.addActionListener(this);
        }
        this.winExportFile.setAttribute("mode", "highlighted");
        AEnv.showWindow(this.winExportFile);
    }

    private void exportFile() {
        try {
            StringWriter sw;
            ListItem li = this.cboType.getSelectedItem();
            if (li == null || li.getValue() == null) {
                FDialog.error(this.m_WindowNo, (Component)this.winExportFile, "FileInvalidExtension");
                return;
            }
            String ext = li.getValue().toString();
            byte[] data = null;
            File inputFile = null;
            if (ext.equals("pdf")) {
                data = this.m_reportEngine.createPDFData();
            } else if (ext.equals("ps")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.m_reportEngine.createPS((OutputStream)baos);
                data = baos.toByteArray();
            } else if (ext.equals("xml")) {
                sw = new StringWriter();
                this.m_reportEngine.createXML((Writer)sw);
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("csv")) {
                sw = new StringWriter();
                this.m_reportEngine.createCSV((Writer)sw, ',', this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("ssv")) {
                sw = new StringWriter();
                this.m_reportEngine.createCSV((Writer)sw, ';', this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("txt")) {
                sw = new StringWriter();
                this.m_reportEngine.createCSV((Writer)sw, '\t', this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("html") || ext.equals("htm")) {
                sw = new StringWriter();
                String contextPath = Executions.getCurrent().getContextPath();
                this.m_reportEngine.createHTML((Writer)sw, false, this.m_reportEngine.getPrintFormat().getLanguage(), (IHTMLExtension)new HTMLExtension(contextPath, "rp", this.getUuid()), true);
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("xls")) {
                inputFile = File.createTempFile("Export", ".xls");
                this.m_reportEngine.createXLS(inputFile, this.m_reportEngine.getPrintFormat().getLanguage());
            } else {
                FDialog.error(this.m_WindowNo, (Component)this.winExportFile, "FileInvalidExtension");
                return;
            }
            this.winExportFile.onClose();
            AMedia media = null;
            media = data != null ? new AMedia(String.valueOf(this.m_reportEngine.getName()) + "." + ext, null, "application/octet-stream", data) : new AMedia(String.valueOf(this.m_reportEngine.getName()) + "." + ext, null, "application/octet-stream", inputFile, true);
            Filedownload.save((Media)media, (String)(String.valueOf(this.m_reportEngine.getName()) + "." + ext));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cmd_report() {
        ListItem li = this.comboReport.getSelectedItem();
        if (li == null || li.getValue() == null) {
            return;
        }
        Object pp = li.getValue();
        if (pp == null) {
            return;
        }
        MPrintFormat pf = null;
        int AD_PrintFormat_ID = Integer.valueOf(pp.toString());
        if (AD_PrintFormat_ID == -1) {
            int AD_ReportView_ID = this.m_reportEngine.getPrintFormat().getAD_ReportView_ID();
            if (AD_ReportView_ID != 0) {
                String name = this.m_reportEngine.getName();
                int index = name.lastIndexOf(95);
                if (index != -1) {
                    name = name.substring(0, index);
                }
                pf = MPrintFormat.createFromReportView((Properties)this.m_ctx, (int)AD_ReportView_ID, (String)name);
            } else {
                int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
                pf = MPrintFormat.createFromTable((Properties)this.m_ctx, (int)AD_Table_ID);
            }
            if (pf == null) return;
            this.fillComboReport(pf.get_ID());
        } else {
            pf = MPrintFormat.get((Properties)Env.getCtx(), (int)AD_PrintFormat_ID, (boolean)true);
        }
        if (this.m_reportEngine.getPrintFormat() != null) {
            this.setLanguage();
            pf.setLanguage(this.m_reportEngine.getPrintFormat().getLanguage());
            pf.setTranslationLanguage(this.m_reportEngine.getPrintFormat().getLanguage());
        }
        this.m_reportEngine.setPrintFormat(pf);
        this.postRenderReportEvent();
    }

    protected void setLanguage() {
        if (MClient.get((Properties)this.m_ctx).isMultiLingualDocument() && this.wLanguage.getValue() != null) {
            MLanguage language = new MLanguage(this.m_ctx, ((Integer)this.wLanguage.getValue()).intValue(), null);
            Language lang = new Language(language.getName(), language.getAD_Language(), language.getLocale());
            this.m_reportEngine.setLanguageID(language.getAD_Language_ID());
            this.m_reportEngine.getPrintFormat().setLanguage(lang);
            this.m_reportEngine.getPrintFormat().setTranslationLanguage(lang);
        }
    }

    private void postRenderReportEvent() {
        this.showBusyDialog();
        this.setLanguage();
        Events.echoEvent((String)ON_RENDER_REPORT_EVENT, (Component)this, null);
    }

    private void cmd_find() {
        String title = null;
        String tableName = null;
        int AD_Table_ID = this.m_reportEngine.getPrintFormat().getAD_Table_ID();
        int AD_Tab_ID = this.getAD_Tab_ID(AD_Table_ID);
        MClient client = MClient.get((Properties)Env.getCtx());
        String ASPFilter = "";
        if (client.isUseASP()) {
            ASPFilter = "     AND (   AD_Tab_ID IN (               SELECT t.AD_Tab_ID                 FROM ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND t.ASP_Window_ID = w.ASP_Window_ID " + "                 AND t.IsActive = 'Y' " + "                 AND w.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND t.ASP_Status = 'S') " + "        OR AD_Tab_ID IN ( " + "              SELECT AD_Tab_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Tab_ID IS NOT NULL " + "                 AND ce.AD_Field_ID IS NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Tab_ID NOT IN ( " + "          SELECT AD_Tab_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Tab_ID IS NOT NULL " + "             AND ce.AD_Field_ID IS NULL " + "             AND ce.ASP_Status = 'H')";
        }
        String sql = null;
        sql = !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Tab") ? "SELECT Name, TableName FROM AD_Tab_vt WHERE AD_Tab_ID=? AND AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "' " + ASPFilter : "SELECT Name, TableName FROM AD_Tab_v WHERE AD_Tab_ID=? " + ASPFilter;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, AD_Tab_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    title = rs.getString(1);
                    tableName = rs.getString(2);
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        GridField[] findFields = null;
        if (tableName != null) {
            findFields = GridField.createFields((Properties)this.m_ctx, (int)this.m_WindowNo, (int)0, (int)AD_Tab_ID);
        }
        if (findFields == null) {
            this.bFind.setVisible(false);
        } else {
            final FindWindow find = new FindWindow(this.m_WindowNo, title, AD_Table_ID, tableName, this.m_reportEngine.getWhereExtended(), findFields, 1, AD_Tab_ID);
            if (!find.initialize()) {
                return;
            }
            find.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (!find.isCancel()) {
                        ZkReportViewer.this.m_reportEngine.setQuery(find.getQuery());
                        ZkReportViewer.this.postRenderReportEvent();
                    }
                }
            });
            find.setTitle(null);
            LayoutUtils.openPopupWindow((Component)this.toolBar, (org.zkoss.zul.Window)find, "after_start");
        }
    }

    private void cmd_customize() {
        int AD_PrintFormat_ID = this.m_reportEngine.getPrintFormat().get_ID();
        int pfAD_Window_ID = MPrintFormat.getZoomWindowID((int)AD_PrintFormat_ID);
        AEnv.zoom(pfAD_Window_ID, MQuery.getEqualQuery((String)"AD_PrintFormat_ID", (int)AD_PrintFormat_ID));
    }

    private void cmd_Wizard() {
        ADForm form = ADForm.openForm(200002);
        WReportCustomization av = (WReportCustomization)form.getICustomForm();
        av.setReportEngine(this.m_reportEngine);
        form.setClosable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)form, "70%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)form, "85%");
        form.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onWindowClose".equals(event.getName())) {
                    ZkReportViewer.this.fillComboReport(ZkReportViewer.this.m_reportEngine.getPrintFormat().get_ID());
                    ZkReportViewer.this.cmd_report();
                }
            }
        });
        form.setAttribute("mode", "highlighted");
        SessionManager.getAppDesktop().showWindow(form);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public void updateToolbarAccess(int AD_Window_ID, int AD_Process_ID) {
        int[] restrictionList;
        if (this.ToolBarMenuRestictionLoaded) {
            return;
        }
        Properties m_ctx = Env.getCtx();
        int ToolBarButton_ID = 0;
        int[] nArray = restrictionList = AD_Window_ID > 0 ? MToolBarButtonRestrict.getOfWindow((Properties)m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)AD_Window_ID, (boolean)true, null) : MToolBarButtonRestrict.getOfReport((Properties)m_ctx, (int)MRole.getDefault().getAD_Role_ID(), (int)AD_Process_ID, null);
        if (log.isLoggable(Level.INFO)) {
            log.info("restrictionList=" + restrictionList.toString());
        }
        int i = 0;
        while (i < restrictionList.length) {
            ToolBarButton_ID = restrictionList[i];
            X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(m_ctx, ToolBarButton_ID, null);
            if ("R".equals(tbt.getAction())) {
                String restrictName = tbt.getComponentName();
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("tbt=" + tbt.getAD_ToolBarButton_ID() + " / " + restrictName);
                }
                Component p2 = this.toolBar.getFirstChild();
                while (p2 != null) {
                    if (p2 instanceof Toolbarbutton && restrictName.equals(((ToolBarButton)p2).getName())) {
                        this.toolBar.removeChild(p2);
                        break;
                    }
                    p2 = p2.getNextSibling();
                }
            }
            ++i;
        }
        this.ToolBarMenuRestictionLoaded = true;
    }

    private void showBusyDialog() {
        this.progressWindow = new BusyDialog();
        this.progressWindow.setStyle("position: absolute;");
        this.appendChild((Component)this.progressWindow);
        this.showBusyMask(this.progressWindow);
        LayoutUtils.openOverlappedWindow((Component)this, this.progressWindow, "middle_center");
    }

    private Div getMask() {
        if (this.mask == null) {
            this.mask = new Mask();
        }
        return this.mask;
    }

    private void showBusyMask(Window window) {
        this.getParent().appendChild((Component)this.getMask());
        StringBuilder script = new StringBuilder("var w=zk.Widget.$('#");
        script.append(this.getParent().getUuid()).append("');");
        if (window != null) {
            script.append("var d=zk.Widget.$('#").append(window.getUuid()).append("');w.busy=d;");
        } else {
            script.append("w.busy=true;");
        }
        Clients.response((AuResponse)new AuScript(script.toString()));
    }

    public void hideBusyMask() {
        if (this.mask != null && this.mask.getParent() != null) {
            this.mask.detach();
            StringBuilder script = new StringBuilder("var w=zk.Widget.$('#");
            script.append(this.getParent().getUuid()).append("');w.busy=false;");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    private void hideBusyDialog() {
        this.hideBusyMask();
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)ZkReportViewer.this);
        }

        public Media getMedia(String pathInfo) {
            return ZkReportViewer.this.media;
        }
    }

    static class HTMLRendererRunnable
    extends ContextRunnable
    implements IServerPushCallback {
        private ZkReportViewer viewer;
        private String contextPath;

        public HTMLRendererRunnable(ZkReportViewer viewer) {
            this.viewer = viewer;
            this.contextPath = Executions.getCurrent().getContextPath();
        }

        protected void doRun() {
            try {
                try {
                    if (!ArchiveEngine.isValid((LayoutEngine)this.viewer.m_reportEngine.getLayout())) {
                        log.warning("Cannot archive Document");
                    }
                    String path = System.getProperty("java.io.tmpdir");
                    String prefix = this.viewer.makePrefix(this.viewer.m_reportEngine.getName());
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                    }
                    File file = File.createTempFile(prefix, ".html", new File(path));
                    this.viewer.m_reportEngine.createHTML(file, false, this.viewer.m_reportEngine.getPrintFormat().getLanguage(), (IHTMLExtension)new HTMLExtension(this.contextPath, "rp", this.viewer.getUuid()));
                    this.viewer.media = new AMedia(file.getName(), "html", "text/html", file, false);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            finally {
                Desktop desktop = AEnv.getDesktop();
                if (desktop != null && desktop.isAlive()) {
                    new ServerPushTemplate(desktop).executeAsync(this);
                }
            }
        }

        @Override
        public void updateUI() {
            if (this.viewer.comboDrill.getItemCount() > 1) {
                this.viewer.labelDrill.setVisible(true);
                this.viewer.comboDrill.setVisible(true);
            }
            this.viewer.onPreviewReport();
        }
    }

    static class PDFRendererRunnable
    extends ContextRunnable
    implements IServerPushCallback {
        private ZkReportViewer viewer;

        public PDFRendererRunnable(ZkReportViewer viewer) {
            this.viewer = viewer;
        }

        protected void doRun() {
            try {
                try {
                    if (!ArchiveEngine.isValid((LayoutEngine)this.viewer.m_reportEngine.getLayout())) {
                        log.warning("Cannot archive Document");
                    }
                    String path = System.getProperty("java.io.tmpdir");
                    String prefix = this.viewer.makePrefix(this.viewer.m_reportEngine.getName());
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                    }
                    File file = File.createTempFile(prefix, ".pdf", new File(path));
                    this.viewer.m_reportEngine.createPDF(file);
                    this.viewer.media = new AMedia(file.getName(), "pdf", "application/pdf", file, true);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            finally {
                Desktop desktop = AEnv.getDesktop();
                if (desktop != null && desktop.isAlive()) {
                    new ServerPushTemplate(desktop).executeAsync(this);
                }
            }
        }

        @Override
        public void updateUI() {
            this.viewer.labelDrill.setVisible(false);
            this.viewer.comboDrill.setVisible(false);
            this.viewer.onPreviewReport();
        }
    }

    static class XLSRendererRunnable
    extends ContextRunnable
    implements IServerPushCallback {
        private ZkReportViewer viewer;

        public XLSRendererRunnable(ZkReportViewer viewer) {
            this.viewer = viewer;
        }

        protected void doRun() {
            try {
                try {
                    if (!ArchiveEngine.isValid((LayoutEngine)this.viewer.m_reportEngine.getLayout())) {
                        log.warning("Cannot archive Document");
                    }
                    String path = System.getProperty("java.io.tmpdir");
                    String prefix = this.viewer.makePrefix(this.viewer.m_reportEngine.getName());
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                    }
                    File file = File.createTempFile(prefix, ".xls", new File(path));
                    this.viewer.m_reportEngine.createXLS(file, this.viewer.m_reportEngine.getPrintFormat().getLanguage());
                    this.viewer.media = new AMedia(file.getName(), "xls", "application/vnd.ms-excel", file, true);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            finally {
                Desktop desktop = AEnv.getDesktop();
                if (desktop != null && desktop.isAlive()) {
                    new ServerPushTemplate(desktop).executeAsync(this);
                }
            }
        }

        @Override
        public void updateUI() {
            this.viewer.labelDrill.setVisible(false);
            this.viewer.comboDrill.setVisible(false);
            this.viewer.onPreviewReport();
        }
    }
}

