/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.WEMailDialog;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.impl.Utils;

public class ZkJRViewer
extends Window
implements EventListener<Event>,
ITabOnCloseHandler {
    private static final long serialVersionUID = -7047317766671393738L;
    private JasperPrint jasperPrint;
    private List<JasperPrint> jasperPrintList;
    private boolean isList;
    private Listbox previewType = new Listbox();
    private Iframe iframe;
    private AMedia media;
    private String defaultType;
    private ToolBarButton bSendMail = new ToolBarButton();
    private File attachment = null;
    private static CLogger log = CLogger.getCLogger(ZkJRViewer.class);
    private int m_WindowNo = -1;
    private long prevKeyEventTime = 0L;
    private KeyEvent prevKeyEvent;
    private String m_title;
    private int mediaVersion = 0;

    public ZkJRViewer(JasperPrint jasperPrint, String title) {
        this.setTitle(title);
        this.m_title = title;
        this.jasperPrint = jasperPrint;
        this.isList = false;
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        this.init();
    }

    public ZkJRViewer(List<JasperPrint> jasperPrintList, String title) {
        this.setTitle(title);
        this.m_title = title;
        this.jasperPrintList = jasperPrintList;
        this.isList = true;
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        this.init();
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        try {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        boolean isCanExport = MRole.getDefault().isCanExport();
        this.defaultType = MSysConfig.getValue((String)"ZK_REPORT_JASPER_OUTPUT_TYPE", (String)"PDF", (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        Borderlayout layout = new Borderlayout();
        layout.setStyle("position: absolute; height: 99%; width: 99%");
        this.appendChild((Component)layout);
        this.setStyle("width: 100%; height: 100%; position: absolute");
        Toolbar toolbar = new Toolbar();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)toolbar, "32px");
        this.previewType.setMold("select");
        this.attachment = null;
        if (isCanExport) {
            this.previewType.appendItem("PDF", "PDF");
            this.previewType.appendItem("HTML", "HTML");
            this.previewType.appendItem("Excel", "XLS");
            this.previewType.appendItem("CSV", "CSV");
            this.previewType.appendItem("SSV", "SSV");
            if ("PDF".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if ("HTML".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(1);
            } else if ("XLS".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(2);
            } else if ("CSV".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(3);
            } else if ("SSV".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(4);
            } else {
                this.previewType.setSelectedIndex(0);
                log.info("Format not Valid: " + this.defaultType);
            }
        } else {
            this.previewType.appendItem("PDF", "PDF");
            this.previewType.appendItem("HTML", "HTML");
            if ("PDF".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if ("HTML".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(1);
            } else if ("XLS".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if ("CSV".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else if ("SSV".equals(this.defaultType)) {
                this.previewType.setSelectedIndex(0);
            } else {
                this.previewType.setSelectedIndex(0);
                log.info("Format not Valid: " + this.defaultType);
            }
        }
        toolbar.appendChild((Component)this.previewType);
        this.previewType.addEventListener("onSelect", this);
        toolbar.appendChild((Component)new Separator("vertical"));
        this.bSendMail.setName("SendMail");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSendMail.setIconSclass("z-icon-SendMail");
        } else {
            this.bSendMail.setImage(ThemeManager.getThemeResource("images/SendMail24.png"));
        }
        this.bSendMail.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail")));
        toolbar.appendChild((Component)this.bSendMail);
        this.bSendMail.addEventListener("onClick", this);
        North north = new North();
        layout.appendChild((Component)north);
        north.appendChild((Component)toolbar);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        Center center = new Center();
        layout.appendChild((Component)center);
        this.iframe = new Iframe();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.iframe, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.iframe, "true");
        this.iframe.setId("reportFrame");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.iframe, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.iframe, "100%");
        try {
            this.renderReport();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            throw new AdempiereException("Failed to render report.", (Throwable)e);
        }
        center.appendChild((Component)this.iframe);
        this.setBorder("normal");
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuilder prefix = new StringBuilder();
        char[] cArray = nameArray = name.toCharArray();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
            } else {
                prefix.append("_");
            }
            ++n2;
        }
        return prefix.toString();
    }

    public void actionPerformed(Event e) {
        if (e.getTarget() == this.previewType) {
            this.cmd_render();
        } else if (e.getTarget() == this.bSendMail) {
            this.cmd_sendMail();
        }
    }

    private void cmd_render() {
        try {
            this.renderReport();
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to render report", (Throwable)e);
        }
    }

    private void cmd_sendMail() {
        if (this.attachment == null) {
            try {
                this.attachment = this.getPDF();
            }
            catch (Exception e) {
                FDialog.error(this.m_WindowNo, (Component)this, e.getLocalizedMessage(), this.m_title);
                return;
            }
        }
        String to = "";
        MUser from = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
        String subject = this.m_title;
        WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"SendMail"), from, to, subject, "", (DataSource)new FileDataSource(this.attachment));
        AEnv.showWindow(dialog);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onClick") || event.getName().equals("onSelect")) {
            this.actionPerformed(event);
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                long time = System.currentTimeMillis();
                if (this.prevKeyEvent != null && this.prevKeyEventTime > 0L && this.prevKeyEvent.getKeyCode() == keyEvent.getKeyCode() && this.prevKeyEvent.getTarget() == keyEvent.getTarget() && this.prevKeyEvent.isAltKey() == keyEvent.isAltKey() && this.prevKeyEvent.isCtrlKey() == keyEvent.isCtrlKey() && this.prevKeyEvent.isShiftKey() == keyEvent.isShiftKey() && time - this.prevKeyEventTime <= 300L) {
                    return;
                }
                this.onCtrlKeyEvent(keyEvent);
            }
        }
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 && this.m_WindowNo > 0) {
            this.prevKeyEventTime = System.currentTimeMillis();
            this.prevKeyEvent = keyEvent;
            keyEvent.stopPropagation();
            SessionManager.getAppDesktop().closeWindow(this.m_WindowNo);
        }
    }

    private void renderReport() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JasperReport.class.getClassLoader());
            ListItem selected = this.previewType.getSelectedItem();
            String reportType = (String)selected.getValue();
            if ("PDF".equals(reportType)) {
                this.attachment = this.getPDF();
                this.media = new AMedia(String.valueOf(this.m_title) + ".pdf", "pdf", "application/pdf", this.attachment, true);
            } else if ("HTML".equals(reportType)) {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".html", new File(path));
                HtmlExporter exporter = new HtmlExporter();
                SimpleHtmlReportConfiguration htmlConfig = new SimpleHtmlReportConfiguration();
                htmlConfig.setEmbedImage(Boolean.valueOf(true));
                htmlConfig.setAccessibleHtml(Boolean.valueOf(true));
                if (!this.isList) {
                    this.jasperPrintList = new ArrayList<JasperPrint>();
                    this.jasperPrintList.add(this.jasperPrint);
                }
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporter.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput(file));
                exporter.setConfiguration((ReportExportConfiguration)htmlConfig);
                exporter.exportReport();
                this.media = new AMedia(this.m_title, "html", "text/html", file, false);
            } else if ("XLS".equals(reportType)) {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".xls", new File(path));
                FileOutputStream fos = new FileOutputStream(file);
                JRXlsExporter exporterXLS = new JRXlsExporter();
                SimpleXlsReportConfiguration xlsConfig = new SimpleXlsReportConfiguration();
                xlsConfig.setOnePagePerSheet(Boolean.valueOf(false));
                if (!this.isList) {
                    this.jasperPrintList = new ArrayList<JasperPrint>();
                    this.jasperPrintList.add(this.jasperPrint);
                }
                exporterXLS.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporterXLS.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)fos));
                exporterXLS.setConfiguration((ReportExportConfiguration)xlsConfig);
                exporterXLS.exportReport();
                this.media = new AMedia(String.valueOf(this.m_title) + ".xls", "xls", "application/vnd.ms-excel", file, true);
            } else if ("CSV".equals(reportType)) {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".csv", new File(path));
                FileOutputStream fos = new FileOutputStream(file);
                JRCsvExporter exporter = new JRCsvExporter();
                if (!this.isList) {
                    this.jasperPrintList = new ArrayList<JasperPrint>();
                    this.jasperPrintList.add(this.jasperPrint);
                }
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)fos));
                exporter.exportReport();
                this.media = new AMedia(String.valueOf(this.m_title) + ".csv", "csv", "application/csv", file, true);
            } else if ("SSV".equals(reportType)) {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = null;
                prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                File file = File.createTempFile(prefix, ".ssv", new File(path));
                FileOutputStream fos = new FileOutputStream(file);
                JRCsvExporter exporter = new JRCsvExporter();
                SimpleCsvExporterConfiguration csvConfig = new SimpleCsvExporterConfiguration();
                csvConfig.setFieldDelimiter(";");
                if (!this.isList) {
                    this.jasperPrintList = new ArrayList<JasperPrint>();
                    this.jasperPrintList.add(this.jasperPrint);
                }
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)fos));
                exporter.setConfiguration((ExporterConfiguration)csvConfig);
                exporter.exportReport();
                this.media = new AMedia(this.m_title, "ssv", "application/ssv", file, true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.iframe.setSrc(null);
        Events.echoEvent((String)"onRenderReport", (Component)this, null);
    }

    private File getPDF() throws IOException, JRException {
        String path = System.getProperty("java.io.tmpdir");
        String prefix = null;
        prefix = this.isList ? String.valueOf(this.makePrefix(this.jasperPrintList.get(0).getName())) + "_List" : this.makePrefix(this.jasperPrint.getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
        }
        File file = new File(FileUtil.getTempMailName((String)prefix, (String)".pdf"));
        SimpleJasperReportsContext context = new SimpleJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        JRPdfExporter exporter = new JRPdfExporter((JasperReportsContext)context);
        if (!this.isList) {
            this.jasperPrintList = new ArrayList<JasperPrint>();
            this.jasperPrintList.add(this.jasperPrint);
        }
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
        exporter.exportReport();
        return file;
    }

    public void onRenderReport() {
        ListItem selected;
        String reportType;
        if (ClientInfo.isMobile() && "PDF".equals(reportType = (String)(selected = this.previewType.getSelectedItem()).getValue())) {
            ++this.mediaVersion;
            String url = Utils.getDynamicMediaURI((AbstractComponent)this, (int)this.mediaVersion, (String)this.media.getName(), (String)this.media.getFormat());
            String pdfJsUrl = "pdf.js/web/viewer.html?file=" + url;
            this.iframe.setContent(null);
            this.iframe.setSrc(pdfJsUrl);
            return;
        }
        this.iframe.setSrc(null);
        this.iframe.setContent((Media)this.media);
    }

    @Override
    public void onClose(Tabpanel tabPanel) {
        Tab tab = tabPanel.getLinkedTab();
        tab.close();
        this.cleanUp();
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent != null && parent instanceof Tabpanel) {
            Tabpanel tabPanel = (Tabpanel)parent;
            tabPanel.setOnCloseHandler(this);
        }
    }

    private void cleanUp() {
        if (this.jasperPrint != null || this.m_WindowNo >= 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.m_WindowNo);
            this.jasperPrint = null;
            this.m_WindowNo = -1;
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)ZkJRViewer.this);
        }

        public Media getMedia(String pathInfo) {
            return ZkJRViewer.this.media;
        }
    }
}

