/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.editor.WYesNoEditor;
import org.adempiere.webui.grid.WQuickEntry;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WGadgets;
import org.compiere.model.MRole;
import org.compiere.model.MUserPreference;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.A;
import org.zkoss.zul.Div;
import org.zkoss.zul.Window;

public class WPreference
extends WQuickEntry
implements EventListener<Event> {
    private static final long serialVersionUID = -8223456746437563389L;
    private static CLogger log = CLogger.getCLogger(WPreference.class);
    private WYesNoEditor adempiereSys;
    private WYesNoEditor logMigrationScript;
    private WGadgets gadgets;
    private A addgadgets;
    private A morePreferences;
    private MUserPreference preferences = null;
    private int recordId = 0;

    public WPreference() {
        super(Env.getZoomWindowID((int)200174, (int)0));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        Boolean canAccessPreference = MRole.getDefault().getWindowAccess(this.m_AD_Window_ID);
        if (canAccessPreference != null && canAccessPreference.booleanValue()) {
            this.initPOs();
            this.loadPreferences();
        }
        this.setTitle("");
    }

    private void loadPreferences() {
        this.preferences = MUserPreference.getUserPreference((int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.recordId = this.preferences.get_ID();
        this.loadRecord(this.recordId);
    }

    protected void jbInit() throws Exception {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "230px");
        this.setBorder("normal");
        this.setClosable(true);
        this.setSizable(true);
        this.appendChild((Component)this.centerPanel);
        this.init();
    }

    private void init() {
        Div div = new Div();
        div.setStyle("background-color: transparent !important; border: none; margin: 5px;");
        this.morePreferences = new A();
        this.morePreferences.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"MorePreferences"));
        this.morePreferences.addEventListener("onClick", (EventListener)this);
        div.appendChild((Component)this.morePreferences);
        this.appendChild((Component)div);
        if (Env.getAD_Client_ID((Properties)Env.getCtx()) <= 20 && Env.getAD_User_ID((Properties)Env.getCtx()) <= 102) {
            this.adempiereSys = new WYesNoEditor("AdempiereSys", Msg.getMsg((Properties)Env.getCtx(), (String)"AdempiereSys", (boolean)true), null, false, false, true);
            this.adempiereSys.getComponent().setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AdempiereSys", (boolean)false));
            div = new Div();
            div.setStyle("background-color: transparent !important; border: none; margin: 5px;");
            div.appendChild((Component)this.adempiereSys.getComponent());
            this.appendChild((Component)div);
            this.adempiereSys.setValue(Env.getCtx().getProperty("AdempiereSys"));
            this.logMigrationScript = new WYesNoEditor("LogMigrationScript", Msg.getMsg((Properties)Env.getCtx(), (String)"LogMigrationScript", (boolean)true), null, false, false, true);
            this.logMigrationScript.getComponent().setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"LogMigrationScript", (boolean)false));
            div = new Div();
            div.setStyle("background-color: transparent !important; border: none; margin: 5px;");
            div.appendChild((Component)this.logMigrationScript.getComponent());
            this.appendChild((Component)div);
            this.logMigrationScript.setValue(Env.getCtx().getProperty("LogMigrationScript"));
        }
        ToolBar toolbar = new ToolBar();
        toolbar.setAlign("end");
        this.appendChild((Component)toolbar);
        ToolBarButton btn = new ToolBarButton("");
        btn.setName("btnSave");
        if (ThemeManager.isUseFontIconForImage()) {
            btn.setIconSclass("z-icon-Save");
        } else {
            btn.setImage(ThemeManager.getThemeResource("images/Save24.png"));
        }
        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Save"));
        btn.addEventListener("onClick", this);
        toolbar.appendChild((Component)btn);
        toolbar.setStyle("border: none");
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("large-toolbarbutton", (HtmlBasedComponent)btn);
        }
        div = new Div();
        div.setStyle("background-color: transparent !important; border: none; margin: 5px;");
        this.addgadgets = new A();
        this.addgadgets.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"ManageGadgets"));
        this.addgadgets.addEventListener("onClick", (EventListener)this);
        div.appendChild((Component)this.addgadgets);
        this.appendChild((Component)div);
    }

    @Override
    public void onEvent(Event event) throws Exception {
        String nameEvent = event.getName();
        Component com = event.getTarget();
        if ("onClick".equals(nameEvent)) {
            if (com instanceof ToolBarButton) {
                this.onSave();
            }
            if (com == this.addgadgets) {
                this.gadgets = new WGadgets();
                this.gadgets.setClosable(true);
                this.gadgets.setSizable(true);
                if (ClientInfo.maxWidth(699)) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gadgets, "90%");
                } else if (ClientInfo.maxWidth(999)) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gadgets, "70%");
                } else {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gadgets, "50%");
                }
                if (ClientInfo.maxHeight(699)) {
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)this.gadgets, "80%");
                } else {
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)this.gadgets, "60%");
                }
                this.gadgets.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"DashboardGadgets"));
                this.gadgets.setAttribute("mode", Window.Mode.HIGHLIGHTED);
                AEnv.showWindow(this.gadgets);
                this.gadgets.focus();
            }
            if (com == this.morePreferences) {
                AEnv.zoom(200174, this.recordId);
            }
        }
    }

    private void onSave() {
        this.actionSave();
        if (this.logMigrationScript != null) {
            Env.getCtx().setProperty("LogMigrationScript", (Boolean)this.logMigrationScript.getValue() != false ? "Y" : "N");
        }
        if (this.adempiereSys != null) {
            Env.getCtx().setProperty("AdempiereSys", (Boolean)this.adempiereSys.getValue() != false ? "Y" : "N");
        }
        this.detach();
    }
}

