/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class WPAttributeInstance
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -4052029122256207113L;
    private Borderlayout mainLayout = new Borderlayout();
    private Panel northPanel = new Panel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Checkbox showAll = new Checkbox();
    private WListbox m_table = new WListbox();
    private int m_M_Warehouse_ID;
    private int m_M_Locator_ID;
    private int m_M_Product_ID;
    private int m_M_AttributeSetInstance_ID = -1;
    private String m_M_AttributeSetInstanceName = null;
    private String m_sql;
    private static CLogger log = CLogger.getCLogger(WPAttributeInstance.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "s.M_AttributeSetInstance_ID", IDColumn.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Description"), "asi.Description", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Lot"), "asi.Lot", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"SerNo"), "asi.SerNo", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate"), "asi.GuaranteeDate", Timestamp.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"), "l.Value", KeyNamePair.class, "s.M_Locator_ID"), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "s.QtyOnHand", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "s.QtyReserved", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"), "s.QtyOrdered", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"GoodForDays"), "(daysbetween(asi.GuaranteeDate, SYSDATE))-p.GuaranteeDaysMin", Integer.class, true, true, null), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"ShelfLifeDays"), "daysbetween(asi.GuaranteeDate, SYSDATE)", Integer.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"ShelfLifeRemainingPct"), "CASE WHEN p.GuaranteeDays > 0 THEN TRUNC(((daysbetween(asi.GuaranteeDate, SYSDATE))/p.GuaranteeDays)*100) ELSE 0 END", Integer.class)};
    private static String s_sqlFrom = "M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)";
    private static String s_sqlWhere = "s.M_Product_ID=? AND l.M_Warehouse_ID=?";
    private static String s_sqlWhereWithoutWarehouse = " s.M_Product_ID=?";
    private String m_sqlNonZero = " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
    private String m_sqlMinLife = "";

    public WPAttributeInstance(String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        this.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"PAttributeInstance")) + title);
        this.setBorder("normal");
        this.setSizable(true);
        this.setMaximizable(true);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 1000);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 550);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setSclass("pattribute-instance-dialog");
        this.init(M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
        AEnv.showCenterScreen(this);
    }

    private void init(int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        log.info("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID);
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_Locator_ID = M_Locator_ID;
        this.m_M_Product_ID = M_Product_ID;
        try {
            this.init();
            this.dynInit(C_BPartner_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void init() throws Exception {
        this.showAll.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ShowAll"));
        this.appendChild((Component)this.mainLayout);
        Hbox box = new Hbox();
        box.setParent((Component)this.northPanel);
        box.setPack("end");
        box.appendChild((Component)this.showAll);
        this.showAll.addEventListener("onCheck", this);
        North north = new North();
        north.setParent((Component)this.mainLayout);
        north.appendChild((Component)this.northPanel);
        Center center = new Center();
        center.setParent((Component)this.mainLayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_table, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.m_table, "true");
        center.appendChild((Component)this.m_table);
        South south = new South();
        south.setParent((Component)this.mainLayout);
        south.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
    }

    private void dynInit(int C_BPartner_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_BPartner_ID=" + C_BPartner_ID);
        }
        if (C_BPartner_ID != 0) {
            int ShelfLifeMinDays;
            int ShelfLifeMinPct;
            block13: {
                ShelfLifeMinPct = 0;
                ShelfLifeMinDays = 0;
                String sql = "SELECT bp.ShelfLifeMinPct, bpp.ShelfLifeMinPct, bpp.ShelfLifeMinDays FROM C_BPartner bp  LEFT OUTER JOIN C_BPartner_Product bpp ON (bp.C_BPartner_ID=bpp.C_BPartner_ID AND bpp.M_Product_ID=?) WHERE bp.C_BPartner_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, this.m_M_Product_ID);
                        pstmt.setInt(2, C_BPartner_ID);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            ShelfLifeMinPct = rs.getInt(1);
                            int pct = rs.getInt(2);
                            if (pct > 0) {
                                ShelfLifeMinDays = pct;
                            }
                            ShelfLifeMinDays = rs.getInt(3);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            if (ShelfLifeMinPct > 0) {
                this.m_sqlMinLife = " AND COALESCE(TRUNC(((daysbetween(asi.GuaranteeDate, SYSDATE))/p.GuaranteeDays)*100),0)>=" + ShelfLifeMinPct;
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("PAttributeInstance.dynInit - ShelfLifeMinPct=" + ShelfLifeMinPct);
                }
            }
            if (ShelfLifeMinDays > 0) {
                this.m_sqlMinLife = String.valueOf(this.m_sqlMinLife) + " AND COALESCE((daysbetween(asi.GuaranteeDate, SYSDATE)),0)>=" + ShelfLifeMinDays;
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("PAttributeInstance.dynInit - ShelfLifeMinDays=" + ShelfLifeMinDays);
                }
            }
        }
        this.m_sql = String.valueOf(this.m_table.prepareTable(s_layout, s_sqlFrom, this.m_M_Warehouse_ID == 0 ? s_sqlWhereWithoutWarehouse : s_sqlWhere, false, "s")) + " ORDER BY asi.GuaranteeDate, s.QtyOnHand";
        this.m_table.addEventListener("onSelect", this);
        this.refresh();
    }

    private void refresh() {
        block8: {
            String sql = this.m_sql;
            int pos = this.m_sql.lastIndexOf(" ORDER BY ");
            if (!this.showAll.isChecked()) {
                sql = String.valueOf(this.m_sql.substring(0, pos)) + this.m_sqlNonZero;
                if (this.m_sqlMinLife.length() > 0) {
                    sql = String.valueOf(sql) + this.m_sqlMinLife;
                }
                sql = String.valueOf(sql) + this.m_sql.substring(pos);
            }
            log.finest(sql);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    if (this.m_M_Warehouse_ID != 0) {
                        pstmt.setInt(2, this.m_M_Warehouse_ID);
                    }
                    rs = pstmt.executeQuery();
                    this.m_table.loadTable(rs);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.enableButtons();
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget().getId().equals("Ok")) {
            this.detach();
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.detach();
            this.m_M_AttributeSetInstance_ID = -1;
            this.m_M_AttributeSetInstanceName = null;
        } else if (e.getTarget() == this.showAll) {
            this.refresh();
        } else if (e.getTarget() == this.m_table) {
            this.enableButtons();
        }
    }

    private void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_M_AttributeSetInstance_ID = -1;
        this.m_M_AttributeSetInstanceName = null;
        this.m_M_Locator_ID = 0;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_M_AttributeSetInstance_ID = ID;
            this.m_M_AttributeSetInstanceName = (String)this.m_table.getValueAt(row, 1);
            Object oo = this.m_table.getValueAt(row, 5);
            if (oo instanceof KeyNamePair) {
                KeyNamePair pp = (KeyNamePair)oo;
                this.m_M_Locator_ID = pp.getKey();
            }
        }
        this.confirmPanel.getButton("Ok").setEnabled(enabled);
        if (log.isLoggable(Level.FINE)) {
            log.fine("M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID + " - " + this.m_M_AttributeSetInstanceName + "; M_Locator_ID=" + this.m_M_Locator_ID);
        }
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }

    public int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }
}

