/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.WPAttributeInstance;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MDocType;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.impl.InputElement;

public class WPAttributeDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -7810825026970615029L;
    private int m_WindowNo;
    private MAttributeSetInstance m_masi;
    private int m_M_AttributeSetInstance_ID;
    private int m_M_Locator_ID;
    private String m_M_AttributeSetInstanceName;
    private int m_M_Product_ID;
    private int m_C_BPartner_ID;
    private int m_AD_Column_ID;
    private int m_WindowNoParent;
    private boolean m_productWindow = false;
    private boolean m_changed = false;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_row = 0;
    private ArrayList<HtmlBasedComponent> m_editors = new ArrayList();
    private Checkbox cbNewEdit = new Checkbox();
    private Button bNewRecord = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"NewRecord"));
    private Listbox existingCombo = new Listbox();
    private Button bSelect = new Button();
    private Textbox fieldLotString = new Textbox();
    private Listbox fieldLot = new Listbox();
    private Button bLot = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"New"));
    Menupopup popupMenu = new Menupopup();
    private Menuitem mZoom;
    private Textbox fieldSerNo = new Textbox();
    private Button bSerNo = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"New"));
    private Datebox fieldGuaranteeDate = new Datebox();
    private Textbox fieldDescription = new Textbox();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel centerPanel = new Panel();
    private Grid centerLayout = new Grid();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private String m_columnName = null;

    public WPAttributeDialog(int M_AttributeSetInstance_ID, int M_Product_ID, int C_BPartner_ID, boolean productWindow, int AD_Column_ID, int WindowNo) {
        this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        }
        this.setSclass("popup-dialog pattribute-dialog");
        this.setBorder("normal");
        this.setShadow(true);
        this.setSizable(true);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", M_Product_ID=" + M_Product_ID + ", C_BPartner_ID=" + C_BPartner_ID + ", ProductW=" + productWindow + ", Column=" + AD_Column_ID);
        }
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
        this.m_M_Product_ID = M_Product_ID;
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.m_productWindow = productWindow;
        this.m_AD_Column_ID = AD_Column_ID;
        this.m_WindowNoParent = WindowNo;
        this.m_columnName = DB.getSQLValueString(null, (String)"SELECT ColumnName FROM AD_Column WHERE AD_Column_ID = ?", (int)this.m_AD_Column_ID);
        if (this.m_columnName == null || this.m_columnName.trim().length() == 0) {
            this.m_columnName = "M_AttributeSetInstance_ID";
        }
        try {
            this.init();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "VPAttributeDialog" + ex);
        }
        if (!this.initAttributes()) {
            this.dispose();
            return;
        }
        AEnv.showCenterScreen(this);
    }

    private void init() throws Exception {
        this.mainLayout.setParent((Component)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mainLayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.mainLayout, "min");
        Center center = new Center();
        center.setSclass("dialog-content");
        center.setParent((Component)this.mainLayout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerPanel, "min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerPanel, "min");
        center.appendChild((Component)this.centerPanel);
        South south = new South();
        south.setSclass("dialog-footer");
        south.setParent((Component)this.mainLayout);
        south.appendChild((Component)this.confirmPanel);
        this.centerPanel.appendChild((Component)this.centerLayout);
        this.centerLayout.setOddRowSclass("even");
        this.confirmPanel.addActionListener("onClick", this);
    }

    private boolean initAttributes() {
        Label label;
        Row row;
        Columns columns = new Columns();
        columns.setParent((Component)this.centerLayout);
        Column column = new Column();
        column.setParent((Component)columns);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        column = new Column();
        column.setParent((Component)columns);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "70%");
        Rows rows = new Rows();
        rows.setParent((Component)this.centerLayout);
        if (this.m_M_Product_ID == 0 && !this.m_productWindow) {
            return false;
        }
        MAttributeSet as = null;
        int M_AttributeSet_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"M_AttributeSet_ID");
        if (this.m_M_Product_ID != 0 && M_AttributeSet_ID == 0) {
            this.m_masi = MAttributeSetInstance.get((Properties)Env.getCtx(), (int)this.m_M_AttributeSetInstance_ID, (int)this.m_M_Product_ID);
            if (this.m_masi == null) {
                this.log.severe("No Model for M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID + ", M_Product_ID=" + this.m_M_Product_ID);
                return false;
            }
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_AttributeSet_ID", (int)this.m_masi.getM_AttributeSet_ID());
            as = this.m_masi.getMAttributeSet();
        } else {
            this.m_masi = new MAttributeSetInstance(Env.getCtx(), this.m_M_AttributeSetInstance_ID, M_AttributeSet_ID, null);
            as = this.m_masi.getMAttributeSet();
        }
        if (as == null) {
            FDialog.error(this.m_WindowNo, (Component)this, "PAttributeNoAttributeSet");
            return false;
        }
        if (!this.m_productWindow && !as.isInstanceAttribute()) {
            FDialog.error(this.m_WindowNo, (Component)this, "PAttributeNoInstanceAttribute");
            return false;
        }
        if (this.m_productWindow) {
            KeyNamePair[] keyNamePairs;
            row = new Row();
            row.setParent((Component)rows);
            this.cbNewEdit.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord"));
            this.cbNewEdit.addEventListener("onCheck", this);
            row.appendChild((Component)this.cbNewEdit);
            String sql = "SELECT M_AttributeSetInstance_ID, Description FROM M_AttributeSetInstance WHERE M_AttributeSet_ID = " + as.getM_AttributeSet_ID() + " AND EXISTS (" + " SELECT 1 FROM M_AttributeInstance INNER JOIN M_Attribute" + " ON (M_AttributeInstance.M_Attribute_ID = M_Attribute.M_Attribute_ID)" + " WHERE M_AttributeInstance.M_AttributeSetInstance_ID = M_AttributeSetInstance.M_AttributeSetInstance_ID" + " AND M_Attribute.IsInstanceAttribute = 'N')";
            this.existingCombo.setMold("select");
            KeyNamePair[] keyNamePairArray = keyNamePairs = DB.getKeyNamePairs((String)sql, (boolean)true);
            int n = keyNamePairs.length;
            int n2 = 0;
            while (n2 < n) {
                KeyNamePair pair = keyNamePairArray[n2];
                this.existingCombo.appendItem(pair.getName(), pair.getKey());
                ++n2;
            }
            this.existingCombo.addActionListener(this);
            row.appendChild((Component)this.existingCombo);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.existingCombo, "1");
            row = new Row();
            row.setParent((Component)rows);
            LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bNewRecord);
            this.bNewRecord.addActionListener(this);
            row.appendChild((Component)this.bNewRecord);
            row.appendChild((Component)new Space());
            MAttribute[] attributes = as.getMAttributes(false);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Product Attributes=" + attributes.length);
            }
            int i = 0;
            while (i < attributes.length) {
                this.addAttributeLine(rows, attributes[i], true, false);
                ++i;
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                i = 0;
                while (i < this.existingCombo.getItemCount()) {
                    ListItem pp = this.existingCombo.getItemAtIndex(i);
                    if (pp.getValue() != null && (Integer)pp.getValue() == this.m_M_AttributeSetInstance_ID) {
                        this.existingCombo.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            row = new Row();
            if (this.m_M_AttributeSetInstance_ID == 0) {
                this.cbNewEdit.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"NewRecord"));
            } else {
                this.cbNewEdit.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord"));
            }
            this.cbNewEdit.addEventListener("onCheck", this);
            row.appendChild((Component)this.cbNewEdit);
            this.bSelect.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectExisting"));
            this.bSelect.setImage(ThemeManager.getThemeResource("images/PAttribute16.png"));
            this.bSelect.addEventListener("onClick", this);
            row.appendChild((Component)this.bSelect);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bSelect, "1");
            rows.appendChild((Component)row);
            MAttribute[] attributes = as.getMAttributes(true);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Instance Attributes=" + attributes.length);
            }
            int i = 0;
            while (i < attributes.length) {
                this.addAttributeLine(rows, attributes[i], false, false);
                ++i;
            }
        }
        if (!this.m_productWindow && as.isLot()) {
            KeyNamePair[] keyNamePairs;
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Lot"));
            row.appendChild((Component)label);
            row.appendChild((Component)this.fieldLotString);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldLotString, "1");
            this.fieldLotString.setText(this.m_masi.getLot());
            String sql = "SELECT M_Lot_ID, Name FROM M_Lot l WHERE EXISTS (SELECT M_Product_ID FROM M_Product p WHERE p.M_AttributeSet_ID=" + this.m_masi.getM_AttributeSet_ID() + " AND p.M_Product_ID=l.M_Product_ID)";
            this.fieldLot = new Listbox();
            this.fieldLot.setMold("select");
            KeyNamePair[] keyNamePairArray = keyNamePairs = DB.getKeyNamePairs((String)sql, (boolean)true);
            int n = keyNamePairs.length;
            int pp = 0;
            while (pp < n) {
                KeyNamePair pair = keyNamePairArray[pp];
                this.fieldLot.appendItem(pair.getName(), pair.getKey());
                ++pp;
            }
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"M_Lot_ID"));
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            row.appendChild((Component)label);
            row.appendChild((Component)this.fieldLot);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldLot, "1");
            if (this.m_masi.getM_Lot_ID() != 0) {
                int i = 1;
                while (i < this.fieldLot.getItemCount()) {
                    ListItem pp2 = this.fieldLot.getItemAtIndex(i);
                    if (((Integer)pp2.getValue()).intValue() == this.m_masi.getM_Lot_ID()) {
                        this.fieldLot.setSelectedIndex(i);
                        this.fieldLotString.setReadonly(true);
                        break;
                    }
                    ++i;
                }
            }
            this.fieldLot.addEventListener("onSelect", this);
            if (this.m_masi.getMAttributeSet().getM_LotCtl_ID() != 0 && MRole.getDefault().isTableAccess(557, false) && MRole.getDefault().isTableAccess(556, false) && !this.m_masi.isExcludeLot(this.m_AD_Column_ID, Env.isSOTrx((Properties)Env.getCtx(), (int)this.m_WindowNoParent))) {
                row = new Row();
                row.setParent((Component)rows);
                ++this.m_row;
                row.appendChild((Component)this.bLot);
                this.bLot.addEventListener("onClick", this);
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bLot);
            }
            this.mZoom = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom"), ThemeManager.getThemeResource("images/Zoom16.png"));
            this.mZoom.addEventListener("onClick", (EventListener)this);
            this.popupMenu.appendChild((Component)this.mZoom);
            this.appendChild((Component)this.popupMenu);
        }
        if (!this.m_productWindow && as.isSerNo()) {
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"SerNo"));
            row.appendChild((Component)label);
            row.appendChild((Component)this.fieldSerNo);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldSerNo, "1");
            this.fieldSerNo.setText(this.m_masi.getSerNo());
            if (this.m_masi.getMAttributeSet().getM_SerNoCtl_ID() != 0 && MRole.getDefault().isTableAccess(555, false) && !this.m_masi.isExcludeSerNo(this.m_AD_Column_ID, Env.isSOTrx((Properties)Env.getCtx(), (int)this.m_WindowNoParent))) {
                row = new Row();
                row.setParent((Component)rows);
                ++this.m_row;
                row.appendChild((Component)this.bSerNo);
                this.bSerNo.addEventListener("onClick", this);
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bSerNo);
            }
        }
        if (!this.m_productWindow && as.isGuaranteeDate()) {
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate"));
            if (this.m_M_AttributeSetInstance_ID == 0) {
                this.fieldGuaranteeDate.setValue(this.m_masi.getGuaranteeDate(true));
            } else {
                this.fieldGuaranteeDate.setValue(this.m_masi.getGuaranteeDate());
            }
            row.appendChild((Component)label);
            row.appendChild((Component)this.fieldGuaranteeDate);
        }
        if (this.m_row == 0) {
            FDialog.error(this.m_WindowNo, (Component)this, "PAttributeNoInfo");
            return false;
        }
        if (!this.m_productWindow) {
            this.cbNewEdit.setChecked(this.m_M_AttributeSetInstance_ID == 0);
            this.cmd_newEdit();
        } else {
            this.cbNewEdit.setSelected(false);
            this.cbNewEdit.setEnabled(this.m_M_AttributeSetInstance_ID > 0);
            this.bNewRecord.setEnabled(this.m_M_AttributeSetInstance_ID > 0);
            boolean rw = this.m_M_AttributeSetInstance_ID == 0;
            int i = 0;
            while (i < this.m_editors.size()) {
                HtmlBasedComponent editor = this.m_editors.get(i);
                if (editor instanceof Listbox) {
                    ((Listbox)editor).setEnabled(rw);
                } else if (editor instanceof NumberBox) {
                    ((NumberBox)editor).setEnabled(rw);
                } else if (editor instanceof Datebox) {
                    ((Datebox)editor).setEnabled(rw);
                } else if (editor instanceof InputElement) {
                    ((InputElement)editor).setReadonly(!rw);
                }
                ++i;
            }
        }
        Label label2 = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        this.fieldDescription.setText(this.m_masi.getDescription());
        this.fieldDescription.setReadonly(true);
        Row row2 = new Row();
        row2.setParent((Component)rows);
        row2.appendChild((Component)label2);
        row2.appendChild((Component)this.fieldDescription);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldDescription, "1");
        return true;
    }

    private void addAttributeLine(Rows rows, MAttribute attribute, boolean product, boolean readOnly) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(attribute + ", Product=" + product + ", R/O=" + readOnly);
        }
        ++this.m_row;
        Label label = new Label(attribute.getName());
        if (product) {
            label.setStyle("font-weight: bold");
        }
        if (attribute.getDescription() != null) {
            label.setTooltiptext(attribute.getDescription());
        }
        Row row = rows.newRow();
        row.appendChild(label.rightAlign());
        if ("L".equals(attribute.getAttributeValueType())) {
            MAttributeValue[] values = attribute.getMAttributeValues();
            Listbox editor = new Listbox();
            editor.setMold("select");
            MAttributeValue[] mAttributeValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                MAttributeValue value = mAttributeValueArray[n2];
                ListItem item = new ListItem(value != null ? value.getName() : "", value);
                editor.appendChild((Component)item);
                ++n2;
            }
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.m_editors.add((HtmlBasedComponent)editor);
            }
            row.appendChild((Component)editor);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor, "1");
            this.setListAttribute(attribute, editor);
        } else if ("N".equals(attribute.getAttributeValueType())) {
            NumberBox editor = new NumberBox(false);
            this.setNumberAttribute(attribute, editor);
            row.appendChild((Component)editor);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor, "1");
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.m_editors.add((HtmlBasedComponent)editor);
            }
        } else if ("D".equals(attribute.getAttributeValueType())) {
            Datebox editor = new Datebox();
            this.setDateAttribute(attribute, editor);
            row.appendChild((Component)editor);
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.m_editors.add((HtmlBasedComponent)editor);
            }
        } else {
            Textbox editor = new Textbox();
            this.setStringAttribute(attribute, editor);
            row.appendChild((Component)editor);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)editor, "1");
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.m_editors.add((HtmlBasedComponent)editor);
            }
        }
    }

    private void updateAttributeEditor(MAttribute attribute, int index) {
        if ("L".equals(attribute.getAttributeValueType())) {
            Listbox editor = (Listbox)this.m_editors.get(index);
            this.setListAttribute(attribute, editor);
        } else if ("N".equals(attribute.getAttributeValueType())) {
            NumberBox editor = (NumberBox)this.m_editors.get(index);
            this.setNumberAttribute(attribute, editor);
        } else if ("D".equals(attribute.getAttributeValueType())) {
            Datebox editor = (Datebox)this.m_editors.get(index);
            this.setDateAttribute(attribute, editor);
        } else {
            Textbox editor = (Textbox)this.m_editors.get(index);
            this.setStringAttribute(attribute, editor);
        }
    }

    private void setStringAttribute(MAttribute attribute, Textbox editor) {
        MAttributeInstance instance = attribute.getMAttributeInstance(this.m_M_AttributeSetInstance_ID);
        if (instance != null) {
            editor.setText(instance.getValue());
        }
    }

    private void setNumberAttribute(MAttribute attribute, NumberBox editor) {
        MAttributeInstance instance = attribute.getMAttributeInstance(this.m_M_AttributeSetInstance_ID);
        if (instance != null) {
            editor.setValue(instance.getValueNumber());
        } else {
            editor.setValue(Env.ZERO);
        }
    }

    private void setDateAttribute(MAttribute attribute, Datebox editor) {
        MAttributeInstance instance = attribute.getMAttributeInstance(this.m_M_AttributeSetInstance_ID);
        if (instance != null) {
            editor.setValue(instance.getValueDate());
        } else {
            editor.setValue(null);
        }
    }

    private void setListAttribute(MAttribute attribute, Listbox editor) {
        boolean found = false;
        MAttributeInstance instance = attribute.getMAttributeInstance(this.m_M_AttributeSetInstance_ID);
        MAttributeValue[] values = attribute.getMAttributeValues();
        if (instance != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i] != null && values[i].getM_AttributeValue_ID() == instance.getM_AttributeValue_ID()) {
                    editor.setSelectedIndex(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Attribute=" + attribute.getName() + " #" + values.length + " - found: " + instance);
                }
            } else {
                this.log.warning("Attribute=" + attribute.getName() + " #" + values.length + " - NOT found: " + instance);
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Attribute=" + attribute.getName() + " #" + values.length + " no instance");
        }
    }

    @Override
    public void dispose() {
        Env.clearWinContext((int)this.m_WindowNo);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (int)1113, (String)this.m_columnName, (String)String.valueOf(this.m_M_AttributeSetInstance_ID));
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (int)1113, (String)"M_Locator_ID", (String)String.valueOf(this.m_M_Locator_ID));
        this.detach();
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget() == this.bSelect) {
            this.cmd_select();
        } else if (e.getTarget() == this.cbNewEdit) {
            if (this.m_productWindow) {
                this.cmd_edit();
            } else {
                this.cmd_newEdit();
            }
        } else if (e.getTarget() == this.bNewRecord) {
            this.cmd_newRecord();
        } else if (e.getTarget() == this.existingCombo) {
            this.cmd_existingCombo();
        } else if (e.getTarget() == this.fieldLot) {
            ListItem pp = this.fieldLot.getSelectedItem();
            if (pp != null && (Integer)pp.getValue() != -1) {
                this.fieldLotString.setText(pp.getLabel());
                this.fieldLotString.setReadonly(true);
                this.m_masi.setM_Lot_ID(((Integer)pp.getValue()).intValue());
            } else {
                this.fieldLotString.setReadonly(false);
                this.m_masi.setM_Lot_ID(0);
            }
        } else if (e.getTarget() == this.bLot) {
            KeyNamePair pp = this.m_masi.createLot(this.m_M_Product_ID);
            if (pp != null) {
                ListItem item = new ListItem(pp.getName(), pp.getKey());
                this.fieldLot.appendChild((Component)item);
                this.fieldLot.setSelectedItem(item);
                this.fieldLotString.setText(this.m_masi.getLot());
                this.fieldLotString.setReadonly(true);
            }
        } else if (e.getTarget() == this.bSerNo) {
            this.fieldSerNo.setText(this.m_masi.getSerNo(true));
        } else if (e.getTarget().getId().equals("Ok")) {
            if (this.saveSelection()) {
                this.dispose();
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.m_changed = false;
            this.m_M_AttributeSetInstance_ID = 0;
            this.m_M_Locator_ID = 0;
            this.dispose();
        } else if (e.getTarget() == this.mZoom) {
            this.cmd_zoom();
        } else {
            this.log.log(Level.SEVERE, "not found - " + e);
        }
    }

    private void cmd_existingCombo() {
        ListItem pp = this.existingCombo.getSelectedItem();
        if (pp != null && (Integer)pp.getValue() != -1) {
            this.m_M_AttributeSetInstance_ID = (Integer)pp.getValue();
            this.m_masi = MAttributeSetInstance.get((Properties)Env.getCtx(), (int)this.m_M_AttributeSetInstance_ID, (int)this.m_M_Product_ID);
            MAttributeSet as = this.m_masi.getMAttributeSet();
            MAttribute[] attributes = as.getMAttributes(false);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Product Attributes=" + attributes.length);
            }
            int i = 0;
            while (i < attributes.length) {
                this.updateAttributeEditor(attributes[i], i);
                ++i;
            }
            this.cbNewEdit.setEnabled(true);
            this.cbNewEdit.setSelected(false);
            this.bNewRecord.setEnabled(true);
            this.cmd_edit();
        }
    }

    private void cmd_newRecord() {
        this.cbNewEdit.setSelected(false);
        this.cbNewEdit.setEnabled(false);
        this.bNewRecord.setEnabled(false);
        this.existingCombo.setSelectedItem(null);
        this.m_M_AttributeSetInstance_ID = 0;
        int M_AttributeSet_ID = this.m_masi.getM_AttributeSet_ID();
        this.m_masi = new MAttributeSetInstance(Env.getCtx(), this.m_M_AttributeSetInstance_ID, M_AttributeSet_ID, null);
        int i = 0;
        while (i < this.m_editors.size()) {
            HtmlBasedComponent editor = this.m_editors.get(i);
            if (editor instanceof Listbox) {
                ((Listbox)editor).setEnabled(true);
                ((Listbox)editor).setSelectedItem(null);
            } else if (editor instanceof NumberBox) {
                ((NumberBox)editor).setEnabled(true);
                ((NumberBox)editor).setValue(null);
            } else if (editor instanceof Datebox) {
                ((Datebox)editor).setEnabled(true);
                ((Datebox)editor).setValue(null);
            } else if (editor instanceof InputElement) {
                ((InputElement)editor).setReadonly(false);
                ((InputElement)editor).setText(null);
            }
            ++i;
        }
        this.fieldDescription.setText("");
    }

    private void cmd_edit() {
        boolean check = this.cbNewEdit.isSelected();
        int i = 0;
        while (i < this.m_editors.size()) {
            HtmlBasedComponent editor = this.m_editors.get(i);
            if (editor instanceof Datebox) {
                ((Datebox)editor).setEnabled(check);
            } else if (editor instanceof Listbox) {
                ((Listbox)editor).setEnabled(check);
            } else if (editor instanceof NumberBox) {
                ((NumberBox)editor).setEnabled(check);
            } else if (editor instanceof InputElement) {
                ((InputElement)editor).setReadonly(!check);
            }
            ++i;
        }
    }

    private void cmd_select() {
        String title;
        int M_Locator_ID;
        int M_Warehouse_ID;
        block8: {
            MDocType doctype;
            String docbase;
            this.log.config("");
            M_Warehouse_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"M_Warehouse_ID");
            int C_DocType_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"C_DocType_ID");
            if (C_DocType_ID > 0 && (docbase = (doctype = new MDocType(Env.getCtx(), C_DocType_ID, null)).getDocBaseType()).equals("MMR")) {
                M_Warehouse_ID = 0;
            }
            M_Locator_ID = 0;
            if (this.m_AD_Column_ID == 8551) {
                M_Locator_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"M_Locator_ID", (boolean)true);
            }
            title = "";
            String sql = "SELECT p.Name, w.Name, w.M_Warehouse_ID FROM M_Product p, M_Warehouse w WHERE p.M_Product_ID=? AND w.M_Warehouse_ID" + (M_Locator_ID <= 0 ? "=?" : " IN (SELECT M_Warehouse_ID FROM M_Locator where M_Locator_ID=?)");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, M_Locator_ID <= 0 ? M_Warehouse_ID : M_Locator_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        title = String.valueOf(rs.getString(1)) + " - " + rs.getString(2);
                        M_Warehouse_ID = rs.getInt(3);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        final WPAttributeInstance pai = new WPAttributeInstance(title, M_Warehouse_ID, M_Locator_ID, this.m_M_Product_ID, this.m_C_BPartner_ID);
        pai.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (pai.getM_AttributeSetInstance_ID() != -1) {
                    WPAttributeDialog.this.m_M_AttributeSetInstance_ID = pai.getM_AttributeSetInstance_ID();
                    WPAttributeDialog.this.m_M_AttributeSetInstanceName = pai.getM_AttributeSetInstanceName();
                    WPAttributeDialog.this.m_M_Locator_ID = pai.getM_Locator_ID();
                    WPAttributeDialog.this.m_changed = true;
                    WPAttributeDialog.this.dispose();
                }
            }
        });
    }

    private void cmd_newEdit() {
        boolean rw = this.cbNewEdit.isChecked();
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("R/W=" + rw + " " + this.m_masi);
        }
        this.fieldLotString.setReadonly(!rw || this.m_masi.getM_Lot_ID() != 0);
        if (this.fieldLot != null) {
            this.fieldLot.setEnabled(rw);
        }
        this.bLot.setEnabled(rw);
        this.fieldSerNo.setReadonly(!rw);
        this.bSerNo.setEnabled(rw);
        this.fieldGuaranteeDate.setReadonly(!rw);
        int i = 0;
        while (i < this.m_editors.size()) {
            HtmlBasedComponent editor = this.m_editors.get(i);
            if (editor instanceof Listbox) {
                ((Listbox)editor).setEnabled(rw);
            } else if (editor instanceof NumberBox) {
                ((NumberBox)editor).setEnabled(rw);
            } else if (editor instanceof Datebox) {
                ((Datebox)editor).setEnabled(rw);
            } else if (editor instanceof InputElement) {
                ((InputElement)editor).setReadonly(!rw);
            }
            ++i;
        }
    }

    private void cmd_zoom() {
        int M_Lot_ID = 0;
        ListItem pp = this.fieldLot.getSelectedItem();
        if (pp != null) {
            M_Lot_ID = (Integer)pp.getValue();
        }
        MQuery zoomQuery = new MQuery("M_Lot");
        zoomQuery.addRestriction("M_Lot_ID", "=", M_Lot_ID);
        this.log.info(zoomQuery.toString());
    }

    private boolean saveSelection() {
        this.log.info("");
        MAttributeSet as = this.m_masi.getMAttributeSet();
        if (as == null) {
            return true;
        }
        Trx trx = null;
        String mandatory = "";
        try {
            String text;
            String trxName = Trx.createTrxName((String)"WPAD");
            trx = Trx.get((String)trxName, (boolean)false);
            trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_saveSelection");
            this.m_masi.set_TrxName(trxName);
            as.set_TrxName(trxName);
            this.m_changed = false;
            if (!this.m_productWindow && as.isLot()) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Lot=" + this.fieldLotString.getText());
                }
                text = this.fieldLotString.getText();
                this.m_masi.setLot(text);
                if (as.isLotMandatory() && (text == null || text.length() == 0)) {
                    mandatory = String.valueOf(mandatory) + " - " + Msg.translate((Properties)Env.getCtx(), (String)"Lot");
                }
                this.m_changed = true;
            }
            if (!this.m_productWindow && as.isSerNo()) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("SerNo=" + this.fieldSerNo.getText());
                }
                text = this.fieldSerNo.getText();
                this.m_masi.setSerNo(text);
                if (as.isSerNoMandatory() && (text == null || text.length() == 0)) {
                    mandatory = String.valueOf(mandatory) + " - " + Msg.translate((Properties)Env.getCtx(), (String)"SerNo");
                }
                this.m_changed = true;
            }
            if (!this.m_productWindow && as.isGuaranteeDate()) {
                Date gDate;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("GuaranteeDate=" + this.fieldGuaranteeDate.getValue());
                }
                Timestamp ts = (gDate = this.fieldGuaranteeDate.getValue()) != null ? new Timestamp(gDate.getTime()) : null;
                this.m_masi.setGuaranteeDate(ts);
                if (as.isGuaranteeDateMandatory() && ts == null) {
                    mandatory = String.valueOf(mandatory) + " - " + Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate");
                }
                this.m_changed = true;
            }
            if (mandatory.isEmpty() && (this.m_changed || this.m_masi.getM_AttributeSetInstance_ID() == 0)) {
                this.m_masi.saveEx();
                this.m_M_AttributeSetInstance_ID = this.m_masi.getM_AttributeSetInstance_ID();
                this.m_M_AttributeSetInstanceName = this.m_masi.getDescription();
            }
            MAttribute[] attributes = as.getMAttributes(!this.m_productWindow);
            MAttribute.set_TrxName((PO[])attributes, (String)trxName);
            int i = 0;
            while (i < attributes.length) {
                Object value;
                Object editor;
                if ("L".equals(attributes[i].getAttributeValueType())) {
                    MAttributeValue value2;
                    editor = (Listbox)this.m_editors.get(i);
                    ListItem item = editor.getSelectedItem();
                    MAttributeValue mAttributeValue = value2 = item != null ? (MAttributeValue)item.getValue() : null;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(String.valueOf(attributes[i].getName()) + "=" + value2);
                    }
                    if (attributes[i].isMandatory() && value2 == null) {
                        mandatory = String.valueOf(mandatory) + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, value2);
                } else if ("N".equals(attributes[i].getAttributeValueType())) {
                    editor = (NumberBox)this.m_editors.get(i);
                    value = ((NumberBox)((Object)editor)).getValue();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(String.valueOf(attributes[i].getName()) + "=" + value);
                    }
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = String.valueOf(mandatory) + " - " + attributes[i].getName();
                    }
                    if (value != null && ((BigDecimal)value).scale() == 0) {
                        value = ((BigDecimal)value).setScale(1, RoundingMode.HALF_UP);
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, (BigDecimal)value);
                } else if ("D".equals(attributes[i].getAttributeValueType())) {
                    Timestamp ts;
                    editor = (Datebox)this.m_editors.get(i);
                    value = editor.getValue();
                    Timestamp timestamp = ts = value != null ? new Timestamp(((Date)value).getTime()) : null;
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = String.valueOf(mandatory) + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, ts);
                } else {
                    editor = (Textbox)this.m_editors.get(i);
                    value = editor.getText();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(String.valueOf(attributes[i].getName()) + "=" + (String)value);
                    }
                    if (attributes[i].isMandatory() && (value == null || ((String)value).length() == 0)) {
                        mandatory = String.valueOf(mandatory) + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, (String)value);
                }
                this.m_changed = true;
                ++i;
            }
            this.m_M_AttributeSetInstance_ID = this.m_masi.getM_AttributeSetInstance_ID();
            this.m_M_AttributeSetInstanceName = this.m_masi.getDescription();
            if (mandatory.length() > 0) {
                FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", mandatory);
                return false;
            }
            if (this.m_changed) {
                this.m_masi.setDescription();
                this.m_masi.saveEx();
            }
        }
        finally {
            if (trx != null) {
                if (!this.m_changed || mandatory.length() > 0) {
                    trx.rollback();
                } else {
                    trx.commit();
                }
                trx.close();
                trx = null;
            }
        }
        return true;
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }

    public int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }

    public boolean isChanged() {
        return this.m_changed;
    }
}

