/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MDashboardContent;
import org.compiere.model.MDashboardPreference;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;

public class WGadgets
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -4466888491090717617L;
    protected Label noLabel = new Label();
    protected Label yesLabel = new Label();
    protected Button bAdd = new Button();
    protected Button bRemove = new Button();
    protected ConfirmPanel panel;
    protected SimpleListModel noModel = new SimpleListModel();
    protected SimpleListModel yesModel = new SimpleListModel();
    protected Listbox noList = new Listbox();
    protected Listbox yesList = new Listbox();
    protected ArrayList<MDashboardContent> yesItems = new ArrayList();
    protected ArrayList<MDashboardContent> noItems = new ArrayList();
    protected Map<Integer, MDashboardPreference> dirtyList = new LinkedHashMap<Integer, MDashboardPreference>();

    public WGadgets() {
        this.init();
        this.refresh();
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            if (this.panel.getButton("Ok").equals(event.getTarget())) {
                trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_onEvent_onOk");
                try (Trx trx = Trx.get((String)Trx.createTrxName((String)"ManagedGadgets"), (boolean)true);){
                    try {
                        trx.start();
                        for (MDashboardPreference pre : this.dirtyList.values()) {
                            pre.saveEx(trx.getTrxName());
                        }
                        trx.commit(true);
                    }
                    catch (RuntimeException e) {
                        trx.rollback();
                        throw e;
                    }
                }
                SessionManager.getAppDesktop().renderHomeTab();
                this.detach();
            } else if (this.panel.getButton("Cancel").equals(event.getTarget())) {
                this.detach();
            }
        }
    }

    public void init() {
        this.setSclass("popup-dialog");
        this.noLabel.setValue(Msg.translate((Properties)Env.getCtx(), (String)"Available"));
        this.yesLabel.setValue(Msg.translate((Properties)Env.getCtx(), (String)"Show"));
        EventListener<Event> mouseListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if ("onClick".equals(event.getName())) {
                    WGadgets.this.migrateValueAcrossLists(event);
                }
            }
        };
        this.yesList.addDoubleClickListener(mouseListener);
        this.noList.addDoubleClickListener(mouseListener);
        EventListener<Event> actionListener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                WGadgets.this.migrateValueAcrossLists(event);
            }
        };
        this.yesList.setSeltype("multiple");
        this.noList.setSeltype("multiple");
        this.bAdd.setImage(ThemeManager.getThemeResource("images/Next24.png"));
        this.bAdd.addEventListener("onClick", (EventListener)actionListener);
        this.bRemove.setImage(ThemeManager.getThemeResource("images/Previous24.png"));
        this.bRemove.addEventListener("onClick", (EventListener)actionListener);
        final MoveListener moveListener = new MoveListener();
        this.yesList.addOnDropListener(moveListener);
        this.yesList.addDoubleClickListener(moveListener);
        this.noList.addOnDropListener(moveListener);
        this.noList.addDoubleClickListener(moveListener);
        this.yesList.setItemDraggable(true);
        this.yesList.setDroppable("true");
        this.yesList.addEventListener("onDrop", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                moveListener.onEvent(event);
            }
        });
        this.noList.setItemDraggable(true);
        this.noList.setDroppable("true");
        this.noList.addEventListener("onDrop", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                moveListener.onEvent(event);
            }
        });
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.yesList);
        ListHeader listHeader = new ListHeader();
        listHeader.appendChild((Component)this.yesLabel);
        listHeader.setParent((Component)listHead);
        listHead = new ListHead();
        listHead.setParent((Component)this.noList);
        listHeader = new ListHeader();
        listHeader.appendChild((Component)this.noLabel);
        listHeader.setParent((Component)listHead);
        Hlayout hlayout = new Hlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hlayout, "true");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hlayout, "true");
        hlayout.setStyle("padding: 2px 3px;");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.noList, "1");
        ZKUpdateUtil.setVflex(this.noList, true);
        hlayout.appendChild((Component)this.noList);
        Vbox vbox = new Vbox();
        vbox.appendChild((Component)this.bAdd);
        vbox.appendChild((Component)this.bRemove);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "50px");
        hlayout.appendChild((Component)vbox);
        ZKUpdateUtil.setVflex(this.yesList, true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.yesList, "1");
        hlayout.appendChild((Component)this.yesList);
        this.panel = new ConfirmPanel(true);
        this.panel.setSclass("dialog-footer");
        this.panel.addActionListener("onClick", this);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.panel, "min");
        Vlayout vlayout = new Vlayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)vlayout, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vlayout, "100%");
        vlayout.setStyle("margin: 0px; border: none; padding: 0px");
        vlayout.appendChild((Component)hlayout);
        vlayout.appendChild((Component)this.panel);
        this.appendChild((Component)vlayout);
        this.setBorder("normal");
    }

    public void loadItems() {
        MDashboardContent content;
        Properties ctx = Env.getCtx();
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        int AD_Role_ID = Env.getAD_Role_ID((Properties)ctx);
        int AD_User_ID = Env.getAD_User_ID((Properties)ctx);
        this.noItems.removeAll(this.noItems);
        this.yesItems.removeAll(this.yesItems);
        String query = "SELECT ct.PA_DashboardContent_ID,        ct.Name FROM   PA_DashboardContent ct WHERE  ct.AD_Client_ID IN ( 0, ? )        AND ct.IsActive = 'Y'        AND ct.PA_DashboardContent_ID NOT IN (SELECT pre.PA_DashboardContent_ID                                              FROM   PA_DashboardPreference pre                                              WHERE  pre.AD_Client_ID IN ( 0, ? )                                                     AND pre.AD_Role_ID = ?                                                     AND pre.AD_User_ID = ?                                                     AND pre.AD_Org_ID = 0                                                     AND pre.IsActive = 'Y')        AND ( ct.PA_DashboardContent_ID NOT IN (SELECT cta.PA_DashboardContent_ID                                                FROM   PA_DashboardContent_Access cta                                                WHERE  cta.IsActive = 'N'                                                       AND COALESCE(cta.AD_Role_ID, ?) = ?                                                       AND COALESCE(cta.AD_User_ID, ?) = ?                                                       AND cta.AD_Client_ID IN ( 0, ? ))               OR ct.PA_DashboardContent_ID IN (SELECT cta.PA_DashboardContent_ID                                                FROM   PA_DashboardContent_Access cta                                                WHERE  cta.IsActive = 'Y'                                                       AND COALESCE(cta.AD_Role_ID, ?) = ?                                                       AND COALESCE(cta.AD_User_ID, ?) = ?                                                       AND cta.AD_Client_ID IN ( 0, ? )) ) ";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)query, null);
                pstmt.setInt(1, AD_Client_ID);
                pstmt.setInt(2, AD_Client_ID);
                pstmt.setInt(3, AD_Role_ID);
                pstmt.setInt(4, AD_User_ID);
                pstmt.setInt(5, AD_Role_ID);
                pstmt.setInt(6, AD_Role_ID);
                pstmt.setInt(7, AD_User_ID);
                pstmt.setInt(8, AD_User_ID);
                pstmt.setInt(9, AD_Client_ID);
                pstmt.setInt(10, AD_Role_ID);
                pstmt.setInt(11, AD_Role_ID);
                pstmt.setInt(12, AD_User_ID);
                pstmt.setInt(13, AD_User_ID);
                pstmt.setInt(14, AD_Client_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MDashboardContent content2 = new MDashboardContent(ctx, rs.getInt(1), null);
                    if (this.dirtyList.containsKey(content2.getPA_DashboardContent_ID())) continue;
                    this.noItems.add(content2);
                }
            }
            catch (Exception e) {
                throw new AdempiereException("Error while loading dashboard contents" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        String where = " AD_User_ID=? AND AD_Role_ID=? AND AD_Client_ID=? AND AD_Org_ID=0 AND IsActive='Y'";
        Query query1 = new Query(ctx, "PA_DashboardPreference", where, null);
        query1.setParameters(new Object[]{AD_User_ID, AD_Role_ID, AD_Client_ID});
        List preference = query1.list();
        if (preference.size() > 0) {
            int i = 0;
            while (i < preference.size()) {
                int ID = ((MDashboardPreference)preference.get(i)).getPA_DashboardContent_ID();
                content = new MDashboardContent(ctx, ID, null);
                if (content.isActive() && !this.dirtyList.containsKey(content.getPA_DashboardContent_ID())) {
                    this.yesItems.add(content);
                }
                ++i;
            }
        }
        for (MDashboardPreference pre : this.dirtyList.values()) {
            content = (MDashboardContent)pre.getPA_DashboardContent();
            if (pre.isActive()) {
                this.yesItems.add(content);
                continue;
            }
            this.noItems.add(content);
        }
        Collections.sort(this.yesItems, new DashboardNameComparator());
        Collections.sort(this.noItems, new DashboardNameComparator());
    }

    protected void migrateValueAcrossLists(Event event) {
        Component source = event.getTarget();
        if (source instanceof ListItem) {
            source = ((ListItem)source).getListbox();
        }
        Listbox listFrom = source == this.bAdd || source == this.noList ? this.noList : this.yesList;
        Listbox listTo = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
        this.migrateLists(listFrom, listTo);
    }

    protected void migrateLists(Listbox listFrom, Listbox listTo) {
        int index = 0;
        SimpleListModel lmFrom = listFrom == this.yesList ? this.yesModel : this.noModel;
        Set selectedItems = listFrom.getSelectedItems();
        ArrayList<ListElement> selObjects = new ArrayList<ListElement>();
        for (Object obj : selectedItems) {
            ListItem listItem = (ListItem)((Object)obj);
            index = listFrom.getIndexOfItem(listItem);
            ListElement selObject = (ListElement)((Object)lmFrom.getElementAt(index));
            selObjects.add(selObject);
        }
        index = 0;
        Arrays.sort(selObjects.toArray());
        for (ListElement selObject : selObjects) {
            if (selObject == null) continue;
            Properties ctx = Env.getCtx();
            int AD_User_ID = Env.getAD_User_ID((Properties)ctx);
            int AD_Role_ID = Env.getAD_Role_ID((Properties)ctx);
            int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
            MDashboardContent content = new MDashboardContent(Env.getCtx(), selObject.m_key, null);
            String where = " AD_Client_ID=? AND PA_DashboardContent_ID=? AND AD_Role_ID=? AND AD_User_ID=? AND AD_Org_ID=0";
            Query query = new Query(ctx, "PA_DashboardPreference", where, null);
            query.setParameters(new Object[]{AD_Client_ID, content.getPA_DashboardContent_ID(), AD_Role_ID, AD_User_ID});
            MDashboardPreference pre = (MDashboardPreference)query.setOnlyActiveRecords(false).first();
            if (listFrom.equals((Object)this.noList)) {
                if (pre != null) {
                    pre.setIsActive(true);
                    pre.setIsShowInDashboard(content.isShowInDashboard());
                } else {
                    pre = new MDashboardPreference(Env.getCtx(), 0, null);
                    pre.setAD_Org_ID(0);
                    pre.setAD_Role_ID(AD_Role_ID);
                    pre.set_ValueNoCheck("AD_User_ID", (Object)AD_User_ID);
                    pre.setColumnNo(content.getColumnNo());
                    pre.setIsCollapsedByDefault(content.isCollapsedByDefault());
                    pre.setIsShowInDashboard(content.isShowInDashboard());
                    pre.setLine(content.getLine());
                    pre.setPA_DashboardContent_ID(content.getPA_DashboardContent_ID());
                }
                this.dirtyList.put(pre.getPA_DashboardContent_ID(), pre);
                continue;
            }
            if (pre != null) {
                pre.setIsActive(false);
            } else {
                pre = new MDashboardPreference(Env.getCtx(), 0, null);
                pre.setAD_Org_ID(0);
                pre.setAD_Role_ID(AD_Role_ID);
                pre.set_ValueNoCheck("AD_User_ID", (Object)AD_User_ID);
                pre.setColumnNo(content.getColumnNo());
                pre.setIsCollapsedByDefault(content.isCollapsedByDefault());
                pre.setIsShowInDashboard(content.isShowInDashboard());
                pre.setLine(content.getLine());
                pre.setPA_DashboardContent_ID(content.getPA_DashboardContent_ID());
                pre.setIsActive(false);
            }
            this.dirtyList.put(pre.getPA_DashboardContent_ID(), pre);
        }
        this.refresh();
        if (listTo.getSelectedItem() != null) {
            AuFocus focus = new AuFocus((Component)listTo.getSelectedItem());
            Clients.response((AuResponse)focus);
        }
    }

    public void refresh() {
        String name;
        int ID;
        int i;
        this.loadItems();
        this.yesList.removeAllItems();
        this.noList.removeAllItems();
        if (this.yesItems.size() > 0 && this.yesItems != null) {
            this.yesModel.removeAllElements();
            i = 0;
            while (i < this.yesItems.size()) {
                ID = this.yesItems.get(i).get_ID();
                name = this.yesItems.get(i).get_Translation("Name");
                this.yesList.addItem(new KeyNamePair(ID, name));
                this.yesModel.addElement((Object)new ListElement(ID, name, this.yesItems.get(i).get_Translation("Name"), true, this.yesItems.get(i).getAD_Client_ID(), this.yesItems.get(i).getAD_Org_ID()));
                ++i;
            }
        }
        if (this.noItems.size() > 0 && this.noItems != null) {
            this.noModel.removeAllElements();
            i = 0;
            while (i < this.noItems.size()) {
                ID = this.noItems.get(i).get_ID();
                name = this.noItems.get(i).get_Translation("Name");
                this.noList.addItem(new KeyNamePair(ID, name));
                this.noModel.add(i, (Object)new ListElement(ID, name, this.noItems.get(i).get_Translation("Name"), false, this.noItems.get(i).getAD_Client_ID(), this.noItems.get(i).getAD_Org_ID()));
                ++i;
            }
        }
    }

    class DashboardNameComparator
    implements Comparator<MDashboardContent> {
        DashboardNameComparator() {
        }

        @Override
        public int compare(MDashboardContent dc1, MDashboardContent dc2) {
            return dc1.get_Translation("Name").compareTo(dc2.get_Translation("Name"));
        }
    }

    public static class ListElement
    extends NamePair {
        private static final long serialVersionUID = -5645910649588308798L;
        private int m_key;
        private int m_AD_Client_ID;
        private int m_AD_Org_ID;
        private String m_namecontent;
        private boolean m_isYes;

        public ListElement(int key, String name, String namecontent, boolean isYes, int AD_Client_ID, int AD_Org_ID) {
            super(name);
            this.m_key = key;
            this.m_AD_Client_ID = AD_Client_ID;
            this.m_AD_Org_ID = AD_Org_ID;
            this.m_namecontent = namecontent;
            this.m_isYes = isYes;
        }

        public int getKey() {
            return this.m_key;
        }

        public String getM_namecontent() {
            return this.m_namecontent;
        }

        public void setM_namecontent(String m_namecontent) {
            this.m_namecontent = m_namecontent;
        }

        public void setIsYes(boolean value) {
            this.m_isYes = value;
        }

        public boolean isYes() {
            return this.m_isYes;
        }

        public int getAD_Client_ID() {
            return this.m_AD_Client_ID;
        }

        public int getAD_Org_ID() {
            return this.m_AD_Org_ID;
        }

        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListElement) {
                ListElement li = (ListElement)((Object)obj);
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName()) && li.getAD_Client_ID() == this.m_AD_Client_ID && li.getAD_Org_ID() == this.m_AD_Org_ID;
            }
            return false;
        }

        public String toString() {
            String s = super.toString();
            if (s == null || s.trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }

    private class MoveListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (event instanceof DropEvent) {
                Listbox listFrom = null;
                Listbox listTo = null;
                ListItem fromItem = null;
                ListItem toItem = null;
                DropEvent me = (DropEvent)event;
                Component target = me.getTarget();
                if (target instanceof ListItem) {
                    toItem = (ListItem)target;
                    listTo = (Listbox)toItem.getListbox();
                } else {
                    listTo = (Listbox)target;
                }
                fromItem = (ListItem)me.getDragged();
                listFrom = (Listbox)fromItem.getListbox();
                if (!fromItem.isSelected()) {
                    fromItem.setSelected(true);
                }
                if (listFrom != listTo) {
                    WGadgets.this.migrateLists(listFrom, listTo);
                }
            } else if (event instanceof MouseEvent) {
                Listbox listFrom = null;
                Listbox listTo = null;
                ListItem fromItem = (ListItem)event.getTarget();
                listFrom = (Listbox)fromItem.getListbox();
                Listbox listbox = listTo = listFrom == WGadgets.this.yesList ? WGadgets.this.noList : WGadgets.this.yesList;
                if (!fromItem.isSelected()) {
                    fromItem.setSelected(true);
                }
                WGadgets.this.migrateLists(listFrom, listTo);
            }
        }
    }
}

