/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.Vlayout;

public class WChat
extends Window
implements EventListener<Event>,
DialogEvents {
    private static final long serialVersionUID = -5265835393257520762L;
    private static final String USER_LABEL_STYLE = "font-weight: bold";
    private static final String TIME_LABEL_STYLE = "font-size:xx-small;color:gray;margin-left:20px";
    private int m_WindowNo;
    private MChat m_chat;
    private static CLogger log = CLogger.getCLogger(WChat.class);
    private Borderlayout mainPanel = new Borderlayout();
    private Textbox newText = new Textbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(false);
    private Tree messageTree = new Tree();
    private Button addButton;
    private Map<Integer, Component> entryMap = new HashMap<Integer, Component>();
    private SimpleDateFormat m_format;
    private String orientation;

    public WChat(int WindowNo, int CM_Chat_ID, int AD_Table_ID, int Record_ID, String Description, String trxName) {
        this.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Chat")) + " " + Description);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("ID=" + CM_Chat_ID + ", Table=" + AD_Table_ID + ", Record=" + Record_ID);
        }
        this.m_WindowNo = WindowNo;
        try {
            this.staticInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.m_chat = CM_Chat_ID > 0 ? new MChat(Env.getCtx(), CM_Chat_ID, trxName) : new MChat(Env.getCtx(), AD_Table_ID, Record_ID, Description, trxName);
        this.loadChat();
    }

    public void showWindow() {
        this.newText.focus();
    }

    private void staticInit() throws Exception {
        this.setSclass("popup-dialog chat-dialog");
        this.setStyle("position: absolute");
        this.setAttribute("instanceName", "chat");
        this.appendChild((Component)this.mainPanel);
        this.mainPanel.setStyle("border: none; background-color: white;");
        Center center = new Center();
        center.setSclass("dialog-content");
        Vlayout content = new Vlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)content, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)content, "1");
        center.appendChild((Component)content);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.messageTree, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.messageTree, "1");
        content.appendChild((Component)this.messageTree);
        center.setAutoscroll(true);
        this.mainPanel.appendChild((Component)center);
        content.appendChild((Component)this.newText);
        this.newText.setRows(3);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.newText, "100%");
        this.newText.setMultiline(true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.newText, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.newText, "min");
        this.addButton = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Add")));
        this.addButton.addActionListener(this);
        content.appendChild((Component)this.addButton);
        South south = new South();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)south, "min");
        this.mainPanel.appendChild((Component)south);
        LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
        south.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanel, "min");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "88%");
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setMaximizable(true);
        this.setSizable(true);
        this.setBorder("normal");
        this.setClosable(true);
        if (ClientInfo.isMobile()) {
            this.orientation = ClientInfo.get().orientation;
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
    }

    protected void onClientInfo() {
        String newOrienation;
        if (this.getPage() != null && !(newOrienation = ClientInfo.get().orientation).equals(this.orientation)) {
            this.orientation = newOrienation;
            ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
            ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            this.invalidate();
        }
    }

    private void loadChat() {
        MChatEntry[] entries;
        Treechildren treeChildren = this.messageTree.getTreechildren();
        if (treeChildren == null) {
            treeChildren = new Treechildren();
            this.messageTree.appendChild((Component)treeChildren);
            this.messageTree.setMultiple(false);
        }
        MChatEntry[] mChatEntryArray = entries = this.m_chat.getEntries(true);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MChatEntry entry = mChatEntryArray[n2];
            this.addEntry(entry);
            ++n2;
        }
    }

    protected void addEntry(MChatEntry entry) {
        if (entry.getCM_ChatEntryParent_ID() == 0) {
            Treechildren treeChildren = this.messageTree.getTreechildren();
            Treeitem treeitem = new Treeitem();
            treeChildren.appendChild((Component)treeitem);
            this.entryMap.put(entry.getCM_ChatEntry_ID(), (Component)treeitem);
            Label userLabel = this.createUserNameLabel(entry);
            Div div = new Div();
            div.setStyle("display:inline;");
            div.appendChild((Component)userLabel);
            Label msgLabel = new Label(entry.getCharacterData());
            div.appendChild((Component)msgLabel);
            Button button = this.createReplyButton(entry);
            Label timeLabel = this.createTimestampLabel(entry);
            div.appendChild((Component)new Space());
            div.appendChild((Component)button);
            div.appendChild((Component)timeLabel);
            Treerow treerow = new Treerow();
            treerow.setStyle("vertical-align:top;");
            treeitem.appendChild((Component)treerow);
            Treecell treecell = new Treecell();
            treerow.appendChild((Component)treecell);
            treecell.appendChild((Component)div);
        } else {
            Component comp = this.entryMap.get(entry.getCM_ChatEntryParent_ID());
            if (comp != null && comp instanceof Treeitem) {
                Treeitem treeitem = (Treeitem)comp;
                Label userLabel = this.createUserNameLabel(entry);
                Div div = new Div();
                div.setStyle("display:inline;");
                div.appendChild((Component)userLabel);
                Label msgLabel = new Label(entry.getCharacterData());
                div.appendChild((Component)msgLabel);
                Button button = this.createReplyButton(entry);
                div.appendChild((Component)new Space());
                div.appendChild((Component)button);
                Label timeLabel = this.createTimestampLabel(entry);
                div.appendChild((Component)timeLabel);
                Treechildren treeChildren = treeitem.getTreechildren();
                if (treeChildren == null) {
                    treeChildren = new Treechildren();
                    treeitem.appendChild((Component)treeChildren);
                }
                Treeitem childItem = new Treeitem();
                treeChildren.appendChild((Component)childItem);
                Treerow treerow = new Treerow();
                treerow.setStyle("vertical-align:top;");
                childItem.appendChild((Component)treerow);
                Treecell treecell = new Treecell();
                treerow.appendChild((Component)treecell);
                treecell.appendChild((Component)div);
                this.entryMap.put(entry.getCM_ChatEntry_ID(), (Component)childItem);
            }
        }
    }

    protected Label createTimestampLabel(MChatEntry entry) {
        Timestamp created = entry.getCreated();
        if (this.m_format == null) {
            this.m_format = DisplayType.getDateFormat((int)16);
        }
        Label timeLabel = new Label(this.m_format.format(created));
        timeLabel.setStyle(TIME_LABEL_STYLE);
        return timeLabel;
    }

    protected Label createUserNameLabel(MChatEntry entry) {
        MUser user = MUser.get((Properties)Env.getCtx(), (int)entry.getCreatedBy());
        String userName = String.valueOf(user.getName()) + ": ";
        Label userLabel = new Label(userName);
        userLabel.setStyle(USER_LABEL_STYLE);
        return userLabel;
    }

    protected Button createReplyButton(MChatEntry entry) {
        Button button = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Reply")));
        button.addActionListener(this);
        button.setAttribute("CM_ChatEntry_ID", entry.getCM_ChatEntry_ID());
        return button;
    }

    public void actionPerformed(Event e) {
        if (e.getTarget().getId().equals("Ok")) {
            this.dispose();
        } else if (e.getTarget() == this.addButton) {
            String data = this.newText.getText();
            if (data != null && data.length() > 0) {
                log.config(data);
                if (this.m_chat.get_ID() == 0) {
                    this.m_chat.saveEx();
                }
                MChatEntry entry = new MChatEntry(this.m_chat, data);
                entry.saveEx();
                this.newText.setText("");
                this.addEntry(entry);
            }
        } else if (e.getTarget().getAttribute("CM_ChatEntry_ID") != null) {
            int CM_ChatEntry_ID = (Integer)e.getTarget().getAttribute("CM_ChatEntry_ID");
            Div div = new Div();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)div, "100%");
            Textbox replyTextbox = new Textbox();
            replyTextbox.setMultiline(true);
            replyTextbox.setRows(3);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)replyTextbox, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)replyTextbox, "100%");
            div.appendChild((Component)replyTextbox);
            Button btn = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Ok")));
            div.appendChild((Component)btn);
            btn.addActionListener(this);
            btn.setAttribute("CM_ChatEntryParent_ID", CM_ChatEntry_ID);
            btn = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Cancel")));
            div.appendChild((Component)btn);
            btn.addActionListener(this);
            btn.setAttribute("CM_ChatEntryParent_ID", CM_ChatEntry_ID);
            btn.setAttribute("cancel.button", true);
            e.getTarget().getParent().appendChild((Component)div);
            replyTextbox.focus();
        } else if (e.getTarget().getAttribute("CM_ChatEntryParent_ID") != null) {
            if (e.getTarget().getAttribute("cancel.button") != null) {
                e.getTarget().getParent().detach();
                return;
            }
            int CM_ChatEntryParent_ID = (Integer)e.getTarget().getAttribute("CM_ChatEntryParent_ID");
            Textbox textbox = (Textbox)e.getTarget().getParent().getFirstChild();
            MChatEntry entry = new MChatEntry(this.m_chat, textbox.getText());
            entry.setCM_ChatEntryParent_ID(CM_ChatEntryParent_ID);
            entry.saveEx();
            this.addEntry(entry);
            e.getTarget().getParent().detach();
        }
    }

    public void onEvent(Event event) throws Exception {
        this.actionPerformed(event);
    }
}

