/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAccount;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;

public final class WAccountDialog
extends Window
implements EventListener<Event>,
DataStatusListener,
ValueChangeListener {
    private static final long serialVersionUID = 3041802296879719489L;
    private Callback<Integer> m_callback;
    private int m_WindowNo;
    protected boolean m_changed = false;
    private static volatile MAcctSchema s_AcctSchema = null;
    private GridWindow m_mWindow = null;
    private GridTab m_mTab = null;
    private ADTabpanel m_adTabPanel = null;
    private MAccountLookup m_mAccount = null;
    private int m_C_ValidCombination_ID;
    private int m_C_AcctSchema_ID = 0;
    private int m_AD_Client_ID;
    private MQuery m_query;
    private int IDvalue = 0;
    private static CLogger log = CLogger.getCLogger(WAccountDialog.class);
    private WEditor f_Alias;
    private WEditor f_Combination;
    private WEditor f_AD_Org_ID;
    private WEditor f_Account_ID;
    private WEditor f_SubAcct_ID;
    private WEditor f_M_Product_ID;
    private WEditor f_C_BPartner_ID;
    private WEditor f_C_Campaign_ID;
    private WEditor f_C_LocFrom_ID;
    private WEditor f_C_LocTo_ID;
    private WEditor f_C_Project_ID;
    private WEditor f_C_SalesRegion_ID;
    private WEditor f_AD_OrgTrx_ID;
    private WEditor f_C_Activity_ID;
    private WEditor f_User1_ID;
    private WEditor f_User2_ID;
    private Label f_Description = new Label("");
    private boolean m_newRow = true;
    private Vbox panel = new Vbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Hbox northPanel = new Hbox();
    private Groupbox parameterPanel = new Groupbox();
    private Grid parameterLayout = new Grid();
    private ToolBar toolBar = new ToolBar();
    private ToolBarButton bRefresh = new ToolBarButton();
    private ToolBarButton bSave = new ToolBarButton();
    private ToolBarButton bIgnore = new ToolBarButton();
    private Row m_row;
    private Rows m_rows;
    private boolean m_smallWidth;

    public WAccountDialog(String title, MAccountLookup mAccount, int C_AcctSchema_ID, Callback<Integer> callback) {
        this.setTitle(title);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 500);
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 750);
        } else {
            this.addCallback("afterPageAttached", (org.zkoss.zk.ui.util.Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
                this.invalidate();
            });
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_AcctSchema_ID=" + C_AcctSchema_ID + ", C_ValidCombination_ID=" + mAccount.C_ValidCombination_ID);
        }
        this.m_mAccount = mAccount;
        this.m_C_AcctSchema_ID = C_AcctSchema_ID;
        this.m_callback = callback;
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        try {
            this.init();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.toString());
        }
        if (this.initAccount()) {
            AEnv.showCenterScreen(this);
        } else {
            this.dispose();
        }
    }

    void init() throws Exception {
        Caption caption = new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"Parameter"));
        this.parameterPanel.appendChild((Component)caption);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.parameterPanel, "min");
        this.parameterPanel.setStyle("background-color: transparent;");
        this.toolBar.setOrient("vertical");
        this.toolBar.setStyle("border: none; padding: 5px");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.toolBar, "min");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSave.setIconSclass("z-icon-Save");
        } else {
            this.bSave.setImage(ThemeManager.getThemeResource("images/Save24.png"));
        }
        this.bSave.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AccountNewUpdate"));
        this.bSave.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bRefresh.setIconSclass("z-icon-Refresh");
        } else {
            this.bRefresh.setImage(ThemeManager.getThemeResource("images/Refresh24.png"));
        }
        this.bRefresh.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"));
        this.bRefresh.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bIgnore.setIconSclass("z-icon-Ignore");
        } else {
            this.bIgnore.setImage(ThemeManager.getThemeResource("images/Ignore24.png"));
        }
        this.bIgnore.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Ignore"));
        this.bIgnore.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bSave);
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bRefresh);
            LayoutUtils.addSclass("medium-toolbarbutton", (HtmlBasedComponent)this.bIgnore);
        }
        this.toolBar.appendChild((Component)this.bRefresh);
        this.toolBar.appendChild((Component)this.bIgnore);
        this.toolBar.appendChild((Component)this.bSave);
        this.northPanel.appendChild((Component)this.parameterPanel);
        this.northPanel.appendChild((Component)this.toolBar);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.northPanel, "100%");
        this.m_adTabPanel = new ADTabpanel();
        Borderlayout layout = new Borderlayout();
        layout.setParent((Component)this);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        layout.setStyle("background-color: transparent; position: relative;");
        North nRegion = new North();
        nRegion.setParent((Component)layout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.northPanel, "false");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.northPanel, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.parameterPanel, "min");
        nRegion.appendChild((Component)this.northPanel);
        nRegion.setStyle("background-color: transparent; border: none");
        this.northPanel.setStyle("background-color: transparent;");
        nRegion.setCollapsible(true);
        nRegion.setSplittable(true);
        nRegion.setAutoscroll(true);
        Center cRegion = new Center();
        cRegion.setParent((Component)layout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_adTabPanel, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.m_adTabPanel, "true");
        cRegion.appendChild((Component)this.m_adTabPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)cRegion, "min");
        South sRegion = new South();
        sRegion.setParent((Component)layout);
        Div div = new Div();
        div.appendChild((Component)this.confirmPanel);
        this.confirmPanel.setStyle("margin-top: 5px; margin-bottom: 5px");
        div.appendChild((Component)this.statusBar);
        sRegion.appendChild((Component)div);
        sRegion.setStyle("background-color: transparent; border: none");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)sRegion, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanel, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.statusBar, "min");
        this.confirmPanel.addActionListener("onClick", this);
        this.setBorder("normal");
        this.setClosable(false);
        this.setSizable(true);
        this.setMaximizable(true);
        this.setSclass("account-dialog");
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
    }

    private boolean initAccount() {
        this.m_AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"AD_Client_ID");
        if (s_AcctSchema == null || s_AcctSchema.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            s_AcctSchema = new MAcctSchema(Env.getCtx(), this.m_C_AcctSchema_ID, null);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(s_AcctSchema.toString()) + ", #" + s_AcctSchema.getAcctSchemaElements().length);
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"C_AcctSchema_ID", (int)this.m_C_AcctSchema_ID);
        int AD_Window_ID = 153;
        GridWindowVO wVO = AEnv.getMWindowVO(this.m_WindowNo, AD_Window_ID, 0);
        if (wVO == null) {
            return false;
        }
        wVO.WindowType = "Q";
        ((GridTabVO)wVO.Tabs.get((int)0)).IsReadOnly = true;
        this.m_mWindow = new GridWindow(wVO);
        this.m_mTab = this.m_mWindow.getTab(0);
        if (!this.m_mTab.isLoadComplete()) {
            this.m_mWindow.initTab(0);
        }
        this.m_mTab.getField("Alias").setDisplayLength(15);
        this.m_mTab.getField("Combination").setDisplayLength(15);
        this.m_mTab.getField("AD_Client_ID").setDisplayed(false);
        this.m_mTab.getField("C_AcctSchema_ID").setDisplayed(false);
        this.m_mTab.getField("IsActive").setDisplayed(false);
        this.m_mTab.getField("IsFullyQualified").setDisplayed(false);
        int i = 0;
        while (i < this.m_mTab.getFieldCount()) {
            GridField field = this.m_mTab.getField(i);
            if (!field.isDisplayed(true)) {
                field.setDisplayed(false);
            }
            ++i;
        }
        this.m_adTabPanel.init(null, this.m_WindowNo, this.m_mTab, null);
        this.parameterLayout.makeNoStrip();
        this.parameterLayout.setOddRowSclass("even");
        this.parameterLayout.setParent((Component)this.parameterPanel);
        this.parameterLayout.setStyle("background-color: transparent; margin:none; border:none; padding:none;");
        this.layoutParameters();
        this.m_query = new MQuery();
        this.m_query.addRestriction("C_AcctSchema_ID", "=", this.m_C_AcctSchema_ID);
        if (this.m_mAccount.C_ValidCombination_ID == 0) {
            this.m_mTab.setQuery(MQuery.getEqualQuery((String)"1", (Object)"2"));
        } else {
            MQuery query = new MQuery();
            query.addRestriction("C_AcctSchema_ID", "=", this.m_C_AcctSchema_ID);
            query.addRestriction("C_ValidCombination_ID", "=", this.m_mAccount.C_ValidCombination_ID);
            this.m_mTab.setQuery(query);
        }
        this.m_mTab.query(false);
        this.m_adTabPanel.getGridTab().addDataStatusListener((DataStatusListener)this);
        this.m_adTabPanel.activate(true);
        if (!this.m_adTabPanel.isGridView()) {
            this.m_adTabPanel.switchRowPresentation();
        }
        this.statusBar.setStatusLine(s_AcctSchema.toString());
        this.statusBar.setStatusDB("");
        if (this.m_mAccount.C_ValidCombination_ID != 0) {
            this.m_mTab.navigate(0);
            if (this.f_Account_ID.getValue() instanceof Integer) {
                Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"Account_ID", (int)((Integer)this.f_Account_ID.getValue()));
                Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (String)"Account_ID", (int)((Integer)this.f_Account_ID.getValue()));
                if (this.f_SubAcct_ID != null) {
                    this.f_SubAcct_ID.dynamicDisplay();
                }
            }
        }
        log.config("fini");
        return true;
    }

    protected void layoutParameters() {
        this.m_smallWidth = ClientInfo.maxWidth(699);
        this.m_rows = new Rows();
        this.m_rows.setParent((Component)this.parameterLayout);
        if (s_AcctSchema.isHasAlias()) {
            GridField alias = this.m_mTab.getField("Alias");
            if (this.f_Alias == null) {
                this.f_Alias = WebEditorFactory.getEditor(alias, false);
            }
            this.addLine(alias, this.f_Alias, false);
        }
        GridField combination = this.m_mTab.getField("Combination");
        if (this.f_Combination == null) {
            this.f_Combination = WebEditorFactory.getEditor(combination, false);
        }
        this.addLine(combination, this.f_Combination, false);
        this.m_newRow = true;
        MAcctSchemaElement[] elements = s_AcctSchema.getAcctSchemaElements();
        int i = 0;
        while (i < elements.length) {
            GridField field;
            MAcctSchemaElement ase = elements[i];
            String type = ase.getElementType();
            boolean isMandatory = ase.isMandatory();
            if (type.equals("OO")) {
                field = this.m_mTab.getField("AD_Org_ID");
                if (this.f_AD_Org_ID == null) {
                    this.f_AD_Org_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_AD_Org_ID, isMandatory);
            } else if (type.equals("AC")) {
                field = this.m_mTab.getField("Account_ID");
                if (this.f_Account_ID == null) {
                    this.f_Account_ID = WebEditorFactory.getEditor(field, false);
                    this.f_Account_ID.addValueChangeListener(this);
                }
                this.addLine(field, this.f_Account_ID, isMandatory);
            } else if (type.equals("SA")) {
                field = this.m_mTab.getField("C_SubAcct_ID");
                if (this.f_SubAcct_ID == null) {
                    this.f_SubAcct_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_SubAcct_ID, isMandatory);
            } else if (type.equals("PR")) {
                field = this.m_mTab.getField("M_Product_ID");
                if (this.f_M_Product_ID == null) {
                    this.f_M_Product_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_M_Product_ID, isMandatory);
            } else if (type.equals("BP")) {
                field = this.m_mTab.getField("C_BPartner_ID");
                if (this.f_C_BPartner_ID == null) {
                    this.f_C_BPartner_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_BPartner_ID, isMandatory);
            } else if (type.equals("MC")) {
                field = this.m_mTab.getField("C_Campaign_ID");
                if (this.f_C_Campaign_ID == null) {
                    this.f_C_Campaign_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_Campaign_ID, isMandatory);
            } else if (type.equals("LF")) {
                field = this.m_mTab.getField("C_LocFrom_ID");
                if (this.f_C_LocFrom_ID == null) {
                    this.f_C_LocFrom_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_LocFrom_ID, isMandatory);
            } else if (type.equals("LT")) {
                field = this.m_mTab.getField("C_LocTo_ID");
                if (this.f_C_LocTo_ID == null) {
                    this.f_C_LocTo_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_LocTo_ID, isMandatory);
            } else if (type.equals("PJ")) {
                field = this.m_mTab.getField("C_Project_ID");
                if (this.f_C_Project_ID == null) {
                    this.f_C_Project_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_Project_ID, isMandatory);
            } else if (type.equals("SR")) {
                field = this.m_mTab.getField("C_SalesRegion_ID");
                if (this.f_C_SalesRegion_ID == null) {
                    this.f_C_SalesRegion_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_SalesRegion_ID, isMandatory);
            } else if (type.equals("OT")) {
                field = this.m_mTab.getField("AD_OrgTrx_ID");
                if (this.f_AD_OrgTrx_ID == null) {
                    this.f_AD_OrgTrx_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_AD_OrgTrx_ID, isMandatory);
            } else if (type.equals("AY")) {
                field = this.m_mTab.getField("C_Activity_ID");
                if (this.f_C_Activity_ID == null) {
                    this.f_C_Activity_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_C_Activity_ID, isMandatory);
            } else if (type.equals("U1")) {
                field = this.m_mTab.getField("User1_ID");
                if (this.f_User1_ID == null) {
                    this.f_User1_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_User1_ID, isMandatory);
            } else if (type.equals("U2")) {
                field = this.m_mTab.getField("User2_ID");
                if (this.f_User2_ID == null) {
                    this.f_User2_ID = WebEditorFactory.getEditor(field, false);
                }
                this.addLine(field, this.f_User2_ID, isMandatory);
            }
            ++i;
        }
        this.m_newRow = true;
        Row row = new Row();
        this.f_Description.setStyle("font-decoration: italic;");
        Cell cell = new Cell();
        cell.setColspan(4);
        cell.appendChild((Component)this.f_Description);
        row.appendChild((Component)cell);
        row.setStyle("background-color: transparent; padding: 10px");
        this.m_rows.appendChild((Component)row);
    }

    private void addLine(GridField field, WEditor editor, boolean mandatory) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Field=" + field);
        }
        Label label = editor.getLabel();
        editor.setReadWrite(true);
        editor.setMandatory(mandatory);
        field.addPropertyChangeListener((PropertyChangeListener)editor);
        if (this.m_newRow) {
            this.m_row = new Row();
            this.m_row.setStyle("background-color: transparent");
            this.m_rows.appendChild((Component)this.m_row);
        }
        if (ClientInfo.maxWidth(699)) {
            Vlayout vlayout = new Vlayout();
            vlayout.setHflex("1");
            vlayout.setSpacing("0px");
            vlayout.appendChild((Component)label);
            vlayout.appendChild(editor.getComponent());
            this.m_row.appendCellChild((Component)vlayout, 2);
        } else {
            Div div = new Div();
            div.setStyle("text-align: right");
            div.appendChild((Component)label);
            this.m_row.appendChild((Component)div);
            this.m_row.appendChild(editor.getComponent());
        }
        editor.fillHorizontal();
        editor.dynamicDisplay();
        this.m_newRow = !this.m_newRow;
    }

    private void loadInfo(int C_ValidCombination_ID, int C_AcctSchema_ID) {
        block8: {
            if (log.isLoggable(Level.FINE)) {
                log.fine("C_ValidCombination_ID=" + C_ValidCombination_ID);
            }
            String sql = "SELECT * FROM C_ValidCombination WHERE C_ValidCombination_ID=? AND C_AcctSchema_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_ValidCombination_ID);
                    pstmt.setInt(2, C_AcctSchema_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        if (this.f_Alias != null) {
                            this.f_Alias.setValue(rs.getString("Alias"));
                        }
                        this.f_Combination.setValue(rs.getString("Combination"));
                        this.loadInfoOf(rs, this.f_AD_Org_ID, "AD_Org_ID");
                        this.loadInfoOf(rs, this.f_Account_ID, "Account_ID");
                        this.loadInfoOf(rs, this.f_SubAcct_ID, "C_SubAcct_ID");
                        this.loadInfoOf(rs, this.f_M_Product_ID, "M_Product_ID");
                        this.loadInfoOf(rs, this.f_C_BPartner_ID, "C_BPartner_ID");
                        this.loadInfoOf(rs, this.f_C_Campaign_ID, "C_Campaign_ID");
                        this.loadInfoOf(rs, this.f_C_LocFrom_ID, "C_LocFrom_ID");
                        this.loadInfoOf(rs, this.f_C_LocTo_ID, "C_LocTo_ID");
                        this.loadInfoOf(rs, this.f_C_Project_ID, "C_Project_ID");
                        this.loadInfoOf(rs, this.f_C_SalesRegion_ID, "C_SalesRegion_ID");
                        this.loadInfoOf(rs, this.f_AD_OrgTrx_ID, "AD_OrgTrx_ID");
                        this.loadInfoOf(rs, this.f_C_Activity_ID, "C_Activity_ID");
                        this.loadInfoOf(rs, this.f_User1_ID, "User1_ID");
                        this.loadInfoOf(rs, this.f_User2_ID, "User2_ID");
                        this.f_Description.setValue(rs.getString("Description"));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void loadInfoOf(ResultSet rs, WEditor editor, String name) throws SQLException {
        if (editor == null) {
            return;
        }
        int intValue = rs.getInt(name);
        if (rs.wasNull()) {
            editor.setValue(null);
        } else {
            editor.setValue(intValue);
        }
    }

    @Override
    public void dispose() {
        this.saveSelection();
        if (this.m_adTabPanel != null) {
            this.m_adTabPanel.detach();
        }
        this.m_adTabPanel = null;
        this.m_mTab = null;
        if (this.m_mWindow != null) {
            this.m_mWindow.dispose();
        }
        this.m_mWindow = null;
        Env.clearWinContext((int)this.m_WindowNo);
        this.onClose();
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.m_callback != null) {
            this.m_callback.onCallback((Object)this.getValue());
        }
    }

    private void saveSelection() {
        if (this.m_changed && this.m_adTabPanel != null) {
            int row = this.m_adTabPanel.getGridTab().getCurrentRow();
            if (row >= 0) {
                this.m_C_ValidCombination_ID = (Integer)this.m_mTab.getValue(row, "C_ValidCombination_ID");
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("(" + row + ") - " + this.m_C_ValidCombination_ID);
            }
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Ok")) {
            MAccount combiOrg = new MAccount(Env.getCtx(), this.IDvalue > 0 ? this.IDvalue : this.m_mAccount.C_ValidCombination_ID, null);
            boolean needconfirm = false;
            if (this.needConfirm(this.f_AD_Org_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_Account_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_SubAcct_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_BPartner_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_M_Product_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_Activity_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_LocFrom_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_LocTo_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_Campaign_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_AD_OrgTrx_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_Project_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_C_SalesRegion_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_User1_ID, combiOrg)) {
                needconfirm = true;
            } else if (this.needConfirm(this.f_User2_ID, combiOrg)) {
                needconfirm = true;
            }
            if (needconfirm) {
                FDialog.ask(this.m_WindowNo, (Component)this, "CreateNewAccountCombination?", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue() && WAccountDialog.this.action_Save()) {
                            WAccountDialog.this.m_changed = true;
                            WAccountDialog.this.dispose();
                        }
                    }
                });
            } else {
                this.m_changed = true;
                this.dispose();
            }
        } else if (event.getTarget().getId().equals("Cancel")) {
            this.m_changed = false;
            this.dispose();
        } else if (event.getTarget() == this.bSave) {
            this.action_Save();
        } else if (event.getTarget() == this.bIgnore) {
            this.action_Ignore();
        } else {
            this.action_Find(true);
        }
    }

    boolean needConfirm(WEditor editor, MAccount combiOrg) {
        if (editor != null) {
            String columnName = editor.getColumnName();
            String oldValue = combiOrg.get_ValueAsString(columnName);
            String newValue = "";
            if (editor.getValue() != null) {
                newValue = editor.getValue().toString();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("columnName : " + columnName + " : " + oldValue + " - " + newValue);
            }
            return !oldValue.equals(newValue);
        }
        return false;
    }

    public void dataStatusChanged(DataStatusEvent e) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(e.toString());
        }
        String info = (String)this.m_mTab.getValue("Description");
        if (Executions.getCurrent() != null) {
            this.f_Description.setValue(info);
        }
    }

    private void action_Find(boolean includeAliasCombination) {
        String value;
        log.info("");
        MQuery query = null;
        query = this.m_query != null ? this.m_query.deepCopy() : new MQuery();
        if (includeAliasCombination && this.f_Alias != null && !this.isEmpty(this.f_Alias)) {
            value = this.f_Alias.getValue().toString().toUpperCase();
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            query.addRestriction("UPPER(Alias)", " LIKE ", (Object)value);
        }
        if (includeAliasCombination && !this.isEmpty(this.f_Combination.getValue())) {
            value = this.f_Combination.getValue().toString().toUpperCase();
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            query.addRestriction("UPPER(Combination)", " LIKE ", (Object)value);
        }
        if (this.f_AD_Org_ID != null && !this.isEmpty(this.f_AD_Org_ID.getValue())) {
            query.addRestriction("AD_Org_ID", "=", this.f_AD_Org_ID.getValue());
        }
        if (this.f_Account_ID != null && !this.isEmpty(this.f_Account_ID.getValue())) {
            query.addRestriction("Account_ID", "=", this.f_Account_ID.getValue());
        }
        if (this.f_SubAcct_ID != null && !this.isEmpty(this.f_SubAcct_ID.getValue())) {
            query.addRestriction("C_SubAcct_ID", "=", this.f_SubAcct_ID.getValue());
        }
        if (this.f_M_Product_ID != null && !this.isEmpty(this.f_M_Product_ID.getValue())) {
            query.addRestriction("M_Product_ID", "=", this.f_M_Product_ID.getValue());
        }
        if (this.f_C_BPartner_ID != null && !this.isEmpty(this.f_C_BPartner_ID.getValue())) {
            query.addRestriction("C_BPartner_ID", "=", this.f_C_BPartner_ID.getValue());
        }
        if (this.f_C_Campaign_ID != null && !this.isEmpty(this.f_C_Campaign_ID.getValue())) {
            query.addRestriction("C_Campaign_ID", "=", this.f_C_Campaign_ID.getValue());
        }
        if (this.f_C_LocFrom_ID != null && !this.isEmpty(this.f_C_LocFrom_ID.getValue())) {
            query.addRestriction("C_LocFrom_ID", "=", this.f_C_LocFrom_ID.getValue());
        }
        if (this.f_C_LocTo_ID != null && !this.isEmpty(this.f_C_LocTo_ID.getValue())) {
            query.addRestriction("C_LocTo_ID", "=", this.f_C_LocTo_ID.getValue());
        }
        if (this.f_C_Project_ID != null && !this.isEmpty(this.f_C_Project_ID.getValue())) {
            query.addRestriction("C_Project_ID", "=", this.f_C_Project_ID.getValue());
        }
        if (this.f_C_SalesRegion_ID != null && !this.isEmpty(this.f_C_SalesRegion_ID.getValue())) {
            query.addRestriction("C_SalesRegion_ID", "=", this.f_C_SalesRegion_ID.getValue());
        }
        if (this.f_AD_OrgTrx_ID != null && !this.isEmpty(this.f_AD_OrgTrx_ID.getValue())) {
            query.addRestriction("AD_OrgTrx_ID", "=", this.f_AD_OrgTrx_ID.getValue());
        }
        if (this.f_C_Activity_ID != null && !this.isEmpty(this.f_C_Activity_ID.getValue())) {
            query.addRestriction("C_Activity_ID", "=", this.f_C_Activity_ID.getValue());
        }
        if (this.f_User1_ID != null && !this.isEmpty(this.f_User1_ID.getValue())) {
            query.addRestriction("User1_ID", "=", this.f_User1_ID.getValue());
        }
        if (this.f_User2_ID != null && !this.isEmpty(this.f_User2_ID.getValue())) {
            query.addRestriction("User2_ID", "=", this.f_User2_ID.getValue());
        }
        this.m_mTab.setQuery(query);
        this.m_mTab.query(false);
        this.statusBar.setStatusDB(String.valueOf(this.m_mTab.getRowCount()));
    }

    private boolean action_Save() {
        MAccount acct;
        String Alias;
        StringBuilder sql;
        block96: {
            log.info("");
            StringBuilder sb = new StringBuilder();
            sql = new StringBuilder("SELECT C_ValidCombination_ID, Alias FROM C_ValidCombination WHERE ");
            Object value = null;
            if (s_AcctSchema.isHasAlias() && this.isEmpty(value = this.f_Alias.getValue().toString()) && this.f_Alias.isMandatory()) {
                sb.append(Msg.translate((Properties)Env.getCtx(), (String)"Alias")).append(", ");
            }
            MAcctSchemaElement[] elements = s_AcctSchema.getAcctSchemaElements();
            int i = 0;
            while (i < elements.length) {
                MAcctSchemaElement ase = elements[i];
                String type = ase.getElementType();
                if (type.equals("OO")) {
                    value = this.f_AD_Org_ID.getValue();
                    sql.append("AD_Org_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("AC")) {
                    value = this.f_Account_ID.getValue();
                    sql.append("Account_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("SA")) {
                    value = this.f_SubAcct_ID.getValue();
                    sql.append("C_SubAcct_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("PR")) {
                    value = this.f_M_Product_ID.getValue();
                    sql.append("M_Product_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("BP")) {
                    value = this.f_C_BPartner_ID.getValue();
                    sql.append("C_BPartner_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("MC")) {
                    value = this.f_C_Campaign_ID.getValue();
                    sql.append("C_Campaign_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("LF")) {
                    value = this.f_C_LocFrom_ID.getValue();
                    sql.append("C_LocFrom_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("LT")) {
                    value = this.f_C_LocTo_ID.getValue();
                    sql.append("C_LocTo_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("PJ")) {
                    value = this.f_C_Project_ID.getValue();
                    sql.append("C_Project_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("SR")) {
                    value = this.f_C_SalesRegion_ID.getValue();
                    sql.append("C_SalesRegion_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("OT")) {
                    value = this.f_AD_OrgTrx_ID.getValue();
                    sql.append("AD_OrgTrx_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("AY")) {
                    value = this.f_C_Activity_ID.getValue();
                    sql.append("C_Activity_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("U1")) {
                    value = this.f_User1_ID.getValue();
                    sql.append("User1_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                } else if (type.equals("U2")) {
                    value = this.f_User2_ID.getValue();
                    sql.append("User2_ID");
                    if (this.isEmpty(value)) {
                        sql.append(" IS NULL AND ");
                    } else {
                        sql.append("=").append(value).append(" AND ");
                    }
                }
                if (ase.isMandatory() && this.isEmpty(value)) {
                    sb.append(ase.getName()).append(", ");
                }
                ++i;
            }
            if (sb.length() != 0) {
                FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", sb.substring(0, sb.length() - 2));
                return false;
            }
            if (this.f_AD_Org_ID == null || this.f_AD_Org_ID.getValue() == null) {
                FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID"));
                return false;
            }
            if (this.f_Account_ID == null || this.f_Account_ID.getValue() == null) {
                FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", Msg.getElement((Properties)Env.getCtx(), (String)"Account_ID"));
                return false;
            }
            sql.append("AD_Client_ID=? AND C_AcctSchema_ID=?");
            if (log.isLoggable(Level.FINE)) {
                log.fine("Check = " + sql.toString());
            }
            Alias = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    pstmt.setInt(2, s_AcctSchema.getC_AcctSchema_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.IDvalue = rs.getInt(1);
                        Alias = rs.getString(2);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    this.IDvalue = 0;
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block96;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ID=" + this.IDvalue + ", Alias=" + Alias);
        }
        if (Alias == null) {
            Alias = "";
        }
        if (this.IDvalue != 0 && s_AcctSchema.isHasAlias() && !this.f_Alias.getValue().toString().equals(Alias)) {
            int i;
            block98: {
                sql = new StringBuilder("UPDATE C_ValidCombination SET Alias=");
                if (this.f_Alias.getValue().toString().length() == 0) {
                    sql.append("NULL");
                } else {
                    sql.append("'").append(this.f_Alias.getValue()).append("'");
                }
                sql.append(" WHERE C_ValidCombination_ID=").append(this.IDvalue);
                i = 0;
                CPreparedStatement stmt = null;
                try {
                    try {
                        stmt = DB.prepareStatement((String)sql.toString(), (int)1003, (int)1008, null);
                        i = stmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                        DB.close((Statement)stmt);
                        stmt = null;
                        break block98;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(stmt);
                    stmt = null;
                    throw throwable;
                }
                DB.close((Statement)stmt);
                stmt = null;
            }
            if (i == 0) {
                FDialog.error(this.m_WindowNo, (Component)this, "AccountNotUpdated");
            }
        }
        if (this.IDvalue != 0) {
            this.loadInfo(this.IDvalue, s_AcctSchema.getC_AcctSchema_ID());
            this.action_Find(false);
            return true;
        }
        log.config("New");
        Alias = null;
        if (this.f_Alias != null) {
            Alias = this.f_Alias.getValue().toString();
        }
        int C_SubAcct_ID = 0;
        if (this.f_SubAcct_ID != null && !this.isEmpty(this.f_SubAcct_ID.getValue())) {
            C_SubAcct_ID = (Integer)this.f_SubAcct_ID.getValue();
        }
        int M_Product_ID = 0;
        if (this.f_M_Product_ID != null && !this.isEmpty(this.f_M_Product_ID.getValue())) {
            M_Product_ID = (Integer)this.f_M_Product_ID.getValue();
        }
        int C_BPartner_ID = 0;
        if (this.f_C_BPartner_ID != null && !this.isEmpty(this.f_C_BPartner_ID.getValue())) {
            C_BPartner_ID = (Integer)this.f_C_BPartner_ID.getValue();
        }
        int AD_OrgTrx_ID = 0;
        if (this.f_AD_OrgTrx_ID != null && !this.isEmpty(this.f_AD_OrgTrx_ID.getValue())) {
            AD_OrgTrx_ID = (Integer)this.f_AD_OrgTrx_ID.getValue();
        }
        int C_LocFrom_ID = 0;
        if (this.f_C_LocFrom_ID != null && !this.isEmpty(this.f_C_LocFrom_ID.getValue())) {
            C_LocFrom_ID = (Integer)this.f_C_LocFrom_ID.getValue();
        }
        int C_LocTo_ID = 0;
        if (this.f_C_LocTo_ID != null && !this.isEmpty(this.f_C_LocTo_ID.getValue())) {
            C_LocTo_ID = (Integer)this.f_C_LocTo_ID.getValue();
        }
        int C_SRegion_ID = 0;
        if (this.f_C_SalesRegion_ID != null && !this.isEmpty(this.f_C_SalesRegion_ID.getValue())) {
            C_SRegion_ID = (Integer)this.f_C_SalesRegion_ID.getValue();
        }
        int C_Project_ID = 0;
        if (this.f_C_Project_ID != null && !this.isEmpty(this.f_C_Project_ID.getValue())) {
            C_Project_ID = (Integer)this.f_C_Project_ID.getValue();
        }
        int C_Campaign_ID = 0;
        if (this.f_C_Campaign_ID != null && !this.isEmpty(this.f_C_Campaign_ID.getValue())) {
            C_Campaign_ID = (Integer)this.f_C_Campaign_ID.getValue();
        }
        int C_Activity_ID = 0;
        if (this.f_C_Activity_ID != null && !this.isEmpty(this.f_C_Activity_ID.getValue())) {
            C_Activity_ID = (Integer)this.f_C_Activity_ID.getValue();
        }
        int User1_ID = 0;
        if (this.f_User1_ID != null && !this.isEmpty(this.f_User1_ID.getValue())) {
            User1_ID = (Integer)this.f_User1_ID.getValue();
        }
        int User2_ID = 0;
        if (this.f_User2_ID != null && !this.isEmpty(this.f_User2_ID.getValue())) {
            User2_ID = (Integer)this.f_User2_ID.getValue();
        }
        if ((acct = MAccount.get((Properties)Env.getCtx(), (int)this.m_AD_Client_ID, (int)((Integer)this.f_AD_Org_ID.getValue()), (int)s_AcctSchema.getC_AcctSchema_ID(), (int)((Integer)this.f_Account_ID.getValue()), (int)C_SubAcct_ID, (int)M_Product_ID, (int)C_BPartner_ID, (int)AD_OrgTrx_ID, (int)C_LocFrom_ID, (int)C_LocTo_ID, (int)C_SRegion_ID, (int)C_Project_ID, (int)C_Campaign_ID, (int)C_Activity_ID, (int)User1_ID, (int)User2_ID, (int)0, (int)0, null)) != null && acct.get_ID() == 0) {
            acct.saveEx();
        }
        if (acct == null || acct.get_ID() == 0) {
            this.loadInfo(0, 0);
        } else {
            if (Alias != null && Alias.length() > 0) {
                acct.setAlias(Alias);
                acct.saveEx();
            }
            this.loadInfo(acct.get_ID(), s_AcctSchema.getC_AcctSchema_ID());
        }
        this.IDvalue = acct.get_ID();
        this.action_Find(false);
        return true;
    }

    private boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).trim().length() == 0;
        }
        return false;
    }

    private void action_Ignore() {
        if (this.f_Alias != null) {
            this.f_Alias.setValue("");
        }
        this.f_Combination.setValue("");
        this.f_Description.setValue("");
        this.f_AD_Org_ID.setValue(null);
        this.f_Account_ID.setValue(null);
        if (this.f_SubAcct_ID != null) {
            this.f_SubAcct_ID.setValue(null);
        }
        if (this.f_M_Product_ID != null) {
            this.f_M_Product_ID.setValue(null);
        }
        if (this.f_C_BPartner_ID != null) {
            this.f_C_BPartner_ID.setValue(null);
        }
        if (this.f_C_Campaign_ID != null) {
            this.f_C_Campaign_ID.setValue(null);
        }
        if (this.f_C_LocFrom_ID != null) {
            this.f_C_LocFrom_ID.setValue(null);
        }
        if (this.f_C_LocTo_ID != null) {
            this.f_C_LocTo_ID.setValue(null);
        }
        if (this.f_C_Project_ID != null) {
            this.f_C_Project_ID.setValue(null);
        }
        if (this.f_C_SalesRegion_ID != null) {
            this.f_C_SalesRegion_ID.setValue(null);
        }
        if (this.f_AD_OrgTrx_ID != null) {
            this.f_AD_OrgTrx_ID.setValue(null);
        }
        if (this.f_C_Activity_ID != null) {
            this.f_C_Activity_ID.setValue(null);
        }
        if (this.f_User1_ID != null) {
            this.f_User1_ID.setValue(null);
        }
        if (this.f_User2_ID != null) {
            this.f_User2_ID.setValue(null);
        }
    }

    public Integer getValue() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_ValidCombination_ID=" + this.m_C_ValidCombination_ID + ", Changed=" + this.m_changed);
        }
        if (!this.m_changed || this.m_C_ValidCombination_ID == 0) {
            return null;
        }
        return this.m_C_ValidCombination_ID;
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (newValue instanceof Integer) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"Account_ID", (int)((Integer)newValue));
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (String)"Account_ID", (int)((Integer)newValue));
            if (this.f_SubAcct_ID != null) {
                this.f_SubAcct_ID.setValue(null);
                this.f_SubAcct_ID.dynamicDisplay();
            }
        }
    }

    protected void onClientInfo() {
        boolean smallWidth;
        if (this.parameterLayout != null && this.parameterLayout.getRows() != null && (smallWidth = ClientInfo.maxWidth(699)) != this.m_smallWidth) {
            this.parameterLayout.getRows().detach();
            this.layoutParameters();
            if (ThemeManager.isUseCSSForWindowSize()) {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            }
            this.invalidate();
        }
    }
}

