/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Locale;
import java.util.Properties;
import org.adempiere.webui.IWebClient;
import org.adempiere.webui.component.FWindow;
import org.adempiere.webui.panel.ChangePasswordPanel;
import org.adempiere.webui.panel.LoginPanel;
import org.adempiere.webui.panel.ResetPasswordPanel;
import org.adempiere.webui.panel.RolePanel;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Clients;

public class LoginWindow
extends FWindow
implements EventListener<Event> {
    private static final long serialVersionUID = -5169830531440825871L;
    protected IWebClient app;
    protected Properties ctx;
    protected LoginPanel pnlLogin;
    protected ResetPasswordPanel pnlResetPassword;
    protected ChangePasswordPanel pnlChangePassword;
    protected RolePanel pnlRole;

    public void init(IWebClient app) {
        this.ctx = Env.getCtx();
        this.app = app;
        this.initComponents();
        this.appendChild((Component)this.pnlLogin);
        this.setStyle("background-color: transparent");
        this.addEventListener("onOK", this);
        this.setWidgetListener("onOK", "zAu.cmd0.showBusy(null)");
    }

    private void initComponents() {
        this.createLoginPanel();
    }

    protected void createLoginPanel() {
        this.pnlLogin = new LoginPanel(this.ctx, this);
    }

    public void loginOk(String userName, boolean show, KeyNamePair[] clientsKNPairs) {
        this.createRolePanel(userName, show, clientsKNPairs);
        this.getChildren().clear();
        this.appendChild((Component)this.pnlRole);
    }

    protected void createRolePanel(String userName, boolean show, KeyNamePair[] clientsKNPairs) {
        this.pnlRole = new RolePanel(this.ctx, this, userName, show, clientsKNPairs);
    }

    public void changePassword(String userName, String userPassword, boolean show, KeyNamePair[] clientsKNPairs) {
        Clients.clearBusy();
        this.createChangePasswordPanel(userName, userPassword, show, clientsKNPairs);
        this.getChildren().clear();
        this.appendChild((Component)this.pnlChangePassword);
    }

    protected void createChangePasswordPanel(String userName, String userPassword, boolean show, KeyNamePair[] clientsKNPairs) {
        this.pnlChangePassword = new ChangePasswordPanel(this.ctx, this, userName, userPassword, show, clientsKNPairs);
    }

    public void resetPassword(String userName, boolean noSecurityQuestion) {
        this.createResetPasswordPanel(userName, noSecurityQuestion);
        this.getChildren().clear();
        this.appendChild((Component)this.pnlResetPassword);
    }

    protected void createResetPasswordPanel(String userName, boolean noSecurityQuestion) {
        this.pnlResetPassword = new ResetPasswordPanel(this.ctx, this, userName, noSecurityQuestion);
    }

    public void loginCompleted() {
        this.app.loginCompleted();
    }

    public void loginCancelled() {
        this.createLoginPanel();
        this.getChildren().clear();
        this.appendChild((Component)this.pnlLogin);
    }

    public void onEvent(Event event) {
        if ("onOK".equals(event.getName())) {
            RolePanel rolePanel = (RolePanel)this.getFellowIfAny("rolePanel");
            if (rolePanel != null) {
                rolePanel.validateRoles();
                return;
            }
            LoginPanel loginPanel = (LoginPanel)this.getFellowIfAny("loginPanel");
            if (loginPanel != null) {
                loginPanel.validateLogin();
                return;
            }
            ChangePasswordPanel changePasswordPanel = (ChangePasswordPanel)this.getFellowIfAny("changePasswordPanel");
            if (changePasswordPanel != null) {
                changePasswordPanel.validateChangePassword();
                return;
            }
            ResetPasswordPanel resetPasswordPanel = (ResetPasswordPanel)this.getFellowIfAny("resetPasswordPanel");
            if (resetPasswordPanel != null) {
                resetPasswordPanel.validate();
                return;
            }
        }
    }

    public void changeRole(Locale locale, Properties ctx) {
        Env.setCtx((Properties)ctx);
        PageDefinition pageDefintion = Executions.getCurrent().getPageDefinition(ThemeManager.getThemeResource("preference.zul"));
        Executions.createComponents((PageDefinition)pageDefintion, (Component)this, null);
        this.getDesktop().getSession().setAttribute("org.zkoss.web.preferred.locale", (Object)locale);
        Locales.setThreadLocal((Locale)locale);
        Login login = new Login(Env.getCtx());
        MUser user = MUser.get((Properties)ctx, (int)Env.getAD_User_ID((Properties)ctx));
        boolean email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
        String loginName = email_login ? user.getEMail() : (user.getLDAPUser() != null ? user.getLDAPUser() : user.getName());
        this.loginOk(loginName, true, login.getClients());
        this.getDesktop().getSession().setAttribute("Check_AD_User_ID", (Object)Env.getAD_User_ID((Properties)ctx));
        this.pnlRole.setChangeRole(true);
        this.pnlRole.changeRole(ctx);
    }
}

