/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.panel.WSchedule;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.WAssignmentDialog;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.ScheduleUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.event.CalendarsEvent;
import org.zkoss.calendar.impl.SimpleCalendarEvent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;

public class InfoSchedule
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -5948901371276429661L;
    private Callback<MResourceAssignment> m_callback;
    private Component m_parent;
    private MResourceAssignment m_mAssignment;
    private Timestamp m_dateFrom = null;
    private boolean m_loading = false;
    private boolean m_createNew;
    private static CLogger log = CLogger.getCLogger(InfoSchedule.class);
    private Vbox mainLayout = new Vbox();
    private Hlayout parameterPanel = new Hlayout();
    private Label labelResourceType = new Label();
    private Listbox fieldResourceType = new Listbox();
    private Label labelResource = new Label();
    private Listbox fieldResource = new Listbox();
    private WSchedule schedulePane = new WSchedule(this);
    private ConfirmPanel confirmPanel = null;
    private WAssignmentDialog vad;
    private boolean m_cancel = false;
    private Mask mask;

    public InfoSchedule(MResourceAssignment mAssignment, boolean createNew) {
        this(mAssignment, createNew, null);
    }

    public InfoSchedule(MResourceAssignment mAssignment, boolean createNew, Callback<MResourceAssignment> callback) {
        this(mAssignment, createNew, null, callback);
    }

    public InfoSchedule(MResourceAssignment mAssignment, boolean createNew, Component parent, Callback<MResourceAssignment> callback) {
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoSchedule"));
        if (createNew) {
            this.setAttribute("mode", "highlighted");
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 700);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 600);
            this.setSizable(true);
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        }
        this.setClosable(true);
        this.setBorder("normal");
        this.setStyle("position: absolute");
        this.m_mAssignment = mAssignment == null ? new MResourceAssignment(Env.getCtx(), 0, null) : mAssignment;
        if (mAssignment != null) {
            log.info(mAssignment.toString());
        }
        this.m_dateFrom = this.m_mAssignment.getAssignDateFrom();
        if (this.m_dateFrom == null) {
            this.m_dateFrom = new Timestamp(System.currentTimeMillis());
        }
        this.m_createNew = createNew;
        this.m_callback = callback;
        this.m_parent = parent;
        if (callback != null) {
            this.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (!InfoSchedule.this.m_cancel) {
                        InfoSchedule.this.m_callback.onCallback((Object)InfoSchedule.this.getMResourceAssignment());
                    } else {
                        InfoSchedule.this.m_callback.onCallback(null);
                    }
                }
            });
        }
        try {
            this.init();
            this.dynInit(createNew);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "InfoSchedule", (Throwable)ex);
        }
        this.displayCalendar();
    }

    public InfoSchedule() {
        this(null, false);
    }

    private void init() throws Exception {
        this.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        this.labelResourceType.setValue(Msg.translate((Properties)Env.getCtx(), (String)"S_ResourceType_ID"));
        this.labelResource.setValue(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"));
        this.parameterPanel.setValign("middle");
        this.parameterPanel.appendChild((Component)this.labelResourceType);
        this.parameterPanel.appendChild((Component)this.fieldResourceType);
        this.parameterPanel.appendChild((Component)new Space());
        this.parameterPanel.appendChild((Component)this.labelResource);
        this.parameterPanel.appendChild((Component)this.fieldResource);
        this.mainLayout.appendChild((Component)this.schedulePane);
        this.schedulePane.addNorthPane((Component)this.parameterPanel);
        if (this.m_createNew) {
            Div div = new Div();
            this.confirmPanel = new ConfirmPanel(true);
            div.appendChild((Component)this.confirmPanel);
            this.schedulePane.addSouthPane((Component)div, "80px");
            this.schedulePane.addEventListener("onEventCreate", this);
            this.schedulePane.addEventListener("onEventEdit", this);
            this.schedulePane.addEventListener("onEventUpdate", this);
            this.schedulePane.removeRefreshButton();
        } else {
            this.schedulePane.addEventListener("onEventEdit", this);
            this.schedulePane.addEventListener("onEventUpdate", this);
        }
        this.fieldResourceType.setMold("select");
        this.fieldResource.setMold("select");
    }

    private void dynInit(boolean createNew) {
        this.fillResourceType();
        this.fillResource();
        this.fieldResourceType.addEventListener("onSelect", this);
        this.fieldResource.addEventListener("onSelect", this);
        if (createNew) {
            this.confirmPanel.addActionListener("onClick", this);
        }
    }

    private void fillResourceType() {
        KeyNamePair defaultValue;
        block20: {
            String sql;
            int S_ResourceType_ID;
            block18: {
                S_ResourceType_ID = 0;
                if (this.m_mAssignment.getS_Resource_ID() != 0) {
                    sql = "SELECT S_ResourceType_ID FROM S_Resource WHERE S_Resource_ID=?";
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, null);
                            pstmt.setInt(1, this.m_mAssignment.getS_Resource_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                S_ResourceType_ID = rs.getInt(1);
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.SEVERE, sql, (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            sql = MRole.getDefault().addAccessSQL("SELECT S_ResourceType_ID, Name FROM S_ResourceType WHERE IsActive='Y' ORDER BY 2", "S_ResourceType", false, false);
            defaultValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        if (S_ResourceType_ID == pp.getKey()) {
                            defaultValue = pp;
                        }
                        this.fieldResourceType.appendItem(pp.getName(), pp.getKey());
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (defaultValue != null) {
            int cnt = this.fieldResourceType.getItemCount();
            int i = 0;
            while (i < cnt) {
                ListItem li = this.fieldResourceType.getItemAtIndex(i);
                Integer key = (Integer)li.getValue();
                if (key.intValue() == defaultValue.getKey()) {
                    this.fieldResourceType.setSelectedItem(li);
                    break;
                }
                ++i;
            }
        } else if (this.fieldResourceType.getItemCount() > 0) {
            this.fieldResourceType.setSelectedIndex(0);
        }
    }

    private void fillResource() {
        KeyNamePair defaultValue;
        block13: {
            ListItem listItem = this.fieldResourceType.getSelectedItem();
            if (listItem == null) {
                return;
            }
            KeyNamePair pp = new KeyNamePair(((Integer)listItem.getValue()).intValue(), listItem.getLabel());
            int S_ResourceType_ID = pp.getKey();
            defaultValue = null;
            this.m_loading = true;
            this.fieldResource.getChildren().clear();
            String sql = "SELECT S_Resource_ID, Name FROM S_Resource WHERE S_ResourceType_ID=? ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, S_ResourceType_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        if (this.m_mAssignment.getS_Resource_ID() == pp.getKey()) {
                            defaultValue = pp;
                        }
                        this.fieldResource.appendItem(pp.getName(), pp.getKey());
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (defaultValue != null) {
            int cnt = this.fieldResource.getItemCount();
            int i = 0;
            while (i < cnt) {
                ListItem li = this.fieldResource.getItemAtIndex(i);
                Integer key = (Integer)li.getValue();
                if (key.intValue() == defaultValue.getKey()) {
                    this.fieldResource.setSelectedItem(li);
                    break;
                }
                ++i;
            }
        } else if (this.fieldResource.getItemCount() > 0) {
            this.fieldResource.setSelectedIndex(0);
        }
        this.m_loading = false;
    }

    private void displayCalendar() {
        ListItem listItem = this.fieldResource.getSelectedItem();
        if (listItem == null) {
            return;
        }
        KeyNamePair pp = new KeyNamePair(((Integer)listItem.getValue()).intValue(), listItem.getLabel());
        int S_Resource_ID = pp.getKey();
        this.m_mAssignment.setS_Resource_ID(S_Resource_ID);
        Timestamp date = this.m_dateFrom;
        if (date == null) {
            date = new Timestamp(System.currentTimeMillis());
        }
        this.m_loading = true;
        this.schedulePane.recreate(S_Resource_ID, date);
        this.m_loading = false;
        this.invalidate();
    }

    @Override
    public void dispose() {
        this.detach();
    }

    public void mAssignmentCallback(MResourceAssignment assignment, boolean createNew, boolean cancelled) {
        this.hideBusyMask();
        if (!cancelled) {
            this.m_mAssignment = assignment;
            if (createNew) {
                this.dispose();
            } else {
                this.displayCalendar();
            }
        } else {
            this.displayCalendar();
        }
    }

    public MResourceAssignment getMResourceAssignment() {
        return this.m_mAssignment;
    }

    public void onEvent(Event event) throws Exception {
        if (this.m_loading) {
            return;
        }
        if (event.getTarget().getId().equals("Ok")) {
            this.m_cancel = false;
            this.dispose();
        } else if (event.getTarget().getId().equals("Cancel")) {
            this.m_cancel = true;
            this.dispose();
        } else if (event.getTarget() == this.fieldResourceType) {
            this.fillResource();
            this.displayCalendar();
        } else if (event instanceof CalendarsEvent) {
            this.doEdit((CalendarsEvent)event);
        } else if (event.getTarget() == this.fieldResource) {
            this.displayCalendar();
        }
    }

    private void doEdit(CalendarsEvent event) {
        ListItem listItem = this.fieldResource.getSelectedItem();
        if (listItem == null) {
            return;
        }
        KeyNamePair pp = new KeyNamePair(((Integer)listItem.getValue()).intValue(), listItem.getLabel());
        int S_Resource_ID = pp.getKey();
        ScheduleUtil schedule = new ScheduleUtil(Env.getCtx());
        Timestamp start = new Timestamp(event.getBeginDate() != null ? event.getBeginDate().getTime() : event.getCalendarEvent().getBeginDate().getTime());
        Timestamp end = new Timestamp(event.getEndDate() != null ? event.getEndDate().getTime() : event.getCalendarEvent().getEndDate().getTime());
        double hours = (double)(end.getTime() - start.getTime()) / 1000.0 / 60.0 / 60.0;
        MAssignmentSlot[] mas = schedule.getAssignmentSlots(S_Resource_ID, TimeUtil.getPreviousDay((Timestamp)start), TimeUtil.getNextDay((Timestamp)end), null, true, null);
        MAssignmentSlot slot = null;
        int i = 0;
        while (i < mas.length) {
            if (mas[i].getStartTime().getTime() == start.getTime()) {
                slot = mas[i];
                break;
            }
            if (mas[i].getEndTime() != null) {
                if (start.getTime() > mas[i].getStartTime().getTime() && start.getTime() < mas[i].getEndTime().getTime()) {
                    slot = mas[i];
                    break;
                }
                if (end.getTime() > mas[i].getStartTime().getTime() && end.getTime() < mas[i].getEndTime().getTime()) {
                    slot = mas[i];
                    break;
                }
                if (start.getTime() < mas[i].getStartTime().getTime() && end.getTime() >= mas[i].getEndTime().getTime()) {
                    slot = mas[i];
                    break;
                }
            }
            ++i;
        }
        if (slot == null) {
            MResourceAssignment ma = this.m_mAssignment == null ? new MResourceAssignment(Env.getCtx(), 0, null) : this.m_mAssignment;
            ma.setS_Resource_ID(S_Resource_ID);
            ma.setAssignDateFrom(start);
            ma.setQty(BigDecimal.valueOf(hours));
            if (this.m_parent == null || this.m_callback == null) {
                boolean createNew = true;
                if (this.vad != null && this.vad.getPage() != null) {
                    this.vad.detach();
                }
                this.vad = new WAssignmentDialog(ma, false, true);
                if (event.getBeginDate() != null && event.getEndDate() != null) {
                    SimpleCalendarEvent newEvent = new SimpleCalendarEvent();
                    newEvent.setBeginDate(event.getBeginDate());
                    newEvent.setEndDate(event.getEndDate());
                    if (event.getCalendarEvent() != null) {
                        newEvent.setContent(event.getCalendarEvent().getContent());
                        newEvent.setContentColor(event.getCalendarEvent().getContentColor());
                        newEvent.setHeaderColor(event.getCalendarEvent().getHeaderColor());
                        newEvent.setTitle(event.getCalendarEvent().getTitle());
                        this.schedulePane.getModel().remove(event.getCalendarEvent());
                    }
                    this.schedulePane.getModel().add((CalendarEvent)newEvent);
                }
                this.vad.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        InfoSchedule.this.mAssignmentCallback(InfoSchedule.this.vad.getMResourceAssignment(), true, InfoSchedule.this.vad.isCancelled());
                    }
                });
                this.vad.setTitle(null);
                ZkCssHelper.appendStyle((HtmlBasedComponent)this.vad, "position: absolute");
                this.showBusyMask();
                this.appendChild((Component)this.vad);
                LayoutUtils.openOverlappedWindow((Component)this, this.vad, "middle_center");
                this.vad.focus();
            } else {
                this.m_cancel = false;
                this.m_mAssignment = ma;
                this.dispose();
            }
        } else {
            if (!slot.isAssignment()) {
                FDialog.error(0, (Component)this, "No available time slot for the selected day.");
                return;
            }
            MResourceAssignment ma = slot.getMAssignment();
            ma.setAssignDateFrom(start);
            ma.setQty(BigDecimal.valueOf(hours));
            if (this.m_parent == null || this.m_callback == null) {
                if (event.getBeginDate() != null && event.getEndDate() != null) {
                    SimpleCalendarEvent newEvent = new SimpleCalendarEvent();
                    newEvent.setBeginDate(event.getBeginDate());
                    newEvent.setEndDate(event.getEndDate());
                    if (event.getCalendarEvent() != null) {
                        newEvent.setContent(event.getCalendarEvent().getContent());
                        newEvent.setContentColor(event.getCalendarEvent().getContentColor());
                        newEvent.setHeaderColor(event.getCalendarEvent().getHeaderColor());
                        newEvent.setTitle(event.getCalendarEvent().getTitle());
                        this.schedulePane.getModel().remove(event.getCalendarEvent());
                    }
                    this.schedulePane.getModel().add((CalendarEvent)newEvent);
                }
                boolean createNew = false;
                if (this.vad != null && this.vad.getPage() != null) {
                    this.vad.detach();
                }
                this.vad = new WAssignmentDialog(ma, false, false);
                this.vad.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        InfoSchedule.this.mAssignmentCallback(InfoSchedule.this.vad.getMResourceAssignment(), false, InfoSchedule.this.vad.isCancelled());
                    }
                });
                this.vad.setTitle(null);
                ZkCssHelper.appendStyle((HtmlBasedComponent)this.vad, "position: absolute");
                this.showBusyMask();
                this.appendChild((Component)this.vad);
                LayoutUtils.openOverlappedWindow((Component)this, this.vad, "middle_center");
                this.vad.focus();
            } else {
                this.m_cancel = false;
                this.m_mAssignment = ma;
                this.dispose();
            }
        }
    }

    public boolean isCreateNew() {
        return this.m_createNew;
    }

    public void dateCallback(Date date) {
        this.m_dateFrom = new Timestamp(date.getTime());
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            this.displayCalendar();
            SessionManager.getAppDesktop().updateHelpContext("H", 0);
        }
    }

    private Div getMask() {
        if (this.mask == null) {
            this.mask = new Mask();
        }
        return this.mask;
    }

    protected void showBusyMask() {
        this.appendChild((Component)this.getMask());
    }

    protected void hideBusyMask() {
        if (this.mask != null && this.mask.getParent() != null) {
            this.mask.detach();
        }
    }
}

