/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Messagebox;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trace;
import org.zkoss.zk.ui.Component;

public class FDialog {
    private static final CLogger logger = CLogger.getCLogger(FDialog.class);

    private static StringBuffer constructMessage(String adMessage, String message) {
        StringBuffer out = new StringBuffer();
        if (adMessage != null && !adMessage.equals("")) {
            out.append(Msg.getMsg((Properties)Env.getCtx(), (String)adMessage));
        }
        if (message != null && message.length() > 0) {
            out.append("<br>").append(message);
        }
        return out;
    }

    public static void warn(int windowNo, String adMessage, String title) {
        FDialog.warn(windowNo, null, adMessage, null, title);
    }

    public static void warn(int windowNo, Component comp, String adMessage, String message) {
        FDialog.warn(windowNo, comp, adMessage, message, null);
    }

    public static void warn(int windowNo, Component comp, String adMessage, String message, String title) {
        Properties ctx = Env.getCtx();
        StringBuffer out = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(adMessage) + " - " + message);
        }
        out = FDialog.constructMessage(adMessage, message);
        String newTitle = title == null ? AEnv.getDialogHeader(ctx, windowNo) : title;
        String s = out.toString().replace("\n", "<br>");
        Messagebox.showDialog(s, newTitle, 1, "~./zul/img/msgbox/warning-btn.png");
    }

    public static void warn(int windowNo, String adMessage) {
        FDialog.warn(windowNo, null, adMessage, null, null);
    }

    public static void error(int windowNo, Component comp, String adMessage) {
        FDialog.error(windowNo, comp, adMessage, null);
    }

    public static void error(int windowNo, String adMessage) {
        FDialog.error(windowNo, null, adMessage, null);
    }

    public static void error(int windowNo, String adMessage, String msg) {
        FDialog.error(windowNo, null, adMessage, msg);
    }

    public static void error(int windowNo, Component comp, String adMessage, String message) {
        FDialog.error(windowNo, comp, adMessage, message, null);
    }

    public static void error(int windowNo, Component comp, String adMessage, String message, Callback<Integer> callback) {
        FDialog.error(windowNo, comp, adMessage, message, callback, null);
    }

    public static void error(int windowNo, Component comp, String adMessage, String message, String title) {
        FDialog.error(windowNo, comp, adMessage, message, null, title);
    }

    public static void error(int windowNo, Component comp, String adMessage, String message, Callback<Integer> callback, String title) {
        Properties ctx = Env.getCtx();
        StringBuffer out = new StringBuffer();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(adMessage) + " - " + message);
        }
        if (CLogMgt.isLevelFinest()) {
            Trace.printStack();
        }
        out = FDialog.constructMessage(adMessage, message);
        String newTitle = title == null ? AEnv.getDialogHeader(ctx, windowNo) : title;
        String s = out.toString().replace("\n", "<br>");
        Messagebox.showDialog(s, newTitle, 1, "~./zul/img/msgbox/stop-btn.png", callback);
    }

    public static boolean ask(int windowNo, Component comp, String adMessage, String msg) {
        return FDialog.ask(windowNo, comp, adMessage, msg, null);
    }

    public static boolean ask(int windowNo, Component comp, String adMessage, String msg, final Callback<Boolean> callback) {
        String title;
        int response;
        StringBuilder out = new StringBuilder();
        if (adMessage != null && !adMessage.equals("")) {
            out.append(Msg.getMsg((Properties)Env.getCtx(), (String)adMessage));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        String s = out.toString().replace("\n", "<br>");
        Callback<Integer> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<Integer>(){

                public void onCallback(Integer result) {
                    boolean b = result != null && result == 1;
                    callback.onCallback((Object)b);
                }
            };
        }
        return (response = Messagebox.showDialog(s, title = AEnv.getDialogHeader(Env.getCtx(), windowNo), 3, "~./zul/img/msgbox/question-btn.png", msgCallback, msgCallback == null)) == 1;
    }

    public static boolean ask(int windowNo, Component comp, String adMessage) {
        return FDialog.ask(windowNo, comp, adMessage, null);
    }

    public static boolean ask(int windowNo, Component comp, String adMessage, Callback<Boolean> callback) {
        return FDialog.ask(AEnv.getDialogHeader(Env.getCtx(), windowNo), windowNo, comp, adMessage, callback, new Object[0]);
    }

    public static void askForInput(int windowNo, Component comp, String adMessage, final Callback<String> callback) {
        Callback<String> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<String>(){

                public void onCallback(String result) {
                    callback.onCallback((Object)result);
                }
            };
        }
        String s = Msg.getMsg((Properties)Env.getCtx(), (String)adMessage).replace("\n", "<br>");
        Messagebox.showDialog(s, AEnv.getDialogHeader(Env.getCtx(), windowNo), 2049, "~./zul/img/msgbox/question-btn.png", msgCallback, msgCallback == null);
    }

    public static boolean ask(String title, int windowNo, Component comp, String adMessage, final Callback<Boolean> callback, Object ... args) {
        Callback<Integer> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<Integer>(){

                public void onCallback(Integer result) {
                    boolean b = result != null && result == 1;
                    callback.onCallback((Object)b);
                }
            };
        }
        String s = args != null && args.length > 0 ? Msg.getMsg((Properties)Env.getCtx(), (String)adMessage, (Object[])args) : Msg.getMsg((Properties)Env.getCtx(), (String)adMessage);
        int response = Messagebox.showDialog(s = s.replace("\n", "<br>"), title, 3, "~./zul/img/msgbox/question-btn.png", msgCallback, msgCallback == null);
        return response == 1;
    }

    public static void info(int windowNo, Component comp, String adMessage) {
        FDialog.info(windowNo, comp, adMessage, null);
    }

    public static void info(int windowNo, Component comp, String adMessage, String message) {
        FDialog.info(windowNo, comp, adMessage, message, null);
    }

    public static void info(int windowNo, Component comp, String adMessage, String message, String title) {
        Properties ctx = Env.getCtx();
        StringBuffer out = new StringBuffer();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(adMessage) + " - " + message);
        }
        if (CLogMgt.isLevelFinest()) {
            Trace.printStack();
        }
        out = FDialog.constructMessage(adMessage, message);
        String newTitle = title == null ? AEnv.getDialogHeader(ctx, windowNo) : title;
        String s = out.toString().replace("\n", "<br>");
        Messagebox.showDialog(s, newTitle, 1, "~./zul/img/msgbox/info-btn.png");
    }

    public static boolean ask(int windowNo, Component comp, String title, String adMessage, String msg, final Callback<Boolean> callback) {
        String s;
        int response;
        Callback<Integer> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<Integer>(){

                public void onCallback(Integer result) {
                    boolean b = result != null && result == 1;
                    callback.onCallback((Object)b);
                }
            };
        }
        StringBuilder out = new StringBuilder();
        if (adMessage != null && !adMessage.equals("")) {
            out.append(Msg.getMsg((Properties)Env.getCtx(), (String)adMessage));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        return (response = Messagebox.showDialog(s = out.toString().replace("\n", "<br>"), title, 3, "~./zul/img/msgbox/question-btn.png", msgCallback, msgCallback == null)) == 1;
    }
}

