/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.WebUIActivator;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.FolderBrowser;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.FeedbackManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.Adempiere;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MUser;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zhtml.Pre;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Textarea;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;

public class AboutWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8527444729510721269L;
    private Checkbox bErrorsOnly;
    private Listbox logTable;
    private Tabbox tabbox;
    protected Tabpanels tabPanels;
    protected Button btnDownload;
    protected Button btnErrorEmail;
    protected Button btnViewLog;
    protected Tab tabLog;
    protected Tab tabPlugins;
    protected Button btnAdempiereLog;
    private Listbox levelListBox;
    private WListbox pluginsTable;
    private Listbox pluginActions;
    private Button pluginProcess;
    private Vector<Vector<Object>> pluginData;
    private Vector<String> pluginColumnNames;
    private static final int PLUGIN_ACTION_NONE = 0;
    private static final int PLUGIN_ACTION_STOP = 1;
    private static final int PLUGIN_ACTION_START = 2;
    private static final int PLUGIN_ACTION_UPDATE = 3;
    private static final int PLUGIN_ACTION_UNINSTALL = 4;
    private static final int PLUGIN_ACTION_INSTALL = 5;

    public AboutWindow() {
        this.init();
    }

    private void init() {
        System.runFinalization();
        System.gc();
        this.setPosition("center");
        this.setTitle(ThemeManager.getBrowserTitle());
        this.setSclass("popup-dialog about-window");
        this.setClosable(true);
        this.setMaximizable(true);
        this.setSizable(true);
        this.tabbox = new Tabbox();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbox, "1");
        Tabs tabs = new Tabs();
        tabs.setParent((Component)this.tabbox);
        this.tabPanels = new Tabpanels();
        this.tabPanels.setParent((Component)this.tabbox);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabPanels, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabPanels, "1");
        this.initTabs(tabs);
        Button btnOk = ButtonFactory.createNamedButton("Ok");
        btnOk.addEventListener("onClick", this);
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        centerPane.appendChild((Component)this.tabbox);
        South southPane = new South();
        southPane.setStyle("text-align: right");
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)btnOk);
        this.setBorder("normal");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 600);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 450);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
    }

    protected void initTabs(Tabs tabs) {
        Tab tab = new Tab();
        tab.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"About"));
        tab.setParent((Component)tabs);
        Tabpanel tabPanel = this.createAbout();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Credits"));
        tab.setParent((Component)tabs);
        tabPanel = this.createCredit();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Info"));
        tab.setParent((Component)tabs);
        tabPanel = this.createInfo();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel("Errors");
        this.tabLog = tab;
        tab.setParent((Component)tabs);
        tabPanel = this.createTrace();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel("Plugins");
        this.tabPlugins = tab;
        tabPanel = this.createPlugins();
        if (tabPanel != null) {
            tab.setParent((Component)tabs);
            tabPanel.setParent((Component)this.tabPanels);
        }
    }

    protected Tabpanel createTrace() {
        MUser user;
        Level level;
        Tabpanel tabPanel = new Tabpanel();
        Vbox vbox = new Vbox();
        LayoutUtils.addSclass("about-trace-panel", (HtmlBasedComponent)vbox);
        vbox.setParent((Component)tabPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)vbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vbox, "1");
        Hbox hbox = new Hbox();
        hbox.setAlign("center");
        hbox.setPack("start");
        Label levelLabel = new Label("Trace Level:");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)levelLabel, "100%");
        hbox.appendChild((Component)levelLabel);
        this.levelListBox = ListboxFactory.newDropdownListbox();
        this.levelListBox.addEventListener("onSelect", this);
        hbox.appendChild((Component)this.levelListBox);
        Level[] levelArray = CLogMgt.LEVELS;
        int n = CLogMgt.LEVELS.length;
        int n2 = 0;
        while (n2 < n) {
            level = levelArray[n2];
            this.levelListBox.appendItem(level.getName(), level);
            ++n2;
        }
        level = CLogMgt.getLevel();
        int i = 0;
        while (i < CLogMgt.LEVELS.length) {
            if (CLogMgt.LEVELS[i].intValue() == level.intValue()) {
                this.levelListBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.levelListBox.setEnabled(false);
        if (Env.getAD_Client_ID((Properties)Env.getCtx()) == 0 && (user = MUser.get((Properties)Env.getCtx())).isAdministrator()) {
            this.levelListBox.setEnabled(true);
            this.levelListBox.setTooltiptext("Set trace level. Warning: this will effect all session not just the current session");
            levelLabel.setTooltiptext("Set trace level. Warning: this will effect all session not just the current session");
            this.btnAdempiereLog = new Button("iDempiere Log");
            this.btnAdempiereLog.setTooltiptext("Download iDempiere log file from server");
            LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnAdempiereLog);
            this.btnAdempiereLog.addEventListener("onClick", this);
            hbox.appendChild((Component)new Space());
            hbox.appendChild((Component)this.btnAdempiereLog);
        }
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "0");
        vbox.appendChild((Component)hbox);
        hbox = new Hbox();
        hbox.setAlign("center");
        hbox.setPack("start");
        this.bErrorsOnly = new Checkbox();
        this.bErrorsOnly.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ErrorsOnly"));
        this.bErrorsOnly.setChecked(true);
        this.bErrorsOnly.addEventListener("onCheck", this);
        hbox.appendChild((Component)this.bErrorsOnly);
        hbox.appendChild((Component)new Space());
        this.btnDownload = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveFile"));
        this.btnDownload.setTooltiptext("Download session log");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnDownload);
        this.btnDownload.addEventListener("onClick", this);
        hbox.appendChild((Component)this.btnDownload);
        this.btnErrorEmail = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"SendEMail"));
        this.btnErrorEmail.setTooltiptext("Email session log");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnErrorEmail);
        this.btnErrorEmail.addEventListener("onClick", this);
        hbox.appendChild((Component)this.btnErrorEmail);
        this.btnViewLog = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"View")));
        this.btnViewLog.setTooltiptext("View session log");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnViewLog);
        this.btnViewLog.addEventListener("onClick", this);
        hbox.appendChild((Component)this.btnViewLog);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "0");
        vbox.appendChild((Component)hbox);
        Vector columnNames = CLogErrorBuffer.get((boolean)true).getColumnNames(Env.getCtx());
        this.logTable = new Listbox();
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.logTable);
        listHead.setSizable(true);
        for (Object obj : columnNames) {
            ListHeader header = new ListHeader(obj.toString());
            ZKUpdateUtil.setHflex((HtmlBasedComponent)header, "1");
            listHead.appendChild((Component)header);
        }
        vbox.appendChild((Component)this.logTable);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.logTable, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.logTable, "1");
        this.updateLogTable();
        return tabPanel;
    }

    private void updateLogTable() {
        Vector data = CLogErrorBuffer.get((boolean)true).getLogData(this.bErrorsOnly.isChecked());
        SimpleListModel model = new SimpleListModel(data);
        int[] nArray = new int[6];
        nArray[3] = 200;
        nArray[5] = 200;
        model.setMaxLength(nArray);
        this.logTable.setItemRenderer(model);
        this.logTable.setModel((ListModel)model);
        if (this.bErrorsOnly.isSelected()) {
            this.tabLog.setLabel(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Errors")) + " (" + data.size() + ")");
        } else {
            this.tabLog.setLabel(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceInfo")) + " (" + data.size() + ")");
        }
    }

    protected Tabpanel createPlugins() {
        Properties ctx = Env.getCtx();
        MUser user = MUser.get((Properties)ctx);
        Tabpanel tabPanel = null;
        if (Env.getAD_Client_ID((Properties)ctx) == 0 && user.isAdministrator()) {
            tabPanel = new Tabpanel();
            Vbox vbox = new Vbox();
            ZKUpdateUtil.setHflex((HtmlBasedComponent)vbox, "1");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)vbox, "1");
            this.pluginColumnNames = new Vector();
            this.pluginColumnNames.add("");
            this.pluginColumnNames.add(Msg.getMsg((Properties)ctx, (String)"Id"));
            this.pluginColumnNames.add(Msg.getMsg((Properties)ctx, (String)"State"));
            this.pluginColumnNames.add(Msg.getCleanMsg((Properties)ctx, (String)"Name"));
            this.pluginColumnNames.add(Msg.getMsg((Properties)ctx, (String)"Version"));
            this.pluginsTable = ListboxFactory.newDataTableAutoSize();
            this.pluginData = new Vector();
            int i = 0;
            this.pluginsTable.setColumnClass(i++, IDColumn.class, true);
            this.pluginsTable.setColumnClass(i++, Integer.class, true);
            this.pluginsTable.setColumnClass(i++, String.class, true);
            this.pluginsTable.setColumnClass(i++, String.class, true);
            this.pluginsTable.setColumnClass(i++, String.class, true);
            vbox.appendChild((Component)this.pluginsTable);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.pluginsTable, "1");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.pluginsTable, "1");
            this.refreshPluginTable();
            this.pluginsTable.autoSize();
            this.pluginsTable.addEventListener("onSelect", this);
            this.pluginActions = new Listbox(new KeyNamePair[]{new KeyNamePair(0, ""), new KeyNamePair(1, Msg.getMsg((Properties)ctx, (String)"Stop")), new KeyNamePair(2, Msg.getMsg((Properties)ctx, (String)"Start")), new KeyNamePair(3, Msg.getMsg((Properties)ctx, (String)"Update")), new KeyNamePair(4, Msg.getMsg((Properties)ctx, (String)"Uninstall")), new KeyNamePair(5, Msg.getMsg((Properties)ctx, (String)"Install"))});
            this.pluginActions.setId("pluginActions");
            this.pluginActions.setRows(0);
            this.pluginActions.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.pluginActions, "200px");
            this.refreshActionList();
            this.pluginProcess = new Button(Msg.getMsg((Properties)ctx, (String)"Process"));
            this.pluginProcess.addEventListener("onClick", this);
            Div div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)this.pluginActions);
            div.appendChild((Component)this.pluginProcess);
            vbox.appendChild((Component)div);
            vbox.setParent((Component)tabPanel);
            this.tabPlugins.setLabel(String.valueOf(Msg.getMsg((Properties)ctx, (String)"Plugins")) + " (" + this.pluginData.size() + ")");
        }
        return tabPanel;
    }

    private String state(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "UNKNOWN";
    }

    private void refreshActionList() {
        this.pluginActions.getItemAtIndex(3).setVisible(false);
        this.pluginActions.getItemAtIndex(4).setVisible(false);
        this.pluginActions.getItemAtIndex(5).setVisible(false);
        this.pluginActions.getItemAtIndex(1).setVisible(false);
        this.pluginActions.getItemAtIndex(2).setVisible(false);
        this.pluginActions.setSelectedItem(null);
        Bundle bundle = this.getSelectedBundle();
        if (bundle == null) {
            return;
        }
        int state = bundle.getState();
        if (bundle.getBundleId() != 0L) {
            if (state == 32) {
                this.pluginActions.getItemAtIndex(1).setVisible(true);
            } else if (state == 4) {
                this.pluginActions.getItemAtIndex(2).setVisible(true);
            } else if (state == 2 || state == 8 || state != 16) {
                // empty if block
            }
        }
    }

    private Bundle getSelectedBundle() {
        Bundle retValue = null;
        int idx = this.pluginsTable.getSelectedIndex();
        if (idx >= 0) {
            Integer selectedPlugin = (Integer)this.pluginsTable.getModel().getDataAt(idx, 1);
            Vector<Object> pluginVector = this.pluginData.get(selectedPlugin);
            int pluginId = ((IDColumn)pluginVector.get(0)).getRecord_ID();
            BundleContext bundleCtx = WebUIActivator.getBundleContext();
            retValue = bundleCtx.getBundle((long)pluginId);
        }
        return retValue;
    }

    private void processPlugin() {
        ListItem actionItem = this.pluginActions.getSelectedItem();
        if (actionItem != null && actionItem.getValue() instanceof Integer) {
            int action = (Integer)actionItem.getValue();
            Bundle bundle = this.getSelectedBundle();
            if (action == 1 && bundle != null) {
                try {
                    bundle.stop();
                }
                catch (BundleException e) {
                    throw new AdempiereException((Throwable)e);
                }
            } else if (action == 2 && bundle != null) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    throw new AdempiereException((Throwable)e);
                }
            } else if (action == 3 && bundle != null || action == 4 && bundle != null || action == 5) {
                // empty if block
            }
        }
        this.refreshPluginTable();
        this.refreshActionList();
    }

    private void refreshPluginTable() {
        this.pluginsTable.getModel().removeAll(this.pluginData);
        this.pluginData.removeAllElements();
        BundleContext bundleCtx = WebUIActivator.getBundleContext();
        Bundle[] bundleArray = bundleCtx.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Vector<Object> line = new Vector<Object>();
            Integer bundl = Long.valueOf(bundle.getBundleId()).intValue();
            line.add(new IDColumn(bundl));
            line.add(bundl);
            line.add(this.state(bundle.getState()));
            line.add(bundle.getSymbolicName());
            line.add(bundle.getVersion());
            this.pluginData.add(line);
            ++n2;
        }
        ListModelTable model = new ListModelTable(this.pluginData);
        this.pluginsTable.setData(model, this.pluginColumnNames);
    }

    protected Tabpanel createInfo() {
        Tabpanel tabPanel = new Tabpanel();
        Div div = new Div();
        LayoutUtils.addSclass("about-info-panel", (HtmlBasedComponent)div);
        div.setParent((Component)tabPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)div, "100%");
        div.setStyle("overflow: auto;");
        Pre pre = new Pre();
        pre.setParent((Component)div);
        Text text = new Text(CLogMgt.getInfo(null).toString());
        text.setParent((Component)pre);
        return tabPanel;
    }

    protected Tabpanel createCredit() {
        Tabpanel tabPanel = new Tabpanel();
        Div div = new Div();
        LayoutUtils.addSclass("about-credit-panel", (HtmlBasedComponent)div);
        div.setParent((Component)tabPanel);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)div, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)div, "100%");
        div.setStyle("overflow: auto;");
        Vbox vbox = new Vbox();
        LayoutUtils.addSclass("about-credit-panel-logo", (HtmlBasedComponent)vbox);
        vbox.setParent((Component)div);
        Label caption = new Label("Top iDempiere sponsor");
        caption.setStyle("font-weight: bold;");
        caption.setParent((Component)vbox);
        ToolBarButton link = new ToolBarButton();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)link, "72px");
        link.setImage("images/TrekGlobal.jpg");
        link.setParent((Component)vbox);
        link.setHref("http://www.trekglobal.com");
        link.setTarget("_blank");
        Separator separator = new Separator();
        separator.setParent((Component)div);
        Div panel = new Div();
        LayoutUtils.addSclass("about-credit-panel-sponsors", (HtmlBasedComponent)panel);
        panel.setParent((Component)div);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)panel, "100%");
        vbox = new Vbox();
        LayoutUtils.addSclass("about-credit-panel-sponsors-header", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        vbox.setParent((Component)panel);
        caption = new Label("Sponsors");
        caption.setStyle("font-weight: bold;");
        caption.setParent((Component)vbox);
        Vbox content = new Vbox();
        LayoutUtils.addSclass("about-credit-panel-sponsors-links", (HtmlBasedComponent)content);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)content, "100%");
        content.setParent((Component)panel);
        Grid grid = new Grid();
        grid.setParent((Component)content);
        Rows rows = new Rows();
        rows.setParent((Component)grid);
        Row row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("GlobalQSS", "http://www.globalqss.com/"));
        row.appendCellChild((Component)this.addLink("Adaxa", "http://www.adaxa.com/"));
        row.appendCellChild((Component)this.addLink("Sysnova", "http://www.sysnova.com/"));
        row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("See also ...", "http://www.idempiere.org/sponsors"), 3);
        panel = new Div();
        LayoutUtils.addSclass("about-credit-panel-contributors", (HtmlBasedComponent)panel);
        panel.setParent((Component)div);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)panel, "100%");
        vbox = new Vbox();
        LayoutUtils.addSclass("about-credit-panel-contributors-header", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        vbox.setParent((Component)panel);
        caption = new Label("Contributors");
        caption.setStyle("font-weight: bold;");
        caption.setParent((Component)vbox);
        content = new Vbox();
        LayoutUtils.addSclass("about-credit-panel-contributors-links", (HtmlBasedComponent)content);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)content, "100%");
        content.setParent((Component)panel);
        grid = new Grid();
        grid.setParent((Component)content);
        rows = new Rows();
        rows.setParent((Component)grid);
        row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("Low Heng Sin", "http://www.adempiere.com/User:Hengsin"));
        row.appendCellChild((Component)this.addLink("Carlos Ruiz", "http://wiki.idempiere.org/en/User:CarlosRuiz"));
        row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("Hiep Lq", "http://wiki.idempiere.org/en/User:Hieplq"));
        row.appendCellChild((Component)this.addLink("Nicolas Micoud", "http://wiki.idempiere.org/en/User:Nmicoud"));
        row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("Jan Thielemann", "http://wiki.idempiere.org/en/User:Jan.thielemann"));
        row.appendCellChild((Component)this.addLink("Redhuan D. Oon", "http://www.red1.org"));
        row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("Thomas Bayen", "http://wiki.idempiere.org/en/User:TBayen"));
        row.appendCellChild((Component)this.addLink("Ashley G Ramdass", "http://www.adempiere.com/User:Agramdass"));
        row = new Row();
        row.setParent((Component)rows);
        row.appendCellChild((Component)this.addLink("Teo Sarca", "http://www.adempiere.com/User:Teo_sarca"));
        row.appendCellChild((Component)this.addLink("Trifon Trifonov", "http://www.adempiere.com/User:Trifonnt"));
        return tabPanel;
    }

    private ToolBarButton addLink(String label, String href) {
        ToolBarButton link = new ToolBarButton();
        link.setLabel(label);
        link.setHref(href);
        link.setTarget("_blank");
        return link;
    }

    protected Tabpanel createAbout() {
        Tabpanel tabPanel = new Tabpanel();
        Vbox vb = new Vbox();
        LayoutUtils.addSclass("about-main-panel", (HtmlBasedComponent)vb);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)vb, "100%");
        vb.setAlign("center");
        vb.setPack("center");
        vb.setParent((Component)tabPanel);
        Vbox vbox = new Vbox();
        LayoutUtils.addSclass("about-main-panel-logo", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        vbox.setAlign("center");
        vbox.setParent((Component)vb);
        Image image = new Image(ThemeManager.getLargeLogo());
        image.setParent((Component)vbox);
        vbox = new Vbox();
        LayoutUtils.addSclass("about-main-panel-version", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        vbox.setAlign("center");
        vbox.setParent((Component)vb);
        Text text = new Text(Adempiere.getSubtitle());
        text.setParent((Component)vbox);
        Separator separator = new Separator();
        separator.setParent((Component)vbox);
        text = new Text(Adempiere.getVersion());
        text.setParent((Component)vbox);
        vbox = new Vbox();
        LayoutUtils.addSclass("about-main-panel-links", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        vbox.setAlign("center");
        vbox.setParent((Component)vb);
        separator = new Separator();
        separator.setParent((Component)vbox);
        ToolBarButton link = new ToolBarButton();
        link.setLabel("Project Site");
        link.setHref("http://www.idempiere.org");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        separator = new Separator();
        separator.setParent((Component)vbox);
        link = new ToolBarButton();
        link.setLabel("Community Wiki");
        link.setHref("http://wiki.idempiere.org");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        separator = new Separator();
        separator.setParent((Component)vbox);
        link = new ToolBarButton();
        link.setLabel("Functional Forums");
        link.setHref("http://groups.google.com/group/idempiere");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        return tabPanel;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.bErrorsOnly) {
            this.updateLogTable();
        } else if (event.getTarget() == this.btnDownload) {
            this.downloadLog();
        } else if (event.getTarget() == this.btnViewLog) {
            this.viewLog();
        } else if (event.getTarget() == this.btnErrorEmail) {
            this.cmd_errorEMail();
        } else if (event.getTarget() == this.btnAdempiereLog) {
            this.downloadAdempiereLogFile();
        } else if (event.getTarget() == this.levelListBox) {
            this.setTraceLevel();
        } else if ("onSelect".equals(event.getName()) && event.getTarget() == this.pluginsTable) {
            this.refreshActionList();
        } else if ("onClick".equals(event.getName())) {
            if (event.getTarget() == this.pluginProcess) {
                this.processPlugin();
            } else {
                this.detach();
            }
        }
    }

    private void setTraceLevel() {
        ListItem item = this.levelListBox.getSelectedItem();
        if (item != null && item.getValue() != null) {
            Level level = (Level)item.getValue();
            CLogMgt.setLevel((Level)level);
            Ini.setProperty((String)"TraceLevel", (String)CLogMgt.getLevel().getName());
            Ini.saveProperties((boolean)false);
        }
    }

    private void downloadAdempiereLogFile() {
        String path = String.valueOf(Ini.getAdempiereHome()) + File.separator + "log";
        final FolderBrowser fileBrowser = new FolderBrowser(path, false);
        fileBrowser.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                File file;
                String selected = fileBrowser.getPath();
                if (selected != null && selected.trim().length() > 0 && (file = new File(selected)).exists() && file.isFile() && file.canRead()) {
                    try {
                        AMedia media = new AMedia(file, "text/plain", null);
                        Filedownload.save((Media)media);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void downloadLog() {
        String log = CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), this.bErrorsOnly.isChecked());
        AMedia media = new AMedia("trace.log", null, "text/plain", log.getBytes());
        Filedownload.save((Media)media);
    }

    private void viewLog() {
        String log = CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), this.bErrorsOnly.isChecked());
        Window w = new Window();
        w.setAttribute("mode", "highlighted");
        w.setTitle("View Log");
        w.setBorder("normal");
        w.setClosable(true);
        w.setMaximizable(true);
        w.setSizable(true);
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)w, 600);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)w, 500);
        Textarea textbox = new Textarea();
        textbox.setDynamicProperty("readonly", (Object)"true");
        textbox.setStyle("width:99%; height: 99%; margin: auto; display: inline-block;");
        w.appendChild((Component)textbox);
        textbox.setValue(log);
        AEnv.showCenterScreen(w);
    }

    private void cmd_errorEMail() {
        this.detach();
        FeedbackManager.emailSupport(this.bErrorsOnly.isSelected());
    }
}

