/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.util.Iterator;
import java.util.List;
import org.adempiere.webui.util.TreeItemAction;
import org.adempiere.webui.util.TreeNodeAction;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.ext.TreeOpenableModel;

public class TreeUtils {
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.Tree.onInitLaterPosted";

    public static void collapseAll(Tree tree) {
        TreeUtils.traverse(tree, new TreeItemAction(){

            @Override
            public void run(Treeitem treeItem) {
                treeItem.setOpen(false);
            }
        });
    }

    public static void expandAll(Tree tree) {
        TreeUtils.traverse(tree, new TreeItemAction(){

            @Override
            public void run(Treeitem treeItem) {
                treeItem.setOpen(true);
            }
        });
    }

    public static void traverse(Tree tree, TreeItemAction action) {
        Treechildren treechildren = tree.getTreechildren();
        TreeUtils.traverse(treechildren, action);
    }

    public static void traverse(Treechildren treechildren, TreeItemAction action) {
        Object[] list = treechildren.getChildren().toArray();
        int index = 0;
        while (index < list.length) {
            Object o = list[index];
            if (o instanceof Treechildren) {
                Treechildren treechild = (Treechildren)o;
                TreeUtils.traverse(treechild, action);
            } else if (o instanceof Treeitem) {
                Treeitem treeitem = (Treeitem)o;
                action.run(treeitem);
                Object[] treeitemChildren = treeitem.getChildren().toArray();
                int childIndex = 0;
                while (childIndex < treeitemChildren.length) {
                    Object child = treeitemChildren[childIndex];
                    if (child instanceof Treechildren) {
                        Treechildren treechild = (Treechildren)child;
                        TreeUtils.traverse(treechild, action);
                    }
                    ++childIndex;
                }
            }
            ++index;
        }
    }

    public static void traverse(TreeModel<Object> model, TreeNodeAction action) {
        TreeUtils.traverse(model, model.getRoot(), action);
    }

    public static void traverse(TreeModel<Object> model, Object parent, TreeNodeAction action) {
        int count = model.getChildCount(parent);
        int i = 0;
        while (i < count) {
            Object child = model.getChild(parent, i);
            if (child instanceof DefaultTreeNode) {
                action.run((DefaultTreeNode)child);
            }
            TreeUtils.traverse(model, child, action);
            ++i;
        }
    }

    public static boolean isOnInitRenderPosted(Tree tree) {
        if (tree.getAttribute(ATTR_ON_INIT_RENDER_POSTED) != null) {
            return (Boolean)tree.getAttribute(ATTR_ON_INIT_RENDER_POSTED);
        }
        return false;
    }

    public static void collapseTree(Component treeObject, boolean isOpen) {
        List com;
        Tree tree;
        if (treeObject instanceof Tree && (tree = (Tree)treeObject).getModel() != null && tree.getModel() instanceof TreeOpenableModel) {
            TreeUtils.collapseTreeModel((TreeOpenableModel)tree.getModel(), isOpen, null);
            return;
        }
        if (treeObject instanceof Treeitem) {
            Treeitem treeitem = (Treeitem)treeObject;
            treeitem.setOpen(isOpen);
        }
        if ((com = treeObject.getChildren()) != null) {
            Iterator iterator = com.iterator();
            while (iterator.hasNext()) {
                TreeUtils.collapseTree((Component)iterator.next(), isOpen);
            }
        }
    }

    protected static <T> void collapseTreeModel(TreeOpenableModel treeModelOpenable, boolean isOpen, T treeNode) {
        if (!isOpen) {
            treeModelOpenable.clearOpen();
            return;
        }
        if (!(treeModelOpenable instanceof TreeModel)) {
            return;
        }
        if (treeNode != null && !(treeNode instanceof TreeNode)) {
            return;
        }
        TreeModel treeModel = (TreeModel)treeModelOpenable;
        if (treeNode == null) {
            Object rootNode = treeModel.getRoot();
            if (!(rootNode instanceof TreeNode)) {
                return;
            }
            TreeNode node = (TreeNode)rootNode;
            TreeUtils.collapseTreeModel(treeModelOpenable, isOpen, node);
        } else {
            TreeNode node = (TreeNode)treeNode;
            treeModelOpenable.addOpenPath(treeModel.getPath(treeNode));
            if (node.getChildren() != null) {
                for (TreeNode childNode : node.getChildren()) {
                    TreeUtils.collapseTreeModel(treeModelOpenable, isOpen, childNode);
                }
            }
        }
    }
}

