/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.session.SessionContextListener;
import org.adempiere.webui.util.IServerPushCallback;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class ServerPushTemplate {
    private Desktop desktop;

    public ServerPushTemplate(Desktop desktop) {
        this.desktop = desktop;
    }

    public void executeAsync(final IServerPushCallback callback) {
        try {
            EventListener<Event> task = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (!SessionContextListener.isContextValid()) {
                        SessionContextListener.setupExecutionContextFromSession(ServerPushTemplate.this.desktop.getExecution());
                    }
                    callback.updateUI();
                }
            };
            Executions.schedule((Desktop)this.desktop, (EventListener)task, (Event)new Event("onExecute"));
        }
        catch (DesktopUnavailableException de) {
            throw de;
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to update client in server push worker thread.", (Throwable)e);
        }
    }

    public void execute(IServerPushCallback callback) {
        boolean inUIThread = Executions.getCurrent() != null;
        boolean desktopActivated = false;
        try {
            try {
                if (!inUIThread) {
                    if (Executions.activate((Desktop)this.desktop, (long)600000L)) {
                        desktopActivated = true;
                    } else {
                        throw new DesktopUnavailableException("Timeout activating desktop.");
                    }
                }
                callback.updateUI();
            }
            catch (DesktopUnavailableException de) {
                throw de;
            }
            catch (Exception e) {
                throw new AdempiereException("Failed to update client in server push worker thread.", (Throwable)e);
            }
        }
        finally {
            if (!inUIThread && desktopActivated) {
                Executions.deactivate((Desktop)this.desktop);
            }
        }
    }

    public Desktop getDesktop() {
        return this.desktop;
    }
}

